/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformer;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\bH\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0018\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u000fH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsAnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "jsContext", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "arraysContentEquals", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getJsContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "chooseConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "implClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "getArrayContentEqualsSymbol", "type", "implementAnnotationPropertiesAndConstructor", "", "annotationClass", "generatedConstructor", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsAnnotationImplementationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsAnnotationImplementationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsAnnotationImplementationTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1#2:72\n661#3,11:73\n*S KotlinDebug\n*F\n+ 1 JsAnnotationImplementationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsAnnotationImplementationTransformer\n*L\n58#1:73,11\n*E\n"})
public final class JsAnnotationImplementationTransformer
extends AnnotationImplementationTransformer
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext jsContext;
    @NotNull
    private final Map<IrType, IrSimpleFunctionSymbol> arraysContentEquals;

    public JsAnnotationImplementationTransformer(@NotNull JsIrBackendContext jsContext) {
        Intrinsics.checkNotNullParameter((Object)jsContext, (String)"jsContext");
        super((BackendContext)jsContext, null);
        this.jsContext = jsContext;
        Map map = this.jsContext.getIr().getSymbols().getArraysContentEquals();
        if (map == null) {
            JsAnnotationImplementationTransformer jsAnnotationImplementationTransformer = this;
            boolean bl = false;
            JsAnnotationImplementationTransformer jsAnnotationImplementationTransformer2 = jsAnnotationImplementationTransformer;
            String string2 = "contentEquals symbols should be defined in JS IR context";
            throw new IllegalArgumentException(string2.toString());
        }
        this.arraysContentEquals = map;
    }

    @NotNull
    public final JsIrBackendContext getJsContext() {
        return this.jsContext;
    }

    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof IrClass && IrUtilsKt.isAnnotationClass((IrClass)((IrClass)declaration))) {
            IrStatement irStatement = this.visitClassNew((IrClass)declaration);
            Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            list2 = CollectionsKt.listOf((Object)((IrClass)irStatement));
        } else {
            list2 = null;
        }
        return list2;
    }

    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrExpression)expression2;
    }

    @NotNull
    public IrConstructor chooseConstructor(@NotNull IrClass implClass, @NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        CompilationExceptionKt.compilationException((String)"Should not be called", (IrDeclaration)((IrDeclaration)implClass));
        throw null;
    }

    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration) {
        IrClass irClass;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrClass $this$visitClassNew_u24lambda_u240 = irClass = declaration;
        boolean bl = false;
        if (IrUtilsKt.isAnnotationClass((IrClass)$this$visitClassNew_u24lambda_u240)) {
            this.implementGeneratedFunctions($this$visitClassNew_u24lambda_u240, $this$visitClassNew_u24lambda_u240);
        }
        this.addConstructorBodyForCompatibility($this$visitClassNew_u24lambda_u240);
        return (IrStatement)irClass;
    }

    @NotNull
    public IrSimpleFunctionSymbol getArrayContentEqualsSymbol(@NotNull IrType type2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (IrTypeUtilsKt.isPrimitiveArray((IrType)type2) || IrTypeUtilsKt.isUnsignedArray((IrType)type2)) {
            object = this.arraysContentEquals.get(type2);
        } else {
            Object v1;
            block5: {
                Iterable $this$singleOrNull$iv = this.arraysContentEquals.entrySet();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    IrType k = (IrType)entry.getKey();
                    if (!IrTypePredicatesKt.isArray((IrType)k)) continue;
                    if (found$iv) {
                        v1 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            Map.Entry entry = v1;
            object = entry != null ? (IrSimpleFunctionSymbol)entry.getValue() : null;
        }
        if (object == null) {
            CompilationExceptionKt.compilationException((String)"Can't find an Arrays.contentEquals method for array type", (IrType)type2);
            throw null;
        }
        return object;
    }

    public void implementAnnotationPropertiesAndConstructor(@NotNull IrClass implClass, @NotNull IrClass annotationClass, @NotNull IrConstructor generatedConstructor) {
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)generatedConstructor, (String)"generatedConstructor");
        CompilationExceptionKt.compilationException((String)"Should not be called", (IrDeclaration)((IrDeclaration)implClass));
        throw null;
    }
}

