/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleCodegenContext;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmAnyRef;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmExternRef;
import org.jetbrains.kotlin.wasm.ir.WasmF32;
import org.jetbrains.kotlin.wasm.ir.WasmF64;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmI64;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmUnreachableType;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0011\u00a8\u0006\u0014"}, d2={"generateConstExpression", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "body", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "location", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "generateDefaultInitializerForType", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "g", "getEffectiveValueParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isExported", "", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nDeclarationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGeneratorKt\n+ 2 WasmExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder\n*L\n1#1,532:1\n202#2,2:533\n*S KotlinDebug\n*F\n+ 1 DeclarationGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGeneratorKt\n*L\n523#1:533,2\n*E\n"})
public final class DeclarationGeneratorKt {
    public static final void generateDefaultInitializerForType(@NotNull WasmType type2, @NotNull WasmExpressionBuilder g) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        SourceLocation location = SourceLocation.Companion.NoLocation("Default initializer, usually don't require location");
        boolean bl = false;
        WasmType wasmType = type2;
        if (Intrinsics.areEqual((Object)wasmType, (Object)WasmI32.INSTANCE)) {
            g.buildConstI32(0, location);
        } else if (Intrinsics.areEqual((Object)wasmType, (Object)WasmI64.INSTANCE)) {
            g.buildConstI64(0L, location);
        } else if (Intrinsics.areEqual((Object)wasmType, (Object)WasmF32.INSTANCE)) {
            g.buildConstF32(0.0f, location);
        } else if (Intrinsics.areEqual((Object)wasmType, (Object)WasmF64.INSTANCE)) {
            g.buildConstF64(0.0, location);
        } else if (wasmType instanceof WasmRefNullType) {
            g.buildRefNull(((WasmRefNullType)type2).getHeapType(), location);
        } else if (wasmType instanceof WasmAnyRef) {
            g.buildRefNull((WasmHeapType)WasmHeapType.Simple.Any.INSTANCE, location);
        } else if (wasmType instanceof WasmExternRef) {
            g.buildRefNull((WasmHeapType)WasmHeapType.Simple.Extern.INSTANCE, location);
        } else {
            if (Intrinsics.areEqual((Object)wasmType, (Object)WasmUnreachableType.INSTANCE)) {
                throw new IllegalStateException("Unreachable type can't be initialized".toString());
            }
            throw new IllegalStateException(("Unknown value type " + type2.getName()).toString());
        }
    }

    @NotNull
    public static final List<IrValueParameter> getEffectiveValueParameters(@NotNull IrFunction $this$getEffectiveValueParameters) {
        IrValueParameter irValueParameter;
        Intrinsics.checkNotNullParameter((Object)$this$getEffectiveValueParameters, (String)"<this>");
        if ($this$getEffectiveValueParameters instanceof IrConstructor) {
            IrValueParameter irValueParameter2 = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)$this$getEffectiveValueParameters)).getThisReceiver();
            irValueParameter = irValueParameter2;
            Intrinsics.checkNotNull((Object)irValueParameter2);
        } else {
            irValueParameter = null;
        }
        IrValueParameter implicitThis = irValueParameter;
        Object[] objectArray = new IrValueParameter[]{implicitThis, $this$getEffectiveValueParameters.getDispatchReceiverParameter(), $this$getEffectiveValueParameters.getExtensionReceiverParameter()};
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])objectArray), (Iterable)$this$getEffectiveValueParameters.getValueParameters());
    }

    public static final boolean isExported(@NotNull IrFunction $this$isExported) {
        Intrinsics.checkNotNullParameter((Object)$this$isExported, (String)"<this>");
        return AnnotationUtilsKt.isJsExport((IrAnnotationContainer)$this$isExported);
    }

    public static final void generateConstExpression(@NotNull IrConst<?> expression2, @NotNull WasmExpressionBuilder body2, @NotNull WasmModuleCodegenContext context, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        IrConstKind kind = expression2.getKind();
        if (kind instanceof IrConstKind.Null) {
            DeclarationGeneratorKt.generateDefaultInitializerForType(context.transformType(expression2.getType()), body2);
        } else if (kind instanceof IrConstKind.Boolean) {
            body2.buildConstI32((Boolean)((IrConstKind.Boolean)kind).valueOf(expression2) != false ? 1 : 0, location);
        } else if (kind instanceof IrConstKind.Byte) {
            body2.buildConstI32((int)((Number)((IrConstKind.Byte)kind).valueOf(expression2)).byteValue(), location);
        } else if (kind instanceof IrConstKind.Short) {
            body2.buildConstI32((int)((Number)((IrConstKind.Short)kind).valueOf(expression2)).shortValue(), location);
        } else if (kind instanceof IrConstKind.Int) {
            body2.buildConstI32(((Number)((IrConstKind.Int)kind).valueOf(expression2)).intValue(), location);
        } else if (kind instanceof IrConstKind.Long) {
            body2.buildConstI64(((Number)((IrConstKind.Long)kind).valueOf(expression2)).longValue(), location);
        } else if (kind instanceof IrConstKind.Char) {
            body2.buildConstI32((int)((Character)((IrConstKind.Char)kind).valueOf(expression2)).charValue(), location);
        } else if (kind instanceof IrConstKind.Float) {
            body2.buildConstF32(((Number)((IrConstKind.Float)kind).valueOf(expression2)).floatValue(), location);
        } else if (kind instanceof IrConstKind.Double) {
            body2.buildConstF64(((Number)((IrConstKind.Double)kind).valueOf(expression2)).doubleValue(), location);
        } else if (kind instanceof IrConstKind.String) {
            String string2;
            String stringValue = (String)((IrConstKind.String)kind).valueOf(expression2);
            Pair<WasmSymbol<Integer>, WasmSymbol<Integer>> pair = context.referenceStringLiteralAddressAndId(stringValue);
            WasmSymbol literalAddress = (WasmSymbol)pair.component1();
            WasmSymbol literalPoolId = (WasmSymbol)pair.component2();
            WasmExpressionBuilder this_$iv = body2;
            boolean $i$f$commentGroupStart = false;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n = 0;
            WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string3 = string2 = "const string: \"" + stringValue + '\"';
            wasmImmediateArray2[n] = new WasmImmediate.ConstString(string3);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
            body2.buildConstI32Symbol(literalPoolId, location);
            body2.buildConstI32Symbol(literalAddress, location);
            body2.buildConstI32(stringValue.length(), location);
            body2.buildCall(context.referenceFunction((IrFunctionSymbol)context.getBackendContext().getWasmSymbols().getStringGetLiteral()), location);
            body2.commentGroupEnd();
        } else {
            throw new IllegalStateException("Unknown constant kind".toString());
        }
    }
}

