/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.resolve.OverloadabilitySpecificityCallbacks;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignature;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignatureKt;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignatureUtilsKt;
import org.jetbrains.kotlin.resolve.calls.results.SimpleConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.results.SpecificityComparisonCallbacks;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "", "specificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "(Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;)V", "getSpecificityComparator", "()Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "checkOverloadability", "", "a", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "b", "getDeclarationCategory", "Lorg/jetbrains/kotlin/resolve/OverloadChecker$DeclarationCategory;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isOverloadable", "DeclarationCategory", "frontend"})
public final class OverloadChecker {
    @NotNull
    private final TypeSpecificityComparator specificityComparator;

    public OverloadChecker(@NotNull TypeSpecificityComparator specificityComparator) {
        Intrinsics.checkNotNullParameter((Object)specificityComparator, (String)"specificityComparator");
        this.specificityComparator = specificityComparator;
    }

    @NotNull
    public final TypeSpecificityComparator getSpecificityComparator() {
        return this.specificityComparator;
    }

    public final boolean isOverloadable(@NotNull DeclarationDescriptor a, @NotNull DeclarationDescriptor b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        DeclarationCategory aCategory = this.getDeclarationCategory(a);
        DeclarationCategory bCategory = this.getDeclarationCategory(b);
        if (aCategory != bCategory) {
            return true;
        }
        if (!(a instanceof CallableDescriptor) || !(b instanceof CallableDescriptor)) {
            return false;
        }
        return this.checkOverloadability((CallableDescriptor)a, (CallableDescriptor)b);
    }

    private final boolean checkOverloadability(CallableDescriptor a, CallableDescriptor b) {
        if (AnnotationsForResolveUtilsKt.hasLowPriorityInOverloadResolution(a) != AnnotationsForResolveUtilsKt.hasLowPriorityInOverloadResolution(b)) {
            return true;
        }
        if (a.getTypeParameters().isEmpty() != b.getTypeParameters().isEmpty()) {
            return true;
        }
        if (a instanceof FunctionDescriptor && ErrorUtils.INSTANCE.containsErrorTypeInParameters((FunctionDescriptor)a) || b instanceof FunctionDescriptor && ErrorUtils.INSTANCE.containsErrorTypeInParameters((FunctionDescriptor)b)) {
            return true;
        }
        if (DescriptorUtilsKt.varargParameterPosition(a) != DescriptorUtilsKt.varargParameterPosition(b)) {
            return true;
        }
        FlatSignature<CallableDescriptor> aSignature = FlatSignatureUtilsKt.createFromCallableDescriptor(FlatSignature.Companion, a);
        FlatSignature<CallableDescriptor> bSignature = FlatSignatureUtilsKt.createFromCallableDescriptor(FlatSignature.Companion, b);
        boolean aIsNotLessSpecificThanB = FlatSignatureKt.isSignatureNotLessSpecific$default((SimpleConstraintSystem)ConstraintSystemBuilderImpl.Companion.forSpecificity(), aSignature, bSignature, (SpecificityComparisonCallbacks)OverloadabilitySpecificityCallbacks.INSTANCE, (TypeSpecificityComparator)this.specificityComparator, (boolean)false, (int)16, null);
        boolean bIsNotLessSpecificThanA = FlatSignatureKt.isSignatureNotLessSpecific$default((SimpleConstraintSystem)ConstraintSystemBuilderImpl.Companion.forSpecificity(), bSignature, aSignature, (SpecificityComparisonCallbacks)OverloadabilitySpecificityCallbacks.INSTANCE, (TypeSpecificityComparator)this.specificityComparator, (boolean)false, (int)16, null);
        return !aIsNotLessSpecificThanB || !bIsNotLessSpecificThanA;
    }

    private final DeclarationCategory getDeclarationCategory(DeclarationDescriptor a) {
        DeclarationCategory declarationCategory;
        DeclarationDescriptor declarationDescriptor = a;
        if (declarationDescriptor instanceof PropertyDescriptor) {
            declarationCategory = DescriptorUtilsKt.isExtensionProperty(a) ? DeclarationCategory.EXTENSION_PROPERTY : DeclarationCategory.TYPE_OR_VALUE;
        } else if (declarationDescriptor instanceof FunctionDescriptor) {
            declarationCategory = DeclarationCategory.FUNCTION;
        } else if (declarationDescriptor instanceof ClassifierDescriptor) {
            declarationCategory = DeclarationCategory.TYPE_OR_VALUE;
        } else {
            throw new IllegalStateException(("Unexpected declaration kind: " + a).toString());
        }
        return declarationCategory;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/OverloadChecker$DeclarationCategory;", "", "(Ljava/lang/String;I)V", "TYPE_OR_VALUE", "FUNCTION", "EXTENSION_PROPERTY", "frontend"})
    private static final class DeclarationCategory
    extends Enum<DeclarationCategory> {
        public static final /* enum */ DeclarationCategory TYPE_OR_VALUE = new DeclarationCategory();
        public static final /* enum */ DeclarationCategory FUNCTION = new DeclarationCategory();
        public static final /* enum */ DeclarationCategory EXTENSION_PROPERTY = new DeclarationCategory();
        private static final /* synthetic */ DeclarationCategory[] $VALUES;

        public static DeclarationCategory[] values() {
            return (DeclarationCategory[])$VALUES.clone();
        }

        public static DeclarationCategory valueOf(String value2) {
            return Enum.valueOf(DeclarationCategory.class, value2);
        }

        static {
            $VALUES = declarationCategoryArray = new DeclarationCategory[]{DeclarationCategory.TYPE_OR_VALUE, DeclarationCategory.FUNCTION, DeclarationCategory.EXTENSION_PROPERTY};
        }
    }
}

