/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CapturingInClosureCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.expressions.CaptureKind;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J&\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0018\u0010#\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010%\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010&\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\rH\u0002J\u0010\u0010*\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010+\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CapturingInClosureChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCapturingInClosure", "variable", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "checkFieldInExactlyOnceLambdaInitialization", "scopeContainer", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "nameElement", "getCalleeDescriptorAndParameter", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "argument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getCaptureKind", "Lorg/jetbrains/kotlin/types/expressions/CaptureKind;", "variableParent", "isArgument", "", "isCapturedVariable", "isCatchBlockParameter", "isCrossinlineParameter", "isExactlyOnceContract", "isExactlyOnceParameter", "function", "parameter", "isForLoopParameter", "isLhsOfAssignment", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isValInWhen", "frontend"})
public final class CapturingInClosureChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        ResolvedCall<?> variableResolvedCall;
        Object obj;
        VariableDescriptor variableDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? (VariableAsFunctionResolvedCall)((Object)resolvedCall2) : null;
        if (object == null || (object = object.getVariableCall()) == null) {
            object = resolvedCall2;
        }
        VariableDescriptor variableDescriptor2 = variableDescriptor = (obj = (variableResolvedCall = object).getResultingDescriptor()) instanceof VariableDescriptor ? (VariableDescriptor)obj : null;
        if (variableDescriptor != null) {
            this.checkCapturingInClosure(variableDescriptor, context.getTrace(), context.getScope());
            this.checkFieldInExactlyOnceLambdaInitialization(variableDescriptor, context.getTrace(), context.getScope().getOwnerDescriptor(), reportOn);
        }
    }

    private final void checkCapturingInClosure(VariableDescriptor variable2, BindingTrace trace, LexicalScope scope) {
        DeclarationDescriptor declarationDescriptor = variable2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"variable.containingDeclaration");
        DeclarationDescriptor variableParent = declarationDescriptor;
        DeclarationDescriptor scopeContainer = scope.getOwnerDescriptor();
        if (this.isCapturedVariable(variableParent, scopeContainer) && trace.get(BindingContext.CAPTURED_IN_CLOSURE, variable2) != CaptureKind.NOT_INLINE) {
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            trace.record(BindingContext.CAPTURED_IN_CLOSURE, variable2, this.getCaptureKind(bindingContext, scopeContainer, variableParent, variable2));
            return;
        }
    }

    private final void checkFieldInExactlyOnceLambdaInitialization(VariableDescriptor variable2, BindingTrace trace, DeclarationDescriptor scopeContainer, PsiElement nameElement) {
        if (!(variable2 instanceof PropertyDescriptor) || !(scopeContainer instanceof AnonymousFunctionDescriptor) || ((PropertyDescriptor)variable2).isVar()) {
            return;
        }
        Intrinsics.checkNotNull((Object)nameElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        if (!this.isLhsOfAssignment((KtExpression)nameElement)) {
            return;
        }
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        KtFunction ktFunction = psiElement instanceof KtFunction ? (KtFunction)psiElement : null;
        if (ktFunction == null) {
            return;
        }
        KtFunction scopeDeclaration = ktFunction;
        if (!(((AnonymousFunctionDescriptor)scopeContainer).getContainingDeclaration() instanceof ConstructorDescriptor) && !(((AnonymousFunctionDescriptor)scopeContainer).getContainingDeclaration() instanceof PropertyDescriptor)) {
            return;
        }
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        if (!this.isExactlyOnceContract(bindingContext, scopeDeclaration)) {
            return;
        }
        if (trace.getBindingContext().get(BindingContext.CAPTURED_IN_CLOSURE, variable2) == CaptureKind.NOT_INLINE) {
            return;
        }
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"trace.bindingContext");
        Pair<CallableDescriptor, ValueParameterDescriptor> pair = this.getCalleeDescriptorAndParameter(bindingContext2, scopeDeclaration);
        if (pair == null) {
            return;
        }
        Pair<CallableDescriptor, ValueParameterDescriptor> pair2 = pair;
        CallableDescriptor callee = (CallableDescriptor)pair2.component1();
        ValueParameterDescriptor param = (ValueParameterDescriptor)pair2.component2();
        if (!(callee instanceof FunctionDescriptor)) {
            return;
        }
        if (!((FunctionDescriptor)callee).isInline() || param.isCrossinline() || !InlineUtil.isInlineParameter(param)) {
            trace.report(Errors.CAPTURED_VAL_INITIALIZATION.on((KtExpression)nameElement, variable2));
        }
    }

    private final boolean isLhsOfAssignment(KtExpression nameElement) {
        PsiElement psiElement = nameElement.getParent();
        KtBinaryExpression ktBinaryExpression = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression parent2 = ktBinaryExpression;
        return Intrinsics.areEqual((Object)parent2.getOperationToken(), (Object)KtTokens.EQ) && Intrinsics.areEqual((Object)parent2.getLeft(), (Object)nameElement);
    }

    private final boolean isCapturedVariable(DeclarationDescriptor variableParent, DeclarationDescriptor scopeContainer) {
        if (!(variableParent instanceof FunctionDescriptor) || Intrinsics.areEqual((Object)scopeContainer, (Object)variableParent)) {
            return false;
        }
        if (variableParent instanceof ConstructorDescriptor) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)variableParent).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptorWithTypeParameters, (String)"variableParent.containingDeclaration");
            ClassifierDescriptorWithTypeParameters classDescriptor2 = classifierDescriptorWithTypeParameters;
            if (Intrinsics.areEqual((Object)scopeContainer, (Object)classDescriptor2)) {
                return false;
            }
            if (scopeContainer instanceof PropertyDescriptor && Intrinsics.areEqual((Object)((PropertyDescriptor)scopeContainer).getContainingDeclaration(), (Object)classDescriptor2)) {
                return false;
            }
        }
        return true;
    }

    private final CaptureKind getCaptureKind(BindingContext context, DeclarationDescriptor scopeContainer, DeclarationDescriptor variableParent, VariableDescriptor variable2) {
        PsiElement scopeDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        if (!InlineUtil.canBeInlineArgument(scopeDeclaration)) {
            return CaptureKind.NOT_INLINE;
        }
        Intrinsics.checkNotNull((Object)scopeDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        if (InlineUtil.isInlinedArgument((KtFunction)scopeDeclaration, context, false) && !this.isCrossinlineParameter(context, (KtFunction)scopeDeclaration)) {
            DeclarationDescriptor declarationDescriptor = scopeContainer.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new IllegalStateException(("parent is null for " + scopeContainer).toString());
            }
            DeclarationDescriptor scopeContainerParent = declarationDescriptor;
            return !this.isCapturedVariable(variableParent, scopeContainerParent) || this.getCaptureKind(context, scopeContainerParent, variableParent, variable2) == CaptureKind.INLINE_ONLY ? CaptureKind.INLINE_ONLY : CaptureKind.NOT_INLINE;
        }
        boolean exactlyOnceContract = this.isExactlyOnceContract(context, (KtFunction)scopeDeclaration);
        if (!exactlyOnceContract) {
            return CaptureKind.NOT_INLINE;
        }
        return this.isArgument(variable2, variableParent) || CapturingInClosureCheckerKt.findDestructuredVariable(variable2, variableParent) != null || this.isForLoopParameter(variable2) || this.isCatchBlockParameter(variable2) || this.isValInWhen(variable2) ? CaptureKind.NOT_INLINE : CaptureKind.EXACTLY_ONCE_EFFECT;
    }

    private final boolean isArgument(VariableDescriptor variable2, DeclarationDescriptor variableParent) {
        return variable2 instanceof ValueParameterDescriptor && variableParent instanceof CallableDescriptor && ((CallableDescriptor)variableParent).getValueParameters().contains(variable2);
    }

    private final boolean isValInWhen(VariableDescriptor variable2) {
        boolean bl;
        LocalVariableDescriptor localVariableDescriptor = variable2 instanceof LocalVariableDescriptor ? (LocalVariableDescriptor)variable2 : null;
        Object object = localVariableDescriptor != null ? localVariableDescriptor.getSource() : null;
        KotlinSourceElement kotlinSourceElement = object instanceof KotlinSourceElement ? (KotlinSourceElement)object : null;
        if (kotlinSourceElement == null || (kotlinSourceElement = kotlinSourceElement.getPsi()) == null) {
            return false;
        }
        KotlinSourceElement psi = kotlinSourceElement;
        object = psi.getParent();
        KtWhenExpression ktWhenExpression = object instanceof KtWhenExpression ? (KtWhenExpression)object : null;
        if (ktWhenExpression != null) {
            KtWhenExpression it = ktWhenExpression;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it.getSubjectVariable(), (Object)psi);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCatchBlockParameter(VariableDescriptor variable2) {
        List list2;
        LocalVariableDescriptor localVariableDescriptor = variable2 instanceof LocalVariableDescriptor ? (LocalVariableDescriptor)variable2 : null;
        SourceElement sourceElement = localVariableDescriptor != null ? localVariableDescriptor.getSource() : null;
        if (!(sourceElement instanceof KotlinSourceElement)) return false;
        KotlinSourceElement kotlinSourceElement2 = (KotlinSourceElement)sourceElement;
        kotlinSourceElement2 = kotlinSourceElement2;
        if (kotlinSourceElement == null) return false;
        if ((kotlinSourceElement2 = kotlinSourceElement2.getPsi()) == null) {
            return false;
        }
        KotlinSourceElement psi = kotlinSourceElement2;
        PsiElement psiElement = psi.getParent().getParent();
        boolean bl = false;
        if (!(psiElement instanceof KtCatchClause)) return false;
        KtParameterList ktParameterList = ((KtCatchClause)psiElement).getParameterList();
        Object object = ktParameterList;
        if (ktParameterList == null) return false;
        List list3 = list2 = object.getParameters();
        object = list3;
        if (list3 == null) return false;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters");
        if (!CollectionsKt.contains((Iterable)list2, (Object)psi)) return false;
        return true;
    }

    private final boolean isForLoopParameter(VariableDescriptor variable2) {
        LocalVariableDescriptor localVariableDescriptor = variable2 instanceof LocalVariableDescriptor ? (LocalVariableDescriptor)variable2 : null;
        Object object = localVariableDescriptor != null ? localVariableDescriptor.getSource() : null;
        KotlinSourceElement kotlinSourceElement = object instanceof KotlinSourceElement ? (KotlinSourceElement)object : null;
        if (kotlinSourceElement == null || (kotlinSourceElement = kotlinSourceElement.getPsi()) == null) {
            return false;
        }
        KotlinSourceElement psi = kotlinSourceElement;
        if (psi.getParent() instanceof KtForExpression) {
            PsiElement psiElement = psi.getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtForExpression");
            KtForExpression forExpression = (KtForExpression)psiElement;
            return Intrinsics.areEqual((Object)forExpression.getLoopParameter(), (Object)psi);
        }
        if (psi.getParent() instanceof KtDestructuringDeclaration) {
            PsiElement psiElement = psi.getParent().getParent();
            KtParameter ktParameter = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
            if (ktParameter == null) {
                return false;
            }
            KtParameter parameter = ktParameter;
            PsiElement psiElement2 = parameter.getParent();
            KtForExpression ktForExpression = psiElement2 instanceof KtForExpression ? (KtForExpression)psiElement2 : null;
            if (ktForExpression == null) {
                return false;
            }
            KtForExpression forExpression = ktForExpression;
            return Intrinsics.areEqual((Object)forExpression.getLoopParameter(), (Object)parameter);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isExactlyOnceParameter(DeclarationDescriptor function2, VariableDescriptor parameter) {
        Object v1;
        block6: {
            void $this$filterIsInstanceTo$iv$iv;
            if (!(function2 instanceof CallableDescriptor)) {
                return false;
            }
            if (!(parameter instanceof ValueParameterDescriptor)) {
                return false;
            }
            Object object = (AbstractContractProvider)((CallableDescriptor)function2).getUserData(ContractProviderKey.INSTANCE);
            if (object == null || (object = ((AbstractContractProvider)object).getContractDescription()) == null) {
                return false;
            }
            Object contractDescription = object;
            Iterable $this$filterIsInstance$iv = ((ContractDescription)contractDescription).getEffects();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CallsEffectDeclaration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                CallsEffectDeclaration it = (CallsEffectDeclaration)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getVariableReference().getDescriptor(), (Object)((ValueParameterDescriptor)parameter).getOriginal())) continue;
                v1 = e;
                break block6;
            }
            v1 = null;
        }
        CallsEffectDeclaration callsEffectDeclaration = v1;
        if (callsEffectDeclaration == null) {
            return false;
        }
        CallsEffectDeclaration effect = callsEffectDeclaration;
        return effect.getKind() == EventOccurrencesRange.EXACTLY_ONCE;
    }

    private final boolean isExactlyOnceContract(BindingContext bindingContext, KtFunction argument2) {
        Pair<CallableDescriptor, ValueParameterDescriptor> pair = this.getCalleeDescriptorAndParameter(bindingContext, argument2);
        if (pair == null) {
            return false;
        }
        Pair<CallableDescriptor, ValueParameterDescriptor> pair2 = pair;
        CallableDescriptor descriptor2 = (CallableDescriptor)pair2.component1();
        ValueParameterDescriptor parameter = (ValueParameterDescriptor)pair2.component2();
        return this.isExactlyOnceParameter(descriptor2, parameter);
    }

    private final Pair<CallableDescriptor, ValueParameterDescriptor> getCalleeDescriptorAndParameter(BindingContext bindingContext, KtFunction argument2) {
        KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)((KtExpression)argument2));
        if (ktExpression == null) {
            return null;
        }
        KtExpression call2 = ktExpression;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)call2, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor descriptor2 = resolvedCall3.getResultingDescriptor();
        Call call3 = resolvedCall3.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call3, (String)"resolvedCall.call");
        ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression(call3, (KtExpression)argument2);
        if (valueArgument == null) {
            return null;
        }
        ValueArgument valueArgument2 = valueArgument;
        ArgumentMapping argumentMapping = resolvedCall3.getArgumentMapping(valueArgument2);
        ArgumentMatch argumentMatch = argumentMapping instanceof ArgumentMatch ? (ArgumentMatch)argumentMapping : null;
        if (argumentMatch == null) {
            return null;
        }
        ArgumentMatch mapping2 = argumentMatch;
        ValueParameterDescriptor parameter = mapping2.getValueParameter();
        return TuplesKt.to((Object)descriptor2, (Object)parameter);
    }

    private final boolean isCrossinlineParameter(BindingContext bindingContext, KtFunction argument2) {
        Object object = this.getCalleeDescriptorAndParameter(bindingContext, argument2);
        return object != null && (object = (ValueParameterDescriptor)object.getSecond()) != null ? object.isCrossinline() : false;
    }
}

