/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIntrinsicTransformers;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrClassModel;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamer;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.js.backend.ast.JsCompositeBlock;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0012H\u0096\u0001\u00a2\u0006\u0002\u0010\"J\u0011\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0012H\u0096\u0001J\u0011\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(H\u0096\u0001J\u0011\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0096\u0001J\u0011\u0010,\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0096\u0001J\u0011\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020/H\u0096\u0001J\u0011\u00100\u001a\u00020$2\u0006\u00101\u001a\u000202H\u0096\u0001J\u0011\u00103\u001a\u00020$2\u0006\u00104\u001a\u000205H\u0096\u0001J\u0011\u00106\u001a\u00020$2\u0006\u0010.\u001a\u00020/H\u0096\u0001J\u0011\u00107\u001a\u0002082\u0006\u0010%\u001a\u00020\u0012H\u0096\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;", "backendContext", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "irNamer", "globalNameScope", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "classModels", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrClassModel;", "getClassModels", "()Ljava/util/Map;", "coroutineImplDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getCoroutineImplDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getGlobalNameScope", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "initializerBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsCompositeBlock;", "getInitializerBlock", "()Lorg/jetbrains/kotlin/js/backend/ast/JsCompositeBlock;", "intrinsics", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIntrinsicTransformers;", "getIntrinsics", "()Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIntrinsicTransformers;", "getAssociatedObjectKey", "", "irClass", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Ljava/lang/Integer;", "getNameForClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "klass", "getNameForConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getNameForField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForMemberField", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getNameForStaticDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getNameForStaticFunction", "getRefForExternalClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "backend.js"})
public final class JsStaticContext
implements IrNamer {
    @NotNull
    private final JsIrBackendContext backendContext;
    @NotNull
    private final IrNamer irNamer;
    @NotNull
    private final NameTable<IrDeclaration> globalNameScope;
    @NotNull
    private final JsIntrinsicTransformers intrinsics;
    @NotNull
    private final Map<IrClassSymbol, JsIrClassModel> classModels;
    @NotNull
    private final IrClass coroutineImplDeclaration;
    @NotNull
    private final JsCompositeBlock initializerBlock;

    public JsStaticContext(@NotNull JsIrBackendContext backendContext, @NotNull IrNamer irNamer, @NotNull NameTable<IrDeclaration> globalNameScope) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)irNamer, (String)"irNamer");
        Intrinsics.checkNotNullParameter(globalNameScope, (String)"globalNameScope");
        this.backendContext = backendContext;
        this.irNamer = irNamer;
        this.globalNameScope = globalNameScope;
        this.intrinsics = new JsIntrinsicTransformers(this.backendContext);
        this.classModels = new LinkedHashMap();
        this.coroutineImplDeclaration = (IrClass)this.backendContext.getIr().getSymbols().getCoroutineImpl().getOwner();
        this.initializerBlock = new JsCompositeBlock();
    }

    @NotNull
    public final JsIrBackendContext getBackendContext() {
        return this.backendContext;
    }

    @NotNull
    public final NameTable<IrDeclaration> getGlobalNameScope() {
        return this.globalNameScope;
    }

    @Override
    @Nullable
    public Integer getAssociatedObjectKey(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.irNamer.getAssociatedObjectKey(irClass);
    }

    @Override
    @NotNull
    public JsName getNameForClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.irNamer.getNameForClass(klass);
    }

    @Override
    @NotNull
    public JsName getNameForConstructor(@NotNull IrConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        return this.irNamer.getNameForConstructor(constructor);
    }

    @Override
    @NotNull
    public JsName getNameForField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.irNamer.getNameForField(field);
    }

    @Override
    @NotNull
    public JsName getNameForMemberField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.irNamer.getNameForMemberField(field);
    }

    @Override
    @NotNull
    public JsName getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.irNamer.getNameForMemberFunction(function2);
    }

    @Override
    @NotNull
    public JsName getNameForProperty(@NotNull IrProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return this.irNamer.getNameForProperty(property);
    }

    @Override
    @NotNull
    public JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.irNamer.getNameForStaticDeclaration(declaration);
    }

    @Override
    @NotNull
    public JsName getNameForStaticFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.irNamer.getNameForStaticFunction(function2);
    }

    @Override
    @NotNull
    public JsNameRef getRefForExternalClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.irNamer.getRefForExternalClass(klass);
    }

    @NotNull
    public final JsIntrinsicTransformers getIntrinsics() {
        return this.intrinsics;
    }

    @NotNull
    public final Map<IrClassSymbol, JsIrClassModel> getClassModels() {
        return this.classModels;
    }

    @NotNull
    public final IrClass getCoroutineImplDeclaration() {
        return this.coroutineImplDeclaration;
    }

    @NotNull
    public final JsCompositeBlock getInitializerBlock() {
        return this.initializerBlock;
    }
}

