/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f*\u00020\rH\u0002J\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f*\u00020\u000eH\u0002J\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f*\u00020\u000fH\u0002J\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\tH\u0002J\f\u0010\u0013\u001a\u00020\u0006*\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ImplicitlyExportedDeclarationsMarkingLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "strictImplicitExport", "", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "collectImplicitlyExportedDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "markWithJsImplicitExport", "", "shouldBeMarkedWithImplicitExport", "backend.js"})
public final class ImplicitlyExportedDeclarationsMarkingLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;
    private final boolean strictImplicitExport;

    public ImplicitlyExportedDeclarationsMarkingLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.strictImplicitExport = this.context.getConfiguration().getBoolean(JSConfigurationKeys.GENERATE_STRICT_IMPLICIT_EXPORT);
    }

    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!this.strictImplicitExport || !ExportModelGeneratorKt.isExported(declaration, this.context)) {
            return null;
        }
        IrDeclaration irDeclaration2 = declaration;
        Set<IrDeclaration> implicitlyExportedDeclarations = irDeclaration2 instanceof IrFunction ? this.collectImplicitlyExportedDeclarations((IrFunction)declaration) : (irDeclaration2 instanceof IrClass ? this.collectImplicitlyExportedDeclarations((IrClass)declaration) : (irDeclaration2 instanceof IrProperty ? this.collectImplicitlyExportedDeclarations((IrProperty)declaration) : SetsKt.emptySet()));
        Iterable $this$forEach$iv = implicitlyExportedDeclarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            this.markWithJsImplicitExport(it);
        }
        return null;
    }

    private final Set<IrDeclaration> collectImplicitlyExportedDeclarations(IrClass $this$collectImplicitlyExportedDeclarations) {
        Iterable list$iv$iv;
        IrTypeParameter it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$collectImplicitlyExportedDeclarations.getTypeParameters();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrTypeParameter)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getSuperTypes();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrType)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.collectImplicitlyExportedDeclarations((IrType)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<IrDeclaration> collectImplicitlyExportedDeclarations(IrFunction $this$collectImplicitlyExportedDeclarations) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMapTo$iv$iv2;
        void $this$flatMap$iv;
        IrTypeParameter it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Set set;
        Set $this$collectImplicitlyExportedDeclarations_u24lambda_u245 = set = SetsKt.createSetBuilder();
        boolean $i$a$-buildSet-ImplicitlyExportedDeclarationsMarkingLowering$collectImplicitlyExportedDeclarations$types$22 = false;
        $this$collectImplicitlyExportedDeclarations_u24lambda_u245.add($this$collectImplicitlyExportedDeclarations.getReturnType());
        Iterable iterable = $this$collectImplicitlyExportedDeclarations.getValueParameters();
        Set set2 = $this$collectImplicitlyExportedDeclarations_u24lambda_u245;
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        set2.addAll((List)destination$iv$iv);
        $this$map$iv = $this$collectImplicitlyExportedDeclarations.getTypeParameters();
        set2 = $this$collectImplicitlyExportedDeclarations_u24lambda_u245;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            it = (IrTypeParameter)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getSuperTypes();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        set2.addAll((List)destination$iv$iv);
        Set types2 = SetsKt.build((Set)set);
        Iterable $this$flatMap$iv2 = types2;
        boolean $i$f$flatMap2 = false;
        Iterable $i$a$-buildSet-ImplicitlyExportedDeclarationsMarkingLowering$collectImplicitlyExportedDeclarations$types$22 = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrType it2 = (IrType)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.collectImplicitlyExportedDeclarations(it2);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
    }

    private final Set<IrDeclaration> collectImplicitlyExportedDeclarations(IrProperty $this$collectImplicitlyExportedDeclarations) {
        Object object;
        Object setterImplicitlyExportedDeclarations;
        Object object2;
        Object getterImplicitlyExportedDeclarations;
        Object object3 = $this$collectImplicitlyExportedDeclarations.getGetter();
        if (object3 == null || (object3 = this.collectImplicitlyExportedDeclarations((IrFunction)object3)) == null) {
            object3 = getterImplicitlyExportedDeclarations = SetsKt.emptySet();
        }
        if ((object2 = $this$collectImplicitlyExportedDeclarations.getSetter()) == null || (object2 = this.collectImplicitlyExportedDeclarations((IrFunction)object2)) == null) {
            object2 = setterImplicitlyExportedDeclarations = SetsKt.emptySet();
        }
        if ((object = $this$collectImplicitlyExportedDeclarations.getBackingField()) == null || (object = object.getType()) == null || (object = this.collectImplicitlyExportedDeclarations((IrType)object)) == null) {
            object = SetsKt.emptySet();
        }
        Object fieldImplicitlyExportedDeclarations = object;
        return SetsKt.plus((Set)SetsKt.plus((Set)getterImplicitlyExportedDeclarations, (Iterable)((Iterable)setterImplicitlyExportedDeclarations)), (Iterable)((Iterable)fieldImplicitlyExportedDeclarations));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<IrDeclaration> collectImplicitlyExportedDeclarations(IrType $this$collectImplicitlyExportedDeclarations) {
        Set set;
        if ($this$collectImplicitlyExportedDeclarations instanceof IrDynamicType || !($this$collectImplicitlyExportedDeclarations instanceof IrSimpleType)) {
            return SetsKt.emptySet();
        }
        IrType irType = IrTypesKt.makeNotNull((IrType)$this$collectImplicitlyExportedDeclarations);
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrSimpleType nonNullType = (IrSimpleType)irType;
        IrClassifierSymbol classifier = nonNullType.getClassifier();
        if (IrTypePredicatesKt.isPrimitiveType$default((IrType)((IrType)nonNullType), (boolean)false, (int)1, null) || IrTypeUtilsKt.isPrimitiveArray((IrType)((IrType)nonNullType)) || IrTypePredicatesKt.isAny((IrType)((IrType)nonNullType)) || IrTypePredicatesKt.isUnit((IrType)((IrType)nonNullType))) {
            set = SetsKt.emptySet();
        } else if (classifier instanceof IrTypeParameterSymbol) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                IrType it = (IrType)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.collectImplicitlyExportedDeclarations(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else if (classifier instanceof IrClassSymbol) {
            IrSymbolOwner irSymbolOwner = ((IrClassSymbol)classifier).getOwner();
            IrClass it = (IrClass)irSymbolOwner;
            boolean bl = false;
            set = SetsKt.setOfNotNull((Object)(this.shouldBeMarkedWithImplicitExport((IrDeclaration)it) ? irSymbolOwner : null));
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final boolean shouldBeMarkedWithImplicitExport(IrDeclaration $this$shouldBeMarkedWithImplicitExport) {
        return $this$shouldBeMarkedWithImplicitExport instanceof IrClass && !((IrClass)$this$shouldBeMarkedWithImplicitExport).isExternal() && !ExportModelGeneratorKt.isExported($this$shouldBeMarkedWithImplicitExport, this.context) && !AnnotationUtilsKt.isJsImplicitExport((IrAnnotationContainer)$this$shouldBeMarkedWithImplicitExport);
    }

    private final void markWithJsImplicitExport(IrDeclaration $this$markWithJsImplicitExport) {
        block1: {
            IrClass irClass;
            IrConstructorSymbol jsImplicitExportCtor = (IrConstructorSymbol)SequencesKt.single((Sequence)IrUtilsKt.getConstructors((IrClassSymbol)this.context.getIntrinsics().getJsImplicitExportAnnotationSymbol()));
            $this$markWithJsImplicitExport.setAnnotations(CollectionsKt.plus((Collection)$this$markWithJsImplicitExport.getAnnotations(), (Object)ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)$this$markWithJsImplicitExport.getSymbol(), (int)0, (int)0, (int)6, null)), (IrConstructorSymbol)jsImplicitExportCtor)));
            Object object = IrUtilsKt.getParentClassOrNull((IrDeclaration)$this$markWithJsImplicitExport);
            if (object == null) break block1;
            IrClass it = irClass = object;
            boolean bl = false;
            object = this.shouldBeMarkedWithImplicitExport((IrDeclaration)it) ? irClass : null;
            if (object != null) {
                this.markWithJsImplicitExport((IrDeclaration)object);
            }
        }
    }
}

