/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.lower.TailCallOptimizationLoweringKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/TailCallOptimizationData;", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)V", "getFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "returnsUnit", "", "getReturnsUnit", "()Z", "tailCalls", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getTailCalls", "()Ljava/util/Set;", "findCallsOnTailPositionWithoutImmediateReturn", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "immediateReturn", "backend.jvm.lower"})
final class TailCallOptimizationData {
    @NotNull
    private final IrSimpleFunction function;
    private final boolean returnsUnit;
    @NotNull
    private final Set<IrCall> tailCalls;

    public TailCallOptimizationData(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        this.function = function2;
        this.returnsUnit = IrTypePredicatesKt.isUnit((IrType)this.function.getReturnType());
        this.tailCalls = new LinkedHashSet();
        IrBody body2 = this.function.getBody();
        if (body2 instanceof IrBlockBody) {
            IrStatement irStatement = TailCallOptimizationLoweringKt.access$findTailCall(((IrBlockBody)body2).getStatements(), this.returnsUnit);
            if (irStatement != null) {
                TailCallOptimizationData.findCallsOnTailPositionWithoutImmediateReturn$default(this, irStatement, false, 1, null);
            }
        } else if (body2 instanceof IrExpressionBody) {
            this.findCallsOnTailPositionWithoutImmediateReturn((IrStatement)((IrExpressionBody)body2).getExpression(), true);
        }
    }

    @NotNull
    public final IrSimpleFunction getFunction() {
        return this.function;
    }

    public final boolean getReturnsUnit() {
        return this.returnsUnit;
    }

    @NotNull
    public final Set<IrCall> getTailCalls() {
        return this.tailCalls;
    }

    private final void findCallsOnTailPositionWithoutImmediateReturn(IrStatement $this$findCallsOnTailPositionWithoutImmediateReturn, boolean immediateReturn) {
        if ($this$findCallsOnTailPositionWithoutImmediateReturn instanceof IrCall && IrUtilsKt.isSuspend((IrCall)((IrCall)$this$findCallsOnTailPositionWithoutImmediateReturn)) && !immediateReturn && (this.returnsUnit || Intrinsics.areEqual((Object)((IrCall)$this$findCallsOnTailPositionWithoutImmediateReturn).getType(), (Object)this.function.getReturnType()))) {
            ((Collection)this.tailCalls).add($this$findCallsOnTailPositionWithoutImmediateReturn);
        } else if ($this$findCallsOnTailPositionWithoutImmediateReturn instanceof IrBlock) {
            IrStatement irStatement = TailCallOptimizationLoweringKt.access$findTailCall(((IrBlock)$this$findCallsOnTailPositionWithoutImmediateReturn).getStatements(), this.returnsUnit);
            if (irStatement != null) {
                TailCallOptimizationData.findCallsOnTailPositionWithoutImmediateReturn$default(this, irStatement, false, 1, null);
            }
        } else if ($this$findCallsOnTailPositionWithoutImmediateReturn instanceof IrWhen) {
            Iterable $this$forEach$iv = ((IrWhen)$this$findCallsOnTailPositionWithoutImmediateReturn).getBranches();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrBranch it = (IrBranch)element$iv;
                boolean bl = false;
                TailCallOptimizationData.findCallsOnTailPositionWithoutImmediateReturn$default(this, (IrStatement)it.getResult(), false, 1, null);
            }
        } else if ($this$findCallsOnTailPositionWithoutImmediateReturn instanceof IrReturn) {
            this.findCallsOnTailPositionWithoutImmediateReturn((IrStatement)((IrReturn)$this$findCallsOnTailPositionWithoutImmediateReturn).getValue(), true);
        } else if ($this$findCallsOnTailPositionWithoutImmediateReturn instanceof IrTypeOperatorCall && ((IrTypeOperatorCall)$this$findCallsOnTailPositionWithoutImmediateReturn).getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT) {
            TailCallOptimizationData.findCallsOnTailPositionWithoutImmediateReturn$default(this, (IrStatement)((IrTypeOperatorCall)$this$findCallsOnTailPositionWithoutImmediateReturn).getArgument(), false, 1, null);
        }
    }

    static /* synthetic */ void findCallsOnTailPositionWithoutImmediateReturn$default(TailCallOptimizationData tailCallOptimizationData, IrStatement irStatement, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        tailCallOptimizationData.findCallsOnTailPositionWithoutImmediateReturn(irStatement, bl);
    }
}

