/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CompanionInParenthesesLHSCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class CompanionInParenthesesLHSCallChecker
implements CallChecker {
    @NotNull
    public static final CompanionInParenthesesLHSCallChecker INSTANCE = new CompanionInParenthesesLHSCallChecker();

    private CompanionInParenthesesLHSCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        KtDotQualifiedExpression ktDotQualifiedExpression;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiElement psiElement = resolvedCall2.getCall().getCallElement().getParent();
        KtCallableReferenceExpression ktCallableReferenceExpression = psiElement instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)psiElement : null;
        if (ktCallableReferenceExpression == null) {
            return;
        }
        KtCallableReferenceExpression callableReference = ktCallableReferenceExpression;
        PsiElement psiElement2 = callableReference.getLhs();
        KtParenthesizedExpression ktParenthesizedExpression = psiElement2 instanceof KtParenthesizedExpression ? (KtParenthesizedExpression)psiElement2 : null;
        if (ktParenthesizedExpression == null) {
            return;
        }
        KtParenthesizedExpression parenthesizedExpression = ktParenthesizedExpression;
        KtExpression ktExpression = parenthesizedExpression.getExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression unwrappedLhs = ktExpression;
        Receiver receiver = resolvedCall2.getCall().getExplicitReceiver();
        ExpressionReceiver expressionReceiver = receiver instanceof ExpressionReceiver ? (ExpressionReceiver)receiver : null;
        if (expressionReceiver == null) {
            return;
        }
        ExpressionReceiver expressionReceiver2 = expressionReceiver;
        ClassifierDescriptor classifierDescriptor = expressionReceiver2.getType().getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor2 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor2 == null) {
            return;
        }
        ClassDescriptor referencedClass = classDescriptor2;
        if (!referencedClass.isCompanionObject()) {
            return;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression2 = unwrappedLhs instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)unwrappedLhs : null;
        if (ktDotQualifiedExpression2 == null || (ktDotQualifiedExpression2 = ktDotQualifiedExpression2.getSelectorExpression()) == null) {
            ktDotQualifiedExpression2 = unwrappedLhs;
        }
        KtReferenceExpression ktReferenceExpression = (ktDotQualifiedExpression = ktDotQualifiedExpression2) instanceof KtReferenceExpression ? (KtReferenceExpression)ktDotQualifiedExpression : null;
        if (ktReferenceExpression == null) {
            return;
        }
        KtReferenceExpression simpleReference = ktReferenceExpression;
        if (context.getTrace().getBindingContext().get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, simpleReference) == null) {
            return;
        }
        context.getTrace().report(Errors.PARENTHESIZED_COMPANION_LHS_DEPRECATION.on((KtParenthesizedExpression)((PsiElement)parenthesizedExpression)));
    }
}

