/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.utils.TypeTranformerKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u001e\u0010\u0019\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0018\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010$\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020\"H\u0002J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u0013H\u0002J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b*\u0002002\u0006\u0010)\u001a\u00020\u0013H\u0002J\f\u00101\u001a\u00020\"*\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmBaseTypeOperatorTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "eraseToClassOrInterface", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getEraseToClassOrInterface", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateIsExternalClass", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "argument", "klass", "generateIsInterface", "toType", "generateIsSubClass", "generateTypeCheck", "valueProvider", "Lkotlin/Function0;", "generateTypeCheckNonNull", "generateTypeCheckWithTypeParameter", "lowerCast", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "isSafe", "", "lowerImplicitCast", "lowerInstanceOf", "inverted", "lowerIntegerCoercion", "narrowType", "fromType", "value", "visitTypeOperator", "visitVariable", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "cacheValue", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "isInlined", "backend.wasm"})
public final class WasmBaseTypeOperatorTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final WasmSymbols symbols;
    @NotNull
    private final IrBuiltIns builtIns;
    private DeclarationIrBuilder builder;

    public WasmBaseTypeOperatorTransformer(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.symbols = this.context.getWasmSymbols();
        this.builtIns = this.context.getIrBuiltIns();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitTypeOperator(expression2);
        BackendContext backendContext = (BackendContext)this.context;
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        this.builder = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)((IrBuilder)LowerUtilsKt.createIrBuilder$default((BackendContext)backendContext, (IrSymbol)scopeWithIr.getScope().getScopeOwnerSymbol(), (int)0, (int)0, (int)6, null)), (IrElement)((IrElement)expression2));
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
            case 1: {
                irExpression = this.lowerImplicitCast(expression2);
                break;
            }
            case 2: {
                throw new IllegalStateException("Dynamic casts are not supported in Wasm backend".toString());
            }
            case 3: {
                irExpression = (IrExpression)expression2;
                break;
            }
            case 4: {
                irExpression = this.lowerIntegerCoercion(expression2);
                break;
            }
            case 5: {
                irExpression = this.lowerImplicitCast(expression2);
                break;
            }
            case 6: {
                irExpression = this.lowerInstanceOf(expression2, false);
                break;
            }
            case 7: {
                irExpression = this.lowerInstanceOf(expression2, true);
                break;
            }
            case 8: {
                irExpression = this.lowerCast(expression2, false);
                break;
            }
            case 9: {
                irExpression = this.lowerCast(expression2, true);
                break;
            }
            case 10: {
                String string2 = "SAM conversion: " + RenderIrElementKt.render((IrElement)((IrElement)expression2));
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }
            case 11: {
                irExpression = (IrExpression)expression2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return irExpression;
    }

    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrExpression initializer = declaration.getInitializer();
        if (initializer != null && !Intrinsics.areEqual((Object)initializer.getType(), (Object)declaration.getType())) {
            BackendContext backendContext = (BackendContext)this.context;
            ScopeWithIr scopeWithIr = this.getCurrentScope();
            Intrinsics.checkNotNull((Object)scopeWithIr);
            this.builder = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)((IrBuilder)LowerUtilsKt.createIrBuilder$default((BackendContext)backendContext, (IrSymbol)scopeWithIr.getScope().getScopeOwnerSymbol(), (int)0, (int)0, (int)6, null)), (IrElement)((IrElement)declaration));
            declaration.setInitializer(this.narrowType(initializer.getType(), declaration.getType(), initializer));
        }
        return super.visitVariable(declaration);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerInstanceOf(IrTypeOperatorCall expression2, boolean inverted) {
        void this_$iv$iv;
        void $this$irComposite_u24default$iv;
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)declarationIrBuilder;
        IrType resultType$iv = this.builtIns.getBooleanType();
        int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irComposite = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
        boolean $i$f$block = false;
        void $this$lowerInstanceOf_u24lambda_u240 = this_$iv$iv;
        boolean bl = false;
        Function0<IrExpression> argument2 = this.cacheValue((IrBlockBuilder)$this$lowerInstanceOf_u24lambda_u240, expression2.getArgument());
        IrExpression check2 = this.generateTypeCheck(argument2, expression2.getTypeOperand());
        if (inverted) {
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder2 = null;
            }
            $this$lowerInstanceOf_u24lambda_u240.unaryPlus((IrStatement)LowerUtilsKt.irNot((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder2), (IrExpression)check2));
        } else {
            $this$lowerInstanceOf_u24lambda_u240.unaryPlus((IrStatement)check2);
        }
        return (IrExpression)this_$iv$iv.doBuild();
    }

    private final Function0<IrExpression> cacheValue(IrBlockBuilder $this$cacheValue, IrExpression value2) {
        if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isPure$default((IrExpression)value2, (boolean)true, (boolean)false, null, (int)6, null) && IrUtilsKt.isTrivial((IrExpression)value2)) {
            return (Function0)new Function0<IrExpression>(value2){
                final /* synthetic */ IrExpression $value;
                {
                    this.$value = $value;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final IrExpression invoke() {
                    void p1;
                    DeepCopyTypeRemapper typeRemapper$iv$iv;
                    void $this$deepCopyWithSymbols$iv$iv;
                    IrElement $this$deepCopyWithSymbols_u24default$iv = (IrElement)this.$value;
                    IrDeclarationParent initialParent$iv = null;
                    boolean $i$f$deepCopyWithSymbols = false;
                    IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
                    DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                    boolean $i$f$deepCopyWithSymbols2 = false;
                    IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, (IrElementVisitorVoid)((IrElementVisitorVoid)symbolRemapper$iv$iv));
                    DeepCopyTypeRemapper deepCopyTypeRemapper = typeRemapper$iv$iv = new DeepCopyTypeRemapper((SymbolRemapper)symbolRemapper$iv$iv);
                    DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                    void var11_10 = $this$deepCopyWithSymbols$iv$iv;
                    boolean bl = false;
                    deepCopyTypeRemapper = (TypeRemapper)deepCopyTypeRemapper;
                    SymbolRemapper p0 = (SymbolRemapper)deepCopySymbolRemapper;
                    IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents((IrElement)var11_10.transform((IrElementTransformer)new DeepCopyIrTreeWithSymbols(p0, (TypeRemapper)p1), null), initialParent$iv);
                    if (irElement2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                    }
                    return (IrExpression)((IrElement)((IrExpression)irElement2));
                }
            };
        }
        IrVariable tmpVal = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$cacheValue), (IrExpression)value2, null, (boolean)false, null, null, (int)30, null);
        return (Function0)new Function0<IrGetValueImpl>(this, tmpVal){
            final /* synthetic */ WasmBaseTypeOperatorTransformer this$0;
            final /* synthetic */ IrVariable $tmpVal;
            {
                this.this$0 = $receiver;
                this.$tmpVal = $tmpVal;
                super(0);
            }

            @NotNull
            public final IrGetValueImpl invoke() {
                DeclarationIrBuilder declarationIrBuilder = WasmBaseTypeOperatorTransformer.access$getBuilder$p(this.this$0);
                if (declarationIrBuilder == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    declarationIrBuilder = null;
                }
                return ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder), (IrValueDeclaration)((IrValueDeclaration)this.$tmpVal));
            }
        };
    }

    private final boolean isInlined(IrType $this$isInlined) {
        return this.context.getInlineClassesUtils().isTypeInlined($this$isInlined);
    }

    private final IrClass getEraseToClassOrInterface(IrType $this$eraseToClassOrInterface) {
        IrClass irClass = TypeTranformerKt.getErasedUpperBound($this$eraseToClassOrInterface);
        if (irClass == null) {
            irClass = (IrClass)this.builtIns.getAnyClass().getOwner();
        }
        return irClass;
    }

    private final IrExpression generateTypeCheck(Function0<? extends IrExpression> valueProvider, IrType toType) {
        IrExpression irExpression;
        IrType toNotNullable = IrTypesKt.makeNotNull((IrType)toType);
        IrExpression valueInstance = (IrExpression)valueProvider.invoke();
        IrType fromType = valueInstance.getType();
        if (this.isInlined(fromType)) {
            boolean result2 = IrUtilsKt.isSubclassOf((IrClass)this.getEraseToClassOrInterface(fromType), (IrClass)this.getEraseToClassOrInterface(toType));
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            return (IrExpression)ExpressionHelpersKt.irBoolean((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder), (boolean)result2);
        }
        IrExpression instanceCheck = this.generateTypeCheckNonNull(valueInstance, toNotNullable);
        boolean isFromNullable = IrTypeUtilsKt.isNullable((IrType)valueInstance.getType());
        boolean isToNullable = IrTypeUtilsKt.isNullable((IrType)toType);
        if (!isFromNullable) {
            irExpression = instanceCheck;
        } else {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)declarationIrBuilder;
            IrType irType = this.builtIns.getBooleanType();
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder2 = null;
            }
            IrExpression irExpression2 = ExpressionHelpersKt.irEqualsNull((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder2), (IrExpression)((IrExpression)valueProvider.invoke()));
            DeclarationIrBuilder declarationIrBuilder3 = this.builder;
            if (declarationIrBuilder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder3 = null;
            }
            irExpression = (IrExpression)ExpressionHelpersKt.irIfThenElse$default((IrBuilderWithScope)irBuilderWithScope, (IrType)irType, (IrExpression)irExpression2, (IrExpression)((IrExpression)ExpressionHelpersKt.irBoolean((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder3), (boolean)isToNullable)), (IrExpression)instanceCheck, null, (int)16, null);
        }
        return irExpression;
    }

    private final IrExpression lowerIntegerCoercion(IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        IrType irType = expression2.getTypeOperand();
        if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getByteType()) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getShortType())) {
            irExpression = expression2.getArgument();
        } else if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getLongType())) {
            IrCall irCall;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrCall $this$lowerIntegerCoercion_u24lambda_u241 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder), (IrSimpleFunctionSymbol)this.symbols.getIntToLong());
            boolean bl = false;
            $this$lowerIntegerCoercion_u24lambda_u241.putValueArgument(0, expression2.getArgument());
            irExpression = (IrExpression)irCall;
        } else {
            throw new IllegalStateException("Unreachable execution (coercion to non-Integer type".toString());
        }
        return irExpression;
    }

    private final IrExpression generateTypeCheckNonNull(IrExpression argument2, IrType toType) {
        IrExpression irExpression;
        boolean bl;
        boolean bl2 = bl = !IrTypePredicatesKt.isMarkedNullable((IrType)toType);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        IrClass classOrInterface = this.getEraseToClassOrInterface(toType);
        if (classOrInterface.isExternal()) {
            if (classOrInterface.getKind() == ClassKind.INTERFACE) {
                DeclarationIrBuilder declarationIrBuilder = this.builder;
                if (declarationIrBuilder == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    declarationIrBuilder = null;
                }
                irExpression = (IrExpression)ExpressionHelpersKt.irTrue((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder));
            } else {
                irExpression = this.generateIsExternalClass(argument2, classOrInterface);
            }
        } else if (IrTypePredicatesKt.isNothing((IrType)toType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            irExpression = (IrExpression)ExpressionHelpersKt.irFalse((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder));
        } else {
            irExpression = org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isTypeParameter((IrType)toType) ? this.generateTypeCheckWithTypeParameter(argument2, toType) : (org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isInterface((IrType)toType) ? this.generateIsInterface(argument2, toType) : this.generateIsSubClass(argument2, toType));
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression narrowType(IrType fromType, IrType toType, IrExpression value2) {
        IrCall irCall;
        if (Intrinsics.areEqual((Object)fromType, (Object)toType)) {
            return value2;
        }
        if (Intrinsics.areEqual((Object)toType, (Object)this.builtIns.getNothingNType())) {
            void this_$iv$iv;
            void $this$irComposite_u24default$iv;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)declarationIrBuilder;
            IrType resultType$iv = this.builtIns.getNothingNType();
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            void $this$narrowType_u24lambda_u242 = this_$iv$iv;
            boolean bl = false;
            $this$narrowType_u24lambda_u242.unaryPlus((IrStatement)value2);
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder2 = null;
            }
            $this$narrowType_u24lambda_u242.unaryPlus((IrStatement)ExpressionHelpersKt.irNull((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder2)));
            return (IrExpression)this_$iv$iv.doBuild();
        }
        if (Intrinsics.areEqual((Object)toType, (Object)this.builtIns.getAnyNType()) && Intrinsics.areEqual((Object)fromType, (Object)this.builtIns.getNothingNType()) && value2 instanceof IrConst && Intrinsics.areEqual((Object)((IrConst)value2).getKind(), (Object)IrConstKind.Null.INSTANCE)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            return (IrExpression)ExpressionHelpersKt.irNull((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder), (IrType)this.builtIns.getNothingNType());
        }
        if (this.isInlined(toType) && !this.isInlined(fromType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrType[] $this$irComposite_u24default$iv = new IrType[]{fromType, toType};
            IrType[] it = $this$irComposite_u24default$iv = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder), (IrFunctionSymbol)((IrFunctionSymbol)this.symbols.getUnboxIntrinsic()), (IrType)toType, (List)CollectionsKt.listOf((Object[])$this$irComposite_u24default$iv));
            boolean bl = false;
            it.putValueArgument(0, value2);
            return (IrExpression)$this$irComposite_u24default$iv;
        }
        if (!this.isInlined(toType) && this.isInlined(fromType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrType[] $this$irComposite_u24default$iv = new IrType[]{fromType, toType};
            IrType[] it = $this$irComposite_u24default$iv = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder), (IrFunctionSymbol)((IrFunctionSymbol)this.symbols.getBoxIntrinsic()), (IrType)toType, (List)CollectionsKt.listOf((Object[])$this$irComposite_u24default$iv));
            boolean bl = false;
            it.putValueArgument(0, value2);
            return (IrExpression)$this$irComposite_u24default$iv;
        }
        IrClass fromClass = this.getEraseToClassOrInterface(fromType);
        IrClass toClass = this.getEraseToClassOrInterface(toType);
        if (fromClass.isExternal() && toClass.isExternal()) {
            return value2;
        }
        if (fromClass.isExternal() && !toClass.isExternal()) {
            IrCall origin$iv;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrCall it = origin$iv = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder), (IrSimpleFunctionSymbol)this.symbols.getJsInteropAdapters().getJsToKotlinAnyAdapter());
            boolean bl = false;
            it.putValueArgument(0, value2);
            IrCall narrowingToAny = origin$iv;
            return this.narrowType(this.context.getIrBuiltIns().getAnyType(), toType, (IrExpression)narrowingToAny);
        }
        if (toClass.isExternal() && !fromClass.isExternal()) {
            IrCall narrowingToAny;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrCall it = narrowingToAny = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder), (IrSimpleFunctionSymbol)this.symbols.getJsInteropAdapters().getKotlinToJsAnyAdapter());
            boolean bl = false;
            it.putValueArgument(0, value2);
            return (IrExpression)narrowingToAny;
        }
        if (IrUtilsKt.isSubclassOf((IrClass)fromClass, (IrClass)toClass)) {
            return value2;
        }
        if (IrTypePredicatesKt.isNothing((IrType)toType)) {
            void this_$iv$iv;
            void $this$irComposite_u24default$iv;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            IrBuilderWithScope narrowingToAny = (IrBuilderWithScope)declarationIrBuilder;
            IrType resultType$iv = this.context.getIrBuiltIns().getNothingType();
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder $this$narrowType_u24lambda_u242 = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            void $this$narrowType_u24lambda_u247 = this_$iv$iv;
            boolean bl = false;
            $this$narrowType_u24lambda_u247.unaryPlus((IrStatement)value2);
            $this$narrowType_u24lambda_u247.unaryPlus((IrStatement)ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$narrowType_u24lambda_u247), (IrSimpleFunctionSymbol)this.symbols.getWasmUnreachable()));
            return (IrExpression)this_$iv$iv.doBuild();
        }
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        IrCall $this$narrowType_u24lambda_u248 = irCall = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder), (IrSimpleFunctionSymbol)this.symbols.getRefCast(), (IrType)toType, (int)0, (int)0, null, (int)28, null);
        boolean bl = false;
        $this$narrowType_u24lambda_u248.putTypeArgument(0, toType);
        $this$narrowType_u24lambda_u248.putValueArgument(0, value2);
        return (IrExpression)irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerCast(IrTypeOperatorCall expression2, boolean isSafe) {
        void this_$iv$iv;
        void $this$irComposite_u24default$iv;
        DeclarationIrBuilder declarationIrBuilder;
        IrExpression failResult;
        IrExpression irExpression;
        IrType toType = expression2.getTypeOperand();
        IrType fromType = expression2.getArgument().getType();
        if (IrUtilsKt.isSubclassOf((IrClass)this.getEraseToClassOrInterface(fromType), (IrClass)this.getEraseToClassOrInterface(expression2.getType()))) {
            return this.narrowType(fromType, expression2.getType(), expression2.getArgument());
        }
        if (isSafe) {
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder2 = null;
            }
            irExpression = (IrExpression)ExpressionHelpersKt.irNull((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder2));
        } else {
            DeclarationIrBuilder declarationIrBuilder3 = this.builder;
            if (declarationIrBuilder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder3 = null;
            }
            irExpression = failResult = (IrExpression)ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder3), (IrSimpleFunctionSymbol)this.context.getIr().getSymbols().getThrowTypeCastException());
        }
        if ((declarationIrBuilder = this.builder) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)declarationIrBuilder;
        IrType resultType$iv = expression2.getType();
        int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irComposite = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
        boolean $i$f$block = false;
        void $this$lowerCast_u24lambda_u249 = this_$iv$iv;
        boolean bl = false;
        Function0<IrExpression> argument2 = this.cacheValue((IrBlockBuilder)$this$lowerCast_u24lambda_u249, expression2.getArgument());
        IrExpression narrowArg = this.narrowType(fromType, expression2.getType(), (IrExpression)argument2.invoke());
        IrExpression check2 = this.generateTypeCheck(argument2, toType);
        if (check2 instanceof IrConst) {
            Object object = ((IrConst)check2).getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            boolean value2 = (Boolean)object;
            if (value2) {
                $this$lowerCast_u24lambda_u249.unaryPlus((IrStatement)narrowArg);
            } else {
                $this$lowerCast_u24lambda_u249.unaryPlus((IrStatement)failResult);
            }
        } else {
            DeclarationIrBuilder declarationIrBuilder4 = this.builder;
            if (declarationIrBuilder4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder4 = null;
            }
            $this$lowerCast_u24lambda_u249.unaryPlus((IrStatement)ExpressionHelpersKt.irIfThenElse$default((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder4), (IrType)expression2.getType(), (IrExpression)check2, (IrExpression)narrowArg, (IrExpression)failResult, null, (int)16, null));
        }
        return (IrExpression)this_$iv$iv.doBuild();
    }

    private final IrExpression lowerImplicitCast(IrTypeOperatorCall expression2) {
        return this.narrowType(expression2.getArgument().getType(), expression2.getTypeOperand(), expression2.getArgument());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateTypeCheckWithTypeParameter(IrExpression argument2, IrType toType) {
        void $this$fold$iv;
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull((IrType)toType);
        IrSymbolOwner irSymbolOwner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
        IrTypeParameter irTypeParameter = irSymbolOwner instanceof IrTypeParameter ? (IrTypeParameter)irSymbolOwner : null;
        if (irTypeParameter == null) {
            throw new IllegalStateException(("expected type parameter, but got " + toType).toString());
        }
        IrTypeParameter typeParameter = irTypeParameter;
        Iterable iterable = typeParameter.getSuperTypes();
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        IrConstImpl irConstImpl = ExpressionHelpersKt.irTrue((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder));
        Intrinsics.checkNotNull((Object)irConstImpl, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
        IrExpression initial$iv = (IrExpression)irConstImpl;
        boolean $i$f$fold = false;
        IrExpression accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            IrCall irCall;
            void t;
            IrType irType = (IrType)element$iv;
            IrExpression r = accumulator$iv;
            boolean bl = false;
            IrExpression check2 = this.generateTypeCheckNonNull(IrUtilsKt.shallowCopy((IrExpression)argument2), IrTypesKt.makeNotNull((IrType)t));
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder2 = null;
            }
            IrCall $this$generateTypeCheckWithTypeParameter_u24lambda_u2411_u24lambda_u2410 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder2), (IrSimpleFunctionSymbol)this.symbols.getBooleanAnd());
            boolean bl2 = false;
            $this$generateTypeCheckWithTypeParameter_u24lambda_u2411_u24lambda_u2410.putValueArgument(0, r);
            $this$generateTypeCheckWithTypeParameter_u24lambda_u2411_u24lambda_u2410.putValueArgument(1, check2);
            accumulator$iv = (IrExpression)irCall;
        }
        return accumulator$iv;
    }

    private final IrExpression generateIsInterface(IrExpression argument2, IrType toType) {
        IrCall irCall;
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        IrCall $this$generateIsInterface_u24lambda_u2412 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder), (IrSimpleFunctionSymbol)this.symbols.getWasmIsInterface());
        boolean bl = false;
        $this$generateIsInterface_u24lambda_u2412.putValueArgument(0, argument2);
        $this$generateIsInterface_u24lambda_u2412.putTypeArgument(0, toType);
        return (IrExpression)irCall;
    }

    private final IrExpression generateIsSubClass(IrExpression argument2, IrType toType) {
        IrCall irCall;
        IrClass toTypeErased;
        IrType fromType = argument2.getType();
        IrClass fromTypeErased = TypeTransformerKt.getRuntimeClass(fromType, this.context.getIrBuiltIns());
        if (IrUtilsKt.isSubclassOf((IrClass)fromTypeErased, (IrClass)(toTypeErased = TypeTransformerKt.getRuntimeClass(toType, this.context.getIrBuiltIns())))) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            return (IrExpression)ExpressionHelpersKt.irTrue((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder));
        }
        if (!IrUtilsKt.isSubclassOf((IrClass)toTypeErased, (IrClass)fromTypeErased)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            }
            return (IrExpression)ExpressionHelpersKt.irFalse((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder));
        }
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        IrCall $this$generateIsSubClass_u24lambda_u2413 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder), (IrSimpleFunctionSymbol)this.symbols.getRefTest());
        boolean bl = false;
        $this$generateIsSubClass_u24lambda_u2413.putValueArgument(0, argument2);
        $this$generateIsSubClass_u24lambda_u2413.putTypeArgument(0, toType);
        return (IrExpression)irCall;
    }

    private final IrExpression generateIsExternalClass(IrExpression argument2, IrClass klass) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        Mapping.Delegate<IrSimpleFunction, IrSimpleFunction> delegate = this.context.getMapping().getWasmJsInteropFunctionToWrapper();
        Object object = this.context.getMapping().getWasmExternalClassToInstanceCheck().get((IrDeclaration)klass);
        Intrinsics.checkNotNull((Object)object);
        Object object2 = delegate.get((IrDeclaration)object);
        Intrinsics.checkNotNull((Object)object2);
        IrSimpleFunction function2 = (IrSimpleFunction)object2;
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        }
        IrFunctionAccessExpression it = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)declarationIrBuilder), (IrFunction)((IrFunction)function2));
        boolean bl = false;
        it.putValueArgument(0, argument2);
        return (IrExpression)irFunctionAccessExpression;
    }

    public static final /* synthetic */ DeclarationIrBuilder access$getBuilder$p(WasmBaseTypeOperatorTransformer $this) {
        return $this.builder;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.IMPLICIT_CAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_DYNAMIC_CAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_INTEGER_COERCION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.CAST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAM_CONVERSION.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

