/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LoopLabelType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.OptimisedWhenGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.SyntheticLocalType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VirtualMethodMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFunctionCodegenContext;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.DisjointUnions;
import org.jetbrains.kotlin.backend.wasm.utils.UtilsKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.TypeTranformerKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrReturnTarget;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImmediateKind;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0015\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002J\u0018\u0010+\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\"H\u0002J\u001d\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020)H\u0000\u00a2\u0006\u0002\b2J\u0018\u00103\u001a\u00020\b2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002J\u0018\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u00020)2\u0006\u00101\u001a\u00020)H\u0002J\u0018\u00106\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020\b2\u0006\u00107\u001a\u000208H\u0002J\u0010\u0010:\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020@H\u0016J\u0014\u0010A\u001a\u00020\u001d2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030BH\u0016J\u0010\u0010C\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\u001d2\u0006\u0010L\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\u001d2\u0006\u0010O\u001a\u00020\"H\u0016J\u0010\u0010P\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020QH\u0002J\u0010\u0010R\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020QH\u0016J\u0010\u0010W\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020XH\u0016J\u0010\u0010Y\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\\H\u0016J\u0010\u0010]\u001a\u00020\u001d2\u0006\u0010^\u001a\u00020_H\u0016J\u0010\u0010`\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020aH\u0016J\u0010\u0010b\u001a\u00020\u001d2\u0006\u0010c\u001a\u00020dH\u0016J\u0010\u0010e\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020fH\u0016J\u0010\u0010g\u001a\u00020\u001d2\u0006\u0010L\u001a\u00020hH\u0016J\n\u0010i\u001a\u00020\u001d*\u00020\rR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/BodyGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "hierarchyDisjointUnions", "Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "isGetUnitFunction", "", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions;Z)V", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "body", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getBody", "()Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "unitGetInstance", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getUnitGetInstance", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unitGetInstance$delegate", "Lkotlin/Lazy;", "wasmSymbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "generateCall", "", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "generateExpression", "elem", "Lorg/jetbrains/kotlin/ir/IrElement;", "generateExpression$backend_wasm", "generateInstanceFieldAccess", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "generateRefCast", "fromType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "toType", "generateRefTest", "generateStatement", "statement", "generateWithExpectedType", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expectedType", "generateWithExpectedType$backend_wasm", "isDownCastAlwaysSuccessInRuntime", "recoverToExpectedType", "actualType", "tryToGenerateIntrinsicCall", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "tryToGenerateWasmOpIntrinsicCall", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "visitElement", "element", "visitFunctionReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitReturn", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitVariable", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "buildGetUnit", "backend.wasm"})
public final class BodyGenerator
implements IrElementVisitorVoid {
    @NotNull
    private final WasmFunctionCodegenContext context;
    @NotNull
    private final DisjointUnions<IrClassSymbol> hierarchyDisjointUnions;
    private final boolean isGetUnitFunction;
    @NotNull
    private final WasmExpressionBuilder body;
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmSymbols wasmSymbols;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Lazy unitGetInstance$delegate;

    public BodyGenerator(@NotNull WasmFunctionCodegenContext context, @NotNull DisjointUnions<IrClassSymbol> hierarchyDisjointUnions, boolean isGetUnitFunction) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(hierarchyDisjointUnions, (String)"hierarchyDisjointUnions");
        this.context = context;
        this.hierarchyDisjointUnions = hierarchyDisjointUnions;
        this.isGetUnitFunction = isGetUnitFunction;
        this.body = this.context.getBodyGen();
        this.backendContext = this.context.getBackendContext();
        this.wasmSymbols = this.backendContext.getWasmSymbols();
        this.irBuiltIns = this.backendContext.getIrBuiltIns();
        this.unitGetInstance$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IrSimpleFunction>(this){
            final /* synthetic */ BodyGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrSimpleFunction invoke() {
                return MiscKt.findUnitGetInstanceFunction(BodyGenerator.access$getBackendContext$p(this.this$0));
            }
        }));
    }

    @NotNull
    public final WasmFunctionCodegenContext getContext() {
        return this.context;
    }

    @NotNull
    public final WasmExpressionBuilder getBody() {
        return this.body;
    }

    private final IrSimpleFunction getUnitGetInstance() {
        Lazy lazy = this.unitGetInstance$delegate;
        return (IrSimpleFunction)lazy.getValue();
    }

    public final void buildGetUnit(@NotNull WasmExpressionBuilder $this$buildGetUnit) {
        Intrinsics.checkNotNullParameter((Object)$this$buildGetUnit, (String)"<this>");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{(WasmImmediate)new WasmImmediate.FuncIdx(this.context.referenceFunction((IrFunctionSymbol)this.getUnitGetInstance().getSymbol()))};
        $this$buildGetUnit.buildInstr(WasmOp.GET_UNIT, wasmImmediateArray);
    }

    public final void generateExpression$backend_wasm(@NotNull IrElement elem) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        boolean bl2 = bl = elem instanceof IrExpression || elem instanceof IrVariable;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Unsupported statement kind";
            throw new AssertionError((Object)string2);
        }
        IrVisitorsKt.acceptVoid((IrElement)elem, (IrElementVisitorVoid)this);
        if (elem instanceof IrExpression && IrTypePredicatesKt.isNothing((IrType)((IrExpression)elem).getType())) {
            this.body.buildUnreachable();
        }
    }

    private final void generateStatement(IrElement statement2) {
        boolean bl;
        boolean bl2 = bl = statement2 instanceof IrExpression || statement2 instanceof IrVariable;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Unsupported statement kind";
            throw new AssertionError((Object)string2);
        }
        this.generateExpression$backend_wasm(statement2);
        if (statement2 instanceof IrExpression && !Intrinsics.areEqual((Object)((IrExpression)statement2).getType(), (Object)this.wasmSymbols.getVoidType())) {
            this.body.buildDrop();
        }
    }

    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new IllegalStateException(("Unexpected element of type " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
    }

    public void visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.generateExpression$backend_wasm((IrElement)expression2.getValue());
        this.body.buildThrow(this.context.getTagIdx());
    }

    public void visitTry(@NotNull IrTry aTry) {
        Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
        boolean bl = UtilsKt.isCanonical(aTry, this.irBuiltIns);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "expected canonical try/catch";
            throw new AssertionError((Object)string2);
        }
        WasmType resultType = this.context.transformBlockResultType(aTry.getType());
        this.body.buildTry(null, resultType);
        this.generateExpression$backend_wasm((IrElement)aTry.getTryResult());
        this.body.buildCatch(this.context.getTagIdx());
        IrVariableSymbol it = ((IrCatch)CollectionsKt.single((List)aTry.getCatches())).getCatchParameter().getSymbol();
        boolean bl3 = false;
        this.context.defineLocal((IrValueSymbol)it);
        this.body.buildSetLocal(this.context.referenceLocal((IrValueSymbol)it));
        this.generateExpression$backend_wasm((IrElement)((IrCatch)CollectionsKt.single((List)aTry.getCatches())).getResult());
        this.body.buildEnd();
    }

    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
            case 1: {
                this.generateExpression$backend_wasm((IrElement)expression2.getArgument());
                break;
            }
            case 2: {
                this.generateStatement((IrElement)expression2.getArgument());
                this.buildGetUnit(this.body);
                break;
            }
            default: {
                if (!_Assertions.ENABLED) break;
                boolean bl = false;
                String string2 = "Other types of casts must be lowered";
                throw new AssertionError((Object)string2);
            }
        }
    }

    public void visitConst(@NotNull IrConst<?> expression2) {
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        DeclarationGeneratorKt.generateConstExpression(expression2, this.body, this.context);
    }

    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        IrExpression receiver = expression2.getReceiver();
        if (receiver != null) {
            this.generateExpression$backend_wasm((IrElement)receiver);
            if (!this.backendContext.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)field)))) {
                this.generateInstanceFieldAccess(field);
            }
        } else {
            this.body.buildGetGlobal(this.context.referenceGlobalField(field.getSymbol()));
        }
    }

    private final void generateInstanceFieldAccess(IrField field) {
        WasmImmediate[] wasmImmediateArray = field.getType();
        WasmOp opcode = Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getCharType()) ? WasmOp.STRUCT_GET_U : (((Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getBooleanType()) ? true : Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getByteType())) ? true : Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getShortType())) ? WasmOp.STRUCT_GET_S : WasmOp.STRUCT_GET);
        wasmImmediateArray = new WasmImmediate[]{(WasmImmediate)new WasmImmediate.GcType(this.context.referenceGcType(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)field)).getSymbol())), (WasmImmediate)new WasmImmediate.StructFieldIdx(this.context.getStructFieldRef(field))};
        this.body.buildInstr(opcode, wasmImmediateArray);
    }

    public void visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        IrExpression receiver = expression2.getReceiver();
        if (receiver != null) {
            this.generateExpression$backend_wasm((IrElement)receiver);
            this.generateExpression$backend_wasm((IrElement)expression2.getValue());
            this.body.buildStructSet(this.context.referenceGcType(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)field)).getSymbol()), this.context.getStructFieldRef(field));
        } else {
            this.generateExpression$backend_wasm((IrElement)expression2.getValue());
            this.body.buildSetGlobal(this.context.referenceGlobalField(expression2.getSymbol()));
        }
        this.buildGetUnit(this.body);
    }

    public void visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrValueSymbol valueSymbol = expression2.getSymbol();
        IrValueDeclaration valueDeclaration = valueSymbol.getOwner();
        this.body.buildGetLocal(MiscKt.isDispatchReceiver(valueDeclaration) ? this.context.referenceLocal(0) : this.context.referenceLocal(valueSymbol));
    }

    public void visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.generateExpression$backend_wasm((IrElement)expression2.getValue());
        this.body.buildSetLocal(this.context.referenceLocal(expression2.getSymbol()));
        this.buildGetUnit(this.body);
    }

    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.generateCall((IrFunctionAccessExpression)expression2);
    }

    /*
     * WARNING - void declaration
     */
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)expression2.getSymbol().getOwner()));
        if (!(!this.backendContext.getInlineClassesUtils().isClassInlineLike(klass))) {
            boolean $i$a$-require-BodyGenerator$visitConstructorCall$32 = false;
            String $i$a$-require-BodyGenerator$visitConstructorCall$32 = "All inline class constructor calls must be lowered to static function calls";
            throw new IllegalArgumentException($i$a$-require-BodyGenerator$visitConstructorCall$32.toString());
        }
        WasmSymbol<WasmTypeDeclaration> wasmGcType = this.context.referenceGcType(klass.getSymbol());
        if (AnnotationsKt.getWasmArrayAnnotation((IrAnnotationContainer)klass) != null) {
            if (!(expression2.getValueArgumentsCount() == 1)) {
                boolean $i$a$-require-BodyGenerator$visitConstructorCall$42 = false;
                String $i$a$-require-BodyGenerator$visitConstructorCall$42 = "@WasmArrayOf constructs must have exactly one argument";
                throw new IllegalArgumentException($i$a$-require-BodyGenerator$visitConstructorCall$42.toString());
            }
            IrExpression irExpression = expression2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            this.generateExpression$backend_wasm((IrElement)irExpression);
            WasmImmediate[] $i$a$-require-BodyGenerator$visitConstructorCall$32 = new WasmImmediate[]{(WasmImmediate)new WasmImmediate.GcType(wasmGcType)};
            this.body.buildInstr(WasmOp.ARRAY_NEW_DEFAULT, $i$a$-require-BodyGenerator$visitConstructorCall$32);
            return;
        }
        this.body.buildGetGlobal(this.context.referenceGlobalVTable(klass.getSymbol()));
        if (ClassInfoKt.hasInterfaceSuperClass(klass)) {
            this.body.buildGetGlobal(this.context.referenceGlobalClassITable(klass.getSymbol()));
        } else {
            this.body.buildRefNull((WasmHeapType)WasmHeapType.Simple.Data.INSTANCE);
        }
        WasmSymbol<Integer> wasmClassId = this.context.referenceClassId(klass.getSymbol());
        List<IrField> irFields = ClassInfoKt.allFields(klass, this.backendContext.getIrBuiltIns());
        Iterable $this$forEachIndexed$iv = irFields;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void field;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrField irField = (IrField)item$iv;
            int index2 = n;
            boolean bl = false;
            if (index2 == 0) {
                this.body.buildConstI32Symbol(wasmClassId);
                continue;
            }
            DeclarationGeneratorKt.generateDefaultInitializerForType(this.context.transformType(field.getType()), this.body);
        }
        this.body.buildStructNew(wasmGcType);
        this.generateCall((IrFunctionAccessExpression)expression2);
    }

    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)this.context.getIrFunction()));
        if (IrTypePredicatesKt.isAny((IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)klass)))) {
            this.buildGetUnit(this.body);
            return;
        }
        this.body.buildGetLocal(this.context.referenceLocal(0));
        this.generateCall((IrFunctionAccessExpression)expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateCall(IrFunctionAccessExpression call2) {
        boolean isSuperCall;
        IrExpression it;
        if (Intrinsics.areEqual((Object)call2.getSymbol(), (Object)this.wasmSymbols.getBoxIntrinsic())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrClass klass = TypeTransformerKt.getRuntimeClass(irType, this.irBuiltIns);
            IrClassSymbol klassSymbol = klass.getSymbol();
            this.body.buildGetGlobal(this.context.referenceGlobalVTable(klassSymbol));
            if (ClassInfoKt.hasInterfaceSuperClass(klass)) {
                this.body.buildGetGlobal(this.context.referenceGlobalClassITable(klassSymbol));
            } else {
                this.body.buildRefNull((WasmHeapType)WasmHeapType.Simple.Data.INSTANCE);
            }
            this.body.buildConstI32Symbol(this.context.referenceClassId(klassSymbol));
            this.body.buildConstI32(0);
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            this.generateExpression$backend_wasm((IrElement)irExpression);
            this.body.buildStructNew(this.context.referenceGcType(klassSymbol));
            return;
        }
        if (Intrinsics.areEqual((Object)call2.getSymbol(), (Object)this.getUnitGetInstance().getSymbol())) {
            this.buildGetUnit(this.body);
            return;
        }
        if (!this.backendContext.getConfiguration().getNotNull(JSConfigurationKeys.WASM_ENABLE_ARRAY_RANGE_CHECKS).booleanValue() && Intrinsics.areEqual((Object)call2.getSymbol(), (Object)this.wasmSymbols.getRangeCheck())) {
            this.buildGetUnit(this.body);
            return;
        }
        if (!this.backendContext.getConfiguration().getNotNull(JSConfigurationKeys.WASM_ENABLE_ASSERTS).booleanValue() && CollectionsKt.contains((Iterable)this.wasmSymbols.getAssertFuncs(), (Object)call2.getSymbol())) {
            this.buildGetUnit(this.body);
            return;
        }
        IrFunction function2 = IrResolveUtilsKt.getRealOverrideTarget(((IrFunctionSymbol)call2.getSymbol()).getOwner());
        IrExpression irExpression = call2.getDispatchReceiver();
        if (irExpression != null) {
            it = irExpression;
            boolean bl = false;
            this.generateExpression$backend_wasm((IrElement)it);
        }
        IrExpression irExpression2 = call2.getExtensionReceiver();
        if (irExpression2 != null) {
            it = irExpression2;
            boolean bl = false;
            this.generateExpression$backend_wasm((IrElement)it);
        }
        int n = call2.getValueArgumentsCount();
        for (int i = 0; i < n; ++i) {
            IrExpression valueArgument = call2.getValueArgument(i);
            if (valueArgument == null) {
                DeclarationGeneratorKt.generateDefaultInitializerForType(this.context.transformType(((IrValueParameter)function2.getValueParameters().get(i)).getType()), this.body);
                continue;
            }
            this.generateExpression$backend_wasm((IrElement)valueArgument);
        }
        if (this.tryToGenerateIntrinsicCall(call2, function2)) {
            if (IrTypePredicatesKt.isUnit((IrType)function2.getReturnType())) {
                this.buildGetUnit(this.body);
            }
            return;
        }
        boolean bl = isSuperCall = call2 instanceof IrCall && ((IrCall)call2).getSuperQualifierSymbol() != null;
        if (function2 instanceof IrSimpleFunction && IrUtilsKt.isOverridable((IrSimpleFunction)((IrSimpleFunction)function2)) && !isSuperCall) {
            IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)function2));
            if (!IrUtilsKt.isInterface((IrClass)klass)) {
                int n2;
                block23: {
                    ClassMetadata classMetadata = this.context.getClassMetadata(klass.getSymbol());
                    List<VirtualMethodMetadata> $this$indexOfFirst$iv = classMetadata.getVirtualMethods();
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<VirtualMethodMetadata> iterator2 = $this$indexOfFirst$iv.iterator();
                    while (iterator2.hasNext()) {
                        VirtualMethodMetadata item$iv;
                        VirtualMethodMetadata it2 = item$iv = iterator2.next();
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it2.getFunction(), (Object)function2)) {
                            n2 = index$iv;
                            break block23;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                int vfSlot = n2;
                IrExpression irExpression3 = call2.getDispatchReceiver();
                Intrinsics.checkNotNull((Object)irExpression3);
                IrExpression receiver = irExpression3;
                this.generateExpression$backend_wasm((IrElement)receiver);
                this.generateRefCast(receiver.getType(), (IrType)IrUtilsKt.getDefaultType((IrClass)klass));
                this.body.buildStructGet(this.context.referenceGcType(klass.getSymbol()), new WasmSymbol((Object)0));
                this.body.buildStructGet(this.context.referenceVTableGcType(klass.getSymbol()), new WasmSymbol((Object)vfSlot));
                this.body.buildInstr(WasmOp.CALL_REF, new WasmImmediate[0]);
            } else {
                IrClassSymbol symbol2 = klass.getSymbol();
                if (this.hierarchyDisjointUnions.contains(symbol2)) {
                    int n3;
                    block24: {
                        void $this$indexOfFirst$iv;
                        IrExpression irExpression4 = call2.getDispatchReceiver();
                        Intrinsics.checkNotNull((Object)irExpression4);
                        this.generateExpression$backend_wasm((IrElement)irExpression4);
                        this.body.buildStructGet(this.context.referenceGcType(this.irBuiltIns.getAnyClass()), new WasmSymbol((Object)1));
                        WasmSymbol<WasmTypeDeclaration> classITableReference = this.context.referenceClassITableGcType(symbol2);
                        this.body.buildRefCastStatic((WasmSymbolReadOnly)classITableReference);
                        this.body.buildStructGet(classITableReference, this.context.referenceClassITableInterfaceSlot(symbol2));
                        List<VirtualMethodMetadata> $i$f$indexOfFirst = this.context.getInterfaceMetadata(symbol2).getMethods();
                        boolean $i$f$indexOfFirst2 = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$indexOfFirst$iv) {
                            VirtualMethodMetadata it3 = (VirtualMethodMetadata)item$iv;
                            boolean bl3 = false;
                            if (Intrinsics.areEqual((Object)it3.getFunction(), (Object)function2)) {
                                n3 = index$iv;
                                break block24;
                            }
                            ++index$iv;
                        }
                        n3 = -1;
                    }
                    int vfSlot = n3;
                    this.body.buildStructGet(this.context.referenceVTableGcType(symbol2), new WasmSymbol((Object)vfSlot));
                    this.body.buildInstr(WasmOp.CALL_REF, new WasmImmediate[0]);
                } else {
                    this.body.buildUnreachable();
                }
            }
        } else {
            this.body.buildCall(this.context.referenceFunction(function2.getSymbol()));
        }
        if (IrTypePredicatesKt.isUnit((IrType)function2.getReturnType())) {
            this.buildGetUnit(this.body);
        }
    }

    private final void generateRefCast(IrType fromType, IrType toType) {
        if (!this.isDownCastAlwaysSuccessInRuntime(fromType, toType)) {
            this.body.buildRefCastStatic((WasmSymbolReadOnly)this.context.referenceGcType(TypeTransformerKt.getRuntimeClass(toType, this.irBuiltIns).getSymbol()));
        }
    }

    private final void generateRefTest(IrType fromType, IrType toType) {
        if (!this.isDownCastAlwaysSuccessInRuntime(fromType, toType)) {
            this.body.buildRefTestStatic((WasmSymbolReadOnly)this.context.referenceGcType(TypeTransformerKt.getRuntimeClass(toType, this.irBuiltIns).getSymbol()));
        } else {
            this.body.buildDrop();
            this.body.buildConstI32(1);
        }
    }

    private final boolean isDownCastAlwaysSuccessInRuntime(IrType fromType, IrType toType) {
        IrClass upperBound = TypeTranformerKt.getErasedUpperBound(fromType);
        if (upperBound != null && IrTypeUtilsKt.isSubtypeOfClass((IrClassifierSymbol)((IrClassifierSymbol)upperBound.getSymbol()), (IrClassSymbol)this.backendContext.getWasmSymbols().getWasmAnyRefClass())) {
            return false;
        }
        return IrUtilsKt.isSubclassOf((IrClass)TypeTransformerKt.getRuntimeClass(fromType, this.irBuiltIns), (IrClass)TypeTransformerKt.getRuntimeClass(toType, this.irBuiltIns));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryToGenerateIntrinsicCall(IrFunctionAccessExpression call2, IrFunction function2) {
        if (this.tryToGenerateWasmOpIntrinsicCall(function2)) {
            return true;
        }
        IrFunctionSymbol irFunctionSymbol = function2.getSymbol();
        if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getWasmClassId())) {
            boolean bl;
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrClass irClass = IrTypesKt.getClass((IrType)irType);
            if (irClass == null) {
                throw new IllegalStateException("No class given for wasmClassId intrinsic".toString());
            }
            IrClass klass = irClass;
            boolean bl2 = bl = !IrUtilsKt.isInterface((IrClass)klass);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            this.body.buildConstI32Symbol(this.context.referenceClassId(klass.getSymbol()));
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getWasmInterfaceId())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrClass irClass = IrTypesKt.getClass((IrType)irType);
            if (irClass == null) {
                throw new IllegalStateException("No interface given for wasmInterfaceId intrinsic".toString());
            }
            IrClass irInterface = irClass;
            boolean bl = IrUtilsKt.isInterface((IrClass)irInterface);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            this.body.buildConstI32Symbol(this.context.referenceInterfaceId(irInterface.getSymbol()));
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getWasmIsInterface())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrClass irClass = IrTypesKt.getClass((IrType)irType);
            if (irClass == null) {
                throw new IllegalStateException("No interface given for wasmInterfaceId intrinsic".toString());
            }
            IrClass irInterface = irClass;
            boolean bl = IrUtilsKt.isInterface((IrClass)irInterface);
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            if (this.hierarchyDisjointUnions.contains(irInterface.getSymbol())) {
                void this_$iv;
                void this_$iv2;
                WasmSymbol<WasmTypeDeclaration> classITable = this.context.referenceClassITableGcType(irInterface.getSymbol());
                WasmLocal parameterLocal = this.context.referenceLocal(SyntheticLocalType.IS_INTERFACE_PARAMETER);
                this.body.buildSetLocal(parameterLocal);
                WasmExpressionBuilder wasmExpressionBuilder = this.body;
                String string5 = "isInterface";
                WasmType resultType$iv = (WasmType)WasmI32.INSTANCE;
                boolean $i$f$buildBlock = false;
                int n = this_$iv2.getNumberOfNestedBlocks();
                this_$iv2.setNumberOfNestedBlocks(n + 1);
                WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{(WasmImmediate)new WasmImmediate.BlockType.Value(resultType$iv)};
                this_$iv2.buildInstr(WasmOp.BLOCK, wasmImmediateArray);
                int outerLabel = this_$iv2.getNumberOfNestedBlocks();
                boolean bl3 = false;
                WasmExpressionBuilder wasmExpressionBuilder2 = this.body;
                String string6 = "isInterface";
                WasmType resultType$iv2 = (WasmType)new WasmRefNullType((WasmHeapType)WasmHeapType.Simple.Data.INSTANCE);
                boolean $i$f$buildBlock2 = false;
                int n2 = this_$iv.getNumberOfNestedBlocks();
                this_$iv.setNumberOfNestedBlocks(n2 + 1);
                WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[]{(WasmImmediate)new WasmImmediate.BlockType.Value(resultType$iv2)};
                this_$iv.buildInstr(WasmOp.BLOCK, wasmImmediateArray2);
                int innerLabel = this_$iv.getNumberOfNestedBlocks();
                boolean bl4 = false;
                this.body.buildGetLocal(parameterLocal);
                this.body.buildStructGet(this.context.referenceGcType(this.irBuiltIns.getAnyClass()), new WasmSymbol((Object)1));
                this.body.buildBrInstr(WasmOp.BR_ON_CAST_FAIL, innerLabel, (WasmSymbolReadOnly)classITable);
                this.body.buildStructGet(classITable, this.context.referenceClassITableInterfaceSlot(irInterface.getSymbol()));
                this.body.buildInstr(WasmOp.REF_IS_NULL, new WasmImmediate[0]);
                this.body.buildInstr(WasmOp.I32_EQZ, new WasmImmediate[0]);
                this.body.buildBr(outerLabel);
                this_$iv.buildEnd();
                this.body.buildDrop();
                this.body.buildConstI32(0);
                this_$iv2.buildEnd();
            } else {
                this.body.buildDrop();
                this.body.buildConstI32(0);
            }
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getRefCast())) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrType irType = irExpression.getType();
            IrType irType2 = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType2);
            this.generateRefCast(irType, irType2);
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getRefTest())) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrType irType = irExpression.getType();
            IrType irType3 = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType3);
            this.generateRefTest(irType, irType3);
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getUnboxIntrinsic())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrType fromType = irType;
            if (IrTypePredicatesKt.isNothing((IrType)fromType)) {
                this.body.buildUnreachable();
                return true;
            }
            if (IrTypePredicatesKt.isNothing((IrType)IrTypesKt.makeNotNull((IrType)fromType))) {
                this.body.buildUnreachable();
                return true;
            }
            IrType irType4 = call2.getTypeArgument(1);
            Intrinsics.checkNotNull((Object)irType4);
            IrType toType = irType4;
            IrClass irClass = this.backendContext.getInlineClassesUtils().getInlinedClass(toType);
            Intrinsics.checkNotNull((Object)irClass);
            IrClass klass = irClass;
            IrField field = InlineClassesKt.getInlineClassBackingField((IrClass)klass);
            this.generateRefCast(fromType, toType);
            this.generateInstanceFieldAccess(field);
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getUnsafeGetScratchRawMemory())) {
            this.body.buildDrop();
            this.body.buildConstI32Symbol(this.context.getScratchMemAddr());
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getUnsafeGetScratchRawMemorySize())) {
            this.body.buildConstI32Symbol(new WasmSymbol((Object)this.context.getScratchMemSizeInBytes()));
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getWasmArrayCopy())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            WasmImmediate.GcType immediate = new WasmImmediate.GcType(this.context.referenceGcType(TypeTransformerKt.getRuntimeClass(irType, this.irBuiltIns).getSymbol()));
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{(WasmImmediate)immediate, (WasmImmediate)immediate};
            this.body.buildInstr(WasmOp.ARRAY_COPY, wasmImmediateArray);
        } else {
            return false;
        }
        return true;
    }

    public void visitBlockBody(@NotNull IrBlockBody body2) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Iterable $this$forEach$iv = body2.getStatements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrElement p0 = (IrElement)element$iv;
            boolean bl = false;
            this.generateStatement(p0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        List statements = expression2.getStatements();
        if (statements.isEmpty()) {
            if (Intrinsics.areEqual((Object)expression2.getType(), (Object)this.irBuiltIns.getUnitType())) {
                this.buildGetUnit(this.body);
            }
            return;
        }
        if (expression2 instanceof IrReturnableBlock) {
            this.context.defineNonLocalReturnLevel(((IrReturnableBlock)expression2).getSymbol(), this.body.buildBlock(this.context.transformBlockResultType(expression2.getType())));
        }
        Iterable $this$forEachIndexed$iv = statements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void statement2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrStatement irStatement = (IrStatement)item$iv;
            int i = n;
            boolean bl = false;
            if (i != CollectionsKt.getLastIndex((List)statements)) {
                this.generateStatement((IrElement)statement2);
                continue;
            }
            if (statement2 instanceof IrExpression) {
                this.generateWithExpectedType$backend_wasm((IrExpression)statement2, expression2.getType());
                continue;
            }
            this.generateStatement((IrElement)statement2);
            if (Intrinsics.areEqual((Object)expression2.getType(), (Object)this.wasmSymbols.getVoidType())) continue;
            this.buildGetUnit(this.body);
        }
        if (expression2 instanceof IrReturnableBlock) {
            this.body.buildEnd();
        }
    }

    public void visitBreak(@NotNull IrBreak jump) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        boolean bl = Intrinsics.areEqual((Object)jump.getType(), (Object)this.irBuiltIns.getNothingType());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.body.buildBr(this.context.referenceLoopLevel(jump.getLoop(), LoopLabelType.BREAK));
    }

    public void visitContinue(@NotNull IrContinue jump) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        boolean bl = Intrinsics.areEqual((Object)jump.getType(), (Object)this.irBuiltIns.getNothingType());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.body.buildBr(this.context.referenceLoopLevel(jump.getLoop(), LoopLabelType.CONTINUE));
    }

    private final void visitFunctionReturn(IrReturn expression2) {
        IrType returnType2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.returnType((IrReturnTarget)expression2.getReturnTargetSymbol().getOwner(), (CommonBackendContext)this.backendContext);
        if (Intrinsics.areEqual((Object)returnType2, (Object)this.irBuiltIns.getUnitType()) && !Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol().getOwner(), (Object)this.getUnitGetInstance())) {
            this.generateStatement((IrElement)expression2.getValue());
        } else if (this.isGetUnitFunction) {
            this.generateExpression$backend_wasm((IrElement)expression2.getValue());
        } else {
            this.generateWithExpectedType$backend_wasm(expression2.getValue(), returnType2);
        }
        if (this.context.getIrFunction() instanceof IrConstructor) {
            this.body.buildGetLocal(this.context.referenceLocal(0));
        }
        this.body.buildInstr(WasmOp.RETURN, new WasmImmediate[0]);
    }

    public final void generateWithExpectedType$backend_wasm(@NotNull IrExpression expression2, @NotNull IrType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        IrType actualType = expression2.getType();
        if (Intrinsics.areEqual((Object)expectedType, (Object)this.wasmSymbols.getVoidType())) {
            this.generateStatement((IrElement)expression2);
            return;
        }
        if (IrTypePredicatesKt.isUnit((IrType)expectedType) && !IrTypePredicatesKt.isUnit((IrType)actualType)) {
            this.generateStatement((IrElement)expression2);
            this.buildGetUnit(this.body);
            return;
        }
        this.generateExpression$backend_wasm((IrElement)expression2);
        this.recoverToExpectedType(actualType, expectedType);
    }

    private final void recoverToExpectedType(IrType actualType, IrType expectedType) {
        boolean actualIsPrimitive;
        IrSimpleType actualTypeErased;
        if (IrTypePredicatesKt.isNothing((IrType)expectedType)) {
            this.body.buildUnreachable();
            return;
        }
        if (IrTypePredicatesKt.isNothing((IrType)actualType)) {
            return;
        }
        if (IrTypePredicatesKt.isNullableNothing((IrType)actualType) && IrTypeUtilsKt.isNullable((IrType)expectedType)) {
            IrClass irClass = IrTypesKt.getClass((IrType)expectedType);
            boolean bl = irClass != null ? irClass.isExternal() : false;
            if (bl) {
                this.body.buildDrop();
                this.body.buildRefNull((WasmHeapType)WasmHeapType.Simple.NullNoExtern.INSTANCE);
            }
            return;
        }
        IrClass expectedClassErased = TypeTransformerKt.getRuntimeClass(expectedType, this.irBuiltIns);
        if (expectedClassErased.isExternal()) {
            return;
        }
        IrClass actualClassErased = TypeTransformerKt.getRuntimeClass(actualType, this.irBuiltIns);
        IrSimpleType expectedTypeErased = IrUtilsKt.getDefaultType((IrClass)expectedClassErased);
        if (Intrinsics.areEqual((Object)expectedTypeErased, (Object)(actualTypeErased = IrUtilsKt.getDefaultType((IrClass)actualClassErased)))) {
            return;
        }
        if (IrTypePredicatesKt.isNothing((IrType)((IrType)expectedTypeErased)) && !IrTypePredicatesKt.isNothing((IrType)((IrType)actualTypeErased))) {
            this.body.buildUnreachable();
            return;
        }
        if (IrUtilsKt.isSubclassOf((IrClass)actualClassErased, (IrClass)expectedClassErased)) {
            return;
        }
        boolean expectedIsPrimitive = IrTypePredicatesKt.isPrimitiveType$default((IrType)((IrType)expectedTypeErased), (boolean)false, (int)1, null);
        if (expectedIsPrimitive != (actualIsPrimitive = IrTypePredicatesKt.isPrimitiveType$default((IrType)((IrType)actualTypeErased), (boolean)false, (int)1, null))) {
            this.body.buildUnreachable();
            return;
        }
        if (!expectedIsPrimitive) {
            this.generateRefCast((IrType)actualTypeErased, (IrType)expectedTypeErased);
        }
    }

    public void visitReturn(@NotNull IrReturn expression2) {
        IrReturnableBlockSymbol nonLocalReturnSymbol;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrReturnTargetSymbol irReturnTargetSymbol = expression2.getReturnTargetSymbol();
        IrReturnableBlockSymbol irReturnableBlockSymbol = nonLocalReturnSymbol = irReturnTargetSymbol instanceof IrReturnableBlockSymbol ? (IrReturnableBlockSymbol)irReturnTargetSymbol : null;
        if (nonLocalReturnSymbol != null) {
            this.generateWithExpectedType$backend_wasm(expression2.getValue(), ((IrReturnableBlock)nonLocalReturnSymbol.getOwner()).getType());
            this.body.buildBr(this.context.referenceNonLocalReturnLevel(nonLocalReturnSymbol));
            this.body.buildUnreachable();
        } else {
            this.visitFunctionReturn(expression2);
        }
    }

    public void visitWhen(@NotNull IrWhen expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (OptimisedWhenGeneratorKt.tryGenerateOptimisedWhen(this, expression2, this.context.getBackendContext().getWasmSymbols())) {
            return;
        }
        WasmType resultType = this.context.transformBlockResultType(expression2.getType());
        int ifCount = 0;
        boolean seenElse = false;
        for (Object branch : expression2.getBranches()) {
            if (!IrUtilsKt.isElseBranch((IrBranch)branch)) {
                this.generateExpression$backend_wasm((IrElement)branch.getCondition());
                this.body.buildIf(null, resultType);
                this.generateWithExpectedType$backend_wasm(branch.getResult(), expression2.getType());
                this.body.buildElse();
                ++ifCount;
                continue;
            }
            this.generateWithExpectedType$backend_wasm(branch.getResult(), expression2.getType());
            seenElse = true;
            break;
        }
        if (!seenElse && resultType != null) {
            boolean bl;
            boolean bl2 = bl = !Intrinsics.areEqual((Object)expression2.getType(), (Object)this.irBuiltIns.getNothingType());
            if (_Assertions.ENABLED && !bl) {
                Object branch;
                branch = "Assertion failed";
                throw new AssertionError(branch);
            }
            if (IrTypePredicatesKt.isUnit((IrType)expression2.getType())) {
                if (this.isGetUnitFunction) {
                    DeclarationGeneratorKt.generateDefaultInitializerForType(resultType, this.body);
                } else {
                    this.buildGetUnit(this.body);
                }
            } else {
                this.body.buildUnreachable();
            }
        }
        int n = 0;
        while (n < ifCount) {
            int it = n++;
            boolean bl = false;
            this.body.buildEnd();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
        void $this$iv;
        void $this$iv2;
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        String label = loop.getLabel();
        WasmExpressionBuilder $this$iv3 = this.body;
        WasmType resultType$iv = null;
        boolean $i$f$buildLoop = false;
        int n = $this$iv3.getNumberOfNestedBlocks();
        $this$iv3.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{(WasmImmediate)new WasmImmediate.BlockType.Value(resultType$iv)};
        $this$iv3.buildInstr(WasmOp.LOOP, wasmImmediateArray);
        int wasmLoop = $this$iv3.getNumberOfNestedBlocks();
        boolean bl = false;
        WasmExpressionBuilder wasmExpressionBuilder = this.body;
        String label$iv = "BREAK_" + label;
        WasmType resultType$iv2 = null;
        boolean $i$f$buildBlock = false;
        int n2 = $this$iv2.getNumberOfNestedBlocks();
        $this$iv2.setNumberOfNestedBlocks(n2 + 1);
        WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[]{(WasmImmediate)new WasmImmediate.BlockType.Value(resultType$iv2)};
        $this$iv2.buildInstr(WasmOp.BLOCK, wasmImmediateArray2);
        int wasmBreakBlock = $this$iv2.getNumberOfNestedBlocks();
        boolean bl2 = false;
        WasmExpressionBuilder wasmExpressionBuilder2 = this.body;
        String label$iv2 = "CONTINUE_" + label;
        WasmType resultType$iv3 = null;
        boolean $i$f$buildBlock2 = false;
        int n3 = $this$iv.getNumberOfNestedBlocks();
        $this$iv.setNumberOfNestedBlocks(n3 + 1);
        WasmImmediate[] wasmImmediateArray3 = new WasmImmediate[]{(WasmImmediate)new WasmImmediate.BlockType.Value(resultType$iv3)};
        $this$iv.buildInstr(WasmOp.BLOCK, wasmImmediateArray3);
        int wasmContinueBlock = $this$iv.getNumberOfNestedBlocks();
        boolean bl3 = false;
        this.context.defineLoopLevel((IrLoop)loop, LoopLabelType.BREAK, wasmBreakBlock);
        this.context.defineLoopLevel((IrLoop)loop, LoopLabelType.CONTINUE, wasmContinueBlock);
        IrExpression irExpression = loop.getBody();
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl4 = false;
            this.generateStatement((IrElement)it);
        }
        $this$iv.buildEnd();
        this.generateExpression$backend_wasm((IrElement)loop.getCondition());
        this.body.buildBrIf(wasmLoop);
        $this$iv2.buildEnd();
        $this$iv3.buildEnd();
        this.buildGetUnit(this.body);
    }

    /*
     * WARNING - void declaration
     */
    public void visitWhileLoop(@NotNull IrWhileLoop loop) {
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        String label = loop.getLabel();
        WasmExpressionBuilder $this$iv2 = this.body;
        WasmType resultType$iv = null;
        boolean $i$f$buildLoop = false;
        int n = $this$iv2.getNumberOfNestedBlocks();
        $this$iv2.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{(WasmImmediate)new WasmImmediate.BlockType.Value(resultType$iv)};
        $this$iv2.buildInstr(WasmOp.LOOP, wasmImmediateArray);
        int wasmLoop = $this$iv2.getNumberOfNestedBlocks();
        boolean bl = false;
        WasmExpressionBuilder wasmExpressionBuilder = this.body;
        String label$iv = "BREAK_" + label;
        WasmType resultType$iv2 = null;
        boolean $i$f$buildBlock = false;
        int n2 = $this$iv.getNumberOfNestedBlocks();
        $this$iv.setNumberOfNestedBlocks(n2 + 1);
        WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[]{(WasmImmediate)new WasmImmediate.BlockType.Value(resultType$iv2)};
        $this$iv.buildInstr(WasmOp.BLOCK, wasmImmediateArray2);
        int wasmBreakBlock = $this$iv.getNumberOfNestedBlocks();
        boolean bl2 = false;
        this.context.defineLoopLevel((IrLoop)loop, LoopLabelType.BREAK, wasmBreakBlock);
        this.context.defineLoopLevel((IrLoop)loop, LoopLabelType.CONTINUE, wasmLoop);
        this.generateExpression$backend_wasm((IrElement)loop.getCondition());
        this.body.buildInstr(WasmOp.I32_EQZ, new WasmImmediate[0]);
        this.body.buildBrIf(wasmBreakBlock);
        IrExpression irExpression = loop.getBody();
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl3 = false;
            this.generateStatement((IrElement)it);
        }
        this.body.buildBr(wasmLoop);
        $this$iv.buildEnd();
        $this$iv2.buildEnd();
        this.buildGetUnit(this.body);
    }

    public void visitVariable(@NotNull IrVariable declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.context.defineLocal((IrValueSymbol)declaration.getSymbol());
        if (declaration.getInitializer() == null) {
            return;
        }
        IrExpression irExpression = declaration.getInitializer();
        Intrinsics.checkNotNull((Object)irExpression);
        IrExpression init = irExpression;
        this.generateExpression$backend_wasm((IrElement)init);
        WasmLocal varName = this.context.referenceLocal((IrValueSymbol)declaration.getSymbol());
        this.body.buildSetLocal(varName);
    }

    private final boolean tryToGenerateWasmOpIntrinsicCall(IrFunction function2) {
        if (AnnotationsKt.hasWasmNoOpCastAnnotation((IrAnnotationContainer)function2)) {
            return true;
        }
        String opString = AnnotationsKt.getWasmOpAnnotation((IrAnnotationContainer)function2);
        if (opString != null) {
            WasmOp op = WasmOp.valueOf((String)opString);
            switch (op.getImmediates().size()) {
                case 0: {
                    this.body.buildInstr(op, new WasmImmediate[0]);
                    break;
                }
                case 1: {
                    WasmImmediate wasmImmediate;
                    WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
                    WasmImmediateKind imm = (WasmImmediateKind)op.getImmediates().get(0);
                    switch (WhenMappings.$EnumSwitchMapping$1[imm.ordinal()]) {
                        case 1: {
                            wasmImmediate = (WasmImmediate)new WasmImmediate.MemArg(0, 0, null);
                            break;
                        }
                        case 2: {
                            IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
                            Intrinsics.checkNotNull((Object)irValueParameter);
                            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)irValueParameter.getType());
                            Intrinsics.checkNotNull((Object)irClassSymbol);
                            wasmImmediate = (WasmImmediate)new WasmImmediate.GcType(this.context.referenceGcType(irClassSymbol));
                            break;
                        }
                        case 3: {
                            IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
                            Intrinsics.checkNotNull((Object)irValueParameter);
                            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)irValueParameter.getType());
                            Intrinsics.checkNotNull((Object)irClassSymbol);
                            wasmImmediate = (WasmImmediate)new WasmImmediate.TypeIdx((WasmSymbolReadOnly)this.context.referenceGcType(irClassSymbol));
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("Immediate " + imm + " is unsupported").toString());
                        }
                    }
                    wasmImmediateArray[0] = wasmImmediate;
                    WasmImmediate[] immediates = wasmImmediateArray;
                    this.body.buildInstr(op, Arrays.copyOf(immediates, immediates.length));
                    break;
                }
                default: {
                    throw new IllegalStateException(("Op " + opString + " is unsupported").toString());
                }
            }
            return true;
        }
        return false;
    }

    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElement((IrElementVisitorVoid)this, (IrElement)element, (Void)data);
    }

    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression2, (Void)data);
    }

    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry, (Void)data);
    }

    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression2, (Void)data);
    }

    public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, expression2, (Void)data);
    }

    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression2, (Void)data);
    }

    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression2, (Void)data);
    }

    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression2, (Void)data);
    }

    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression2, (Void)data);
    }

    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression2, (Void)data);
    }

    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression2, (Void)data);
    }

    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression2, (Void)data);
    }

    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body2, (Void)data);
    }

    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression2, (Void)data);
    }

    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump, (Void)data);
    }

    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump, (Void)data);
    }

    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression2, (Void)data);
    }

    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression2, (Void)data);
    }

    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop, (Void)data);
    }

    public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop, (Void)data);
    }

    public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration, (Void)data);
    }

    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration);
    }

    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration, (Void)data);
    }

    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2);
    }

    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2, (Void)data);
    }

    public void visitBody(@NotNull IrBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body2);
    }

    public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body2, (Void)data);
    }

    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch);
    }

    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch, (Void)data);
    }

    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump);
    }

    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump, (Void)data);
    }

    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2);
    }

    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2, (Void)data);
    }

    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch);
    }

    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch, (Void)data);
    }

    public void visitClass(@NotNull IrClass declaration) {
        IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration);
    }

    public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration, (Void)data);
    }

    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2);
    }

    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2, (Void)data);
    }

    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2);
    }

    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2, (Void)data);
    }

    public void visitConstantArray(@NotNull IrConstantArray expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2);
    }

    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2, (Void)data);
    }

    public void visitConstantObject(@NotNull IrConstantObject expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2);
    }

    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2, (Void)data);
    }

    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2);
    }

    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2, (Void)data);
    }

    public void visitConstantValue(@NotNull IrConstantValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2);
    }

    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2, (Void)data);
    }

    public void visitConstructor(@NotNull IrConstructor declaration) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration);
    }

    public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration, (Void)data);
    }

    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration);
    }

    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration, (Void)data);
    }

    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2);
    }

    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2, (Void)data);
    }

    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2);
    }

    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2, (Void)data);
    }

    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2);
    }

    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2, (Void)data);
    }

    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2);
    }

    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2, (Void)data);
    }

    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch);
    }

    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch, (Void)data);
    }

    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2);
    }

    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2, (Void)data);
    }

    public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration);
    }

    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration, (Void)data);
    }

    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2);
    }

    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2, (Void)data);
    }

    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration);
    }

    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration, (Void)data);
    }

    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2);
    }

    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2, (Void)data);
    }

    public void visitExpression(@NotNull IrExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2);
    }

    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2, (Void)data);
    }

    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body2);
    }

    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body2, (Void)data);
    }

    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration);
    }

    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration, (Void)data);
    }

    public void visitField(@NotNull IrField declaration) {
        IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration);
    }

    public void visitField(@NotNull IrField declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration, (Void)data);
    }

    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2);
    }

    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2, (Void)data);
    }

    public void visitFile(@NotNull IrFile declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration);
    }

    public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration, (Void)data);
    }

    public void visitFunction(@NotNull IrFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration);
    }

    public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration, (Void)data);
    }

    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2);
    }

    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2, (Void)data);
    }

    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2);
    }

    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2, (Void)data);
    }

    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2);
    }

    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2, (Void)data);
    }

    public void visitGetClass(@NotNull IrGetClass expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2);
    }

    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2, (Void)data);
    }

    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2);
    }

    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2, (Void)data);
    }

    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2);
    }

    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2, (Void)data);
    }

    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2);
    }

    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2, (Void)data);
    }

    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration);
    }

    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration, (Void)data);
    }

    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2);
    }

    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2, (Void)data);
    }

    public void visitLoop(@NotNull IrLoop loop) {
        IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop);
    }

    public void visitLoop(@NotNull IrLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop, (Void)data);
    }

    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2);
    }

    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2, (Void)data);
    }

    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration);
    }

    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration, (Void)data);
    }

    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration);
    }

    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration, (Void)data);
    }

    public void visitProperty(@NotNull IrProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration);
    }

    public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration, (Void)data);
    }

    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2);
    }

    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2, (Void)data);
    }

    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2);
    }

    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2, (Void)data);
    }

    public void visitScript(@NotNull IrScript declaration) {
        IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration);
    }

    public void visitScript(@NotNull IrScript declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration, (Void)data);
    }

    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration);
    }

    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration, (Void)data);
    }

    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2);
    }

    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2, (Void)data);
    }

    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread);
    }

    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread, (Void)data);
    }

    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2);
    }

    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2, (Void)data);
    }

    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2);
    }

    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2, (Void)data);
    }

    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2);
    }

    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2, (Void)data);
    }

    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body2);
    }

    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body2, (Void)data);
    }

    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration);
    }

    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration, (Void)data);
    }

    public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration);
    }

    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration, (Void)data);
    }

    public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2);
    }

    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2, (Void)data);
    }

    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration);
    }

    public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration, (Void)data);
    }

    public void visitVararg(@NotNull IrVararg expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression2);
    }

    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression2, (Void)data);
    }

    public static final /* synthetic */ WasmBackendContext access$getBackendContext$p(BodyGenerator $this) {
        return $this.backendContext;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WasmImmediateKind.values().length];
            try {
                nArray[WasmImmediateKind.MEM_ARG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediateKind.STRUCT_TYPE_IDX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediateKind.TYPE_IDX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

