/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js.ast;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsClassModel;
import org.jetbrains.kotlin.js.backend.ast.JsCompositeBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameBinding;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.serialization.js.ast.JsAstProtoBuf;
import org.jetbrains.kotlin.serialization.js.ast.JsAstSerializerBase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012 \u0010\u0002\u001a\u001c\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004J\u0016\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002R(\u0010\u0002\u001a\u001c\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/serialization/js/ast/JsAstSerializer;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstSerializerBase;", "jsAstValidator", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "", "pathResolver", "Lkotlin/Function1;", "Ljava/io/File;", "", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "extractLocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "element", "Lcom/intellij/psi/PsiElement;", "node", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "serialize", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$ClassModel;", "classModel", "Lorg/jetbrains/kotlin/js/backend/ast/JsClassModel;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Chunk;", "fragment", "output", "Ljava/io/OutputStream;", "serializeFragment", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Fragment;", "js.serializer"})
public final class JsAstSerializer
extends JsAstSerializerBase {
    @Nullable
    private final Function2<JsProgramFragment, Set<? extends JsName>, Unit> jsAstValidator;
    @NotNull
    private final Function1<File, String> pathResolver;

    public JsAstSerializer(@Nullable Function2<? super JsProgramFragment, ? super Set<? extends JsName>, Unit> jsAstValidator, @NotNull Function1<? super File, String> pathResolver) {
        Intrinsics.checkNotNullParameter(pathResolver, (String)"pathResolver");
        this.jsAstValidator = jsAstValidator;
        this.pathResolver = pathResolver;
    }

    /*
     * WARNING - void declaration
     */
    public final void serialize(@NotNull JsProgramFragment fragment, @NotNull OutputStream output) {
        void $this$mapTo$iv$iv;
        Object object;
        void destination$iv;
        void $this$associateTo$iv;
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Iterable iterable = fragment.getNameBindings();
        Object object2 = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            void var9_8 = destination$iv;
            JsNameBinding it = (JsNameBinding)element$iv;
            boolean bl = false;
            object = TuplesKt.to((Object)it.getKey(), (Object)it.getName());
            var9_8.put(object.getFirst(), object.getSecond());
        }
        void namesBySignature = destination$iv;
        this.getImportedNames().clear();
        iterable = this.getImportedNames();
        Map<String, JsExpression> $this$map$iv = fragment.getImports();
        boolean $i$f$map = false;
        Map<String, JsExpression> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        object = $this$mapTo$iv$iv.entrySet().iterator();
        while (object.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)object.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = namesBySignature.get(it.getKey());
            Intrinsics.checkNotNull(v);
            collection.add((JsName)v);
        }
        object2 = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)iterable, (Iterable)object2);
        this.serialize(fragment).writeTo(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JsAstProtoBuf.Chunk serialize(@NotNull JsProgramFragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        try {
            JsAstProtoBuf.Chunk.Builder chunkBuilder = JsAstProtoBuf.Chunk.newBuilder();
            chunkBuilder.setFragment(this.serializeFragment(fragment));
            chunkBuilder.setNameTable(this.getNameTableBuilder().build());
            chunkBuilder.setStringTable(this.getStringTableBuilder().build());
            JsAstProtoBuf.Chunk chunk = chunkBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"chunkBuilder.build()");
            JsAstProtoBuf.Chunk chunk2 = chunk;
            return chunk2;
        }
        finally {
            this.getNameTableBuilder().clear();
            this.getStringTableBuilder().clear();
            this.getNameMap().clear();
            this.getStringMap().clear();
        }
    }

    private final JsAstProtoBuf.Fragment serializeFragment(JsProgramFragment fragment) {
        Function2<JsProgramFragment, Set<? extends JsName>, Unit> it;
        JsAstProtoBuf.Fragment.Builder fragmentBuilder = JsAstProtoBuf.Fragment.newBuilder();
        fragmentBuilder.setPackageFqn(fragment.getPackageFqn());
        for (JsImportedModule jsImportedModule : fragment.getImportedModules()) {
            JsAstProtoBuf.ImportedModule.Builder importedModuleBuilder = JsAstProtoBuf.ImportedModule.newBuilder();
            importedModuleBuilder.setExternalNameId(this.serialize(jsImportedModule.getExternalName()));
            importedModuleBuilder.setInternalNameId(this.serialize(jsImportedModule.getInternalName()));
            if (jsImportedModule.getPlainReference() != null) {
                JsExpression it2;
                boolean bl = false;
                importedModuleBuilder.setPlainReference(this.serialize(it2));
            }
            fragmentBuilder.addImportedModule(importedModuleBuilder);
        }
        for (Map.Entry entry : fragment.getImports().entrySet()) {
            String signature = (String)entry.getKey();
            JsExpression expression2 = (JsExpression)entry.getValue();
            JsAstProtoBuf.Import.Builder importBuilder = JsAstProtoBuf.Import.newBuilder();
            importBuilder.setSignatureId(this.serialize(signature));
            importBuilder.setExpression(this.serialize(expression2));
            fragmentBuilder.addImportEntry(importBuilder);
        }
        fragmentBuilder.setDeclarationBlock(this.serializeBlock(fragment.getDeclarationBlock()));
        fragmentBuilder.setInitializerBlock(this.serializeBlock(fragment.getInitializerBlock()));
        fragmentBuilder.setExportBlock(this.serializeBlock(fragment.getExportBlock()));
        for (JsNameBinding jsNameBinding : fragment.getNameBindings()) {
            Map.Entry<String, JsExpression> nameBindingBuilder = JsAstProtoBuf.NameBinding.newBuilder();
            ((JsAstProtoBuf.NameBinding.Builder)((Object)nameBindingBuilder)).setSignatureId(this.serialize(jsNameBinding.getKey()));
            ((JsAstProtoBuf.NameBinding.Builder)((Object)nameBindingBuilder)).setNameId(this.serialize(jsNameBinding.getName()));
            fragmentBuilder.addNameBinding((JsAstProtoBuf.NameBinding.Builder)((Object)nameBindingBuilder));
        }
        Iterable $this$forEach$iv = fragment.getClasses().values();
        boolean bl = false;
        for (Object element$iv : $this$forEach$iv) {
            JsClassModel it3 = (JsClassModel)element$iv;
            boolean bl2 = false;
            fragmentBuilder.addClassModel(this.serialize(it3));
        }
        Map inlineModuleExprMap = new LinkedHashMap();
        for (Map.Entry<String, JsExpression> nameBindingBuilder : fragment.getInlineModuleMap().entrySet()) {
            Object object;
            String signature = nameBindingBuilder.getKey();
            JsExpression expression3 = nameBindingBuilder.getValue();
            JsAstProtoBuf.InlineModule.Builder inlineModuleBuilder = JsAstProtoBuf.InlineModule.newBuilder();
            inlineModuleBuilder.setSignatureId(this.serialize(signature));
            JsAstProtoBuf.InlineModule.Builder builder2 = inlineModuleBuilder;
            Map $this$getOrPut$iv = inlineModuleExprMap;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(expression3);
            if (value$iv == null) {
                JsAstProtoBuf.InlineModule.Builder builder3 = builder2;
                boolean bl3 = false;
                int result2 = fragmentBuilder.getModuleExpressionCount();
                fragmentBuilder.addModuleExpression(this.serialize(expression3));
                builder2 = builder3;
                Integer answer$iv = result2;
                $this$getOrPut$iv.put(expression3, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            builder2.setExpressionId(((Number)object).intValue());
            fragmentBuilder.addInlineModule(inlineModuleBuilder);
        }
        JsStatement jsStatement = fragment.getTests();
        if (jsStatement != null) {
            it = jsStatement;
            boolean bl4 = false;
            fragmentBuilder.setTestsInvocation(this.serialize((JsStatement)it));
        }
        JsStatement jsStatement2 = fragment.getMainFunction();
        if (jsStatement2 != null) {
            it = jsStatement2;
            boolean bl5 = false;
            fragmentBuilder.setMainInvocation(this.serialize((JsStatement)it));
        }
        Map<String, JsCompositeBlock> map = fragment.getInlinedLocalDeclarations();
        boolean $i$f$forEach2 = false;
        it = map.entrySet().iterator();
        while (it.hasNext()) {
            JsAstProtoBuf.InlinedLocalDeclarations.Builder builder4;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)it.next();
            boolean bl6 = false;
            String tag = (String)entry.getKey();
            JsCompositeBlock block = (JsCompositeBlock)entry.getValue();
            JsAstProtoBuf.InlinedLocalDeclarations.Builder $this$serializeFragment_u24lambda_u248_u24lambda_u247 = builder4 = JsAstProtoBuf.InlinedLocalDeclarations.newBuilder();
            boolean bl2 = false;
            $this$serializeFragment_u24lambda_u248_u24lambda_u247.setTag(this.serialize(tag));
            $this$serializeFragment_u24lambda_u248_u24lambda_u247.setBlock(this.serializeBlock(block));
            JsAstProtoBuf.InlinedLocalDeclarations.Builder builder5 = builder4;
            fragmentBuilder.addInlinedLocalDeclarations(builder5.build());
        }
        Function2<JsProgramFragment, Set<? extends JsName>, Unit> function2 = this.jsAstValidator;
        if (function2 != null) {
            it = function2;
            boolean bl7 = false;
            it.invoke((Object)fragment, this.getNameMap().keySet());
        }
        JsAstProtoBuf.Fragment fragment2 = fragmentBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)fragment2, (String)"fragmentBuilder.build()");
        return fragment2;
    }

    private final JsAstProtoBuf.ClassModel serialize(JsClassModel classModel) {
        JsAstProtoBuf.ClassModel.Builder builder2 = JsAstProtoBuf.ClassModel.newBuilder();
        builder2.setNameId(this.serialize(classModel.getName()));
        JsName jsName = classModel.getSuperName();
        if (jsName != null) {
            JsName it = jsName;
            boolean bl = false;
            builder2.setSuperNameId(this.serialize(it));
        }
        Iterable $this$forEach$iv = classModel.getInterfaces();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsName it = (JsName)element$iv;
            boolean bl = false;
            builder2.addInterfaceNameId(this.serialize(it));
        }
        List<JsStatement> list2 = classModel.getPostDeclarationBlock().getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"classModel.postDeclarationBlock.statements");
        if (!((Collection)list2).isEmpty()) {
            builder2.setPostDeclarationBlock(this.serializeBlock(classModel.getPostDeclarationBlock()));
        }
        JsAstProtoBuf.ClassModel classModel2 = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)classModel2, (String)"builder.build()");
        return classModel2;
    }

    @Override
    @Nullable
    public JsLocation extractLocation(@NotNull JsNode node) {
        JsLocation jsLocation;
        Object source;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object object = source = node.getSource();
        if (object instanceof JsLocationWithSource) {
            jsLocation = ((JsLocationWithSource)source).asSimpleLocation();
        } else if (object instanceof PsiElement) {
            Intrinsics.checkNotNullExpressionValue((Object)source, (String)"source");
            jsLocation = !CallUtilKt.isFakePsiElement((PsiElement)source) ? this.extractLocation((PsiElement)source) : null;
        } else {
            jsLocation = null;
        }
        return jsLocation;
    }

    private final JsLocation extractLocation(PsiElement element) {
        PsiFile file2 = element.getContainingFile();
        Document document = file2.getViewProvider().getDocument();
        Intrinsics.checkNotNull((Object)document);
        Document document2 = document;
        String path2 = (String)this.pathResolver.invoke((Object)new File(file2.getViewProvider().getVirtualFile().getPath()));
        int startOffset = element.getNode().getStartOffset();
        int startLine = document2.getLineNumber(startOffset);
        int startChar = startOffset - document2.getLineStartOffset(startLine);
        return new JsLocation(path2, startLine, startChar);
    }
}

