/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithEmbeddedSource;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMap;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapGroup;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapLocationRemapper$applySourceMap$;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSegment;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u000fB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapLocationRemapper;", "", "sourceMap", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap;", "sourceMapPathMapper", "Lkotlin/Function1;", "", "(Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap;Lkotlin/jvm/functions/Function1;)V", "applySourceMap", "", "nodes", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "remap", "node", "JsNodeFlatListCollector", "js.parser"})
public final class SourceMapLocationRemapper {
    @NotNull
    private final SourceMap sourceMap;
    @NotNull
    private final Function1<String, String> sourceMapPathMapper;

    public SourceMapLocationRemapper(@NotNull SourceMap sourceMap2, @NotNull Function1<? super String, String> sourceMapPathMapper) {
        Intrinsics.checkNotNullParameter((Object)sourceMap2, (String)"sourceMap");
        Intrinsics.checkNotNullParameter(sourceMapPathMapper, (String)"sourceMapPathMapper");
        this.sourceMap = sourceMap2;
        this.sourceMapPathMapper = sourceMapPathMapper;
    }

    public /* synthetic */ SourceMapLocationRemapper(SourceMap sourceMap2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(sourceMap2, (Function1<? super String, String>)function1);
    }

    public final void remap(@NotNull JsNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        JsNodeFlatListCollector listCollector = new JsNodeFlatListCollector();
        node.accept(listCollector);
        this.applySourceMap(listCollector.getNodeList());
    }

    private final void applySourceMap(List<? extends JsNode> nodes) {
        Ref.ObjectRef lastGroup = new Ref.ObjectRef();
        Ref.IntRef lastGroupIndex = new Ref.IntRef();
        Ref.ObjectRef lastSegment = new Ref.ObjectRef();
        Ref.IntRef lastSegmentIndex = new Ref.IntRef();
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)nodes);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)applySourceMap$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        for (SourceInfoAwareJsNode node : sequence2) {
            JsLocationWithEmbeddedSource jsLocationWithEmbeddedSource;
            String sourceFileName;
            SourceMapSegment segment;
            SourceMapSegment sourceMapSegment = segment = SourceMapLocationRemapper.applySourceMap$findCorrespondingSegment(this, (Ref.ObjectRef<SourceMapGroup>)lastGroup, lastSegmentIndex, lastGroupIndex, (Ref.ObjectRef<SourceMapSegment>)lastSegment, node);
            String string2 = sourceFileName = sourceMapSegment != null ? sourceMapSegment.getSourceFileName() : null;
            if (sourceFileName != null) {
                JsLocation location = new JsLocation((String)this.sourceMapPathMapper.invoke((Object)sourceFileName), segment.getSourceLineNumber(), segment.getSourceColumnNumber());
                jsLocationWithEmbeddedSource = new JsLocationWithEmbeddedSource(location, null, (Function0<? extends Reader>)((Function0)new Function0<Reader>(this, segment){
                    final /* synthetic */ SourceMapLocationRemapper this$0;
                    final /* synthetic */ SourceMapSegment $segment;
                    {
                        this.this$0 = $receiver;
                        this.$segment = $segment;
                        super(0);
                    }

                    @Nullable
                    public final Reader invoke() {
                        return (Reader)SourceMapLocationRemapper.access$getSourceMap$p(this.this$0).getSourceContentResolver().invoke((Object)this.$segment.getSourceFileName());
                    }
                }));
            } else {
                jsLocationWithEmbeddedSource = null;
            }
            node.setSource(jsLocationWithEmbeddedSource);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final SourceMapSegment applySourceMap$findCorrespondingSegment(SourceMapLocationRemapper this$0, Ref.ObjectRef<SourceMapGroup> lastGroup, Ref.IntRef lastSegmentIndex, Ref.IntRef lastGroupIndex, Ref.ObjectRef<SourceMapSegment> lastSegment, SourceInfoAwareJsNode node) {
        SourceMapSegment segment;
        List<SourceMapGroup> list2 = node.getSource();
        JsLocation jsLocation = list2 instanceof JsLocation ? (JsLocation)((Object)list2) : null;
        if (jsLocation == null) {
            return null;
        }
        JsLocation source = jsLocation;
        list2 = this$0.sourceMap.getGroups();
        int n = source.getStartLine();
        if (n < 0 || n > CollectionsKt.getLastIndex(list2)) {
            int it = n;
            boolean bl = false;
            return null;
        }
        SourceMapGroup group = list2.get(n);
        if (!Intrinsics.areEqual((Object)lastGroup.element, (Object)group)) {
            if (lastGroup.element != null) {
                Object object = lastGroup.element;
                Intrinsics.checkNotNull((Object)object);
                List segmentsToSkip = CollectionsKt.toMutableList((Collection)CollectionsKt.drop((Iterable)((SourceMapGroup)object).getSegments(), (int)lastSegmentIndex.element));
                if (lastGroupIndex.element + 1 < source.getStartLine()) {
                    void $this$flatMapTo$iv$iv;
                    Collection collection = segmentsToSkip;
                    Iterable $this$flatMap$iv = this$0.sourceMap.getGroups().subList(lastGroupIndex.element + 1, source.getStartLine());
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        SourceMapGroup it = (SourceMapGroup)element$iv$iv;
                        boolean bl = false;
                        Iterable list$iv$iv = it.getSegments();
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    Iterable iterable2 = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
                }
                SourceMapSegment sourceMapSegment = (SourceMapSegment)CollectionsKt.lastOrNull((List)segmentsToSkip);
                if (sourceMapSegment != null) {
                    SourceMapSegment it = sourceMapSegment;
                    boolean bl = false;
                    lastSegment.element = it;
                }
            }
            lastGroup.element = group;
            lastGroupIndex.element = source.getStartLine();
            lastSegmentIndex.element = 0;
        }
        while (lastSegmentIndex.element < group.getSegments().size() && (segment = group.getSegments().get(lastSegmentIndex.element)).getGeneratedColumnNumber() <= source.getStartChar()) {
            lastSegment.element = segment;
            n = lastSegmentIndex.element;
            lastSegmentIndex.element = n + 1;
        }
        return (SourceMapSegment)lastSegment.element;
    }

    public static final /* synthetic */ SourceMap access$getSourceMap$p(SourceMapLocationRemapper $this) {
        return $this.sourceMap;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0016\u0010\u000b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\f\"\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0014J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020%H\u0016J\u0014\u0010&\u001a\u00020'*\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapLocationRemapper$JsNodeFlatListCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "()V", "nodeList", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "getNodeList", "()Ljava/util/List;", "handleNode", "", "node", "children", "", "(Lorg/jetbrains/kotlin/js/backend/ast/JsNode;[Lorg/jetbrains/kotlin/js/backend/ast/JsNode;)V", "visitArray", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsArrayLiteral;", "visitArrayAccess", "Lorg/jetbrains/kotlin/js/backend/ast/JsArrayAccess;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "visitConditional", "Lorg/jetbrains/kotlin/js/backend/ast/JsConditional;", "visitDoWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsDoWhile;", "visitElement", "visitFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "visitInvocation", "invocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "visitNameRef", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "visitPostfixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPostfixOperation;", "visitPrefixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPrefixOperation;", "isNotBefore", "", "other", "js.parser"})
    public static final class JsNodeFlatListCollector
    extends RecursiveJsVisitor {
        @NotNull
        private final List<JsNode> nodeList = new ArrayList();

        @NotNull
        public final List<JsNode> getNodeList() {
            return this.nodeList;
        }

        @Override
        public void visitDoWhile(@NotNull JsDoWhile x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            ((Collection)this.nodeList).add(x);
            this.accept((JsNode)x.getBody());
            this.accept((JsNode)x.getCondition());
        }

        @Override
        public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            JsNode[] jsNodeArray = new JsNode[]{x.getArg1(), x.getArg2()};
            this.handleNode(x, jsNodeArray);
        }

        @Override
        public void visitConditional(@NotNull JsConditional x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            JsNode[] jsNodeArray = new JsNode[]{x.getTestExpression(), x.getThenExpression(), x.getElseExpression()};
            this.handleNode(x, jsNodeArray);
        }

        @Override
        public void visitArrayAccess(@NotNull JsArrayAccess x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            JsNode[] jsNodeArray = new JsNode[]{x.getArrayExpression(), x.getIndexExpression()};
            this.handleNode(x, jsNodeArray);
        }

        @Override
        public void visitArray(@NotNull JsArrayLiteral x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            JsNode jsNode = x;
            List<JsExpression> list2 = x.getExpressions();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"x.expressions");
            Collection $this$toTypedArray$iv = list2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            JsExpression[] jsExpressionArray = thisCollection$iv.toArray(new JsExpression[0]);
            this.handleNode(jsNode, Arrays.copyOf(jsExpressionArray, jsExpressionArray.length));
        }

        @Override
        public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            JsNode[] jsNodeArray = new JsNode[]{x.getArg()};
            this.handleNode(x, jsNodeArray);
        }

        @Override
        public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            JsNode[] jsNodeArray = new JsNode[]{x.getArg()};
            this.handleNode(x, jsNodeArray);
        }

        @Override
        public void visitNameRef(@NotNull JsNameRef nameRef) {
            Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
            JsNode[] jsNodeArray = new JsNode[]{nameRef.getQualifier()};
            this.handleNode(nameRef, jsNodeArray);
        }

        @Override
        public void visitInvocation(@NotNull JsInvocation invocation) {
            Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
            JsNode jsNode = invocation;
            SpreadBuilder spreadBuilder2 = new SpreadBuilder(2);
            spreadBuilder2.add((Object)invocation.getQualifier());
            List<JsExpression> list2 = invocation.getArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"invocation.arguments");
            Collection $this$toTypedArray$iv = list2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            spreadBuilder2.addSpread((Object)thisCollection$iv.toArray(new JsExpression[0]));
            this.handleNode(jsNode, (JsNode[])spreadBuilder2.toArray((Object[])new JsNode[spreadBuilder2.size()]));
        }

        @Override
        public void visitFunction(@NotNull JsFunction x) {
            JsNode it;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            List<JsParameter> list2 = x.getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"x.parameters");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JsParameter)element$iv;
                boolean bl = false;
                this.accept((JsNode)it);
            }
            List<JsStatement> list3 = x.getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"x.body.statements");
            $this$forEach$iv = list3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JsStatement)element$iv;
                boolean bl = false;
                this.accept((JsNode)it);
            }
            ((Collection)this.nodeList).add(x);
        }

        @Override
        protected void visitElement(@NotNull JsNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ((Collection)this.nodeList).add(node);
            node.acceptChildren(this);
        }

        /*
         * WARNING - void declaration
         */
        private final void handleNode(JsNode node, JsNode ... children2) {
            void $this$mapNotNullTo$iv$iv;
            JsNode[] $this$mapNotNull$iv = children2;
            boolean $i$f$mapNotNull = false;
            JsNode[] jsNodeArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (it == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List nonNullChildren = (List)destination$iv$iv;
            if (nonNullChildren.isEmpty()) {
                ((Collection)this.nodeList).add(node);
            } else {
                JsNode it;
                JsNode firstChild = (JsNode)CollectionsKt.first((List)nonNullChildren);
                if (this.isNotBefore(node, firstChild)) {
                    this.accept(firstChild);
                    ((Collection)this.nodeList).add(node);
                    Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)nonNullChildren, (int)1);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (JsNode)element$iv;
                        boolean bl = false;
                        this.accept(it);
                    }
                } else {
                    ((Collection)this.nodeList).add(node);
                    Iterable $this$forEach$iv = nonNullChildren;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (JsNode)element$iv;
                        boolean bl = false;
                        this.accept(it);
                    }
                }
            }
        }

        private final boolean isNotBefore(JsNode $this$isNotBefore, JsNode other) {
            Object object = $this$isNotBefore.getSource();
            JsLocation jsLocation = object instanceof JsLocation ? (JsLocation)object : null;
            if (jsLocation == null) {
                return false;
            }
            JsLocation first = jsLocation;
            Object object2 = other.getSource();
            JsLocation jsLocation2 = object2 instanceof JsLocation ? (JsLocation)object2 : null;
            if (jsLocation2 == null) {
                return false;
            }
            JsLocation second = jsLocation2;
            if (!Intrinsics.areEqual((Object)first.getFile(), (Object)second.getFile())) {
                return false;
            }
            return first.getStartLine() > second.getStartLine() || first.getStartLine() == second.getStartLine() && first.getStartChar() >= second.getStartChar();
        }
    }
}

