/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamer;
import org.jetbrains.kotlin.ir.backend.js.utils.JsStaticContext;
import org.jetbrains.kotlin.ir.backend.js.utils.LocalNameGenerator;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010 \u001a\u0004\u0018\u00010\u00182\u0006\u0010!\u001a\u00020\"H\u0096\u0001\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u0004\u0018\u00010\u00192\u0006\u0010%\u001a\u00020\fJ\u0011\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\"H\u0096\u0001J\u0011\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*H\u0096\u0001J\u0011\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020-H\u0096\u0001J\u0010\u0010.\u001a\u0004\u0018\u00010\r2\u0006\u0010/\u001a\u000200J\u0011\u00101\u001a\u00020\r2\u0006\u0010,\u001a\u00020-H\u0096\u0001J\u0011\u00102\u001a\u00020\r2\u0006\u00103\u001a\u000204H\u0096\u0001J\u0011\u00105\u001a\u00020\r2\u0006\u00106\u001a\u000207H\u0096\u0001J\u0010\u00108\u001a\u0004\u0018\u00010\r2\u0006\u00109\u001a\u00020:J\u0011\u0010;\u001a\u00020\r2\u0006\u0010<\u001a\u00020=H\u0096\u0001J\u0011\u0010>\u001a\u00020\r2\u0006\u00103\u001a\u000204H\u0096\u0001J\u000e\u0010?\u001a\u00020\r2\u0006\u0010<\u001a\u00020=J\u0011\u0010@\u001a\u00020A2\u0006\u0010'\u001a\u00020\"H\u0096\u0001J\u001e\u0010B\u001a\u00020\u00002\n\b\u0002\u0010C\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tJ&\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u00032\n\b\u0002\u0010C\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;", "currentFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "currentFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "staticContext", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "localNames", "Lorg/jetbrains/kotlin/ir/backend/js/utils/LocalNameGenerator;", "nameCache", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "useBareParameterNames", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;Lorg/jetbrains/kotlin/ir/backend/js/utils/LocalNameGenerator;Ljava/util/Map;Z)V", "getCurrentFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getCurrentFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getLocalNames", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/LocalNameGenerator;", "locationCache", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "getStaticContext", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "checkIfHasAssociatedJsCode", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "checkIfJsCode", "getAssociatedObjectKey", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Ljava/lang/Integer;", "getLocationForIrElement", "irElement", "getNameForClass", "klass", "getNameForConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getNameForField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "getNameForMemberField", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getNameForReturnableBlock", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;", "getNameForStaticDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getNameForStaticFunction", "getNameForValueDeclaration", "getRefForExternalClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "newDeclaration", "func", "newFile", "file", "backend.js"})
public final class JsGenerationContext
implements IrNamer {
    @NotNull
    private final IrFile currentFile;
    @Nullable
    private final IrFunction currentFunction;
    @NotNull
    private final JsStaticContext staticContext;
    @Nullable
    private final LocalNameGenerator localNames;
    @NotNull
    private final Map<IrElement, JsName> nameCache;
    private final boolean useBareParameterNames;
    @NotNull
    private final Map<Integer, JsLocation> locationCache;

    public JsGenerationContext(@NotNull IrFile currentFile, @Nullable IrFunction currentFunction, @NotNull JsStaticContext staticContext, @Nullable LocalNameGenerator localNames, @NotNull Map<IrElement, JsName> nameCache, boolean useBareParameterNames) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        Intrinsics.checkNotNullParameter((Object)staticContext, (String)"staticContext");
        Intrinsics.checkNotNullParameter(nameCache, (String)"nameCache");
        this.currentFile = currentFile;
        this.currentFunction = currentFunction;
        this.staticContext = staticContext;
        this.localNames = localNames;
        this.nameCache = nameCache;
        this.useBareParameterNames = useBareParameterNames;
        this.locationCache = new LinkedHashMap();
    }

    public /* synthetic */ JsGenerationContext(IrFile irFile, IrFunction irFunction, JsStaticContext jsStaticContext, LocalNameGenerator localNameGenerator, Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            localNameGenerator = null;
        }
        if ((n & 0x10) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(irFile, irFunction, jsStaticContext, localNameGenerator, map, bl);
    }

    @NotNull
    public final IrFile getCurrentFile() {
        return this.currentFile;
    }

    @Nullable
    public final IrFunction getCurrentFunction() {
        return this.currentFunction;
    }

    @NotNull
    public final JsStaticContext getStaticContext() {
        return this.staticContext;
    }

    @Nullable
    public final LocalNameGenerator getLocalNames() {
        return this.localNames;
    }

    @Override
    @Nullable
    public Integer getAssociatedObjectKey(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.staticContext.getAssociatedObjectKey(irClass);
    }

    @Override
    @NotNull
    public JsName getNameForClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.staticContext.getNameForClass(klass);
    }

    @Override
    @NotNull
    public JsName getNameForConstructor(@NotNull IrConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        return this.staticContext.getNameForConstructor(constructor);
    }

    @Override
    @NotNull
    public JsName getNameForField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.staticContext.getNameForField(field);
    }

    @Override
    @NotNull
    public JsName getNameForMemberField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.staticContext.getNameForMemberField(field);
    }

    @Override
    @NotNull
    public JsName getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.staticContext.getNameForMemberFunction(function2);
    }

    @Override
    @NotNull
    public JsName getNameForProperty(@NotNull IrProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return this.staticContext.getNameForProperty(property);
    }

    @Override
    @NotNull
    public JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.staticContext.getNameForStaticDeclaration(declaration);
    }

    @Override
    @NotNull
    public JsName getNameForStaticFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.staticContext.getNameForStaticFunction(function2);
    }

    @Override
    @NotNull
    public JsNameRef getRefForExternalClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.staticContext.getRefForExternalClass(klass);
    }

    @NotNull
    public final JsGenerationContext newFile(@NotNull IrFile file2, @Nullable IrFunction func, @Nullable LocalNameGenerator localNames) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return new JsGenerationContext(file2, func, this.staticContext, localNames, this.nameCache, this.useBareParameterNames);
    }

    public static /* synthetic */ JsGenerationContext newFile$default(JsGenerationContext jsGenerationContext, IrFile irFile, IrFunction irFunction, LocalNameGenerator localNameGenerator, int n, Object object) {
        if ((n & 2) != 0) {
            irFunction = null;
        }
        if ((n & 4) != 0) {
            localNameGenerator = null;
        }
        return jsGenerationContext.newFile(irFile, irFunction, localNameGenerator);
    }

    @NotNull
    public final JsGenerationContext newDeclaration(@Nullable IrFunction func, @Nullable LocalNameGenerator localNames) {
        return new JsGenerationContext(this.currentFile, func, this.staticContext, localNames, this.nameCache, this.useBareParameterNames);
    }

    public static /* synthetic */ JsGenerationContext newDeclaration$default(JsGenerationContext jsGenerationContext, IrFunction irFunction, LocalNameGenerator localNameGenerator, int n, Object object) {
        if ((n & 1) != 0) {
            irFunction = null;
        }
        if ((n & 2) != 0) {
            localNameGenerator = null;
        }
        return jsGenerationContext.newDeclaration(irFunction, localNameGenerator);
    }

    @NotNull
    public final JsName getNameForValueDeclaration(@NotNull IrDeclarationWithName declaration) {
        JsName jsName;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Map<IrElement, JsName> $this$getOrPut$iv = this.nameCache;
        boolean $i$f$getOrPut = false;
        JsName value$iv = $this$getOrPut$iv.get(declaration);
        if (value$iv == null) {
            JsName jsName2;
            boolean bl = false;
            if (this.useBareParameterNames) {
                String string2 = declaration.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"declaration.name.asString()");
                jsName2 = new JsName(NameTablesKt.sanitizeName$default(string2, false, 2, null), true);
            } else {
                LocalNameGenerator localNameGenerator = this.localNames;
                Intrinsics.checkNotNull((Object)localNameGenerator);
                String string3 = localNameGenerator.getVariableNames().getNames().get(declaration);
                if (string3 == null) {
                    throw new IllegalStateException(("Variable name is not found " + declaration.getName()).toString());
                }
                String name = string3;
                jsName2 = new JsName(name, true);
            }
            JsName answer$iv = jsName2;
            $this$getOrPut$iv.put((IrElement)declaration, answer$iv);
            jsName = answer$iv;
        } else {
            jsName = value$iv;
        }
        return jsName;
    }

    @Nullable
    public final JsName getNameForLoop(@NotNull IrLoop loop) {
        JsName jsName;
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        Map<IrElement, JsName> $this$getOrPut$iv = this.nameCache;
        boolean $i$f$getOrPut = false;
        JsName value$iv = $this$getOrPut$iv.get(loop);
        if (value$iv == null) {
            boolean bl = false;
            LocalNameGenerator localNameGenerator = this.localNames;
            Intrinsics.checkNotNull((Object)localNameGenerator);
            String string2 = localNameGenerator.getLocalLoopNames().getNames().get(loop);
            if (string2 == null) {
                return null;
            }
            String name = string2;
            JsName answer$iv = new JsName(name, true);
            $this$getOrPut$iv.put((IrElement)loop, answer$iv);
            jsName = answer$iv;
        } else {
            jsName = value$iv;
        }
        return jsName;
    }

    @Nullable
    public final JsName getNameForReturnableBlock(@NotNull IrReturnableBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Map<IrElement, JsName> $this$getOrPut$iv = this.nameCache;
        boolean $i$f$getOrPut = false;
        JsName value$iv = $this$getOrPut$iv.get(block);
        if (value$iv == null) {
            boolean bl = false;
            LocalNameGenerator localNameGenerator = this.localNames;
            Intrinsics.checkNotNull((Object)localNameGenerator);
            String string2 = localNameGenerator.getLocalReturnableBlockNames().getNames().get(block);
            if (string2 == null) {
                return null;
            }
            String name = string2;
            return new JsName(name, true);
        }
        return value$iv;
    }

    public final boolean checkIfJsCode(@NotNull IrFunctionSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return Intrinsics.areEqual((Object)symbol2, (Object)this.staticContext.getBackendContext().getIntrinsics().getJsCode());
    }

    public final boolean checkIfHasAssociatedJsCode(@NotNull IrFunctionSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return this.staticContext.getBackendContext().getJsCodeForFunction(symbol2) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JsLocation getLocationForIrElement(@NotNull IrElement irElement) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        Map<Integer, JsLocation> map = this.locationCache;
        Integer key$iv = irElement.getStartOffset();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            JsLocation jsLocation = JsAstUtilsKt.getSourceInfo(irElement, this.currentFile.getFileEntry());
            if (jsLocation == null) {
                return null;
            }
            JsLocation answer$iv = jsLocation;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (JsLocation)object;
    }
}

