/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnBooleanExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnEnumExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnSealedExhaustivenessChecker;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0015H\u0007J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J&\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0015H\u0007J\u0018\u0010\"\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010#\u001a\u0004\u0018\u00010\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010$\u001a\u0004\u0018\u00010\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J \u0010%\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030&2\u0006\u0010\n\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/cfg/WhenChecker;", "", "()V", "exhaustivenessCheckers", "", "Lorg/jetbrains/kotlin/cfg/WhenExhaustivenessChecker;", "checkDeprecatedWhenSyntax", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "checkDuplicatedLabels", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkReservedPrefix", "containsNullCase", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getClassDescriptorOfTypeIfEnum", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getClassDescriptorOfTypeIfSealed", "getClassIdForEnumSubject", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassIdForTypeIfEnum", "getEnumMissingCases", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "enumClassDescriptor", "getMissingCases", "getSealedMissingCases", "sealedClassDescriptor", "isWhenExhaustive", "whenSubjectType", "whenSubjectTypeWithoutSmartCasts", "isTrivial", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "frontend"})
public final class WhenChecker {
    @NotNull
    public static final WhenChecker INSTANCE = new WhenChecker();
    @NotNull
    private static final List<WhenExhaustivenessChecker> exhaustivenessCheckers;

    private WhenChecker() {
    }

    @JvmStatic
    @Nullable
    public static final ClassId getClassIdForEnumSubject(@NotNull KtWhenExpression expression2, @NotNull BindingContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return WhenChecker.getClassIdForTypeIfEnum(WhenChecker.whenSubjectType(expression2, context));
    }

    @JvmStatic
    @Nullable
    public static final ClassId getClassIdForTypeIfEnum(@Nullable KotlinType type2) {
        ClassDescriptor classDescriptor2 = WhenChecker.getClassDescriptorOfTypeIfEnum(type2);
        return classDescriptor2 != null ? DescriptorUtilsKt.getClassId((ClassifierDescriptor)classDescriptor2) : null;
    }

    @JvmStatic
    @Nullable
    public static final ClassDescriptor getClassDescriptorOfTypeIfEnum(@Nullable KotlinType type2) {
        if (type2 == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor(type2);
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor classDescriptor3 = classDescriptor2;
        if (classDescriptor3.getKind() != ClassKind.ENUM_CLASS) {
            return null;
        }
        return classDescriptor3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final ClassDescriptor getClassDescriptorOfTypeIfSealed(@Nullable KotlinType type2) {
        Annotated annotated;
        KotlinType kotlinType = type2;
        Annotated annotated2 = kotlinType;
        if (kotlinType == null) return null;
        KotlinType it = annotated2;
        boolean bl = false;
        ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor(it);
        annotated2 = classDescriptor2;
        if (classDescriptor2 == null) return null;
        it = annotated = annotated2;
        boolean bl2 = false;
        if (!DescriptorUtils.isSealedClass((DeclarationDescriptor)((Object)it))) return null;
        Annotated annotated3 = annotated;
        return annotated3;
    }

    @JvmStatic
    @Nullable
    public static final KotlinType whenSubjectType(@NotNull KtWhenExpression expression2, @NotNull BindingContext context) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KtProperty subjectVariable = expression2.getSubjectVariable();
        KtExpression subjectExpression = expression2.getSubjectExpression();
        if (subjectVariable != null) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)context.get(BindingContext.VARIABLE, subjectVariable);
            object = variableDescriptor != null ? variableDescriptor.getType() : null;
        } else if (subjectExpression != null) {
            object = (ExplicitSmartCasts)context.get(BindingContext.SMARTCAST, subjectExpression);
            if (object == null || (object = object.getDefaultType()) == null) {
                object = context.getType(subjectExpression);
            }
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public final KotlinType whenSubjectTypeWithoutSmartCasts(@NotNull KtWhenExpression expression2, @NotNull BindingContext context) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KtProperty subjectVariable = expression2.getSubjectVariable();
        KtExpression subjectExpression = expression2.getSubjectExpression();
        if (subjectVariable != null) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)context.get(BindingContext.VARIABLE, subjectVariable);
            kotlinType = variableDescriptor != null ? variableDescriptor.getType() : null;
        } else {
            KtExpression ktExpression = subjectExpression;
            kotlinType = ktExpression != null ? context.getType(ktExpression) : null;
        }
        return kotlinType;
    }

    @JvmStatic
    @NotNull
    public static final List<WhenMissingCase> getEnumMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context, @NotNull ClassDescriptor enumClassDescriptor) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)enumClassDescriptor, (String)"enumClassDescriptor");
        return WhenOnEnumExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context, enumClassDescriptor, false);
    }

    @JvmStatic
    @NotNull
    public static final List<WhenMissingCase> getSealedMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context, @NotNull ClassDescriptor sealedClassDescriptor) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sealedClassDescriptor, (String)"sealedClassDescriptor");
        return WhenOnSealedExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context, sealedClassDescriptor, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context) {
        void $this$mapTo$iv$iv;
        WhenExhaustivenessChecker it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KotlinType kotlinType = WhenChecker.whenSubjectType(expression2, context);
        if (kotlinType == null) {
            return CollectionsKt.listOf((Object)WhenMissingCase.Unknown.INSTANCE);
        }
        KotlinType type2 = kotlinType;
        boolean nullable = type2.isMarkedNullable();
        Iterable $this$filter$iv = exhaustivenessCheckers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (WhenExhaustivenessChecker)element$iv$iv;
            boolean bl = false;
            if (!it.isApplicable(type2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List checkers = (List)destination$iv$iv;
        if (checkers.isEmpty()) {
            return CollectionsKt.listOf((Object)WhenMissingCase.Unknown.INSTANCE);
        }
        Iterable $this$map$iv = checkers;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (WhenExhaustivenessChecker)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMissingCases(expression2, context, TypeUtils.getClassDescriptor(type2), nullable));
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @JvmStatic
    public static final boolean isWhenExhaustive(@NotNull KtWhenExpression expression2, @NotNull BindingTrace trace) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        if (INSTANCE.getMissingCases(expression2, bindingContext).isEmpty()) {
            trace.record(BindingContext.EXHAUSTIVE_WHEN, expression2);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean containsNullCase(@NotNull KtWhenExpression expression2, @NotNull BindingContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context, true).isEmpty();
    }

    public final void checkDuplicatedLabels(@NotNull KtWhenExpression expression2, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (expression2.getSubjectExpression() == null) {
            return;
        }
        HashSet<Pair> checkedTypes = new HashSet<Pair>();
        Map checkedConstants = new LinkedHashMap();
        Map notTrivialBranches = new LinkedHashMap();
        for (KtWhenEntry entry : expression2.getEntries()) {
            KtWhenCondition[] ktWhenConditionArray;
            if (entry.isElse()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)entry.getConditions(), (String)"entry.conditions");
            for (KtWhenCondition condition : ktWhenConditionArray) {
                KotlinType type2;
                KtTypeReference typeReference;
                KtWhenCondition ktWhenCondition = condition;
                if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
                    boolean isTrivial;
                    CompileTimeConstant<?> constant;
                    KtExpression constantExpression;
                    if (((KtWhenConditionWithExpression)condition).getExpression() == null) continue;
                    BindingContext bindingContext = trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                    if (ConstantExpressionEvaluator.Companion.getConstant(constantExpression, bindingContext) == null) continue;
                    Boolean bl = (Boolean)checkedConstants.get(constant);
                    if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                        WhenChecker.checkDuplicatedLabels$report(trace, constantExpression);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)bl, (Object)false)) {
                        isTrivial = this.isTrivial(constant, constantExpression, languageVersionSettings);
                        if (isTrivial) {
                            Object v = notTrivialBranches.remove(constant);
                            Intrinsics.checkNotNull(v);
                            KtExpression reportOn = (KtExpression)v;
                            WhenChecker.checkDuplicatedLabels$report(trace, reportOn);
                            checkedConstants.put(constant, true);
                            continue;
                        }
                        WhenChecker.checkDuplicatedLabels$report(trace, constantExpression);
                        continue;
                    }
                    if (bl != null) continue;
                    isTrivial = this.isTrivial(constant, constantExpression, languageVersionSettings);
                    Boolean bl2 = isTrivial;
                    checkedConstants.put(constant, bl2);
                    if (isTrivial) continue;
                    notTrivialBranches.put(constant, constantExpression);
                    continue;
                }
                if (!(ktWhenCondition instanceof KtWhenConditionIsPattern) || ((KtWhenConditionIsPattern)condition).getTypeReference() == null || (KotlinType)trace.get(BindingContext.TYPE, typeReference) == null) continue;
                Pair typeWithIsNegation = TuplesKt.to((Object)type2, (Object)((KtWhenConditionIsPattern)condition).isNegated());
                if (checkedTypes.contains(typeWithIsNegation)) {
                    trace.report(Errors.DUPLICATE_LABEL_IN_WHEN.on((PsiElement)typeReference));
                    continue;
                }
                checkedTypes.add(typeWithIsNegation);
            }
        }
    }

    private final boolean isTrivial(CompileTimeConstant<?> $this$isTrivial, KtExpression expression2, LanguageVersionSettings languageVersionSettings) {
        if ($this$isTrivial.getUsesVariableAsConstant()) {
            return false;
        }
        if (!languageVersionSettings.supportsFeature(LanguageFeature.ProhibitSimplificationOfNonTrivialConstBooleanExpressions)) {
            return !ConstantExpressionEvaluator.Companion.isComplexBooleanConstant(expression2, $this$isTrivial);
        }
        return true;
    }

    public final void checkDeprecatedWhenSyntax(@NotNull BindingTrace trace, @NotNull KtWhenExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2.getSubjectExpression() != null) {
            return;
        }
        block0: for (KtWhenEntry entry : expression2.getEntries()) {
            if (entry.isElse()) continue;
            for (PsiElement child = entry.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNode().getElementType() == KtTokens.COMMA) {
                    trace.report(Errors.COMMA_IN_WHEN_CONDITION_WITHOUT_ARGUMENT.on(child));
                }
                if (child.getNode().getElementType() == KtTokens.ARROW) continue block0;
            }
        }
    }

    public final void checkReservedPrefix(@NotNull BindingTrace trace, @NotNull KtWhenExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        DiagnosticSink diagnosticSink = trace;
        PsiElement psiElement = expression2.getWhenKeyword();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.whenKeyword");
        ReservedCheckingKt.checkReservedPrefixWord(diagnosticSink, psiElement, "sealed", "sealed when");
    }

    private static final void checkDuplicatedLabels$report(BindingTrace $trace, KtExpression reportOn) {
        $trace.report(Errors.DUPLICATE_LABEL_IN_WHEN.on((PsiElement)reportOn));
    }

    static {
        Object[] objectArray = new WhenExhaustivenessChecker[]{WhenOnBooleanExhaustivenessChecker.INSTANCE, WhenOnEnumExhaustivenessChecker.INSTANCE, WhenOnSealedExhaustivenessChecker.INSTANCE};
        exhaustivenessCheckers = CollectionsKt.listOf((Object[])objectArray);
    }
}

