/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.SingleAbstractMethodLowering;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\u0006*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0018\u0010\r\u001a\u00020\u0006*\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmSingleAbstractMethodLowering;", "Lorg/jetbrains/kotlin/backend/common/lower/SingleAbstractMethodLowering;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "inInlineFunctionScope", "", "getInInlineFunctionScope", "()Z", "isJavaSamConversionWithEqualsHashCode", "isKotlinFunInterface", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "needEqualsHashCodeMethods", "getNeedEqualsHashCodeMethods", "getSuperTypeForWrapper", "typeOperand", "getWrappedFunctionType", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getWrapperVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "scopes", "", "Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "setConstructorSourceRange", "", "Lorg/jetbrains/kotlin/ir/builders/declarations/IrFunctionBuilder;", "createFor", "Lorg/jetbrains/kotlin/ir/IrElement;", "backend.jvm.lower"})
final class JvmSingleAbstractMethodLowering
extends SingleAbstractMethodLowering {
    private final boolean isJavaSamConversionWithEqualsHashCode;

    public JvmSingleAbstractMethodLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super((CommonBackendContext)context);
        this.isJavaSamConversionWithEqualsHashCode = context.getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.JavaSamConversionEqualsHashCode);
    }

    public boolean getInInlineFunctionScope() {
        boolean bl;
        block4: {
            Iterable $this$any$iv = this.getAllScopes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ScopeWithIr it = (ScopeWithIr)element$iv;
                    boolean bl2 = false;
                    IrElement $this$safeAs$iv = it.getIrElement();
                    boolean $i$f$safeAs = false;
                    IrElement irElement = $this$safeAs$iv;
                    if (!(irElement instanceof IrDeclaration)) {
                        irElement = null;
                    }
                    IrDeclaration irDeclaration2 = (IrDeclaration)irElement;
                    boolean bl3 = irDeclaration2 != null ? JvmIrInlineUtilsKt.isInPublicInlineScope(irDeclaration2) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public DescriptorVisibility getWrapperVisibility(@NotNull IrTypeOperatorCall expression2, @NotNull List<? extends ScopeWithIr> scopes) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        DescriptorVisibility descriptorVisibility = this.getInInlineFunctionScope() ? DescriptorVisibilities.PUBLIC : JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"if (inInlineFunctionScop\u2026lities.PACKAGE_VISIBILITY");
        return descriptorVisibility;
    }

    @NotNull
    public IrType getSuperTypeForWrapper(@NotNull IrType typeOperand) {
        Intrinsics.checkNotNullParameter((Object)typeOperand, (String)"typeOperand");
        IrClass irClass = JvmIrTypeUtilsKt.getErasedUpperBound(typeOperand);
        CommonBackendContext commonBackendContext = this.getContext();
        Intrinsics.checkNotNull((Object)commonBackendContext, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.backend.jvm.JvmBackendContext");
        return JvmIrUtilsKt.rawType(irClass, (JvmBackendContext)commonBackendContext);
    }

    @NotNull
    protected IrType getWrappedFunctionType(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        CommonBackendContext commonBackendContext = this.getContext();
        Intrinsics.checkNotNull((Object)commonBackendContext, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.backend.jvm.JvmBackendContext");
        return JvmIrUtilsKt.rawType(klass, (JvmBackendContext)commonBackendContext);
    }

    protected void setConstructorSourceRange(@NotNull IrFunctionBuilder $this$setConstructorSourceRange, @NotNull IrElement createFor) {
        Intrinsics.checkNotNullParameter((Object)$this$setConstructorSourceRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)createFor, (String)"createFor");
        $this$setConstructorSourceRange.setStartOffset(-1);
        $this$setConstructorSourceRange.setEndOffset(-1);
    }

    private final boolean isKotlinFunInterface(IrType $this$isKotlinFunInterface) {
        IrClass irClass = IrTypesKt.getClass((IrType)$this$isKotlinFunInterface);
        return !Intrinsics.areEqual((Object)(irClass != null ? irClass.getOrigin() : null), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE);
    }

    public boolean getNeedEqualsHashCodeMethods(@NotNull IrType $this$needEqualsHashCodeMethods) {
        Intrinsics.checkNotNullParameter((Object)$this$needEqualsHashCodeMethods, (String)"<this>");
        return this.isKotlinFunInterface($this$needEqualsHashCodeMethods) || this.isJavaSamConversionWithEqualsHashCode;
    }
}

