/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorEquivalenceForOverrides;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000eH\u0002J,\u0010\u000f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0004J@\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00042\u001e\b\u0002\u0010\u0013\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\u00040\u0014H\u0007J>\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00102\u001c\u0010\u0013\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u000f\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u0006H\u0082\u0010\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/DescriptorEquivalenceForOverrides;", "", "()V", "areCallableDescriptorsEquivalent", "", "a", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "b", "allowCopiesFromTheSameDeclaration", "distinguishExpectsAndNonExpects", "ignoreReturnType", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "areClassesEquivalent", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "areEquivalent", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "areTypeParametersEquivalent", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "equivalentCallables", "Lkotlin/Function2;", "ownersEquivalent", "singleSource", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "descriptors"})
public final class DescriptorEquivalenceForOverrides {
    @NotNull
    public static final DescriptorEquivalenceForOverrides INSTANCE = new DescriptorEquivalenceForOverrides();

    private DescriptorEquivalenceForOverrides() {
    }

    public final boolean areEquivalent(@Nullable DeclarationDescriptor a, @Nullable DeclarationDescriptor b, boolean allowCopiesFromTheSameDeclaration, boolean distinguishExpectsAndNonExpects) {
        return a instanceof ClassDescriptor && b instanceof ClassDescriptor ? this.areClassesEquivalent((ClassDescriptor)a, (ClassDescriptor)b) : (a instanceof TypeParameterDescriptor && b instanceof TypeParameterDescriptor ? DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, (TypeParameterDescriptor)a, (TypeParameterDescriptor)b, allowCopiesFromTheSameDeclaration, null, 8, null) : (a instanceof CallableDescriptor && b instanceof CallableDescriptor ? DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$default(this, (CallableDescriptor)a, (CallableDescriptor)b, allowCopiesFromTheSameDeclaration, distinguishExpectsAndNonExpects, false, KotlinTypeRefiner.Default.INSTANCE, 16, null) : (a instanceof PackageFragmentDescriptor && b instanceof PackageFragmentDescriptor ? Intrinsics.areEqual((Object)((PackageFragmentDescriptor)a).getFqName(), (Object)((PackageFragmentDescriptor)b).getFqName()) : Intrinsics.areEqual((Object)a, (Object)b))));
    }

    public static /* synthetic */ boolean areEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return descriptorEquivalenceForOverrides.areEquivalent(declarationDescriptor, declarationDescriptor2, bl, bl2);
    }

    private final boolean areClassesEquivalent(ClassDescriptor a, ClassDescriptor b) {
        return Intrinsics.areEqual((Object)a.getTypeConstructor(), (Object)b.getTypeConstructor());
    }

    @JvmOverloads
    public final boolean areTypeParametersEquivalent(@NotNull TypeParameterDescriptor a, @NotNull TypeParameterDescriptor b, boolean allowCopiesFromTheSameDeclaration, @NotNull Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter(equivalentCallables, (String)"equivalentCallables");
        if (Intrinsics.areEqual((Object)a, (Object)b)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)a.getContainingDeclaration(), (Object)b.getContainingDeclaration())) {
            return false;
        }
        if (!this.ownersEquivalent(a, b, equivalentCallables, allowCopiesFromTheSameDeclaration)) {
            return false;
        }
        return a.getIndex() == b.getIndex();
    }

    public static /* synthetic */ boolean areTypeParametersEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, TypeParameterDescriptor typeParameterDescriptor, TypeParameterDescriptor typeParameterDescriptor2, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 8) != 0) {
            function2 = areTypeParametersEquivalent.1.INSTANCE;
        }
        return descriptorEquivalenceForOverrides.areTypeParametersEquivalent(typeParameterDescriptor, typeParameterDescriptor2, bl, (Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean>)function2);
    }

    private final SourceElement singleSource(CallableDescriptor $this$singleSource) {
        while (true) {
            if (!($this$singleSource instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)$this$singleSource).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                return $this$singleSource.getSource();
            }
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)$this$singleSource).getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"overriddenDescriptors");
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (callableMemberDescriptor == null) break;
            $this$singleSource = callableMemberDescriptor;
        }
        return null;
    }

    public final boolean areCallableDescriptorsEquivalent(@NotNull CallableDescriptor a, @NotNull CallableDescriptor b, boolean allowCopiesFromTheSameDeclaration, boolean distinguishExpectsAndNonExpects, boolean ignoreReturnType, @NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)((Object)kotlinTypeRefiner), (String)"kotlinTypeRefiner");
        if (Intrinsics.areEqual((Object)a, (Object)b)) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)a.getName(), (Object)b.getName())) {
            return false;
        }
        if (distinguishExpectsAndNonExpects && a instanceof MemberDescriptor && b instanceof MemberDescriptor && ((MemberDescriptor)((Object)a)).isExpect() != ((MemberDescriptor)((Object)b)).isExpect()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)a.getContainingDeclaration(), (Object)b.getContainingDeclaration())) {
            if (!allowCopiesFromTheSameDeclaration) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.singleSource(a), (Object)this.singleSource(b))) {
                return false;
            }
        }
        if (DescriptorUtils.isLocal(a) || DescriptorUtils.isLocal(b)) {
            return false;
        }
        if (!this.ownersEquivalent(a, b, (Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean>)((Function2)areCallableDescriptorsEquivalent.1.INSTANCE), allowCopiesFromTheSameDeclaration)) {
            return false;
        }
        OverridingUtil overridingUtil2 = OverridingUtil.create(kotlinTypeRefiner, new KotlinTypeChecker.TypeConstructorEquality(allowCopiesFromTheSameDeclaration, a, b){
            final /* synthetic */ boolean $allowCopiesFromTheSameDeclaration;
            final /* synthetic */ CallableDescriptor $a;
            final /* synthetic */ CallableDescriptor $b;
            {
                this.$allowCopiesFromTheSameDeclaration = $allowCopiesFromTheSameDeclaration;
                this.$a = $a;
                this.$b = $b;
            }

            public final boolean equals(@NotNull TypeConstructor c1, @NotNull TypeConstructor c2) {
                Intrinsics.checkNotNullParameter((Object)c1, (String)"c1");
                Intrinsics.checkNotNullParameter((Object)c2, (String)"c2");
                if (Intrinsics.areEqual((Object)c1, (Object)c2)) {
                    return true;
                }
                ClassifierDescriptor d1 = c1.getDeclarationDescriptor();
                ClassifierDescriptor d2 = c2.getDeclarationDescriptor();
                if (!(d1 instanceof TypeParameterDescriptor) || !(d2 instanceof TypeParameterDescriptor)) {
                    return false;
                }
                return DescriptorEquivalenceForOverrides.INSTANCE.areTypeParametersEquivalent((TypeParameterDescriptor)d1, (TypeParameterDescriptor)d2, this.$allowCopiesFromTheSameDeclaration, (Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean>)((Function2)new Function2<DeclarationDescriptor, DeclarationDescriptor, Boolean>(this.$a, this.$b){
                    final /* synthetic */ CallableDescriptor $a;
                    final /* synthetic */ CallableDescriptor $b;
                    {
                        this.$a = $a;
                        this.$b = $b;
                        super(2);
                    }

                    @NotNull
                    public final Boolean invoke(@Nullable DeclarationDescriptor x, @Nullable DeclarationDescriptor y) {
                        return Intrinsics.areEqual((Object)x, (Object)this.$a) && Intrinsics.areEqual((Object)y, (Object)this.$b);
                    }
                }));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)overridingUtil2, (String)"a: CallableDescriptor,\n \u2026= a && y == b }\n        }");
        OverridingUtil overridingUtil3 = overridingUtil2;
        return overridingUtil3.isOverridableBy(a, b, null, !ignoreReturnType).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE && overridingUtil3.isOverridableBy(b, a, null, !ignoreReturnType).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
    }

    public static /* synthetic */ boolean areCallableDescriptorsEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, boolean bl, boolean bl2, boolean bl3, KotlinTypeRefiner kotlinTypeRefiner, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return descriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent(callableDescriptor, callableDescriptor2, bl, bl2, bl3, kotlinTypeRefiner);
    }

    private final boolean ownersEquivalent(DeclarationDescriptor a, DeclarationDescriptor b, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables, boolean allowCopiesFromTheSameDeclaration) {
        DeclarationDescriptor aOwner = a.getContainingDeclaration();
        DeclarationDescriptor bOwner = b.getContainingDeclaration();
        return aOwner instanceof CallableMemberDescriptor || bOwner instanceof CallableMemberDescriptor ? (Boolean)equivalentCallables.invoke((Object)aOwner, (Object)bOwner) : DescriptorEquivalenceForOverrides.areEquivalent$default(this, aOwner, bOwner, allowCopiesFromTheSameDeclaration, false, 8, null);
    }

    @JvmOverloads
    public final boolean areTypeParametersEquivalent(@NotNull TypeParameterDescriptor a, @NotNull TypeParameterDescriptor b, boolean allowCopiesFromTheSameDeclaration) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, a, b, allowCopiesFromTheSameDeclaration, null, 8, null);
    }
}

