/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IdSignatureValues;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0010*\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\nR\u0018\u0010\u000b\u001a\u00020\b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsStringConcatenationTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "isStringPlus", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;)Z", "shouldExplicitlyConvertToString", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getShouldExplicitlyConvertToString", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "explicitlyConvertedToString", "backend.js"})
final class JsStringConcatenationTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final CommonBackendContext context;

    public JsStringConcatenationTransformer(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    private final boolean getShouldExplicitlyConvertToString(IrType $this$shouldExplicitlyConvertToString) {
        if (!($this$shouldExplicitlyConvertToString instanceof IrSimpleType)) {
            return false;
        }
        IdSignature idSignature = ((IrSimpleType)$this$shouldExplicitlyConvertToString).getClassifier().getSignature();
        return ((Intrinsics.areEqual((Object)idSignature, (Object)IdSignatureValues.any) ? true : Intrinsics.areEqual((Object)idSignature, (Object)IdSignatureValues.comparable)) ? true : Intrinsics.areEqual((Object)idSignature, (Object)IdSignatureValues.number)) ? true : Intrinsics.areEqual((Object)idSignature, (Object)IdSignatureValues._long);
    }

    private final IrExpression explicitlyConvertedToString(IrExpression $this$explicitlyConvertedToString) {
        IrExpression irExpression;
        boolean bl = this.getShouldExplicitlyConvertToString($this$explicitlyConvertedToString.getType());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (IrTypeUtilsKt.isNullable((IrType)$this$explicitlyConvertedToString.getType())) {
            IrCall irCall;
            IrCall $this$explicitlyConvertedToString_u24lambda_u240 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIr().getSymbols().getExtensionToString(), null, null, null, 14, null);
            boolean bl2 = false;
            $this$explicitlyConvertedToString_u24lambda_u240.setExtensionReceiver($this$explicitlyConvertedToString);
            irExpression = (IrExpression)irCall;
        } else {
            IrCall irCall;
            IrCall $this$explicitlyConvertedToString_u24lambda_u241 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIr().getSymbols().getMemberToString(), null, null, null, 14, null);
            boolean bl3 = false;
            $this$explicitlyConvertedToString_u24lambda_u241.setDispatchReceiver($this$explicitlyConvertedToString);
            irExpression = (IrExpression)irCall;
        }
        return irExpression;
    }

    private final boolean isStringPlus(IrFunctionSymbol $this$isStringPlus) {
        return this.context.getIr().getSymbols().isStringPlus($this$isStringPlus);
    }

    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrFunctionReference irFunctionReference;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2.getValueArgumentsCount() == 0) {
            return super.visitCall(expression2);
        }
        if (this.isStringPlus((IrFunctionSymbol)expression2.getSymbol())) {
            return JsStringConcatenationTransformer.visitCall$explicitlyConvertToStringIfNeeded(expression2, this);
        }
        IrExpression $this$safeAs$iv = expression2.getDispatchReceiver();
        boolean $i$f$safeAs = false;
        IrExpression irExpression = $this$safeAs$iv;
        if (!(irExpression instanceof IrFunctionReference)) {
            irExpression = null;
        }
        boolean bl = (irFunctionReference = (IrFunctionReference)irExpression) != null && (irFunctionReference = (IrFunctionSymbol)irFunctionReference.getSymbol()) != null ? this.isStringPlus((IrFunctionSymbol)irFunctionReference) : false;
        if (bl) {
            return JsStringConcatenationTransformer.visitCall$explicitlyConvertToStringIfNeeded(expression2, this);
        }
        return super.visitCall(expression2);
    }

    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)new IrElementTransformerVoid(this){
            final /* synthetic */ JsStringConcatenationTransformer this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public IrExpression visitExpression(@NotNull IrExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (JsStringConcatenationTransformer.access$getShouldExplicitlyConvertToString(this.this$0, expression2.getType())) {
                    return JsStringConcatenationTransformer.access$explicitlyConvertedToString(this.this$0, expression2);
                }
                return expression2;
            }
        });
        return super.visitStringConcatenation(expression2);
    }

    private static final IrExpression visitCall$explicitlyConvertToStringIfNeeded(IrCall $expression, JsStringConcatenationTransformer this$0) {
        int lastArgIndex = $expression.getValueArgumentsCount() - 1;
        IrExpression irExpression = $expression.getValueArgument(lastArgIndex);
        if (irExpression == null) {
            return super.visitCall($expression);
        }
        IrExpression plusArg = irExpression;
        if (!this$0.getShouldExplicitlyConvertToString(plusArg.getType())) {
            return super.visitCall($expression);
        }
        $expression.putValueArgument(lastArgIndex, this$0.explicitlyConvertedToString(plusArg));
        return (IrExpression)$expression;
    }

    public static final /* synthetic */ boolean access$getShouldExplicitlyConvertToString(JsStringConcatenationTransformer $this, IrType $receiver) {
        return $this.getShouldExplicitlyConvertToString($receiver);
    }

    public static final /* synthetic */ IrExpression access$explicitlyConvertedToString(JsStringConcatenationTransformer $this, IrExpression $receiver) {
        return $this.explicitlyConvertedToString($receiver);
    }
}

