/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.export.ErrorDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGenerator;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.export.Exportability;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedClass;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedClassDeclarationsInfo;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedConstructor;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedFunction;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedModule;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedNamespace;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedObject;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedParameter;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedProperty;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedRegularClass;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedType;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedVisibility;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddInternalParametersToConstructorPhase;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J,\u0010\u0017\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0016\b\u0002\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00102\u0006\u0010$\u001a\u00020%H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u00102\u0006\u0010-\u001a\u00020.H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0012\u00104\u001a\u0004\u0018\u00010\u00102\u0006\u00105\u001a\u000206H\u0002J\u001c\u00107\u001a\u00020\u00102\u0006\u00105\u001a\u0002062\n\b\u0002\u00108\u001a\u0004\u0018\u000109H\u0002J\u0010\u0010:\u001a\u0002092\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u0002092\u0006\u0010;\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020\f2\u0006\u0010-\u001a\u00020.H\u0002J\u001e\u0010D\u001a\u00020E2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020H0G2\b\b\u0002\u0010I\u001a\u00020JJ\u0014\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u0010K\u001a\u00020LJ\f\u0010M\u001a\u00020\u0005*\u00020<H\u0002J\f\u0010N\u001a\u00020O*\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006P"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/export/ExportModelGenerator;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "generateNamespacesForPackages", "", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Z)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getGenerateNamespacesForPackages", "()Z", "classExportability", "Lorg/jetbrains/kotlin/ir/backend/js/export/Exportability;", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "exportAsEnumMember", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedDeclaration;", "candidate", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "enumEntriesToOrdinal", "", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "", "exportClass", "members", "", "nestedClasses", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedClass;", "exportClassDeclarations", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedClassDeclarationsInfo;", "specialProcessing", "Lkotlin/Function1;", "exportConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "exportDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "exportEnumClass", "exportEnumEntry", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedProperty;", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "enumEntries", "exportFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "exportOrdinaryClass", "exportParameter", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedParameter;", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "exportProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "exportPropertyUnsafely", "specializeType", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedType;", "exportType", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "exportTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "exportTypeParameter", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedType$TypeParameter;", "typeParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "functionExportability", "generateExport", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedModule;", "modules", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "moduleKind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "canBeUsedAsSuperTypeOfExportedClasses", "getExportedIdentifier", "", "backend.js"})
public final class ExportModelGenerator {
    @NotNull
    private final JsIrBackendContext context;
    private final boolean generateNamespacesForPackages;

    public ExportModelGenerator(@NotNull JsIrBackendContext context, boolean generateNamespacesForPackages) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.generateNamespacesForPackages = generateNamespacesForPackages;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public final boolean getGenerateNamespacesForPackages() {
        return this.generateNamespacesForPackages;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ExportedDeclaration> generateExport(@NotNull IrPackageFragment file2) {
        List list2;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FqName namespaceFqName = file2.getFqName();
        Iterable $this$flatMap$iv = file2.getDeclarations();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrDeclaration declaration = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object)this.exportDeclaration(declaration));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List exports = (List)destination$iv$iv;
        if (exports.isEmpty()) {
            list2 = CollectionsKt.emptyList();
        } else if (!this.generateNamespacesForPackages || namespaceFqName.isRoot()) {
            list2 = exports;
        } else {
            String string2 = namespaceFqName.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"namespaceFqName.toString()");
            list2 = CollectionsKt.listOf((Object)new ExportedNamespace(string2, exports));
        }
        return list2;
    }

    @NotNull
    public final ExportedModule generateExport(@NotNull Iterable<? extends IrModuleFragment> modules, @NotNull ModuleKind moduleKind) {
        Iterable list$iv$iv;
        IrModuleFragment it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter((Object)((Object)moduleKind), (String)"moduleKind");
        String string2 = this.context.getConfiguration().get(CommonConfigurationKeys.MODULE_NAME);
        Intrinsics.checkNotNull((Object)string2);
        Iterable<? extends IrModuleFragment> iterable = modules;
        List list2 = this.context.getExternalPackageFragment().values();
        ModuleKind moduleKind2 = moduleKind;
        String string3 = string2;
        boolean $i$f$flatMap = false;
        void var5_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrModuleFragment)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        $this$flatMap$iv = CollectionsKt.plus(list2, (Iterable)list3);
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrFile)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.generateExport((IrPackageFragment)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list4 = list2 = (List)destination$iv$iv;
        ModuleKind moduleKind3 = moduleKind2;
        String string4 = string3;
        return new ExportedModule(string4, moduleKind3, list4);
    }

    public static /* synthetic */ ExportedModule generateExport$default(ExportModelGenerator exportModelGenerator, Iterable iterable, ModuleKind moduleKind, int n, Object object) {
        if ((n & 2) != 0) {
            moduleKind = ModuleKind.PLAIN;
        }
        return exportModelGenerator.generateExport(iterable, moduleKind);
    }

    private final ExportedDeclaration exportDeclaration(IrDeclaration declaration) {
        ExportedDeclaration exportedDeclaration;
        IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.access$getExportCandidate(declaration);
        if (irDeclarationWithName == null) {
            return null;
        }
        IrDeclarationWithName candidate2 = irDeclarationWithName;
        if (!ExportModelGeneratorKt.access$shouldDeclarationBeExported(candidate2, this.context)) {
            return null;
        }
        IrDeclarationWithName irDeclarationWithName2 = candidate2;
        if (irDeclarationWithName2 instanceof IrSimpleFunction) {
            exportedDeclaration = this.exportFunction((IrSimpleFunction)candidate2);
        } else if (irDeclarationWithName2 instanceof IrProperty) {
            exportedDeclaration = this.exportProperty((IrProperty)candidate2);
        } else if (irDeclarationWithName2 instanceof IrClass) {
            exportedDeclaration = this.exportClass((IrClass)candidate2);
        } else if (irDeclarationWithName2 instanceof IrField) {
            exportedDeclaration = null;
        } else {
            throw new IllegalStateException(("Can't export declaration " + candidate2).toString());
        }
        return exportedDeclaration;
    }

    private final ExportedDeclaration exportClass(IrClass candidate2) {
        return IrUtilsKt.isEnumClass((IrClass)candidate2) ? this.exportEnumClass(candidate2) : this.exportOrdinaryClass(candidate2);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportFunction(IrSimpleFunction function2) {
        ExportedDeclaration exportedDeclaration;
        Exportability exportability = this.functionExportability(function2);
        if (exportability instanceof Exportability.NotNeeded) {
            exportedDeclaration = null;
        } else if (exportability instanceof Exportability.Prohibited) {
            exportedDeclaration = new ErrorDeclaration(((Exportability.Prohibited)exportability).getReason());
        } else if (exportability instanceof Exportability.Allowed) {
            Collection<ExportedType.TypeParameter> collection;
            IrTypeParameter it;
            Collection<ExportedParameter> collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            IrDeclarationParent parent2 = function2.getParent();
            Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)function2.getExtensionReceiverParameter()), (Iterable)function2.getValueParameters());
            ExportedType exportedType = this.exportType(function2.getReturnType());
            String string2 = this.getExportedIdentifier((IrDeclarationWithName)function2);
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(this.exportParameter((IrValueParameter)it));
            }
            collection2 = (List)destination$iv$iv;
            $this$map$iv = function2.getTypeParameters();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                it = (IrTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.exportTypeParameter((IrTypeParameter)p0));
            }
            collection = (List)destination$iv$iv;
            IrSimpleFunction irSimpleFunction = function2;
            boolean bl = Intrinsics.areEqual((Object)function2.getVisibility(), (Object)DescriptorVisibilities.PROTECTED);
            boolean bl2 = parent2 instanceof IrClass && !IrUtilsKt.isInterface((IrClass)((IrClass)parent2)) && function2.getModality() == Modality.ABSTRACT;
            boolean bl3 = IrDeclarationsKt.isStaticMethodOfClass((IrFunction)((IrFunction)function2));
            boolean bl4 = parent2 instanceof IrClass;
            Collection<ExportedType.TypeParameter> collection3 = collection;
            Collection<ExportedParameter> collection4 = collection2;
            ExportedType exportedType2 = exportedType;
            String string3 = string2;
            exportedDeclaration = new ExportedFunction(string3, exportedType2, (List<ExportedParameter>)collection4, (List<ExportedType.TypeParameter>)collection3, bl4, bl3, bl2, bl, irSimpleFunction);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return exportedDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportConstructor(IrConstructor constructor) {
        void $this$mapTo$iv$iv;
        IrValueParameter it;
        Iterable $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        if (!constructor.isPrimary()) {
            return null;
        }
        Iterable iterable = constructor.getValueParameters();
        Collection collection = CollectionsKt.listOfNotNull((Object)constructor.getExtensionReceiverParameter());
        boolean $i$f$filterNot = false;
        void var5_5 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (IrValueParameter)element$iv$iv;
            boolean bl = false;
            if (it.getOrigin() == ES6AddInternalParametersToConstructorPhase.ES6_RESULT_TYPE_PARAMETER.INSTANCE || it.getOrigin() == ES6AddInternalParametersToConstructorPhase.ES6_INIT_BOX_PARAMETER.INSTANCE) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allValueParameters = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv = allValueParameters;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrValueParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.exportParameter(it));
        }
        ExportedVisibility exportedVisibility = ExportModelGeneratorKt.access$toExportedVisibility(constructor.getVisibility());
        List list2 = (List)destination$iv$iv;
        return new ExportedConstructor(list2, exportedVisibility);
    }

    private final ExportedParameter exportParameter(IrValueParameter parameter) {
        String string2 = parameter.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parameter.name.asString()");
        String parameterName = NameTablesKt.sanitizeName(string2, false);
        if (ExportModelGeneratorKt.access$getAllReservedWords$p().contains(parameterName)) {
            parameterName = '_' + parameterName;
        }
        return new ExportedParameter(parameterName, this.exportType(parameter.getType()), Intrinsics.areEqual((Object)parameter.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.JS_SHADOWED_DEFAULT_PARAMETER.INSTANCE)));
    }

    private final ExportedDeclaration exportProperty(IrProperty property) {
        Object[] objectArray = new IrSimpleFunction[]{property.getGetter(), property.getSetter()};
        for (IrSimpleFunction accessor : CollectionsKt.listOfNotNull((Object[])objectArray)) {
            if (accessor.getExtensionReceiverParameter() != null) {
                return null;
            }
            if (!accessor.isFakeOverride() || ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration((IrOverridableDeclaration)accessor, this.context)) continue;
            return null;
        }
        return ExportModelGenerator.exportPropertyUnsafely$default(this, property, null, 2, null);
    }

    private final ExportedDeclaration exportPropertyUnsafely(IrProperty property, ExportedType specializeType) {
        IrDeclarationParent irDeclarationParent = property.getParent();
        IrClass parentClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        String string2 = this.getExportedIdentifier((IrDeclarationWithName)property);
        ExportedType exportedType = specializeType;
        if (exportedType == null) {
            IrSimpleFunction irSimpleFunction = property.getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            exportedType = this.exportType(irSimpleFunction.getReturnType());
        }
        IrClass irClass = parentClass;
        IrClass irClass2 = parentClass;
        return new ExportedProperty(string2, exportedType, property.isVar(), parentClass != null, false, (irClass != null ? !IrUtilsKt.isInterface((IrClass)irClass) : false) && property.getModality() == Modality.ABSTRACT, Intrinsics.areEqual((Object)property.getVisibility(), (Object)DescriptorVisibilities.PROTECTED), irClass2 != null ? IrUtilsKt.isInterface((IrClass)irClass2) : false, (IrFunction)property.getGetter(), (IrFunction)property.getSetter());
    }

    static /* synthetic */ ExportedDeclaration exportPropertyUnsafely$default(ExportModelGenerator exportModelGenerator, IrProperty irProperty, ExportedType exportedType, int n, Object object) {
        if ((n & 2) != 0) {
            exportedType = null;
        }
        return exportModelGenerator.exportPropertyUnsafely(irProperty, exportedType);
    }

    private final ExportedProperty exportEnumEntry(IrField field, Map<IrEnumEntry, Integer> enumEntries) {
        IrEnumEntry irEnumEntry = (IrEnumEntry)this.context.getMapping().getFieldToEnumEntry().get((IrDeclaration)field);
        if (irEnumEntry == null) {
            throw new IllegalStateException(("Unable to find enum entry for " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)field))).toString());
        }
        IrEnumEntry irEnumEntry2 = irEnumEntry;
        IrDeclarationParent irDeclarationParent = field.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass parentClass = (IrClass)irDeclarationParent;
        String name = this.getExportedIdentifier((IrDeclarationWithName)irEnumEntry2);
        int ordinal = ((Number)MapsKt.getValue(enumEntries, (Object)irEnumEntry2)).intValue();
        ExportedProperty nameProperty = ExportModelGenerator.exportEnumEntry$fakeProperty("name", new ExportedType.LiteralType.StringLiteralType(name));
        ExportedProperty ordinalProperty = ExportModelGenerator.exportEnumEntry$fakeProperty("ordinal", new ExportedType.LiteralType.NumberLiteralType(ordinal));
        Object object = new ExportedProperty[]{nameProperty, ordinalProperty};
        ExportedType.InlineInterfaceType type2 = new ExportedType.InlineInterfaceType(CollectionsKt.listOf((Object[])object));
        object = new ExportedType.IntersectionType(this.exportType((IrType)IrUtilsKt.getDefaultType((IrClass)parentClass)), type2);
        boolean bl = Intrinsics.areEqual((Object)parentClass.getVisibility(), (Object)DescriptorVisibilities.PROTECTED);
        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)this.context.getMapping().getEnumEntryToGetInstanceFun().get((IrDeclaration)irEnumEntry2);
        if (irSimpleFunction == null) {
            throw new IllegalStateException(("Unable to find get instance fun for " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)field))).toString());
        }
        IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
        return new ExportedProperty(name, (ExportedType)object, false, true, true, false, bl, false, (IrFunction)irSimpleFunction2, null);
    }

    private final Exportability classExportability(IrClass klass) {
        switch (WhenMappings.$EnumSwitchMapping$0[klass.getKind().ordinal()]) {
            case 1: {
                return new Exportability.Prohibited("Class " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass)) + " with kind: " + klass.getKind());
            }
        }
        if (IrDeclarationsKt.isSingleFieldValueClass((IrClass)klass)) {
            return new Exportability.Prohibited("Inline class " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass)));
        }
        return Exportability.Allowed.INSTANCE;
    }

    private final ExportedDeclaration exportOrdinaryClass(IrClass klass) {
        Exportability exportability = this.classExportability(klass);
        if (exportability instanceof Exportability.Prohibited) {
            throw new IllegalStateException(((Exportability.Prohibited)exportability).getReason().toString());
        }
        if (exportability instanceof Exportability.NotNeeded) {
            return null;
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.Allowed.INSTANCE)) {
            // empty if block
        }
        ExportedClassDeclarationsInfo exportedClassDeclarationsInfo = ExportModelGenerator.exportClassDeclarations$default(this, klass, null, 2, null);
        List<ExportedDeclaration> members = exportedClassDeclarationsInfo.component1();
        List<ExportedClass> nestedClasses2 = exportedClassDeclarationsInfo.component2();
        return this.exportClass(klass, members, nestedClasses2);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportEnumClass(IrClass klass) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Exportability exportability = this.classExportability(klass);
        if (exportability instanceof Exportability.Prohibited) {
            throw new IllegalStateException(((Exportability.Prohibited)exportability).getReason().toString());
        }
        if (exportability instanceof Exportability.NotNeeded) {
            return null;
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.Allowed.INSTANCE)) {
            // empty if block
        }
        Iterable $this$filterIsInstance$iv = klass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrEnumEntry it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrField it = (IrField)element$iv$iv;
            boolean bl2 = false;
            if ((IrEnumEntry)this.context.getMapping().getFieldToEnumEntry().get((IrDeclaration)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List enumEntries = (List)destination$iv$iv;
        Map enumEntriesToOrdinal2 = org.jetbrains.kotlin.utils.CollectionsKt.keysToMap((Iterable)enumEntries, (Function1)((Function1)new Function1<IrEnumEntry, Integer>((Object)enumEntries){

            @NotNull
            public final Integer invoke(@NotNull IrEnumEntry p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((List)this.receiver).indexOf(p0);
            }

            @NotNull
            public final String getSignature() {
                return "indexOf(Ljava/lang/Object;)I";
            }

            @NotNull
            public final String getName() {
                return "indexOf";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(List.class);
            }
        }));
        ExportedClassDeclarationsInfo exportedClassDeclarationsInfo = this.exportClassDeclarations(klass, (Function1<? super IrDeclarationWithName, ? extends ExportedDeclaration>)((Function1)new Function1<IrDeclarationWithName, ExportedDeclaration>(this, (Map<IrEnumEntry, Integer>)enumEntriesToOrdinal2){
            final /* synthetic */ ExportModelGenerator this$0;
            final /* synthetic */ Map<IrEnumEntry, Integer> $enumEntriesToOrdinal;
            {
                this.this$0 = $receiver;
                this.$enumEntriesToOrdinal = $enumEntriesToOrdinal;
                super(1);
            }

            @Nullable
            public final ExportedDeclaration invoke(@NotNull IrDeclarationWithName candidate2) {
                Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
                ExportedDeclaration enumExportedMember = ExportModelGenerator.access$exportAsEnumMember(this.this$0, candidate2, this.$enumEntriesToOrdinal);
                return enumExportedMember;
            }
        }));
        List<ExportedDeclaration> members = exportedClassDeclarationsInfo.component1();
        List<ExportedClass> nestedClasses2 = exportedClassDeclarationsInfo.component2();
        ExportedConstructor privateConstructor = new ExportedConstructor(CollectionsKt.emptyList(), ExportedVisibility.PRIVATE);
        ExportedDeclaration it = this.exportClass(klass, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)privateConstructor), (Iterable)members), nestedClasses2);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.backend.js.export.ExportedRegularClass");
        return ExportedRegularClass.copy$default((ExportedRegularClass)it, null, false, true, null, null, null, null, null, null, 507, null);
    }

    private final ExportedClassDeclarationsInfo exportClassDeclarations(IrClass klass, Function1<? super IrDeclarationWithName, ? extends ExportedDeclaration> specialProcessing) {
        List members = new ArrayList();
        List nestedClasses2 = new ArrayList();
        for (IrDeclaration declaration : klass.getDeclarations()) {
            IrDeclarationWithName candidate2;
            if (ExportModelGeneratorKt.access$getExportCandidate(declaration) == null || !ExportModelGeneratorKt.access$shouldDeclarationBeExported(candidate2, this.context)) continue;
            ExportedDeclaration processingResult = (ExportedDeclaration)specialProcessing.invoke((Object)candidate2);
            if (processingResult != null) {
                members.add(processingResult);
                continue;
            }
            IrDeclarationWithName irDeclarationWithName = candidate2;
            if (irDeclarationWithName instanceof IrSimpleFunction) {
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)members, (Object)this.exportFunction((IrSimpleFunction)candidate2));
                continue;
            }
            if (irDeclarationWithName instanceof IrConstructor) {
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)members, (Object)this.exportConstructor((IrConstructor)candidate2));
                continue;
            }
            if (irDeclarationWithName instanceof IrProperty) {
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)members, (Object)this.exportProperty((IrProperty)candidate2));
                continue;
            }
            if (irDeclarationWithName instanceof IrClass) {
                ExportedDeclaration ec = this.exportClass((IrClass)candidate2);
                if (ec instanceof ExportedClass) {
                    nestedClasses2.add(ec);
                    continue;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)members, (Object)ec);
                continue;
            }
            if (irDeclarationWithName instanceof IrField) {
                boolean bl;
                boolean bl2 = bl = Intrinsics.areEqual((Object)candidate2.getOrigin(), (Object)IrDeclarationOrigin.FIELD_FOR_OBJECT_INSTANCE.INSTANCE) || Intrinsics.areEqual((Object)candidate2.getOrigin(), (Object)IrDeclarationOrigin.FIELD_FOR_OUTER_THIS.INSTANCE) || ((IrField)candidate2).getCorrespondingPropertySymbol() != null;
                if (!_Assertions.ENABLED || bl) continue;
                boolean bl3 = false;
                String string2 = "Unexpected field without property " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)candidate2);
                throw new AssertionError((Object)string2);
            }
            throw new IllegalStateException(("Can't export member declaration " + declaration).toString());
        }
        return new ExportedClassDeclarationsInfo(members, nestedClasses2);
    }

    static /* synthetic */ ExportedClassDeclarationsInfo exportClassDeclarations$default(ExportModelGenerator exportModelGenerator, IrClass irClass, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = exportClassDeclarations.1.INSTANCE;
        }
        return exportModelGenerator.exportClassDeclarations(irClass, (Function1<? super IrDeclarationWithName, ? extends ExportedDeclaration>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportClass(IrClass klass, List<? extends ExportedDeclaration> members, List<? extends ExportedClass> nestedClasses2) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        ExportedType exportedType;
        Object v0;
        Object it2;
        Iterable $this$firstOrNull$iv;
        List typeParameters2;
        Collection collection;
        block8: {
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = klass.getTypeParameters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it3.getName().getIdentifier());
            }
            typeParameters2 = (List)destination$iv$iv;
            $this$mapTo$iv$iv2 = klass.getSuperTypes();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it2 = (IrType)element$iv;
                boolean bl = false;
                if (!(!ExportModelGeneratorKt.access$isInterface(IrTypesKt.getClassifierOrFail((IrType)it2)) && this.canBeUsedAsSuperTypeOfExportedClasses((IrType)it2))) continue;
                v0 = element$iv;
                break block8;
            }
            v0 = null;
        }
        IrType $i$f$map = v0;
        if ($i$f$map != null) {
            Object element$iv;
            IrType it4 = $i$f$map;
            boolean bl = false;
            element$iv = this.exportType(it4);
            it2 = element$iv;
            boolean bl2 = false;
            exportedType = !(it2 instanceof ExportedType.ErrorType) ? (ExportedType)element$iv : null;
        } else {
            exportedType = null;
        }
        ExportedType superType = exportedType;
        $this$firstOrNull$iv = klass.getSuperTypes();
        boolean $i$f$filter = false;
        void bl = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrType)element$iv$iv;
            boolean bl3 = false;
            if (!ExportModelGeneratorKt.access$isInterface(IrTypesKt.getClassifierOrFail((IrType)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(this.exportType((IrType)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ExportedType)element$iv$iv;
            boolean bl5 = false;
            if (!(!(it instanceof ExportedType.ErrorType))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List superInterfaces = (List)destination$iv$iv;
        String name = this.getExportedIdentifier((IrDeclarationWithName)klass);
        if (klass.getKind() == ClassKind.OBJECT) {
            Object object = this.context.getMapping().getObjectToGetInstanceFunction().get((IrDeclaration)klass);
            Intrinsics.checkNotNull((Object)object);
            IrSimpleFunction irSimpleFunction = (IrSimpleFunction)object;
            return new ExportedObject(name, superType, superInterfaces, members, nestedClasses2, klass, (IrFunction)irSimpleFunction);
        }
        return new ExportedRegularClass(name, IrUtilsKt.isInterface((IrClass)klass), klass.getModality() == Modality.ABSTRACT || klass.getModality() == Modality.SEALED, superType, superInterfaces, typeParameters2, members, nestedClasses2, klass);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportAsEnumMember(IrDeclarationWithName candidate2, Map<IrEnumEntry, Integer> enumEntriesToOrdinal2) {
        ExportedDeclaration exportedDeclaration;
        Set<IrEnumEntry> enumEntries = enumEntriesToOrdinal2.keySet();
        IrDeclarationWithName irDeclarationWithName = candidate2;
        if (irDeclarationWithName instanceof IrProperty) {
            if (ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration((IrOverridableDeclaration)candidate2, this.context)) {
                ExportedType exportedType;
                Object acc;
                Object accumulator$iv;
                Iterator iterator$iv;
                Map<IrEnumEntry, Integer> $this$reduce$iv;
                boolean $i$f$reduce;
                Collection collection;
                Object object;
                Iterable $this$mapTo$iv$iv;
                Collection destination$iv$iv;
                Iterable $this$map$iv;
                boolean $i$f$map;
                String string2 = this.getExportedIdentifier(candidate2);
                if (Intrinsics.areEqual((Object)string2, (Object)"name")) {
                    String it;
                    Iterable iterable = enumEntries;
                    $i$f$map = false;
                    void var9_8 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        object = (IrEnumEntry)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(this.getExportedIdentifier((IrDeclarationWithName)it));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new ExportedType.LiteralType.StringLiteralType(it));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$reduce = false;
                    iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        void s;
                        ExportedType $i$f$mapTo2 = (ExportedType)iterator$iv.next();
                        acc = (ExportedType)accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = new ExportedType.UnionType((ExportedType)acc, (ExportedType)s);
                    }
                    exportedType = (ExportedType)accumulator$iv;
                } else if (Intrinsics.areEqual((Object)string2, (Object)"ordinal")) {
                    $this$reduce$iv = enumEntriesToOrdinal2;
                    $i$f$map = false;
                    iterator$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList($this$map$iv.size());
                    boolean $i$f$mapTo3 = false;
                    for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                        object = item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        int ordinal = ((Number)object.getValue()).intValue();
                        collection.add(new ExportedType.LiteralType.NumberLiteralType(ordinal));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$reduce = false;
                    iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        void s;
                        ExportedType $i$f$mapTo3 = (ExportedType)iterator$iv.next();
                        acc = (ExportedType)accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = new ExportedType.UnionType((ExportedType)acc, (ExportedType)s);
                    }
                    exportedType = (ExportedType)accumulator$iv;
                } else {
                    exportedType = null;
                }
                ExportedType type2 = exportedType;
                exportedDeclaration = this.exportPropertyUnsafely((IrProperty)candidate2, type2);
            } else {
                exportedDeclaration = null;
            }
        } else {
            exportedDeclaration = irDeclarationWithName instanceof IrField ? (ExportedDeclaration)(Intrinsics.areEqual((Object)candidate2.getOrigin(), (Object)IrDeclarationOrigin.FIELD_FOR_ENUM_ENTRY.INSTANCE) ? this.exportEnumEntry((IrField)candidate2, enumEntriesToOrdinal2) : (ExportedProperty)null) : null;
        }
        return exportedDeclaration;
    }

    private final boolean canBeUsedAsSuperTypeOfExportedClasses(IrType $this$canBeUsedAsSuperTypeOfExportedClasses) {
        return !IrTypePredicatesKt.isAny((IrType)$this$canBeUsedAsSuperTypeOfExportedClasses) && !Intrinsics.areEqual((Object)IrTypesKt.getClassifierOrNull((IrType)$this$canBeUsedAsSuperTypeOfExportedClasses), (Object)this.context.getIrBuiltIns().getEnumClass());
    }

    private final ExportedType exportTypeArgument(IrTypeArgument type2) {
        if (type2 instanceof IrTypeProjection) {
            return this.exportType(((IrTypeProjection)type2).getType());
        }
        if (type2 instanceof IrType) {
            return this.exportType((IrType)type2);
        }
        return new ExportedType.ErrorType("UnknownType " + RenderIrElementKt.render((IrTypeArgument)type2));
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedType.TypeParameter exportTypeParameter(IrTypeParameter typeParameter) {
        ExportedType exportedType;
        void $this$exportTypeParameter_u24lambda_u2422;
        List constraint2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)typeParameter.getSuperTypes()), (Function1)((Function1)new Function1<IrType, Boolean>(this){
            final /* synthetic */ ExportModelGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IrType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !Intrinsics.areEqual((Object)it, (Object)this.this$0.getContext().getIrBuiltIns().getAnyNType());
            }
        })), (Function1)((Function1)new Function1<IrType, ExportedType>((Object)this){

            @NotNull
            public final ExportedType invoke(@NotNull IrType p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ExportModelGenerator.access$exportType((ExportModelGenerator)this.receiver, p0);
            }

            @NotNull
            public final String getSignature() {
                return "exportType(Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedType;";
            }

            @NotNull
            public final String getName() {
                return "exportType";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(ExportModelGenerator.class);
            }
        })), (Function1)exportTypeParameter.constraint.3.INSTANCE));
        String string2 = typeParameter.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"typeParameter.name.identifier");
        List list2 = constraint2;
        String string3 = string2;
        boolean bl = false;
        switch ($this$exportTypeParameter_u24lambda_u2422.size()) {
            case 0: {
                exportedType = null;
                break;
            }
            case 1: {
                exportedType = (ExportedType)CollectionsKt.single((List)$this$exportTypeParameter_u24lambda_u2422);
                break;
            }
            default: {
                Iterable $this$reduce$iv = (Iterable)$this$exportTypeParameter_u24lambda_u2422;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void p1;
                    ExportedType exportedType2 = (ExportedType)iterator$iv.next();
                    ExportedType p0 = (ExportedType)accumulator$iv;
                    boolean bl2 = false;
                    accumulator$iv = new ExportedType.IntersectionType(p0, (ExportedType)p1);
                }
                exportedType = (ExportedType)accumulator$iv;
            }
        }
        ExportedType exportedType3 = exportedType;
        String string4 = string3;
        return new ExportedType.TypeParameter(string4, exportedType3);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedType exportType(IrType type2) {
        Iterable it;
        Object object;
        ExportedType exportedType;
        if (type2 instanceof IrDynamicType) {
            return ExportedType.Primitive.Any.INSTANCE;
        }
        if (!(type2 instanceof IrSimpleType)) {
            return new ExportedType.ErrorType("NonSimpleType " + RenderIrElementKt.render((IrType)type2));
        }
        IrClassifierSymbol classifier = ((IrSimpleType)type2).getClassifier();
        boolean isMarkedNullable = IrTypePredicatesKt.isMarkedNullable((IrSimpleType)((IrSimpleType)type2));
        IrType irType = IrTypesKt.makeNotNull((IrType)type2);
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrSimpleType nonNullType = (IrSimpleType)irType;
        if (IrTypePredicatesKt.isBoolean((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.Boolean.INSTANCE;
        } else if (IrTypePredicatesKt.isPrimitiveType$default((IrType)((IrType)nonNullType), (boolean)false, (int)1, null) && !IrTypePredicatesKt.isLong((IrType)((IrType)nonNullType)) && !IrTypePredicatesKt.isChar((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.Number.INSTANCE;
        } else if (IrTypePredicatesKt.isByteArray((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.ByteArray.INSTANCE;
        } else if (IrTypePredicatesKt.isShortArray((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.ShortArray.INSTANCE;
        } else if (IrTypePredicatesKt.isIntArray((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.IntArray.INSTANCE;
        } else if (IrTypePredicatesKt.isFloatArray((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.FloatArray.INSTANCE;
        } else if (IrTypePredicatesKt.isDoubleArray((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.DoubleArray.INSTANCE;
        } else if (IrTypePredicatesKt.isBooleanArray((IrType)((IrType)nonNullType))) {
            exportedType = new ExportedType.ErrorType("BooleanArray");
        } else if (IrTypePredicatesKt.isLongArray((IrType)((IrType)nonNullType))) {
            exportedType = new ExportedType.ErrorType("LongArray");
        } else if (IrTypePredicatesKt.isCharArray((IrType)((IrType)nonNullType))) {
            exportedType = new ExportedType.ErrorType("CharArray");
        } else if (IrTypePredicatesKt.isString((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.String.INSTANCE;
        } else if (IrTypeUtilsKt.isThrowable((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.Throwable.INSTANCE;
        } else if (IrTypePredicatesKt.isAny((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.Any.INSTANCE;
        } else if (IrTypePredicatesKt.isUnit((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.Unit.INSTANCE;
        } else if (IrTypePredicatesKt.isNothing((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.Nothing.INSTANCE;
        } else if (IrTypePredicatesKt.isArray((IrType)((IrType)nonNullType))) {
            exportedType = new ExportedType.Array(this.exportTypeArgument((IrTypeArgument)nonNullType.getArguments().get(0)));
        } else if (IrTypeUtilsKt.isSuspendFunction((IrType)((IrType)nonNullType))) {
            exportedType = new ExportedType.ErrorType("Suspend functions are not supported");
        } else if (IrTypeUtilsKt.isFunction((IrType)((IrType)nonNullType))) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.dropLast((List)nonNullType.getArguments(), (int)1);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(this.exportTypeArgument((IrTypeArgument)it));
            }
            ExportedType exportedType2 = this.exportTypeArgument((IrTypeArgument)CollectionsKt.last((List)nonNullType.getArguments()));
            List list2 = (List)destination$iv$iv;
            exportedType = new ExportedType.Function(list2, exportedType2);
        } else if (classifier instanceof IrTypeParameterSymbol) {
            String string2 = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classifier.owner.name.identifier");
            exportedType = new ExportedType.TypeParameter(string2, null, 2, null);
        } else if (classifier instanceof IrClassSymbol) {
            ExportedType exportedType3;
            IrClass klass = (IrClass)((IrClassSymbol)classifier).getOwner();
            boolean isExported = ExportModelGeneratorKt.isExported((IrDeclaration)klass, this.context);
            boolean isImplicitlyExported = !isExported && !klass.isExternal();
            boolean isNonExportedExternal = klass.isExternal() && !isExported;
            String string3 = IrJsUtilsKt.getFqNameWithJsNameWhenAvailable((IrDeclarationWithName)klass, !isNonExportedExternal && this.generateNamespacesForPackages).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"klass.getFqNameWithJsNam\u2026esForPackages).asString()");
            String name = string3;
            switch (WhenMappings.$EnumSwitchMapping$0[klass.getKind().ordinal()]) {
                case 1: 
                case 6: {
                    exportedType3 = new ExportedType.ErrorType("Class " + name + " with kind: " + klass.getKind());
                    break;
                }
                case 2: {
                    exportedType3 = new ExportedType.TypeOf(name);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    it = ((IrSimpleType)type2).getArguments();
                    object = name;
                    boolean $i$f$map = false;
                    void var15_20 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(this.exportTypeArgument((IrTypeArgument)it2));
                    }
                    IrClass irClass = klass;
                    List list3 = (List)destination$iv$iv;
                    Object object2 = object;
                    exportedType3 = new ExportedType.ClassType((String)object2, list3, irClass);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            exportedType = exportedType3.withImplicitlyExported(isImplicitlyExported);
        } else {
            throw new IllegalStateException(("Unexpected classifier " + classifier).toString());
        }
        ExportedType exportedType4 = exportedType;
        return exportedType4.withNullability(isMarkedNullable);
    }

    private final String getExportedIdentifier(IrDeclarationWithName $this$getExportedIdentifier) {
        Name $this$getExportedIdentifier_u24lambda_u2425 = AnnotationUtilsKt.getJsNameOrKotlinName($this$getExportedIdentifier);
        boolean bl = false;
        if ($this$getExportedIdentifier_u24lambda_u2425.isSpecial()) {
            throw new IllegalStateException(("Cannot export special name: " + $this$getExportedIdentifier.getName().asString() + " for declaration " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)$this$getExportedIdentifier)).toString());
        }
        String string2 = $this$getExportedIdentifier_u24lambda_u2425.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"with(getJsNameOrKotlinNa\u2026else identifier\n        }");
        return string2;
    }

    private final Exportability functionExportability(IrSimpleFunction function2) {
        IrClass parentClass;
        if (function2.isInline()) {
            boolean bl;
            block16: {
                Iterable $this$any$iv = function2.getTypeParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrTypeParameter it = (IrTypeParameter)element$iv;
                        boolean bl2 = false;
                        if (!it.isReified()) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return new Exportability.Prohibited("Inline reified function");
            }
        }
        if (function2.isSuspend()) {
            return new Exportability.Prohibited("Suspend function");
        }
        if (function2.isFakeOverride() && !ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration((IrOverridableDeclaration)function2, this.context)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)function2.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.BRIDGE_WITHOUT_STABLE_NAME.INSTANCE)) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.BRIDGE_PROPERTY_ACCESSOR.INSTANCE)) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.BRIDGE_WITH_STABLE_NAME.INSTANCE)) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.OBJECT_GET_INSTANCE_FUNCTION.INSTANCE)) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.JS_SHADOWED_EXPORT.INSTANCE)) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.ENUM_GET_INSTANCE_FUNCTION.INSTANCE))) {
            return Exportability.NotNeeded.INSTANCE;
        }
        IrDeclarationParent $i$f$any = function2.getParent();
        IrClass irClass = parentClass = $i$f$any instanceof IrClass ? (IrClass)$i$f$any : null;
        if (parentClass != null && Intrinsics.areEqual((Object)this.context.getMapping().getEnumClassToInitEntryInstancesFun().get((IrDeclaration)parentClass), (Object)function2)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        String string2 = function2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"function.name.asString()");
        String nameString = string2;
        if (StringsKt.endsWith$default((String)nameString, (String)"-impl", (boolean)false, (int)2, null)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (StringsKt.endsWith$default((String)nameString, (String)"$", (boolean)false, (int)2, null)) {
            boolean bl;
            block17: {
                Iterable $this$any$iv = function2.getValueParameters();
                boolean $i$f$any2 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl3 = false;
                        String string3 = it.getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name.asString()");
                        if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"$mask", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return Exportability.NotNeeded.INSTANCE;
            }
        }
        String name = this.getExportedIdentifier((IrDeclarationWithName)function2);
        if (parentClass == null && ExportModelGeneratorKt.access$getAllReservedWords$p().contains(name)) {
            return new Exportability.Prohibited("Name is a reserved word");
        }
        return Exportability.Allowed.INSTANCE;
    }

    private static final ExportedProperty exportEnumEntry$fakeProperty(String name, ExportedType type2) {
        return new ExportedProperty(name, type2, false, true, false, false, false, false, null, null);
    }

    public static final /* synthetic */ ExportedDeclaration access$exportAsEnumMember(ExportModelGenerator $this, IrDeclarationWithName candidate2, Map enumEntriesToOrdinal2) {
        return $this.exportAsEnumMember(candidate2, enumEntriesToOrdinal2);
    }

    public static final /* synthetic */ ExportedType access$exportType(ExportModelGenerator $this, IrType type2) {
        return $this.exportType(type2);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

