/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.InterfaceMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmTypeTransformer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u0011H\u0016J\u0018\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010-\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u0002022\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00103\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00104\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u00105\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0010\u00109\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020>2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020!0\u00102\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020(0\u00102\u0006\u0010%\u001a\u00020&H\u0016J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020+0\u00102\u0006\u0010%\u001a\u00020&H\u0016J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020!0\u00102\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020/0\u00102\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020/0\u00102\u0006\u00101\u001a\u000202H\u0016J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020/0\u00102\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010I\u001a\u00020\u000bH\u0016J*\u0010J\u001a\b\u0012\u0004\u0012\u00020!0\u00102\u0006\u0010\u001f\u001a\u00020\u000b2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020!0LH\u0002J\u0016\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010N\u001a\u00020\u001cH\u0016J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020!0\u00102\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0018\u0010P\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\u0006\u0010Q\u001a\u00020\u001cH\u0016J\u0012\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010W\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0016J\u0012\u0010X\u001a\u0004\u0018\u00010S2\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010Y\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010Z\u001a\u00020S2\u0006\u0010[\u001a\u00020\\H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContextImpl;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "wasmFragment", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "classMetadataCache", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ClassMetadata;", "interfaceMetadataCache", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/InterfaceMetadata;", "scratchMemAddr", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "", "getScratchMemAddr", "()Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "typeTransformer", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeTransformer;", "addExport", "", "wasmExport", "Lorg/jetbrains/kotlin/wasm/ir/WasmExport;", "addJsFun", "importName", "", "jsCode", "defineClassITableGcType", "irClass", "wasmType", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "defineClassITableInterfaceSlot", "slot", "defineFunction", "irFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "wasmFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "defineFunctionType", "wasmFunctionType", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "defineGcType", "defineGlobalClassITable", "wasmGlobal", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "defineGlobalField", "irField", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "defineGlobalVTable", "defineVTableGcType", "generateTypeInfo", "typeInfo", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataElement;", "getClassMetadata", "getInterfaceMetadata", "getStructFieldRef", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "isAlreadyDefinedClassITableGcType", "", "referenceClassITableGcType", "referenceClassITableInterfaceSlot", "referenceClassId", "referenceFunction", "referenceFunctionType", "referenceGcType", "referenceGlobalClassITable", "referenceGlobalField", "referenceGlobalVTable", "referenceInterfaceId", "irInterface", "referenceNonNothingType", "from", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment$ReferencableAndDefinable;", "referenceStringLiteral", "string", "referenceVTableGcType", "registerInitFunction", "priority", "transformBlockResultType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "transformBoxedType", "transformFieldType", "transformResultType", "transformType", "transformValueParameterType", "irValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "backend.wasm"})
public final class WasmModuleCodegenContextImpl
implements WasmModuleCodegenContext {
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmCompiledModuleFragment wasmFragment;
    @NotNull
    private final WasmTypeTransformer typeTransformer;
    @NotNull
    private final Map<IrClassSymbol, ClassMetadata> classMetadataCache;
    @NotNull
    private final Map<IrClassSymbol, InterfaceMetadata> interfaceMetadataCache;

    public WasmModuleCodegenContextImpl(@NotNull WasmBackendContext backendContext, @NotNull WasmCompiledModuleFragment wasmFragment) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)wasmFragment, (String)"wasmFragment");
        this.backendContext = backendContext;
        this.wasmFragment = wasmFragment;
        this.typeTransformer = new WasmTypeTransformer(this, this.getBackendContext().getIrBuiltIns());
        this.classMetadataCache = new LinkedHashMap();
        this.interfaceMetadataCache = new LinkedHashMap();
    }

    @Override
    @NotNull
    public WasmBackendContext getBackendContext() {
        return this.backendContext;
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> getScratchMemAddr() {
        return this.wasmFragment.getScratchMemAddr();
    }

    @Override
    @NotNull
    public WasmType transformType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer $this$transformType_u24lambda_u240 = this.typeTransformer;
        boolean bl = false;
        return $this$transformType_u24lambda_u240.toWasmValueType(irType);
    }

    @Override
    @NotNull
    public WasmType transformFieldType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer $this$transformFieldType_u24lambda_u241 = this.typeTransformer;
        boolean bl = false;
        return $this$transformFieldType_u24lambda_u241.toWasmFieldType(irType);
    }

    @Override
    @NotNull
    public WasmType transformBoxedType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer $this$transformBoxedType_u24lambda_u242 = this.typeTransformer;
        boolean bl = false;
        return $this$transformBoxedType_u24lambda_u242.toBoxedInlineClassType(irType);
    }

    @Override
    @NotNull
    public WasmType transformValueParameterType(@NotNull IrValueParameter irValueParameter) {
        Intrinsics.checkNotNullParameter((Object)irValueParameter, (String)"irValueParameter");
        WasmTypeTransformer $this$transformValueParameterType_u24lambda_u243 = this.typeTransformer;
        boolean bl = false;
        return $this$transformValueParameterType_u24lambda_u243.getContext().getBackendContext().getInlineClassesUtils().shouldValueParameterBeBoxed(irValueParameter) ? $this$transformValueParameterType_u24lambda_u243.toBoxedInlineClassType(irValueParameter.getType()) : $this$transformValueParameterType_u24lambda_u243.toWasmValueType(irValueParameter.getType());
    }

    @Override
    @Nullable
    public WasmType transformResultType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer $this$transformResultType_u24lambda_u244 = this.typeTransformer;
        boolean bl = false;
        return $this$transformResultType_u24lambda_u244.toWasmResultType(irType);
    }

    @Override
    @Nullable
    public WasmType transformBlockResultType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer $this$transformBlockResultType_u24lambda_u245 = this.typeTransformer;
        boolean bl = false;
        return $this$transformBlockResultType_u24lambda_u245.toWasmBlockResultType(irType);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceStringLiteral(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        return this.wasmFragment.getStringLiteralId().reference(string2);
    }

    @Override
    public void generateTypeInfo(@NotNull IrClassSymbol irClass, @NotNull ConstantDataElement typeInfo) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)typeInfo, (String)"typeInfo");
        this.wasmFragment.getTypeInfo().define(irClass, typeInfo);
    }

    @Override
    public void registerInitFunction(@NotNull WasmFunction wasmFunction, @NotNull String priority) {
        Intrinsics.checkNotNullParameter((Object)wasmFunction, (String)"wasmFunction");
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        ((Collection)this.wasmFragment.getInitFunctions()).add(new WasmCompiledModuleFragment.FunWithPriority(wasmFunction, priority));
    }

    @Override
    public void addExport(@NotNull WasmExport<?> wasmExport) {
        Intrinsics.checkNotNullParameter(wasmExport, (String)"wasmExport");
        ((Collection)this.wasmFragment.getExports()).add(wasmExport);
    }

    @Override
    public void defineFunction(@NotNull IrFunctionSymbol irFunction, @NotNull WasmFunction wasmFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)wasmFunction, (String)"wasmFunction");
        this.wasmFragment.getFunctions().define(irFunction, wasmFunction);
    }

    @Override
    public void defineGlobalField(@NotNull IrFieldSymbol irField, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter((Object)irField, (String)"irField");
        Intrinsics.checkNotNullParameter((Object)wasmGlobal, (String)"wasmGlobal");
        this.wasmFragment.getGlobalFields().define(irField, wasmGlobal);
    }

    @Override
    public void defineGlobalVTable(@NotNull IrClassSymbol irClass, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmGlobal, (String)"wasmGlobal");
        this.wasmFragment.getGlobalVTables().define(irClass, wasmGlobal);
    }

    @Override
    public void defineGlobalClassITable(@NotNull IrClassSymbol irClass, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmGlobal, (String)"wasmGlobal");
        this.wasmFragment.getGlobalClassITables().define(irClass, wasmGlobal);
    }

    @Override
    public void defineGcType(@NotNull IrClassSymbol irClass, @NotNull WasmTypeDeclaration wasmType) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmType, (String)"wasmType");
        this.wasmFragment.getGcTypes().define(irClass, wasmType);
    }

    @Override
    public void defineVTableGcType(@NotNull IrClassSymbol irClass, @NotNull WasmTypeDeclaration wasmType) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmType, (String)"wasmType");
        this.wasmFragment.getVTableGcTypes().define(irClass, wasmType);
    }

    @Override
    public void defineFunctionType(@NotNull IrFunctionSymbol irFunction, @NotNull WasmFunctionType wasmFunctionType) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)wasmFunctionType, (String)"wasmFunctionType");
        this.wasmFragment.getFunctionTypes().define(irFunction, wasmFunctionType);
    }

    @Override
    @NotNull
    public ClassMetadata getClassMetadata(@NotNull IrClassSymbol irClass) {
        ClassMetadata classMetadata;
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Map<IrClassSymbol, ClassMetadata> $this$getOrPut$iv = this.classMetadataCache;
        boolean $i$f$getOrPut = false;
        ClassMetadata value$iv = $this$getOrPut$iv.get(irClass);
        if (value$iv == null) {
            ClassMetadata classMetadata2;
            IrClass superClass;
            boolean bl = false;
            IrClass irClass2 = superClass = ClassInfoKt.getSuperClass((IrClass)irClass.getOwner(), this.getBackendContext().getIrBuiltIns());
            if (irClass2 != null) {
                IrClass it = irClass2;
                boolean bl2 = false;
                classMetadata2 = this.getClassMetadata(it.getSymbol());
            } else {
                classMetadata2 = null;
            }
            ClassMetadata superClassMetadata = classMetadata2;
            ClassMetadata answer$iv = new ClassMetadata((IrClass)irClass.getOwner(), superClassMetadata, this.getBackendContext().getIrBuiltIns());
            $this$getOrPut$iv.put(irClass, answer$iv);
            classMetadata = answer$iv;
        } else {
            classMetadata = value$iv;
        }
        return classMetadata;
    }

    @Override
    @NotNull
    public InterfaceMetadata getInterfaceMetadata(@NotNull IrClassSymbol irClass) {
        InterfaceMetadata interfaceMetadata;
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Map<IrClassSymbol, InterfaceMetadata> $this$getOrPut$iv = this.interfaceMetadataCache;
        boolean $i$f$getOrPut = false;
        InterfaceMetadata value$iv = $this$getOrPut$iv.get(irClass);
        if (value$iv == null) {
            boolean bl = false;
            InterfaceMetadata answer$iv = new InterfaceMetadata((IrClass)irClass.getOwner(), this.getBackendContext().getIrBuiltIns());
            $this$getOrPut$iv.put(irClass, answer$iv);
            interfaceMetadata = answer$iv;
        } else {
            interfaceMetadata = value$iv;
        }
        return interfaceMetadata;
    }

    @Override
    @NotNull
    public WasmSymbol<WasmFunction> referenceFunction(@NotNull IrFunctionSymbol irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        return this.wasmFragment.getFunctions().reference(irFunction);
    }

    @Override
    @NotNull
    public WasmSymbol<WasmGlobal> referenceGlobalField(@NotNull IrFieldSymbol irField) {
        Intrinsics.checkNotNullParameter((Object)irField, (String)"irField");
        return this.wasmFragment.getGlobalFields().reference(irField);
    }

    @Override
    @NotNull
    public WasmSymbol<WasmGlobal> referenceGlobalVTable(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.wasmFragment.getGlobalVTables().reference(irClass);
    }

    @Override
    @NotNull
    public WasmSymbol<WasmGlobal> referenceGlobalClassITable(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.wasmFragment.getGlobalClassITables().reference(irClass);
    }

    private final WasmSymbol<WasmTypeDeclaration> referenceNonNothingType(IrClassSymbol irClass, WasmCompiledModuleFragment.ReferencableAndDefinable<IrClassSymbol, WasmTypeDeclaration> from) {
        IrType type2 = IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)irClass));
        if (!(!IrTypePredicatesKt.isNothing((IrType)type2))) {
            boolean bl = false;
            String string2 = "Can't reference Nothing type";
            throw new IllegalArgumentException(string2.toString());
        }
        return from.reference(irClass);
    }

    @Override
    @NotNull
    public WasmSymbol<WasmTypeDeclaration> referenceGcType(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.referenceNonNothingType(irClass, this.wasmFragment.getGcTypes());
    }

    @Override
    @NotNull
    public WasmSymbol<WasmTypeDeclaration> referenceVTableGcType(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.referenceNonNothingType(irClass, this.wasmFragment.getVTableGcTypes());
    }

    @Override
    @NotNull
    public WasmSymbol<WasmTypeDeclaration> referenceClassITableGcType(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.referenceNonNothingType(irClass, this.wasmFragment.getClassITableGcType());
    }

    @Override
    public void defineClassITableGcType(@NotNull IrClassSymbol irClass, @NotNull WasmTypeDeclaration wasmType) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmType, (String)"wasmType");
        this.wasmFragment.getClassITableGcType().define(irClass, wasmType);
    }

    @Override
    public boolean isAlreadyDefinedClassITableGcType(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.wasmFragment.getClassITableGcType().getDefined().keySet().contains(irClass);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceClassITableInterfaceSlot(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        IrType type2 = IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)irClass));
        if (!(!IrTypePredicatesKt.isNothing((IrType)type2))) {
            boolean bl = false;
            String string2 = "Can't reference Nothing type";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.wasmFragment.getClassITableInterfaceSlot().reference(irClass);
    }

    @Override
    public void defineClassITableInterfaceSlot(@NotNull IrClassSymbol irClass, int slot) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        this.wasmFragment.getClassITableInterfaceSlot().define(irClass, slot);
    }

    @Override
    @NotNull
    public WasmSymbol<WasmFunctionType> referenceFunctionType(@NotNull IrFunctionSymbol irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        return this.wasmFragment.getFunctionTypes().reference(irFunction);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceClassId(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.wasmFragment.getClassIds().reference(irClass);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceInterfaceId(@NotNull IrClassSymbol irInterface) {
        Intrinsics.checkNotNullParameter((Object)irInterface, (String)"irInterface");
        return this.wasmFragment.getInterfaceId().reference(irInterface);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> getStructFieldRef(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)field));
        ClassMetadata metadata = this.getClassMetadata(klass.getSymbol());
        int fieldId = metadata.getFields().indexOf(field) + 2;
        return new WasmSymbol((Object)fieldId);
    }

    @Override
    public void addJsFun(@NotNull String importName, @NotNull String jsCode) {
        Intrinsics.checkNotNullParameter((Object)importName, (String)"importName");
        Intrinsics.checkNotNullParameter((Object)jsCode, (String)"jsCode");
        ((Collection)this.wasmFragment.getJsFuns()).add(new WasmCompiledModuleFragment.JsCodeSnippet(importName, jsCode));
    }
}

