/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.BodyGenerator;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataIntArray;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataIntField;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataStruct;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VirtualMethodMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFunctionCodegenContextImpl;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleCodegenContext;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.DisjointUnions;
import org.jetbrains.kotlin.backend.wasm.utils.UtilsKt;
import org.jetbrains.kotlin.backend.wasm.utils.WasmArrayInfo;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.wasm.ir.TypesKt;
import org.jetbrains.kotlin.wasm.ir.WasmArrayDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImportPair;
import org.jetbrains.kotlin.wasm.ir.WasmIrExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructFieldDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J0\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&2\u0010\b\u0002\u0010'\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010(H\u0002J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u001b2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u001b2\u0006\u0010,\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u00106\u001a\u00020\u001b2\u0006\u0010,\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u001b2\u0006\u0010,\u001a\u000209H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "allowIncompleteImplementations", "", "hierarchyDisjointUnions", "Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;ZLorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions;)V", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "unitGetInstanceFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getUnitGetInstanceFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unitGetInstanceFunction$delegate", "Lkotlin/Lazy;", "binaryDataStruct", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataStruct;", "classMetadata", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ClassMetadata;", "createClassITable", "", "metadata", "createDeclarationByInterface", "iFace", "createVTable", "createVirtualTableStruct", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructDeclaration;", "methods", "", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/VirtualMethodMetadata;", "name", "", "superType", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbolReadOnly;", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "interfaceTable", "jsCodeName", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitFunction", "visitProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "visitTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "backend.wasm"})
public final class DeclarationGenerator
implements IrElementVisitorVoid {
    @NotNull
    private final WasmModuleCodegenContext context;
    private final boolean allowIncompleteImplementations;
    @NotNull
    private final DisjointUnions<IrClassSymbol> hierarchyDisjointUnions;
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Lazy unitGetInstanceFunction$delegate;

    public DeclarationGenerator(@NotNull WasmModuleCodegenContext context, boolean allowIncompleteImplementations, @NotNull DisjointUnions<IrClassSymbol> hierarchyDisjointUnions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(hierarchyDisjointUnions, (String)"hierarchyDisjointUnions");
        this.context = context;
        this.allowIncompleteImplementations = allowIncompleteImplementations;
        this.hierarchyDisjointUnions = hierarchyDisjointUnions;
        this.backendContext = this.context.getBackendContext();
        this.irBuiltIns = this.backendContext.getIrBuiltIns();
        this.unitGetInstanceFunction$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IrSimpleFunction>(this){
            final /* synthetic */ DeclarationGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrSimpleFunction invoke() {
                return MiscKt.findUnitGetInstanceFunction(DeclarationGenerator.access$getBackendContext$p(this.this$0));
            }
        }));
    }

    @NotNull
    public final WasmModuleCodegenContext getContext() {
        return this.context;
    }

    private final IrSimpleFunction getUnitGetInstanceFunction() {
        Lazy lazy = this.unitGetInstanceFunction$delegate;
        return (IrSimpleFunction)lazy.getValue();
    }

    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new IllegalStateException(("Unexpected element of type " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
    }

    public void visitProperty(@NotNull IrProperty declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!declaration.isExternal()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
    }

    private final String jsCodeName(IrFunction declaration) {
        StringBuilder stringBuilder2 = new StringBuilder();
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration));
        Intrinsics.checkNotNull((Object)fqName2);
        StringBuilder stringBuilder3 = stringBuilder2.append(fqName2.asString()).append('_');
        Intrinsics.checkNotNull((Object)declaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
        return stringBuilder3.append(ClassInfoKt.wasmSignature((IrSimpleFunction)declaration, this.irBuiltIns).hashCode()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public void visitFunction(@NotNull IrFunction declaration) {
        String initPriority;
        void $this$mapTo$iv$iv;
        WasmImportPair importedName;
        WasmImportPair wasmImportPair;
        String jsCode;
        boolean isIntrinsic;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof IrConstructor && this.backendContext.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)declaration)))) {
            return;
        }
        boolean bl = isIntrinsic = AnnotationsKt.hasWasmNoOpCastAnnotation((IrAnnotationContainer)declaration) || AnnotationsKt.getWasmOpAnnotation((IrAnnotationContainer)declaration) != null;
        if (isIntrinsic) {
            return;
        }
        String string2 = AnnotationsKt.getJsFunAnnotation((IrAnnotationContainer)declaration);
        if (string2 == null) {
            string2 = declaration.isExternal() ? declaration.getName().asString() : null;
        }
        String string3 = jsCode = string2;
        if (string3 != null) {
            String it = string3;
            boolean bl2 = false;
            String jsCodeName = this.jsCodeName(declaration);
            this.context.addJsFun(jsCodeName, it);
            wasmImportPair = new WasmImportPair("js_code", this.jsCodeName(declaration));
        } else {
            wasmImportPair = importedName = null;
        }
        if (IrFakeOverrideUtilsKt.isFakeOverride((IrDeclaration)((IrDeclaration)declaration))) {
            return;
        }
        String watName = String.valueOf(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration)));
        List<IrValueParameter> irParameters = DeclarationGeneratorKt.getEffectiveValueParameters(declaration);
        WasmType resultType = Intrinsics.areEqual((Object)declaration, (Object)this.getUnitGetInstanceFunction()) ? this.context.transformType(declaration.getReturnType()) : this.context.transformResultType(declaration.getReturnType());
        Iterable $this$map$iv22 = irParameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(this.context.transformValueParameterType((IrValueParameter)it));
        }
        List list2 = CollectionsKt.listOfNotNull((Object)resultType);
        List list3 = (List)destination$iv$iv;
        WasmFunctionType wasmFunctionType = new WasmFunctionType(list3, list2);
        this.context.defineFunctionType(declaration.getSymbol(), wasmFunctionType);
        if (declaration instanceof IrSimpleFunction && ((IrSimpleFunction)declaration).getModality() == Modality.ABSTRACT) {
            return;
        }
        boolean $this$map$iv22 = Intrinsics.areEqual((Object)declaration, (Object)IrResolveUtilsKt.getRealOverrideTarget(declaration));
        if (_Assertions.ENABLED && !$this$map$iv22) {
            boolean $i$a$-assert-DeclarationGenerator$visitFunction$22 = false;
            String $i$a$-assert-DeclarationGenerator$visitFunction$22 = "Sanity check that " + declaration + " is a real function that can be used in calls";
            throw new AssertionError((Object)$i$a$-assert-DeclarationGenerator$visitFunction$22);
        }
        WasmSymbol<WasmFunctionType> functionTypeSymbol = this.context.referenceFunctionType(declaration.getSymbol());
        if (importedName != null) {
            this.context.defineFunction(declaration.getSymbol(), (WasmFunction)new WasmFunction.Imported(watName, (WasmSymbolReadOnly)functionTypeSymbol, importedName));
            return;
        }
        WasmFunction.Defined function2 = new WasmFunction.Defined(watName, (WasmSymbolReadOnly)functionTypeSymbol, null, null, 12, null);
        WasmFunctionCodegenContextImpl functionCodegenContext = new WasmFunctionCodegenContextImpl(declaration, function2, this.backendContext, this.context);
        for (IrValueParameter irParameter : irParameters) {
            functionCodegenContext.defineLocal((IrValueSymbol)irParameter.getSymbol());
        }
        WasmExpressionBuilder exprGen = functionCodegenContext.getBodyGen();
        BodyGenerator bodyBuilder = new BodyGenerator(functionCodegenContext, this.hierarchyDisjointUnions);
        if (!(declaration.getBody() instanceof IrBlockBody)) {
            boolean bl4 = false;
            String string4 = "Only IrBlockBody is supported";
            throw new IllegalArgumentException(string4.toString());
        }
        IrBody irBody = declaration.getBody();
        if (irBody != null) {
            IrVisitorsKt.acceptVoid((IrElement)((IrElement)irBody), (IrElementVisitorVoid)bodyBuilder);
        }
        if (declaration instanceof IrConstructor) {
            exprGen.buildGetLocal((WasmLocal)function2.getLocals().get(0));
            exprGen.buildInstr(WasmOp.RETURN, new WasmImmediate[0]);
        }
        if (!((Collection)wasmFunctionType.getResultTypes()).isEmpty()) {
            exprGen.buildUnreachable();
        }
        this.context.defineFunction(declaration.getSymbol(), (WasmFunction)function2);
        Object object = declaration;
        String string5 = Intrinsics.areEqual((Object)object, (Object)this.backendContext.getFieldInitFunction()) ? "0" : (initPriority = Intrinsics.areEqual((Object)object, (Object)this.backendContext.getMainCallsWrapperFunction()) ? "1" : null);
        if (initPriority != null) {
            this.context.registerInitFunction((WasmFunction)function2, initPriority);
        }
        if (DeclarationGeneratorKt.isExported(declaration)) {
            object = AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)declaration).getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier");
            this.context.addExport((WasmExport)new WasmExport.Function((String)object, (WasmFunction)function2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createDeclarationByInterface(IrClassSymbol iFace) {
        void $this$mapIndexedTo$iv$iv;
        if (this.context.isAlreadyDefinedClassITableGcType(iFace)) {
            return;
        }
        if (!this.hierarchyDisjointUnions.contains(iFace)) {
            return;
        }
        List<IrClassSymbol> iFacesUnion = this.hierarchyDisjointUnions.get(iFace);
        Iterable $this$mapIndexed$iv = iFacesUnion;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void unionIFace;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrClassSymbol irClassSymbol = (IrClassSymbol)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.context.defineClassITableInterfaceSlot((IrClassSymbol)unionIFace, (int)index2);
            collection.add(new WasmStructFieldDeclaration(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)unionIFace.getOwner())) + ".itable", (WasmType)new WasmRefNullType((WasmHeapType)new WasmHeapType.Type((WasmSymbolReadOnly)this.context.referenceVTableGcType((IrClassSymbol)unionIFace))), false));
        }
        List fields2 = (List)destination$iv$iv;
        WasmStructDeclaration struct = new WasmStructDeclaration("classITable", fields2, null);
        Iterable $this$forEach$iv = iFacesUnion;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrClassSymbol it = (IrClassSymbol)element$iv;
            boolean bl = false;
            this.context.defineClassITableGcType(it, (WasmTypeDeclaration)struct);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final WasmStructDeclaration createVirtualTableStruct(List<VirtualMethodMetadata> methods2, String name, WasmSymbolReadOnly<? extends WasmTypeDeclaration> superType) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = methods2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualMethodMetadata virtualMethodMetadata = (VirtualMethodMetadata)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getSignature().getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.signature.name.asString()");
            collection.add(new WasmStructFieldDeclaration(string2, (WasmType)new WasmRefNullType((WasmHeapType)new WasmHeapType.Type((WasmSymbolReadOnly)this.context.referenceFunctionType((IrFunctionSymbol)it.getFunction().getSymbol()))), false));
        }
        List tableFields = (List)destination$iv$iv;
        return new WasmStructDeclaration(name, tableFields, superType);
    }

    static /* synthetic */ WasmStructDeclaration createVirtualTableStruct$default(DeclarationGenerator declarationGenerator, List list2, String string2, WasmSymbolReadOnly wasmSymbolReadOnly, int n, Object object) {
        if ((n & 4) != 0) {
            wasmSymbolReadOnly = null;
        }
        return declarationGenerator.createVirtualTableStruct(list2, string2, (WasmSymbolReadOnly<? extends WasmTypeDeclaration>)wasmSymbolReadOnly);
    }

    /*
     * WARNING - void declaration
     */
    private final void createVTable(ClassMetadata metadata) {
        WasmSymbol<WasmTypeDeclaration> wasmSymbol;
        IrClass klass = metadata.getKlass();
        IrClassSymbol symbol2 = klass.getSymbol();
        String vtableName = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass)) + ".vtable";
        DeclarationGenerator declarationGenerator = this;
        List<VirtualMethodMetadata> list2 = metadata.getVirtualMethods();
        String string2 = vtableName;
        ClassMetadata classMetadata = metadata.getSuperClass();
        if (classMetadata != null && (classMetadata = classMetadata.getKlass()) != null && (classMetadata = classMetadata.getSymbol()) != null) {
            void p0;
            ClassMetadata classMetadata2 = classMetadata;
            WasmModuleCodegenContext wasmModuleCodegenContext = this.context;
            ClassMetadata classMetadata3 = classMetadata2;
            String string3 = string2;
            List<VirtualMethodMetadata> list3 = list2;
            DeclarationGenerator declarationGenerator2 = declarationGenerator;
            boolean bl = false;
            WasmSymbol<WasmTypeDeclaration> wasmSymbol2 = wasmModuleCodegenContext.referenceVTableGcType((IrClassSymbol)p0);
            declarationGenerator = declarationGenerator2;
            list2 = list3;
            string2 = string3;
            wasmSymbol = wasmSymbol2;
        } else {
            wasmSymbol = null;
        }
        WasmStructDeclaration vtableStruct = declarationGenerator.createVirtualTableStruct(list2, string2, (WasmSymbolReadOnly<? extends WasmTypeDeclaration>)((WasmSymbolReadOnly)wasmSymbol));
        this.context.defineVTableGcType(metadata.getKlass().getSymbol(), (WasmTypeDeclaration)vtableStruct);
        if (UtilsKt.isAbstractOrSealed(klass)) {
            return;
        }
        WasmSymbol<WasmTypeDeclaration> vTableTypeReference = this.context.referenceVTableGcType(symbol2);
        WasmRefType vTableRefGcType = new WasmRefType((WasmHeapType)new WasmHeapType.Type((WasmSymbolReadOnly)vTableTypeReference));
        boolean $i$f$buildWasmExpression = false;
        List res$iv = new ArrayList();
        WasmExpressionBuilder $this$createVTable_u24lambda_u249 = (WasmExpressionBuilder)new WasmIrExpressionBuilder(res$iv);
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = metadata.getVirtualMethods();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void method;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VirtualMethodMetadata virtualMethodMetadata = (VirtualMethodMetadata)item$iv;
            int i = n;
            boolean bl2 = false;
            if (method.getFunction().getModality() != Modality.ABSTRACT) {
                WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{(WasmImmediate)new WasmImmediate.FuncIdx(this.context.referenceFunction((IrFunctionSymbol)method.getFunction().getSymbol()))};
                $this$createVTable_u24lambda_u249.buildInstr(WasmOp.REF_FUNC, wasmImmediateArray);
                continue;
            }
            if (!this.allowIncompleteImplementations) {
                boolean bl3 = false;
                String string4 = "Cannot find class implementation of method " + method.getSignature() + " in class " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass));
                throw new IllegalStateException(string4.toString());
            }
            $this$createVTable_u24lambda_u249.buildRefNull(TypesKt.getHeapType((WasmType)((WasmStructFieldDeclaration)vtableStruct.getFields().get(i)).getType()));
        }
        $this$createVTable_u24lambda_u249.buildStructNew(vTableTypeReference);
        List initVTableGlobal = res$iv;
        this.context.defineGlobalVTable(symbol2, new WasmGlobal(vtableName, (WasmType)vTableRefGcType, false, initVTableGlobal, null, 16, null));
    }

    private final void createClassITable(ClassMetadata metadata) {
        IrClass klass = metadata.getKlass();
        if (UtilsKt.isAbstractOrSealed(klass)) {
            return;
        }
        IrClass irClass = (IrClass)CollectionsKt.firstOrNull(metadata.getInterfaces());
        if (irClass == null || (irClass = irClass.getSymbol()) == null) {
            return;
        }
        IrClass supportedInterface = irClass;
        this.createDeclarationByInterface((IrClassSymbol)supportedInterface);
        WasmSymbol<WasmTypeDeclaration> classInterfaceType = this.context.referenceClassITableGcType((IrClassSymbol)supportedInterface);
        List<IrClassSymbol> interfaceList = this.hierarchyDisjointUnions.get((IrClassSymbol)supportedInterface);
        boolean $i$f$buildWasmExpression = false;
        List res$iv = new ArrayList();
        WasmExpressionBuilder $this$createClassITable_u24lambda_u2411 = (WasmExpressionBuilder)new WasmIrExpressionBuilder(res$iv);
        boolean bl = false;
        for (IrClassSymbol iFace : interfaceList) {
            WasmSymbol<WasmTypeDeclaration> iFaceVTableGcType = this.context.referenceVTableGcType(iFace);
            WasmHeapType.Type iFaceVTableGcNullHeapType = new WasmHeapType.Type((WasmSymbolReadOnly)iFaceVTableGcType);
            if (!metadata.getInterfaces().contains(iFace.getOwner())) {
                $this$createClassITable_u24lambda_u2411.buildRefNull((WasmHeapType)iFaceVTableGcNullHeapType);
                continue;
            }
            for (VirtualMethodMetadata method : this.context.getInterfaceMetadata(iFace).getMethods()) {
                Object v1;
                WasmImmediate[] wasmImmediateArray;
                block8: {
                    wasmImmediateArray = (WasmImmediate[])metadata.getVirtualMethods();
                    for (Object t : wasmImmediateArray) {
                        VirtualMethodMetadata it = (VirtualMethodMetadata)t;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)it.getSignature(), (Object)method.getSignature()) && it.getFunction().getModality() != Modality.ABSTRACT)) continue;
                        v1 = t;
                        break block8;
                    }
                    v1 = null;
                }
                VirtualMethodMetadata classMethod = v1;
                if (classMethod == null && !this.allowIncompleteImplementations) {
                    throw new IllegalStateException(("Cannot find interface implementation of method " + method.getSignature() + " in class " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass))).toString());
                }
                if (classMethod != null) {
                    WasmSymbol<WasmFunction> functionTypeReference = this.context.referenceFunction((IrFunctionSymbol)classMethod.getFunction().getSymbol());
                    wasmImmediateArray = new WasmImmediate[]{(WasmImmediate)new WasmImmediate.FuncIdx(functionTypeReference)};
                    $this$createClassITable_u24lambda_u2411.buildInstr(WasmOp.REF_FUNC, wasmImmediateArray);
                    continue;
                }
                $this$createClassITable_u24lambda_u2411.buildRefNull((WasmHeapType)new WasmHeapType.Type((WasmSymbolReadOnly)this.context.referenceFunctionType((IrFunctionSymbol)method.getFunction().getSymbol())));
            }
            $this$createClassITable_u24lambda_u2411.buildStructNew(iFaceVTableGcType);
        }
        $this$createClassITable_u24lambda_u2411.buildStructNew(classInterfaceType);
        List initITableGlobal = res$iv;
        WasmGlobal wasmClassIFaceGlobal = new WasmGlobal(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass)) + ".classITable", (WasmType)new WasmRefType((WasmHeapType)new WasmHeapType.Type((WasmSymbolReadOnly)classInterfaceType)), false, initITableGlobal, null, 16, null);
        this.context.defineGlobalClassITable(klass.getSymbol(), wasmClassIFaceGlobal);
    }

    /*
     * WARNING - void declaration
     */
    public void visitClass(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (IrUtilsKt.isAnnotationClass((IrClass)declaration)) {
            return;
        }
        if (declaration.isExternal()) {
            return;
        }
        IrClassSymbol symbol2 = declaration.getSymbol();
        WasmArrayInfo wasmArrayInfo = AnnotationsKt.getWasmArrayAnnotation((IrAnnotationContainer)declaration);
        if (wasmArrayInfo != null) {
            WasmArrayInfo wasmArrayAnnotation = wasmArrayInfo;
            boolean bl = false;
            String nameStr = String.valueOf(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration)));
            WasmArrayDeclaration wasmArrayDeclaration = new WasmArrayDeclaration(nameStr, new WasmStructFieldDeclaration("field", this.context.transformFieldType(wasmArrayAnnotation.getType()), true));
            this.context.defineGcType(symbol2, (WasmTypeDeclaration)wasmArrayDeclaration);
            return;
        }
        String nameStr = String.valueOf(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration)));
        if (IrUtilsKt.isInterface((IrClass)declaration)) {
            if (this.hierarchyDisjointUnions.contains(symbol2)) {
                WasmStructDeclaration vtableStruct = DeclarationGenerator.createVirtualTableStruct$default(this, this.context.getInterfaceMetadata(symbol2).getMethods(), nameStr + ".itable", null, 4, null);
                this.context.defineVTableGcType(symbol2, (WasmTypeDeclaration)vtableStruct);
            }
        } else {
            WasmSymbol<WasmTypeDeclaration> wasmSymbol;
            ClassMetadata metadata = this.context.getClassMetadata(symbol2);
            this.createVTable(metadata);
            this.createClassITable(metadata);
            WasmRefType vtableRefGcType = new WasmRefType((WasmHeapType)new WasmHeapType.Type((WasmSymbolReadOnly)this.context.referenceVTableGcType(symbol2)));
            WasmRefNullType classITableRefGcType = new WasmRefNullType((WasmHeapType)WasmHeapType.Simple.Data.INSTANCE);
            List fields2 = new ArrayList();
            fields2.add(new WasmStructFieldDeclaration("vtable", (WasmType)vtableRefGcType, false));
            fields2.add(new WasmStructFieldDeclaration("itable", (WasmType)classITableRefGcType, false));
            Iterable $this$mapTo$iv = ClassInfoKt.allFields(declaration, this.irBuiltIns);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                IrField irField = (IrField)item$iv;
                Collection collection = fields2;
                boolean bl = false;
                String string2 = it.getName().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name.toString()");
                collection.add(new WasmStructFieldDeclaration(string2, this.context.transformFieldType(it.getType()), true));
            }
            ClassMetadata superClass = metadata.getSuperClass();
            String string3 = nameStr;
            List list2 = fields2;
            ClassMetadata classMetadata = superClass;
            if (classMetadata != null) {
                Object item$iv;
                item$iv = classMetadata;
                List list3 = list2;
                String string4 = string3;
                boolean bl = false;
                WasmSymbol<WasmTypeDeclaration> wasmSymbol2 = this.context.referenceGcType(superClass.getKlass().getSymbol());
                string3 = string4;
                list2 = list3;
                wasmSymbol = wasmSymbol2;
            } else {
                wasmSymbol = null;
            }
            WasmSymbolReadOnly wasmSymbolReadOnly = (WasmSymbolReadOnly)wasmSymbol;
            List list4 = list2;
            String string5 = string3;
            WasmStructDeclaration structType = new WasmStructDeclaration(string5, list4, wasmSymbolReadOnly);
            this.context.defineGcType(symbol2, (WasmTypeDeclaration)structType);
            this.context.generateTypeInfo(symbol2, this.binaryDataStruct(metadata));
        }
        for (IrDeclaration member2 : declaration.getDeclarations()) {
            IrVisitorsKt.acceptVoid((IrElement)((IrElement)member2), (IrElementVisitorVoid)this);
        }
    }

    private final ConstantDataStruct binaryDataStruct(ClassMetadata classMetadata) {
        ConstantDataIntField constantDataIntField;
        IrClass superClass;
        String string2;
        boolean fqnShouldBeEmitted = (Boolean)CommonConfigurationKeysKt.getLanguageVersionSettings(this.context.getBackendContext().getConfiguration()).getFlag(AnalysisFlags.getAllowFullyQualifiedNameInKClass());
        if (fqnShouldBeEmitted) {
            string2 = FqNamesUtilKt.parentOrNull((FqName)AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)classMetadata.getKlass())));
            if (string2 == null || (string2 = string2.asString()) == null) {
                string2 = "";
            }
        } else {
            string2 = "";
        }
        String packageName = string2;
        String string3 = AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)classMetadata.getKlass())).shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"classMetadata.klass.kotl\u2026me.shortName().asString()");
        String simpleName = string3;
        Object[] objectArray = new ConstantDataIntField[]{new ConstantDataIntField("TypePackageNameLength", packageName.length()), new ConstantDataIntField("TypePackageNamePtr", this.context.referenceStringLiteral(packageName)), new ConstantDataIntField("TypeNameLength", simpleName.length()), new ConstantDataIntField("TypeNamePtr", this.context.referenceStringLiteral(simpleName))};
        ConstantDataStruct typeInfo = new ConstantDataStruct("TypeInfo", CollectionsKt.listOf((Object[])objectArray));
        IrClass irClass = superClass = ClassInfoKt.getSuperClass(classMetadata.getKlass(), this.context.getBackendContext().getIrBuiltIns());
        if (irClass != null) {
            IrClass it = irClass;
            boolean bl = false;
            constantDataIntField = new ConstantDataIntField("SuperTypeId", this.context.referenceClassId(it.getSymbol()));
        } else {
            constantDataIntField = new ConstantDataIntField("SuperTypeId", -1);
        }
        ConstantDataIntField superTypeId = constantDataIntField;
        Object[] objectArray2 = new ConstantDataElement[]{typeInfo, superTypeId};
        List typeInfoContent = CollectionsKt.mutableListOf((Object[])objectArray2);
        if (!UtilsKt.isAbstractOrSealed(classMetadata.getKlass())) {
            typeInfoContent.add(this.interfaceTable(classMetadata));
        }
        return new ConstantDataStruct("Class TypeInfo: " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)classMetadata.getKlass())) + ' ', typeInfoContent);
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantDataStruct interfaceTable(ClassMetadata classMetadata) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<IrClass> interfaces = classMetadata.getInterfaces();
        ConstantDataIntField size = new ConstantDataIntField("size", interfaces.size());
        Object[] objectArray = (Object[])interfaces;
        String string2 = "interfaceIds";
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrClass irClass = (IrClass)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.context.referenceInterfaceId(it.getSymbol()));
        }
        List list2 = (List)destination$iv$iv;
        String string3 = string2;
        ConstantDataIntArray interfaceIds = new ConstantDataIntArray(string3, list2);
        objectArray = new ConstantDataElement[]{size, interfaceIds};
        return new ConstantDataStruct("Class interface table: " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)classMetadata.getKlass())) + ' ', CollectionsKt.listOf((Object[])objectArray));
    }

    public void visitField(@NotNull IrField declaration) {
        IrExpression initValue;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!declaration.isStatic()) {
            return;
        }
        WasmType wasmType = this.context.transformType(declaration.getType());
        List initBody = new ArrayList();
        WasmIrExpressionBuilder wasmExpressionGenerator = new WasmIrExpressionBuilder(initBody);
        IrExpressionBody irExpressionBody = declaration.getInitializer();
        Object object = initValue = irExpressionBody != null ? irExpressionBody.getExpression() : null;
        if (initValue != null) {
            if (!(initValue instanceof IrConst && !(((IrConst)initValue).getKind() instanceof IrConstKind.String) && !(((IrConst)initValue).getKind() instanceof IrConstKind.Null))) {
                boolean bl = false;
                String string2 = "Static field initializer should be non-string const or null";
                throw new IllegalStateException(string2.toString());
            }
            DeclarationGeneratorKt.generateConstExpression((IrConst)initValue, (WasmExpressionBuilder)wasmExpressionGenerator, this.context);
        } else {
            DeclarationGeneratorKt.generateDefaultInitializerForType(wasmType, (WasmExpressionBuilder)wasmExpressionGenerator);
        }
        WasmGlobal global = new WasmGlobal(String.valueOf(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration))), wasmType, true, initBody, null, 16, null);
        this.context.defineGlobalField(declaration.getSymbol(), global);
    }

    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElement((IrElementVisitorVoid)this, (IrElement)element, (Void)data);
    }

    public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration, (Void)data);
    }

    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration, (Void)data);
    }

    public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration, (Void)data);
    }

    public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration, (Void)data);
    }

    public void visitField(@NotNull IrField declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration, (Void)data);
    }

    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration);
    }

    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration, (Void)data);
    }

    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2);
    }

    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2, (Void)data);
    }

    public void visitBlockBody(@NotNull IrBlockBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body2);
    }

    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body2, (Void)data);
    }

    public void visitBody(@NotNull IrBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body2);
    }

    public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body2, (Void)data);
    }

    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch);
    }

    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch, (Void)data);
    }

    public void visitBreak(@NotNull IrBreak jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump);
    }

    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump, (Void)data);
    }

    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump);
    }

    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump, (Void)data);
    }

    public void visitCall(@NotNull IrCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression2);
    }

    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression2, (Void)data);
    }

    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2);
    }

    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2, (Void)data);
    }

    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch);
    }

    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch, (Void)data);
    }

    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2);
    }

    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2, (Void)data);
    }

    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2);
    }

    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2, (Void)data);
    }

    public void visitConst(@NotNull IrConst<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, expression2);
    }

    public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, expression2, (Void)data);
    }

    public void visitConstantArray(@NotNull IrConstantArray expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2);
    }

    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2, (Void)data);
    }

    public void visitConstantObject(@NotNull IrConstantObject expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2);
    }

    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2, (Void)data);
    }

    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2);
    }

    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2, (Void)data);
    }

    public void visitConstantValue(@NotNull IrConstantValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2);
    }

    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2, (Void)data);
    }

    public void visitConstructor(@NotNull IrConstructor declaration) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration);
    }

    public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration, (Void)data);
    }

    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression2);
    }

    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression2, (Void)data);
    }

    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression2);
    }

    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression2, (Void)data);
    }

    public void visitContinue(@NotNull IrContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump);
    }

    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump, (Void)data);
    }

    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration);
    }

    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration, (Void)data);
    }

    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2);
    }

    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2, (Void)data);
    }

    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression2);
    }

    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression2, (Void)data);
    }

    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop);
    }

    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop, (Void)data);
    }

    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2);
    }

    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2, (Void)data);
    }

    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2);
    }

    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2, (Void)data);
    }

    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2);
    }

    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2, (Void)data);
    }

    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch);
    }

    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch, (Void)data);
    }

    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2);
    }

    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2, (Void)data);
    }

    public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration);
    }

    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration, (Void)data);
    }

    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2);
    }

    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2, (Void)data);
    }

    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration);
    }

    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration, (Void)data);
    }

    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2);
    }

    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2, (Void)data);
    }

    public void visitExpression(@NotNull IrExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2);
    }

    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2, (Void)data);
    }

    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body2);
    }

    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body2, (Void)data);
    }

    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration);
    }

    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration, (Void)data);
    }

    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2);
    }

    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2, (Void)data);
    }

    public void visitFile(@NotNull IrFile declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration);
    }

    public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration, (Void)data);
    }

    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2);
    }

    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2, (Void)data);
    }

    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2);
    }

    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2, (Void)data);
    }

    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2);
    }

    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2, (Void)data);
    }

    public void visitGetClass(@NotNull IrGetClass expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2);
    }

    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2, (Void)data);
    }

    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2);
    }

    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2, (Void)data);
    }

    public void visitGetField(@NotNull IrGetField expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression2);
    }

    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression2, (Void)data);
    }

    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2);
    }

    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2, (Void)data);
    }

    public void visitGetValue(@NotNull IrGetValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression2);
    }

    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression2, (Void)data);
    }

    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2);
    }

    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2, (Void)data);
    }

    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration);
    }

    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration, (Void)data);
    }

    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2);
    }

    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2, (Void)data);
    }

    public void visitLoop(@NotNull IrLoop loop) {
        IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop);
    }

    public void visitLoop(@NotNull IrLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop, (Void)data);
    }

    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2);
    }

    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2, (Void)data);
    }

    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration);
    }

    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration, (Void)data);
    }

    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration);
    }

    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration, (Void)data);
    }

    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2);
    }

    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2, (Void)data);
    }

    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2);
    }

    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2, (Void)data);
    }

    public void visitReturn(@NotNull IrReturn expression2) {
        IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression2);
    }

    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression2, (Void)data);
    }

    public void visitScript(@NotNull IrScript declaration) {
        IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration);
    }

    public void visitScript(@NotNull IrScript declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration, (Void)data);
    }

    public void visitSetField(@NotNull IrSetField expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression2);
    }

    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression2, (Void)data);
    }

    public void visitSetValue(@NotNull IrSetValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression2);
    }

    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression2, (Void)data);
    }

    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration);
    }

    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration, (Void)data);
    }

    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2);
    }

    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2, (Void)data);
    }

    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread);
    }

    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread, (Void)data);
    }

    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2);
    }

    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2, (Void)data);
    }

    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2);
    }

    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2, (Void)data);
    }

    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2);
    }

    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2, (Void)data);
    }

    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body2);
    }

    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body2, (Void)data);
    }

    public void visitThrow(@NotNull IrThrow expression2) {
        IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression2);
    }

    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression2, (Void)data);
    }

    public void visitTry(@NotNull IrTry aTry) {
        IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry);
    }

    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry, (Void)data);
    }

    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression2);
    }

    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression2, (Void)data);
    }

    public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration);
    }

    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration, (Void)data);
    }

    public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2);
    }

    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2, (Void)data);
    }

    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration);
    }

    public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration, (Void)data);
    }

    public void visitVararg(@NotNull IrVararg expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression2);
    }

    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression2, (Void)data);
    }

    public void visitVariable(@NotNull IrVariable declaration) {
        IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration);
    }

    public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration, (Void)data);
    }

    public void visitWhen(@NotNull IrWhen expression2) {
        IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression2);
    }

    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression2, (Void)data);
    }

    public void visitWhileLoop(@NotNull IrWhileLoop loop) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop);
    }

    public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop, (Void)data);
    }

    public static final /* synthetic */ WasmBackendContext access$getBackendContext$p(DeclarationGenerator $this) {
        return $this.backendContext;
    }
}

