/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.SamEqualsHashCodeMethodsGenerator;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocator;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.FunctionReferenceLowering;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStaticAnnotationLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.VarargLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.indy.LambdaMetafactoryArguments;
import org.jetbrains.kotlin.backend.jvm.lower.indy.LambdaMetafactoryArgumentsBuilder;
import org.jetbrains.kotlin.backend.jvm.lower.indy.MetafactoryArgumentsResult;
import org.jetbrains.kotlin.backend.jvm.lower.indy.SamDelegatingLambdaBlock;
import org.jetbrains.kotlin.backend.jvm.lower.indy.SamDelegatingLambdaBuilder;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrTypeParameterBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrRawFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeParameterRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0002KLB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u001a\u0010%\u001a\u0004\u0018\u00010\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0015H\u0002J\"\u0010)\u001a\u0004\u0018\u00010\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u0015H\u0002J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001dH\u0016J\u0010\u0010-\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020'H\u0016J\u0010\u0010.\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010/\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u000200H\u0016J,\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u001d2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001b05H\u0002J \u00106\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u00107\u001a\u000208H\u0002J$\u00109\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u0002002\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001b05H\u0002J \u0010:\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010;\u001a\u00020<2\u0006\u00107\u001a\u000208H\u0002J\u0018\u0010=\u001a\u00020'2\u0006\u00102\u001a\u00020\u00192\u0006\u00107\u001a\u000208H\u0002J\u001c\u0010>\u001a\u00020\"*\u00020?2\u0006\u0010(\u001a\u00020\u00152\u0006\u0010&\u001a\u00020?H\u0002J\u0014\u0010@\u001a\u00020A*\u00020B2\u0006\u0010C\u001a\u00020DH\u0002J\u001a\u0010E\u001a\u00020F*\u00020B2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020D0HH\u0002J\f\u0010I\u001a\u00020\u000b*\u00020DH\u0002J\f\u0010J\u001a\u00020\u000b*\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\u00020\u000b*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "crossinlineLambdas", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lkotlin/collections/HashSet;", "isJavaSamConversionWithEqualsHashCode", "", "jvmIndyLambdaMetafactoryIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "shouldGenerateIndyLambdas", "shouldGenerateIndySamConversions", "specialNullabilityAnnotationsFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.jvm.PlatformType", "isIgnored", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;)Z", "canGenerateIndySamConversionOnFunctionalExpression", "samSuperType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "createProxyLocalFunctionForIndySamConversion", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "reference", "getDeclarationParentForDelegatingLambda", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "rewriteDirectInvokeToFunctionReference", "irInvokeCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "irFunRef", "rewriteDirectInvokeToLambda", "irBlock", "lastFunRef", "visitBlock", "visitCall", "visitFunctionReference", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "wrapFunctionReferenceInsideBlockWithIndySamConversion", "samType", "block", "produceSamConversion", "Lkotlin/Function1;", "wrapLambdaReferenceWithIndySamConversion", "lambdaMetafactoryArguments", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArguments;", "wrapSamConversionArgumentWithIndySamConversion", "wrapSamDelegatingLambdaWithIndySamConversion", "lambdaBlock", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/SamDelegatingLambdaBlock;", "wrapWithIndySamConversion", "copyReceiverAndValueArgumentsForDirectInvoke", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "irRawFunctionRef", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrRawFunctionReferenceImpl;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "irFun", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "irVarargOfRawFunctionRefs", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrVarargImpl;", "irFuns", "", "isInvokeOperator", "isSuspendFunctionReference", "Companion", "FunctionReferenceBuilder", "backend.jvm.lower"})
public final class FunctionReferenceLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final HashSet<IrSimpleFunction> crossinlineLambdas;
    private final boolean shouldGenerateIndySamConversions;
    private final boolean shouldGenerateIndyLambdas;
    private final boolean isJavaSamConversionWithEqualsHashCode;
    @NotNull
    private final IrSimpleFunctionSymbol jvmIndyLambdaMetafactoryIntrinsic;
    @NotNull
    private final Set<FqName> specialNullabilityAnnotationsFqNames;

    public FunctionReferenceLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.crossinlineLambdas = new HashSet();
        this.shouldGenerateIndySamConversions = this.context.getState().getSamConversionsScheme() == JvmClosureGenerationScheme.INDY;
        this.shouldGenerateIndyLambdas = this.context.getState().getLambdasScheme() == JvmClosureGenerationScheme.INDY;
        this.isJavaSamConversionWithEqualsHashCode = this.context.getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.JavaSamConversionEqualsHashCode);
        this.jvmIndyLambdaMetafactoryIntrinsic = this.context.getIr().getSymbols().getIndyLambdaMetafactoryIntrinsic();
        Object[] objectArray = new FqName[]{JvmSymbols.Companion.getFLEXIBLE_NULLABILITY_ANNOTATION_FQ_NAME(), JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION};
        this.specialNullabilityAnnotationsFqNames = SetsKt.setOf((Object[])objectArray);
    }

    private final boolean isIgnored(IrFunctionReference $this$isIgnored) {
        return !IrTypeUtilsKt.isFunctionOrKFunction((IrType)$this$isIgnored.getType()) && !this.isSuspendFunctionReference($this$isIgnored) || Intrinsics.areEqual((Object)$this$isIgnored.getOrigin(), (Object)((Object)JvmLoweredStatementOrigin.INLINE_LAMBDA.INSTANCE));
    }

    private final boolean isSuspendFunctionReference(IrFunctionReference $this$isSuspendFunctionReference) {
        return IrUtilsKt.isSuspend((IrFunctionReference)$this$isSuspendFunctionReference) && ($this$isSuspendFunctionReference.getOrigin() == null || Intrinsics.areEqual((Object)$this$isSuspendFunctionReference.getOrigin(), (Object)IrStatementOrigin.ADAPTED_FUNCTION_REFERENCE.INSTANCE) || Intrinsics.areEqual((Object)$this$isSuspendFunctionReference.getOrigin(), (Object)IrStatementOrigin.SUSPEND_CONVERSION.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    public void lower(@NotNull IrFile irFile) {
        void $this$findInlineLambdas$iv;
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrFile irFile2 = irFile;
        JvmBackendContext context$iv = this.context;
        boolean $i$f$findInlineLambdas = false;
        $this$findInlineLambdas$iv.accept((IrElementVisitor)new IrInlineReferenceLocator(context$iv, this){
            final /* synthetic */ FunctionReferenceLowering this$0;
            {
                this.this$0 = functionReferenceLowering;
                super($context);
            }

            /*
             * WARNING - void declaration
             */
            public void visitInlineLambda(@NotNull IrFunctionReference argument2, @NotNull IrFunction callee, @NotNull IrValueParameter parameter, @NotNull IrDeclaration scope) {
                void parameter2;
                Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
                Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                IrValueParameter irValueParameter = parameter;
                IrFunctionReference argument3 = argument2;
                boolean bl = false;
                if (parameter2.isCrossinline()) {
                    HashSet hashSet = FunctionReferenceLowering.access$getCrossinlineLambdas$p(this.this$0);
                    IrFunction irFunction = ((IrFunctionSymbol)argument3.getSymbol()).getOwner();
                    Intrinsics.checkNotNull((Object)irFunction, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
                    hashSet.add((IrSimpleFunction)irFunction);
                }
            }
        }, null);
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        this.crossinlineLambdas.clear();
    }

    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        MetafactoryArgumentsResult lambdaMetafactoryArguments;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!IrUtilsKt.isLambda((IrStatementOrigin)expression2.getOrigin())) {
            return super.visitBlock(expression2);
        }
        Object object = CollectionsKt.last((List)expression2.getStatements());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
        IrFunctionReference reference = (IrFunctionReference)object;
        if (this.isIgnored(reference)) {
            return super.visitBlock(expression2);
        }
        Iterable $this$forEach$iv = CollectionsKt.dropLast((List)expression2.getStatements(), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement it = (IrStatement)element$iv;
            boolean bl = false;
            it.transform((IrElementTransformer)this, null);
        }
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)reference), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        if (this.shouldGenerateIndyLambdas && (lambdaMetafactoryArguments = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArguments(reference, reference.getType(), true)) instanceof LambdaMetafactoryArguments) {
            return (IrExpression)this.wrapLambdaReferenceWithIndySamConversion(expression2, reference, (LambdaMetafactoryArguments)lambdaMetafactoryArguments);
        }
        return new FunctionReferenceBuilder(this, reference, null, 2, null).build();
    }

    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (this.isInvokeOperator(expression2.getSymbol().getOwner())) {
            IrExpression irExpression;
            IrStatement last;
            IrExpression receiver = expression2.getDispatchReceiver();
            if (receiver instanceof IrFunctionReference) {
                IrExpression irExpression2 = this.rewriteDirectInvokeToFunctionReference(expression2, (IrFunctionReference)receiver);
                if (irExpression2 != null) {
                    IrExpression it = irExpression2;
                    boolean bl = false;
                    this.transformChildrenVoid((IrElement)it);
                    return it;
                }
            } else if (receiver instanceof IrBlock && (last = (IrStatement)CollectionsKt.last((List)((IrBlock)receiver).getStatements())) instanceof IrFunctionReference && (irExpression = this.rewriteDirectInvokeToLambda(expression2, (IrBlock)receiver, (IrFunctionReference)last)) != null) {
                IrExpression it = irExpression;
                boolean bl = false;
                this.transformChildrenVoid((IrElement)it);
                return it;
            }
        }
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        return (IrExpression)expression2;
    }

    private final boolean isInvokeOperator(IrFunction $this$isInvokeOperator) {
        return Intrinsics.areEqual((Object)$this$isInvokeOperator.getName(), (Object)OperatorNameConventions.INVOKE);
    }

    private final IrExpression rewriteDirectInvokeToLambda(IrCall irInvokeCall, IrBlock irBlock, IrFunctionReference lastFunRef) {
        boolean bl;
        IrFunction callee;
        block5: {
            callee = ((IrFunctionSymbol)lastFunRef.getSymbol()).getOwner();
            if (!Intrinsics.areEqual((Object)callee.getOrigin(), (Object)IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE) && !AdditionalIrUtilsKt.isAnonymousFunction((IrDeclaration)((IrDeclaration)callee))) {
                return null;
            }
            Sequence $this$any$iv = LocalDeclarationsLoweringKt.getParents((IrDeclaration)((IrDeclaration)callee));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                IrDeclarationParent it = (IrDeclarationParent)element$iv;
                boolean bl2 = false;
                if (!(it instanceof IrSimpleFunction && ((IrSimpleFunction)it).isInline())) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        if (bl) {
            return null;
        }
        IrExpression irExpression = this.rewriteDirectInvokeToFunctionReference(irInvokeCall, lastFunRef);
        if (irExpression == null) {
            return null;
        }
        IrExpression irDirectCall = irExpression;
        if (callee instanceof IrFunctionImpl) {
            this.context.getDirectInvokedLambdas().add(((IrFunctionImpl)callee).getAttributeOwnerId());
        }
        IrBlockImpl newBlock = new IrBlockImpl(irBlock.getStartOffset(), irBlock.getEndOffset(), irDirectCall.getType(), null, 8, null);
        newBlock.getStatements().addAll(irBlock.getStatements());
        newBlock.getStatements().set(CollectionsKt.getLastIndex((List)newBlock.getStatements()), irDirectCall);
        return (IrExpression)newBlock;
    }

    private final IrExpression rewriteDirectInvokeToFunctionReference(IrCall irInvokeCall, IrFunctionReference irFunRef) {
        IrExpression irExpression;
        IrFunction irFun = ((IrFunctionSymbol)irFunRef.getSymbol()).getOwner();
        if (irFun instanceof IrSimpleFunction) {
            IrCallImpl irCallImpl;
            if (!((Collection)irFun.getTypeParameters()).isEmpty()) {
                return null;
            }
            IrCallImpl $this$rewriteDirectInvokeToFunctionReference_u24lambda_u245 = irCallImpl = new IrCallImpl(irInvokeCall.getStartOffset(), irInvokeCall.getEndOffset(), irInvokeCall.getType(), ((IrSimpleFunction)irFun).getSymbol(), irFun.getTypeParameters().size(), irFun.getValueParameters().size(), null, null, 192, null);
            boolean bl = false;
            this.copyReceiverAndValueArgumentsForDirectInvoke((IrFunctionAccessExpression)$this$rewriteDirectInvokeToFunctionReference_u24lambda_u245, irFunRef, (IrFunctionAccessExpression)irInvokeCall);
            irExpression = (IrExpression)irCallImpl;
        } else if (irFun instanceof IrConstructor) {
            IrConstructorCallImpl irConstructorCallImpl;
            IrConstructorCallImpl $this$rewriteDirectInvokeToFunctionReference_u24lambda_u246 = irConstructorCallImpl = new IrConstructorCallImpl(irInvokeCall.getStartOffset(), irInvokeCall.getEndOffset(), irInvokeCall.getType(), ((IrConstructor)irFun).getSymbol(), irFun.getTypeParameters().size(), 0, irFun.getValueParameters().size(), null, null, 384, null);
            boolean bl = false;
            this.copyReceiverAndValueArgumentsForDirectInvoke((IrFunctionAccessExpression)$this$rewriteDirectInvokeToFunctionReference_u24lambda_u246, irFunRef, (IrFunctionAccessExpression)irInvokeCall);
            irExpression = (IrExpression)irConstructorCallImpl;
        } else {
            throw new AssertionError((Object)("Simple function or constructor expected: " + RenderIrElementKt.render((IrElement)((IrElement)irFun))));
        }
        return irExpression;
    }

    private final void copyReceiverAndValueArgumentsForDirectInvoke(IrFunctionAccessExpression $this$copyReceiverAndValueArgumentsForDirectInvoke, IrFunctionReference irFunRef, IrFunctionAccessExpression irInvokeCall) {
        IrFunction irFun = ((IrFunctionSymbol)irFunRef.getSymbol()).getOwner();
        int invokeArgIndex = 0;
        if (irFun.getDispatchReceiverParameter() != null) {
            IrExpression irExpression = irFunRef.getDispatchReceiver();
            if (irExpression == null) {
                irExpression = irInvokeCall.getValueArgument(invokeArgIndex++);
            }
            $this$copyReceiverAndValueArgumentsForDirectInvoke.setDispatchReceiver(irExpression);
        }
        if (irFun.getExtensionReceiverParameter() != null) {
            IrExpression irExpression = irFunRef.getExtensionReceiver();
            if (irExpression == null) {
                irExpression = irInvokeCall.getValueArgument(invokeArgIndex++);
            }
            $this$copyReceiverAndValueArgumentsForDirectInvoke.setExtensionReceiver(irExpression);
        }
        if (invokeArgIndex + $this$copyReceiverAndValueArgumentsForDirectInvoke.getValueArgumentsCount() != irInvokeCall.getValueArgumentsCount()) {
            throw new AssertionError((Object)("Mismatching value arguments: " + invokeArgIndex + " arguments used for receivers\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)irInvokeCall), (boolean)false, (boolean)false, (int)3, null)));
        }
        int n = $this$copyReceiverAndValueArgumentsForDirectInvoke.getValueArgumentsCount();
        for (int i = 0; i < n; ++i) {
            $this$copyReceiverAndValueArgumentsForDirectInvoke.putValueArgument(i, irInvokeCall.getValueArgument(invokeArgIndex++));
        }
    }

    private final IrBlock wrapLambdaReferenceWithIndySamConversion(IrBlock expression2, IrFunctionReference reference, LambdaMetafactoryArguments lambdaMetafactoryArguments) {
        IrCall indySamConversion = this.wrapWithIndySamConversion(reference.getType(), lambdaMetafactoryArguments);
        expression2.getStatements().set(expression2.getStatements().size() - 1, indySamConversion);
        expression2.setType(indySamConversion.getType());
        return expression2;
    }

    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        return this.isIgnored(expression2) ? (IrExpression)expression2 : new FunctionReferenceBuilder(this, expression2, null, 2, null).build();
    }

    private final IrDeclarationParent getDeclarationParentForDelegatingLambda() {
        for (ScopeWithIr s : CollectionsKt.asReversedMutable((List)this.getAllScopes())) {
            IrSymbolOwner scopeOwner = s.getScope().getScopeOwnerSymbol().getOwner();
            if (!(scopeOwner instanceof IrDeclarationParent)) continue;
            return (IrDeclarationParent)scopeOwner;
        }
        throw new AssertionError((Object)("No IrDeclarationParent found in scopes:\n" + CollectionsKt.joinToString$default((Iterable)this.getAllScopes(), (CharSequence)"\n", null, null, (int)0, null, (Function1)getDeclarationParentForDelegatingLambda.1.INSTANCE, (int)30, null)));
    }

    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrFunctionReference irFunctionReference;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2.getOperator() != IrTypeOperator.SAM_CONVERSION) {
            return super.visitTypeOperator(expression2);
        }
        IrType samSuperType = expression2.getTypeOperand();
        IrExpression invokable = expression2.getArgument();
        if (invokable instanceof IrFunctionReference) {
            irFunctionReference = (IrFunctionReference)invokable;
        } else if (invokable instanceof IrBlock && IrUtilsKt.isLambda((IrStatementOrigin)((IrBlock)invokable).getOrigin()) && CollectionsKt.last((List)((IrBlock)invokable).getStatements()) instanceof IrFunctionReference) {
            Iterable $this$forEach$iv = CollectionsKt.dropLast((List)((IrBlock)invokable).getStatements(), (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrStatement it = (IrStatement)element$iv;
                boolean bl = false;
                it.transform((IrElementTransformer)this, null);
            }
            Object object = CollectionsKt.last((List)((IrBlock)invokable).getStatements());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
            irFunctionReference = (IrFunctionReference)object;
        } else {
            if (this.shouldGenerateIndySamConversions && this.canGenerateIndySamConversionOnFunctionalExpression(samSuperType, invokable)) {
                SamDelegatingLambdaBuilder samDelegatingLambdaBuilder = new SamDelegatingLambdaBuilder(this.context);
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                SamDelegatingLambdaBlock lambdaBlock = samDelegatingLambdaBuilder.build(invokable, samSuperType, scopeWithIr.getScope().getScopeOwnerSymbol(), this.getDeclarationParentForDelegatingLambda());
                MetafactoryArgumentsResult lambdaMetafactoryArguments = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArguments(lambdaBlock.getRef(), samSuperType, false);
                if (!(lambdaMetafactoryArguments instanceof LambdaMetafactoryArguments)) {
                    return super.visitTypeOperator(expression2);
                }
                this.transformChildrenVoid((IrElement)invokable);
                return this.wrapSamDelegatingLambdaWithIndySamConversion(samSuperType, lambdaBlock, (LambdaMetafactoryArguments)lambdaMetafactoryArguments);
            }
            return super.visitTypeOperator(expression2);
        }
        IrFunctionReference reference = irFunctionReference;
        this.transformChildrenVoid((IrElement)reference);
        if (this.shouldGenerateIndySamConversions) {
            MetafactoryArgumentsResult lambdaMetafactoryArguments = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArguments(reference, samSuperType, false);
            if (lambdaMetafactoryArguments instanceof LambdaMetafactoryArguments) {
                return this.wrapSamConversionArgumentWithIndySamConversion(expression2, (Function1<? super IrType, ? extends IrExpression>)((Function1)new Function1<IrType, IrExpression>(this, lambdaMetafactoryArguments){
                    final /* synthetic */ FunctionReferenceLowering this$0;
                    final /* synthetic */ MetafactoryArgumentsResult $lambdaMetafactoryArguments;
                    {
                        this.this$0 = $receiver;
                        this.$lambdaMetafactoryArguments = $lambdaMetafactoryArguments;
                        super(1);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull IrType samType) {
                        Intrinsics.checkNotNullParameter((Object)samType, (String)"samType");
                        return (IrExpression)FunctionReferenceLowering.access$wrapWithIndySamConversion(this.this$0, samType, (LambdaMetafactoryArguments)this.$lambdaMetafactoryArguments);
                    }
                }));
            }
            if (lambdaMetafactoryArguments instanceof MetafactoryArgumentsResult.Failure.FunctionHazard) {
                IrBlock proxyLocalFunBlock = this.createProxyLocalFunctionForIndySamConversion(reference);
                Object e = proxyLocalFunBlock.getStatements().get(proxyLocalFunBlock.getStatements().size() - 1);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
                IrFunctionReference proxyLocalFunRef = (IrFunctionReference)e;
                MetafactoryArgumentsResult proxyLambdaMetafactoryArguments = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArguments(proxyLocalFunRef, samSuperType, false);
                if (proxyLambdaMetafactoryArguments instanceof LambdaMetafactoryArguments) {
                    return this.wrapSamConversionArgumentWithIndySamConversion(expression2, (Function1<? super IrType, ? extends IrExpression>)((Function1)new Function1<IrType, IrExpression>(proxyLocalFunBlock, this, proxyLambdaMetafactoryArguments){
                        final /* synthetic */ IrBlock $proxyLocalFunBlock;
                        final /* synthetic */ FunctionReferenceLowering this$0;
                        final /* synthetic */ MetafactoryArgumentsResult $proxyLambdaMetafactoryArguments;
                        {
                            this.$proxyLocalFunBlock = $proxyLocalFunBlock;
                            this.this$0 = $receiver;
                            this.$proxyLambdaMetafactoryArguments = $proxyLambdaMetafactoryArguments;
                            super(1);
                        }

                        @NotNull
                        public final IrExpression invoke(@NotNull IrType samType) {
                            Intrinsics.checkNotNullParameter((Object)samType, (String)"samType");
                            this.$proxyLocalFunBlock.getStatements().set(this.$proxyLocalFunBlock.getStatements().size() - 1, FunctionReferenceLowering.access$wrapWithIndySamConversion(this.this$0, samType, (LambdaMetafactoryArguments)this.$proxyLambdaMetafactoryArguments));
                            this.$proxyLocalFunBlock.setType(samType);
                            return (IrExpression)this.$proxyLocalFunBlock;
                        }
                    }));
                }
            }
        }
        IrType erasedSamSuperType = JvmIrUtilsKt.rawType(JvmIrTypeUtilsKt.getErasedUpperBound(samSuperType), this.context);
        return new FunctionReferenceBuilder(this, reference, erasedSamSuperType).build();
    }

    private final IrBlock createProxyLocalFunctionForIndySamConversion(IrFunctionReference reference) {
        IrBlockBodyImpl irBlockBodyImpl;
        IrFunctionAccessExpression irFunctionAccessExpression;
        int startOffset = reference.getStartOffset();
        int endOffset = reference.getEndOffset();
        IrFunction targetFun = ((IrFunctionSymbol)reference.getSymbol()).getOwner();
        ArrayList<IrVariable> temporaryVals = new ArrayList<IrVariable>();
        IrFunction irFunction = targetFun;
        if (irFunction instanceof IrSimpleFunction) {
            irFunctionAccessExpression = (IrFunctionAccessExpression)IrCallImpl.Companion.fromSymbolOwner(startOffset, endOffset, ((IrSimpleFunction)targetFun).getSymbol());
        } else if (irFunction instanceof IrConstructor) {
            irFunctionAccessExpression = (IrFunctionAccessExpression)IrConstructorCallImpl.Companion.fromSymbolOwner$default((IrConstructorCallImpl.Companion)IrConstructorCallImpl.Companion, (int)startOffset, (int)endOffset, (IrType)targetFun.getReturnType(), (IrConstructorSymbol)((IrConstructor)targetFun).getSymbol(), null, (int)16, null);
        } else {
            throw new AssertionError((Object)("Unexpected callable reference target: " + RenderIrElementKt.render((IrElement)((IrElement)targetFun))));
        }
        IrFunctionAccessExpression targetCall = irFunctionAccessExpression;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2418$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u248 = $this$buildFun_u24lambda_u2418$iv;
        boolean $i$a$-buildFun-FunctionReferenceLowering$createProxyLocalFunctionForIndySamConversion$proxyFun$22 = false;
        Name name = Name.identifier((String)(targetFun.getName().asString() + "__proxy"));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"${targetFun.name.asString()}__proxy\")");
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u248.setName(name);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u248.setReturnType(JvmIrTypeUtilsKt.eraseTypeParameters(targetFun.getReturnType()));
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"LOCAL");
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u248.setVisibility(descriptorVisibility);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u248.setModality(Modality.FINAL);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u248.setSuspend(false);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u248.setInline(false);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u248.setOrigin(targetFun.isInline() || VarargLoweringKt.isArrayOf(targetFun) ? (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.PROXY_FUN_FOR_METAFACTORY.INSTANCE : (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.SYNTHETIC_PROXY_FUN_FOR_METAFACTORY.INSTANCE);
        IrFactory proxyFun = $this$buildFun$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2418$iv);
        boolean bl2 = false;
        IrDeclarationParent irDeclarationParent = this.getCurrentDeclarationParent();
        if (irDeclarationParent == null) {
            throw new AssertionError((Object)("No declaration parent when processing " + reference));
        }
        proxyFun.setParent(irDeclarationParent);
        Ref.IntRef temporaryValIndex = new Ref.IntRef();
        Ref.IntRef proxyParameterIndex = new Ref.IntRef();
        targetCall.setDispatchReceiver(FunctionReferenceLowering.createProxyLocalFunctionForIndySamConversion$lambda$12$getTargetCallArgument(startOffset, endOffset, temporaryValIndex, (IrSimpleFunction)proxyFun, temporaryVals, proxyParameterIndex, reference.getDispatchReceiver(), targetFun.getDispatchReceiverParameter()));
        targetCall.setExtensionReceiver(FunctionReferenceLowering.createProxyLocalFunctionForIndySamConversion$lambda$12$getTargetCallArgument(startOffset, endOffset, temporaryValIndex, (IrSimpleFunction)proxyFun, temporaryVals, proxyParameterIndex, reference.getExtensionReceiver(), targetFun.getExtensionReceiverParameter()));
        Iterator $i$a$-buildFun-FunctionReferenceLowering$createProxyLocalFunctionForIndySamConversion$proxyFun$22 = targetFun.getValueParameters().iterator();
        int n = 0;
        while ($i$a$-buildFun-FunctionReferenceLowering$createProxyLocalFunctionForIndySamConversion$proxyFun$22.hasNext()) {
            int valueParameterIndex = n++;
            IrValueParameter valueParameter2 = (IrValueParameter)$i$a$-buildFun-FunctionReferenceLowering$createProxyLocalFunctionForIndySamConversion$proxyFun$22.next();
            targetCall.putValueArgument(valueParameterIndex, FunctionReferenceLowering.createProxyLocalFunctionForIndySamConversion$lambda$12$getTargetCallArgument(startOffset, endOffset, temporaryValIndex, (IrSimpleFunction)proxyFun, temporaryVals, proxyParameterIndex, reference.getValueArgument(valueParameterIndex), valueParameter2));
        }
        n = targetFun.getTypeParameters().size();
        for (int typeParameterIndex = 0; typeParameterIndex < n; ++typeParameterIndex) {
            targetCall.putTypeArgument(typeParameterIndex, reference.getTypeArgument(typeParameterIndex));
        }
        IrBlockBodyImpl it = irBlockBodyImpl = new IrBlockBodyImpl(startOffset, endOffset);
        boolean bl3 = false;
        proxyFun.setBody((IrBody)it);
        IrBlockBodyImpl proxyFunBody = irBlockBodyImpl;
        if (IrTypePredicatesKt.isUnit((IrType)targetFun.getReturnType())) {
            proxyFunBody.getStatements().add(targetCall);
        } else {
            proxyFunBody.getStatements().add(new IrReturnImpl(startOffset, endOffset, this.context.getIrBuiltIns().getNothingType(), (IrReturnTargetSymbol)proxyFun.getSymbol(), (IrExpression)targetCall));
        }
        IrFactory proxyFun2 = $this$buildFun$iv;
        IrFunctionReferenceImpl proxyFunRef = new IrFunctionReferenceImpl(startOffset, endOffset, reference.getType(), (IrFunctionSymbol)proxyFun2.getSymbol(), 0, proxyFun2.getValueParameters().size(), null, null, 192, null);
        return (IrBlock)new IrBlockImpl(startOffset, endOffset, reference.getType(), null, CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)temporaryVals, (Object)proxyFun2), (Object)proxyFunRef));
    }

    private final boolean canGenerateIndySamConversionOnFunctionalExpression(IrType samSuperType, IrExpression expression2) {
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)samSuperType);
        if (irClassSymbol == null) {
            throw new AssertionError((Object)("Class type expected: " + RenderIrElementKt.render((IrType)samSuperType)));
        }
        IrClassSymbol samClass = irClassSymbol;
        if (!IrUtilsKt.isFromJava((IrDeclaration)((IrDeclaration)samClass.getOwner())) || this.isJavaSamConversionWithEqualsHashCode) {
            return false;
        }
        return !(expression2 instanceof IrBlock) || !Intrinsics.areEqual((Object)((IrBlock)expression2).getOrigin(), (Object)IrStatementOrigin.ADAPTED_FUNCTION_REFERENCE.INSTANCE);
    }

    private final IrExpression wrapSamDelegatingLambdaWithIndySamConversion(IrType samSuperType, SamDelegatingLambdaBlock lambdaBlock, LambdaMetafactoryArguments lambdaMetafactoryArguments) {
        IrCall indySamConversion = this.wrapWithIndySamConversion(samSuperType, lambdaMetafactoryArguments);
        lambdaBlock.replaceRefWith((IrExpression)indySamConversion);
        return (IrExpression)lambdaBlock.getBlock();
    }

    private final IrExpression wrapSamConversionArgumentWithIndySamConversion(IrTypeOperatorCall expression2, Function1<? super IrType, ? extends IrExpression> produceSamConversion) {
        IrExpression irExpression;
        IrType samType = expression2.getTypeOperand();
        IrExpression argument2 = expression2.getArgument();
        if (argument2 instanceof IrFunctionReference) {
            irExpression = (IrExpression)produceSamConversion.invoke((Object)samType);
        } else if (argument2 instanceof IrBlock) {
            irExpression = this.wrapFunctionReferenceInsideBlockWithIndySamConversion(samType, (IrBlock)argument2, produceSamConversion);
        } else {
            throw new AssertionError((Object)("Block or function reference expected: " + RenderIrElementKt.render((IrElement)((IrElement)expression2))));
        }
        return irExpression;
    }

    private final IrExpression wrapFunctionReferenceInsideBlockWithIndySamConversion(IrType samType, IrBlock block, Function1<? super IrType, ? extends IrExpression> produceSamConversion) {
        IrExpression indySamConversion = (IrExpression)produceSamConversion.invoke((Object)samType);
        block.getStatements().set(block.getStatements().size() - 1, indySamConversion);
        block.setType(indySamConversion.getType());
        return (IrExpression)block;
    }

    private final IrCall wrapWithIndySamConversion(IrType samType, LambdaMetafactoryArguments lambdaMetafactoryArguments) {
        IrCall irCall;
        IrType notNullSamType2 = IrTypesKt.removeAnnotations((IrType)IrTypesKt.makeNotNull((IrType)samType), (Function1)((Function1)new Function1<IrConstructorCall, Boolean>(this){
            final /* synthetic */ FunctionReferenceLowering this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IrConstructorCall it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FunctionReferenceLowering.access$getSpecialNullabilityAnnotationsFqNames$p(this.this$0).contains(IrTypesKt.getClassFqName((IrType)it.getType()));
            }
        }));
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        JvmIrBuilder $this$wrapWithIndySamConversion_u24lambda_u2414 = JvmIrBuilderKt.createJvmIrBuilder(this.context, scopeWithIr);
        boolean bl = false;
        IrCall $this$wrapWithIndySamConversion_u24lambda_u2414_u24lambda_u2413 = irCall = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)$this$wrapWithIndySamConversion_u24lambda_u2414, (IrSimpleFunctionSymbol)this.jvmIndyLambdaMetafactoryIntrinsic, (IrType)notNullSamType2, (int)0, (int)0, null, (int)28, null);
        boolean bl2 = false;
        $this$wrapWithIndySamConversion_u24lambda_u2414_u24lambda_u2413.putTypeArgument(0, notNullSamType2);
        $this$wrapWithIndySamConversion_u24lambda_u2414_u24lambda_u2413.putValueArgument(0, (IrExpression)this.irRawFunctionRef($this$wrapWithIndySamConversion_u24lambda_u2414, (IrFunction)lambdaMetafactoryArguments.getSamMethod()));
        $this$wrapWithIndySamConversion_u24lambda_u2414_u24lambda_u2413.putValueArgument(1, (IrExpression)lambdaMetafactoryArguments.getImplMethodReference());
        $this$wrapWithIndySamConversion_u24lambda_u2414_u24lambda_u2413.putValueArgument(2, (IrExpression)this.irRawFunctionRef($this$wrapWithIndySamConversion_u24lambda_u2414, (IrFunction)lambdaMetafactoryArguments.getFakeInstanceMethod()));
        $this$wrapWithIndySamConversion_u24lambda_u2414_u24lambda_u2413.putValueArgument(3, (IrExpression)this.irVarargOfRawFunctionRefs($this$wrapWithIndySamConversion_u24lambda_u2414, lambdaMetafactoryArguments.getExtraOverriddenMethods()));
        $this$wrapWithIndySamConversion_u24lambda_u2414_u24lambda_u2413.putValueArgument(4, (IrExpression)ExpressionHelpersKt.irBoolean((IrBuilderWithScope)$this$wrapWithIndySamConversion_u24lambda_u2414, (boolean)lambdaMetafactoryArguments.getShouldBeSerializable()));
        return irCall;
    }

    private final IrRawFunctionReferenceImpl irRawFunctionRef(IrBuilderWithScope $this$irRawFunctionRef, IrFunction irFun) {
        return ExpressionHelpersKt.irRawFunctionReferefence((IrBuilderWithScope)$this$irRawFunctionRef, (IrType)$this$irRawFunctionRef.getContext().getIrBuiltIns().getAnyType(), (IrFunctionSymbol)irFun.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrVarargImpl irVarargOfRawFunctionRefs(IrBuilderWithScope $this$irVarargOfRawFunctionRefs, List<? extends IrFunction> irFuns) {
        Collection<IrRawFunctionReferenceImpl> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = irFuns;
        IrType irType = $this$irVarargOfRawFunctionRefs.getContext().getIrBuiltIns().getAnyType();
        IrBuilderWithScope irBuilderWithScope = $this$irVarargOfRawFunctionRefs;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrFunction irFunction = (IrFunction)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.irRawFunctionRef($this$irVarargOfRawFunctionRefs, (IrFunction)it));
        }
        collection = (List)destination$iv$iv;
        return ExpressionHelpersKt.irVararg((IrBuilderWithScope)irBuilderWithScope, (IrType)irType, (List)collection);
    }

    private static final IrGetValue createProxyLocalFunctionForIndySamConversion$lambda$12$addAndGetTemporaryVal(int startOffset, int endOffset, Ref.IntRef temporaryValIndex, IrSimpleFunction $proxyFun, ArrayList<IrVariable> temporaryVals, IrExpression initializer) {
        IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE;
        IrVariableSymbol irVariableSymbol = (IrVariableSymbol)new IrVariableSymbolImpl(null, 1, null);
        int n = temporaryValIndex.element;
        temporaryValIndex.element = n + 1;
        Name name = Name.identifier((String)("tmp_proxy_" + n));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"tmp_proxy_${temporaryValIndex++}\")");
        IrVariableImpl tmpVal = new IrVariableImpl(startOffset, endOffset, irDeclarationOrigin, irVariableSymbol, name, initializer.getType(), false, false, false);
        tmpVal.setInitializer(initializer);
        tmpVal.setParent($proxyFun.getParent());
        temporaryVals.add((IrVariable)tmpVal);
        return (IrGetValue)new IrGetValueImpl(startOffset, endOffset, (IrValueSymbol)tmpVal.getSymbol(), null, 8, null);
    }

    private static final IrGetValue createProxyLocalFunctionForIndySamConversion$lambda$12$addAndGetProxyValueParameter(IrSimpleFunction $proxyFun, int startOffset, int endOffset, Ref.IntRef proxyParameterIndex, IrValueParameter originalParameter) {
        IrValueParameter irValueParameter;
        boolean $i$f$buildValueParameter = false;
        IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2428$iv = new IrValueParameterBuilder();
        boolean bl = false;
        IrValueParameterBuilder $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u2412_u24addAndGetProxyValueParameter_u24lambda_u249 = $this$buildValueParameter_u24lambda_u2428$iv;
        boolean bl2 = false;
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u2412_u24addAndGetProxyValueParameter_u24lambda_u249.updateFrom(originalParameter);
        Name name = Name.identifier((String)("" + 'p' + proxyParameterIndex.element + '$' + originalParameter.getName().asString()));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"p$proxyParam\u2026ameter.name.asString()}\")");
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u2412_u24addAndGetProxyValueParameter_u24lambda_u249.setName(name);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u2412_u24addAndGetProxyValueParameter_u24lambda_u249.setIndex(proxyParameterIndex.element);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u2412_u24addAndGetProxyValueParameter_u24lambda_u249.setType(JvmIrTypeUtilsKt.eraseTypeParameters(originalParameter.getType()));
        int n = proxyParameterIndex.element;
        proxyParameterIndex.element = n + 1;
        IrValueParameter $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u2412_u24addAndGetProxyValueParameter_u24lambda_u2410 = irValueParameter = DeclarationBuildersKt.buildValueParameter((IrFactory)((IrDeclaration)$proxyFun).getFactory(), (IrValueParameterBuilder)$this$buildValueParameter_u24lambda_u2428$iv, (IrDeclarationParent)((IrDeclarationParent)((IrDeclaration)$proxyFun)));
        boolean bl3 = false;
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u2412_u24addAndGetProxyValueParameter_u24lambda_u2410.setParent((IrDeclarationParent)$proxyFun);
        IrValueParameter proxyParameter = irValueParameter;
        $proxyFun.setValueParameters(CollectionsKt.plus((Collection)$proxyFun.getValueParameters(), (Object)proxyParameter));
        return (IrGetValue)new IrGetValueImpl(startOffset, endOffset, (IrValueSymbol)proxyParameter.getSymbol(), null, 8, null);
    }

    private static final IrExpression createProxyLocalFunctionForIndySamConversion$lambda$12$getTargetCallArgument(int startOffset, int endOffset, Ref.IntRef temporaryValIndex, IrSimpleFunction $proxyFun, ArrayList<IrVariable> temporaryVals, Ref.IntRef proxyParameterIndex, IrExpression boundValue, IrValueParameter originalParameter) {
        return boundValue != null ? (IrExpression)FunctionReferenceLowering.createProxyLocalFunctionForIndySamConversion$lambda$12$addAndGetTemporaryVal(startOffset, endOffset, temporaryValIndex, $proxyFun, temporaryVals, boundValue) : (originalParameter != null ? (IrExpression)FunctionReferenceLowering.createProxyLocalFunctionForIndySamConversion$lambda$12$addAndGetProxyValueParameter($proxyFun, startOffset, endOffset, proxyParameterIndex, originalParameter) : null);
    }

    public static final /* synthetic */ IrCall access$wrapWithIndySamConversion(FunctionReferenceLowering $this, IrType samType, LambdaMetafactoryArguments lambdaMetafactoryArguments) {
        return $this.wrapWithIndySamConversion(samType, lambdaMetafactoryArguments);
    }

    public static final /* synthetic */ Set access$getSpecialNullabilityAnnotationsFqNames$p(FunctionReferenceLowering $this) {
        return $this.specialNullabilityAnnotationsFqNames;
    }

    public static final /* synthetic */ HashSet access$getCrossinlineLambdas$p(FunctionReferenceLowering $this) {
        return $this.crossinlineLambdas;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u00101\u001a\u00020\u0010J\u001a\u00102\u001a\u00020'2\u0006\u00103\u001a\u00020'2\b\b\u0002\u00104\u001a\u00020\u0005H\u0002J\b\u00105\u001a\u000206H\u0002J\u0014\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002080\u000eH\u0002J$\u00109\u001a\b\u0012\u0004\u0012\u00020:0\f2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020:0\f2\u0006\u0010<\u001a\u00020\u0015H\u0002J\u0012\u0010=\u001a\u00020'2\b\u0010>\u001a\u0004\u0018\u00010?H\u0002J)\u0010@\u001a\u00020'2\u0006\u00103\u001a\u00020'2\u0017\u0010A\u001a\u0013\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020\u00100B\u00a2\u0006\u0002\bDH\u0002J\b\u0010E\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020F2\u0006\u0010H\u001a\u00020\bH\u0002J\b\u0010I\u001a\u00020\u001aH\u0002J\u0018\u0010J\u001a\u00020\u00102\u0006\u0010K\u001a\u00020\n2\u0006\u0010L\u001a\u00020'H\u0002J\u0010\u0010M\u001a\u00020\u001a2\u0006\u0010N\u001a\u00020'H\u0002J\u0010\u0010O\u001a\u00020\u001a2\u0006\u0010N\u001a\u00020'H\u0002J\f\u0010P\u001a\u00020Q*\u00020'H\u0002J\u0016\u0010R\u001a\u00020Q*\u00020'2\b\u0010S\u001a\u0004\u0018\u00010?H\u0002J\f\u0010T\u001a\u00020Q*\u00020'H\u0002J-\u0010U\u001a\u00020Q*\u00020C2\u0006\u0010V\u001a\u00020\n2\u0017\u0010W\u001a\u0013\u0012\u0004\u0012\u00020X\u0012\u0004\u0012\u00020\u00100B\u00a2\u0006\u0002\bDH\u0002J\u0016\u0010Y\u001a\u00020Q*\u00020C2\b\u0010Z\u001a\u0004\u0018\u00010[H\u0002J\u0014\u0010\\\u001a\u00020\u0010*\u00020C2\u0006\u0010]\u001a\u00020^H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00050*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010-\u001a\u00020.*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006_"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$FunctionReferenceBuilder;", "", "irFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "samSuperType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering;Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "adaptedReferenceOriginalTarget", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "adapteeCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "argumentTypes", "", "boundReceiver", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "callee", "constructedFunInterfaceSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "functionReferenceClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "functionSuperClass", "getIrFunctionReference", "()Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "isAdaptedReference", "", "isFunInterfaceConstructorReference", "isKotlinFunInterface", "isLambda", "needToGenerateSamEqualsHashCodeMethods", "parameterTypes", "receiverField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "referenceReturnType", "samInterface", "getSamSuperType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "superMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "superType", "typeArgumentsMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "useOptimizedSuperClass", "originalName", "Lorg/jetbrains/kotlin/name/Name;", "getOriginalName", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/name/Name;", "build", "buildOverride", "superFunction", "newReturnType", "createConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "createFakeBoundReceiverForJvmStaticInObject", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "createFakeFormalTypeParameters", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "sourceTypeParameters", "irClass", "createInvokeMethod", "receiverVar", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "createLegacyMethodOverride", "generator", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "Lkotlin/ExtensionFunctionType;", "getAdaptedCallableReferenceFlags", "", "getFunctionReferenceFlags", "callableReferenceTarget", "hasVarargMappedToElement", "inlineAdapterCallIfPossible", "expression", "invokeMethod", "isEqualsFromAny", "f", "isHashCodeFromAny", "createFunInterfaceConstructorInvokeMethod", "", "createFunctionReferenceInvokeMethod", "receiver", "createLambdaInvokeMethod", "generateConstructorCallArguments", "call", "generateBoundReceiver", "Lorg/jetbrains/kotlin/ir/builders/IrBuilder;", "generateSamEqualsHashCodeMethods", "boundReceiverVar", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "generateSignature", "target", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "backend.jvm.lower"})
    private final class FunctionReferenceBuilder {
        @NotNull
        private final IrFunctionReference irFunctionReference;
        @Nullable
        private final IrType samSuperType;
        private final boolean isLambda;
        @NotNull
        private final IrFunction callee;
        @Nullable
        private final Pair<IrValueParameter, IrExpression> boundReceiver;
        @NotNull
        private final List<IrType> parameterTypes;
        @NotNull
        private final List<IrType> argumentTypes;
        @NotNull
        private final IrType referenceReturnType;
        @NotNull
        private final Map<IrTypeParameterSymbol, IrType> typeArgumentsMap;
        @NotNull
        private final IrClassSymbol functionSuperClass;
        @NotNull
        private final IrSimpleFunction superMethod;
        private final boolean useOptimizedSuperClass;
        @Nullable
        private final IrFunctionAccessExpression adapteeCall;
        @Nullable
        private final IrFunction adaptedReferenceOriginalTarget;
        private final boolean isFunInterfaceConstructorReference;
        @Nullable
        private final IrClassSymbol constructedFunInterfaceSymbol;
        private final boolean isAdaptedReference;
        @Nullable
        private final IrClass samInterface;
        private final boolean isKotlinFunInterface;
        private final boolean needToGenerateSamEqualsHashCodeMethods;
        @NotNull
        private final IrType superType;
        @NotNull
        private final IrClass functionReferenceClass;
        @NotNull
        private final IrField receiverField;
        final /* synthetic */ FunctionReferenceLowering this$0;

        /*
         * WARNING - void declaration
         */
        public FunctionReferenceBuilder(@NotNull FunctionReferenceLowering this$0, @Nullable IrFunctionReference irFunctionReference, IrType samSuperType) {
            void $this$functionReferenceClass_u24lambda_u243;
            void $this$functionReferenceClass_u24lambda_u242;
            IrClassSymbol irClassSymbol;
            IrFunctionAccessExpression irFunctionAccessExpression;
            IrFunctionAccessExpression irFunctionAccessExpression2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)irFunctionReference, (String)"irFunctionReference");
            this.this$0 = this$0;
            this.irFunctionReference = irFunctionReference;
            this.samSuperType = samSuperType;
            this.isLambda = IrUtilsKt.isLambda((IrStatementOrigin)this.irFunctionReference.getOrigin());
            this.callee = ((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner();
            this.boundReceiver = JvmStaticAnnotationLoweringKt.isJvmStaticInObject((IrDeclaration)this.callee) ? this.createFakeBoundReceiverForJvmStaticInObject() : (Pair)CollectionsKt.singleOrNull((List)IrUtilsKt.getArgumentsWithIr((IrMemberAccessExpression)((IrMemberAccessExpression)this.irFunctionReference)));
            IrType irType = this.irFunctionReference.getType();
            Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            Iterable iterable = ((IrSimpleType)irType).getArguments();
            FunctionReferenceLowering functionReferenceLowering = this.this$0;
            FunctionReferenceBuilder functionReferenceBuilder = this;
            boolean $i$f$map = false;
            void var7_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it instanceof IrTypeProjection ? ((IrTypeProjection)it).getType() : functionReferenceLowering.context.getIrBuiltIns().getAnyNType());
            }
            functionReferenceBuilder.parameterTypes = (List)destination$iv$iv;
            this.argumentTypes = CollectionsKt.dropLast(this.parameterTypes, (int)1);
            this.referenceReturnType = (IrType)CollectionsKt.last(this.parameterTypes);
            this.typeArgumentsMap = IrUtilsKt.getTypeSubstitutionMap((IrFunctionReference)this.irFunctionReference);
            IrType irType2 = this.samSuperType;
            if (irType2 == null || (irType2 = IrTypesKt.getClassOrNull((IrType)irType2)) == null) {
                irType2 = IrUtilsKt.isSuspend((IrFunctionReference)this.irFunctionReference) ? this.this$0.context.getIrBuiltIns().suspendFunctionN(this.argumentTypes.size()).getSymbol() : this.this$0.context.getIrBuiltIns().functionN(this.argumentTypes.size()).getSymbol();
            }
            this.functionSuperClass = irType2;
            IrSimpleFunction irSimpleFunction = JvmIrUtilsKt.getSingleAbstractMethod((IrClass)this.functionSuperClass.getOwner());
            if (irSimpleFunction == null) {
                throw new AssertionError((Object)("Not a SAM class: " + RenderIrElementKt.render((IrElement)((IrElement)this.functionSuperClass.getOwner()))));
            }
            this.superMethod = irSimpleFunction;
            this.useOptimizedSuperClass = this.this$0.context.getState().getGenerateOptimizedCallableReferenceSuperClasses();
            if (Intrinsics.areEqual((Object)this.callee.getOrigin(), (Object)IrDeclarationOrigin.ADAPTER_FOR_CALLABLE_REFERENCE.INSTANCE)) {
                IrStatement call2;
                IrStatement irStatement;
                IrBody irBody = this.callee.getBody();
                Intrinsics.checkNotNull((Object)irBody);
                IrStatement statement2 = (IrStatement)CollectionsKt.single((List)IrUtilsKt.getStatements((IrBody)irBody));
                if (statement2 instanceof IrTypeOperatorCall) {
                    boolean bl = $i$f$map = ((IrTypeOperatorCall)statement2).getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT;
                    if (_Assertions.ENABLED && !$i$f$map) {
                        functionReferenceBuilder = this;
                        boolean $i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$22 = false;
                        FunctionReferenceBuilder functionReferenceBuilder2 = functionReferenceBuilder;
                        String $i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$22 = "Unexpected type operator in ADAPTER_FOR_CALLABLE_REFERENCE: " + RenderIrElementKt.render((IrElement)((IrElement)this.callee));
                        throw new AssertionError((Object)$i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$22);
                    }
                    irStatement = (IrStatement)((IrTypeOperatorCall)statement2).getArgument();
                } else {
                    irStatement = call2 = statement2 instanceof IrReturn ? (IrStatement)((IrReturn)statement2).getValue() : statement2;
                }
                if (!(call2 instanceof IrFunctionAccessExpression)) {
                    throw new UnsupportedOperationException("Unknown structure of ADAPTER_FOR_CALLABLE_REFERENCE: " + RenderIrElementKt.render((IrElement)((IrElement)this.callee)));
                }
                irFunctionAccessExpression2 = (IrFunctionAccessExpression)call2;
            } else {
                irFunctionAccessExpression2 = null;
            }
            this.adaptedReferenceOriginalTarget = (irFunctionAccessExpression = (this.adapteeCall = irFunctionAccessExpression2)) != null && (irFunctionAccessExpression = (IrFunctionSymbol)irFunctionAccessExpression.getSymbol()) != null ? irFunctionAccessExpression.getOwner() : null;
            this.isFunInterfaceConstructorReference = Intrinsics.areEqual((Object)this.callee.getOrigin(), (Object)IrDeclarationOrigin.ADAPTER_FOR_FUN_INTERFACE_CONSTRUCTOR.INSTANCE);
            if (this.isFunInterfaceConstructorReference) {
                irClassSymbol = IrTypesKt.getClassOrNull((IrType)this.callee.getReturnType());
                if (irClassSymbol == null) {
                    throw new AssertionError((Object)("Fun interface type expected: " + RenderIrElementKt.render((IrType)this.callee.getReturnType())));
                }
            } else {
                irClassSymbol = null;
            }
            this.constructedFunInterfaceSymbol = irClassSymbol;
            this.isAdaptedReference = this.isFunInterfaceConstructorReference || this.adaptedReferenceOriginalTarget != null;
            IrType irType3 = this.samSuperType;
            this.samInterface = irType3 != null ? IrTypesKt.getClass((IrType)irType3) : null;
            this.isKotlinFunInterface = this.samInterface != null && !IrUtilsKt.isFromJava((IrDeclaration)((IrDeclaration)this.samInterface));
            this.needToGenerateSamEqualsHashCodeMethods = !(!this.isKotlinFunInterface && !this.this$0.isJavaSamConversionWithEqualsHashCode || !this.isAdaptedReference && this.isLambda);
            IrType irType4 = this.samSuperType;
            if (irType4 == null) {
                irType4 = IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)(this.isLambda ? this.this$0.context.getIr().getSymbols().getLambdaClass() : (this.isFunInterfaceConstructorReference ? this.this$0.context.getIr().getSymbols().getFunInterfaceConstructorReferenceClass() : (this.useOptimizedSuperClass ? (this.isAdaptedReference ? this.this$0.context.getIr().getSymbols().getAdaptedFunctionReference() : this.this$0.context.getIr().getSymbols().getFunctionReferenceImpl()) : this.this$0.context.getIr().getSymbols().getFunctionReference())))));
            }
            this.superType = irType4;
            IrFactory $this$buildClass$iv = this.this$0.context.getIrFactory();
            boolean $i$f$buildClass = false;
            Object $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
            boolean bl = false;
            destination$iv$iv = $this$buildClass_u24lambda_u241$iv;
            functionReferenceBuilder = this;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)((IrElementBuilder)$this$functionReferenceClass_u24lambda_u242), (IrElement)((IrElement)this.irFunctionReference));
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"LOCAL");
            $this$functionReferenceClass_u24lambda_u242.setVisibility(descriptorVisibility);
            $this$functionReferenceClass_u24lambda_u242.setOrigin(this.isLambda ? (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.LAMBDA_IMPL.INSTANCE : (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.FUNCTION_REFERENCE_IMPL.INSTANCE);
            $this$functionReferenceClass_u24lambda_u242.setName(SpecialNames.NO_NAME_PROVIDED);
            iterable = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, (IrClassBuilder)$this$buildClass_u24lambda_u241$iv);
            FunctionReferenceLowering functionReferenceLowering2 = this.this$0;
            $this$buildClass_u24lambda_u241$iv = iterable;
            boolean bl3 = false;
            IrDeclarationParent irDeclarationParent = functionReferenceLowering2.getCurrentDeclarationParent();
            if (irDeclarationParent == null) {
                throw new IllegalStateException(("No current declaration parent at " + DumpIrTreeKt.dump$default((IrElement)((IrElement)this.irFunctionReference), (boolean)false, (boolean)false, (int)3, null)).toString());
            }
            $this$functionReferenceClass_u24lambda_u243.setParent(irDeclarationParent);
            Object[] objectArray = new IrType[]{this.superType, (IrType)(this.samSuperType == null ? IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)this.functionSuperClass), this.parameterTypes) : null), this.needToGenerateSamEqualsHashCodeMethods ? IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)functionReferenceLowering2.context.getIr().getSymbols().getFunctionAdapter())) : null};
            $this$functionReferenceClass_u24lambda_u243.setSuperTypes(CollectionsKt.listOfNotNull((Object[])objectArray));
            if (this.samInterface != null && Intrinsics.areEqual((Object)$this$functionReferenceClass_u24lambda_u243.getOrigin(), (Object)((Object)JvmLoweredDeclarationOrigin.LAMBDA_IMPL.INSTANCE))) {
                $this$functionReferenceClass_u24lambda_u243.setTypeParameters(this.createFakeFormalTypeParameters(this.samInterface.getTypeParameters(), (IrClass)$this$functionReferenceClass_u24lambda_u243));
            }
            IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$functionReferenceClass_u24lambda_u243);
            IrDeclarationsKt.copyAttributes((IrAttributeContainer)((IrAttributeContainer)$this$functionReferenceClass_u24lambda_u243), (IrAttributeContainer)((IrAttributeContainer)this.irFunctionReference));
            if (this.isLambda) {
                $this$functionReferenceClass_u24lambda_u243.setMetadata(((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner().getMetadata());
            }
            functionReferenceBuilder.functionReferenceClass = iterable;
            this.receiverField = (IrField)this.this$0.context.getIr().getSymbols().getFunctionReferenceReceiverField().getOwner();
        }

        public /* synthetic */ FunctionReferenceBuilder(FunctionReferenceLowering functionReferenceLowering, IrFunctionReference irFunctionReference, IrType irType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                irType = null;
            }
            this(functionReferenceLowering, irFunctionReference, irType);
        }

        @NotNull
        public final IrFunctionReference getIrFunctionReference() {
            return this.irFunctionReference;
        }

        @Nullable
        public final IrType getSamSuperType() {
            return this.samSuperType;
        }

        /*
         * WARNING - void declaration
         */
        private final List<IrTypeParameter> createFakeFormalTypeParameters(List<? extends IrTypeParameter> sourceTypeParameters, IrClass irClass) {
            Collection collection;
            void $this$mapTo$iv$iv;
            if (sourceTypeParameters.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$map$iv = sourceTypeParameters;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                boolean $i$f$buildTypeParameter = false;
                IrTypeParameterBuilder $this$buildTypeParameter_u24lambda_u2434$iv = new IrTypeParameterBuilder();
                boolean bl2 = false;
                IrTypeParameterBuilder $this$createFakeFormalTypeParameters_u24lambda_u245_u24lambda_u244 = $this$buildTypeParameter_u24lambda_u2434$iv;
                boolean bl3 = false;
                $this$createFakeFormalTypeParameters_u24lambda_u245_u24lambda_u244.updateFrom((IrTypeParameter)it);
                $this$createFakeFormalTypeParameters_u24lambda_u245_u24lambda_u244.setName(it.getName());
                collection.add(DeclarationBuildersKt.buildTypeParameter((IrFactory)((IrTypeParametersContainer)irClass).getFactory(), (IrTypeParameterBuilder)$this$buildTypeParameter_u24lambda_u2434$iv, (IrDeclarationParent)((IrDeclarationParent)((IrTypeParametersContainer)irClass))));
            }
            List fakeTypeParameters = (List)destination$iv$iv;
            Iterable $this$associateWith$iv = sourceTypeParameters;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                IrTypeParameter bl = (IrTypeParameter)element$iv$iv;
                Object e = element$iv$iv;
                Map map = result$iv;
                boolean bl4 = false;
                IrTypeParameter irTypeParameter = (IrTypeParameter)fakeTypeParameters.get(it.getIndex());
                map.put(e, irTypeParameter);
            }
            Map map = result$iv;
            IrTypeParameterRemapper typeRemapper = new IrTypeParameterRemapper(map);
            for (IrTypeParameter fakeTypeParameter : fakeTypeParameters) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Object item$iv$iv;
                IrTypeParameter sourceTypeParameter = sourceTypeParameters.get(fakeTypeParameter.getIndex());
                $this$associateWithTo$iv$iv = sourceTypeParameter.getSuperTypes();
                collection = fakeTypeParameter;
                boolean $i$f$map2 = false;
                item$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    IrType bl2 = (IrType)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl = false;
                    collection2.add(typeRemapper.remapType((IrType)it));
                }
                collection.setSuperTypes((List)destination$iv$iv2);
            }
            return fakeTypeParameters;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrExpression build() {
            void $this$build_u24lambda_u2410_u24lambda_u249_u24lambda_u248;
            IrConstructorCall irConstructorCall;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlock_u24default$iv;
            JvmBackendContext jvmBackendContext = this.this$0.context;
            ScopeWithIr scopeWithIr = this.this$0.getCurrentScope();
            Intrinsics.checkNotNull((Object)scopeWithIr);
            JvmIrBuilder $this$build_u24lambda_u2410 = JvmIrBuilderKt.createJvmIrBuilder(jvmBackendContext, scopeWithIr);
            boolean bl = false;
            IrBuilderWithScope irBuilderWithScope = $this$build_u24lambda_u2410;
            int n = this.irFunctionReference.getStartOffset();
            int endOffset$iv = this.irFunctionReference.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$build_u24lambda_u2410_u24lambda_u249 = this_$iv$iv;
            boolean bl2 = false;
            IrConstructor constructor = this.createConstructor();
            IrVariable boundReceiverVar = this.samSuperType != null && this.boundReceiver != null ? ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)((IrStatementsBuilder)$this$build_u24lambda_u2410_u24lambda_u249), (IrExpression)((IrExpression)this.boundReceiver.getSecond()), null, null, (boolean)false, (int)14, null) : null;
            this.createInvokeMethod((IrValueDeclaration)boundReceiverVar);
            if (!this.isLambda && this.samSuperType == null && !this.useOptimizedSuperClass) {
                this.createLegacyMethodOverride((IrSimpleFunction)$this$build_u24lambda_u2410.getIrSymbols().getFunctionReferenceGetSignature().getOwner(), (Function1<? super JvmIrBuilder, ? extends IrExpression>)((Function1)new Function1<JvmIrBuilder, IrExpression>(this){
                    final /* synthetic */ FunctionReferenceBuilder this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull JvmIrBuilder $this$createLegacyMethodOverride) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$createLegacyMethodOverride), (String)"$this$createLegacyMethodOverride");
                        return FunctionReferenceBuilder.access$generateSignature(this.this$0, $this$createLegacyMethodOverride, FunctionReferenceBuilder.access$getCallee$p(this.this$0).getSymbol());
                    }
                }));
                this.createLegacyMethodOverride((IrSimpleFunction)$this$build_u24lambda_u2410.getIrSymbols().getFunctionReferenceGetName().getOwner(), (Function1<? super JvmIrBuilder, ? extends IrExpression>)((Function1)new Function1<JvmIrBuilder, IrExpression>(this){
                    final /* synthetic */ FunctionReferenceBuilder this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull JvmIrBuilder $this$createLegacyMethodOverride) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$createLegacyMethodOverride), (String)"$this$createLegacyMethodOverride");
                        IrBuilderWithScope irBuilderWithScope = $this$createLegacyMethodOverride;
                        String string2 = FunctionReferenceBuilder.access$getOriginalName(this.this$0, FunctionReferenceBuilder.access$getCallee$p(this.this$0)).asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"callee.originalName.asString()");
                        return (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)irBuilderWithScope, (String)string2);
                    }
                }));
                this.createLegacyMethodOverride((IrSimpleFunction)$this$build_u24lambda_u2410.getIrSymbols().getFunctionReferenceGetOwner().getOwner(), (Function1<? super JvmIrBuilder, ? extends IrExpression>)((Function1)new Function1<JvmIrBuilder, IrExpression>(this){
                    final /* synthetic */ FunctionReferenceBuilder this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull JvmIrBuilder $this$createLegacyMethodOverride) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$createLegacyMethodOverride), (String)"$this$createLegacyMethodOverride");
                        return FunctionReferenceLowering.Companion.calculateOwner$backend_jvm_lower($this$createLegacyMethodOverride, FunctionReferenceBuilder.access$getCallee$p(this.this$0).getParent());
                    }
                }));
            }
            if (this.needToGenerateSamEqualsHashCodeMethods) {
                this.generateSamEqualsHashCodeMethods($this$build_u24lambda_u2410, boundReceiverVar);
            }
            if (this.isKotlinFunInterface) {
                IrUtilsKt.addFakeOverrides$default((IrClass)this.functionReferenceClass, (IrTypeSystemContext)$this$build_u24lambda_u2410.getBackendContext().getTypeSystem(), null, (int)2, null);
            }
            $this$build_u24lambda_u2410_u24lambda_u249.unaryPlus((IrStatement)this.functionReferenceClass);
            IrConstructorCall irConstructorCall2 = irConstructorCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$build_u24lambda_u2410_u24lambda_u249), (IrConstructorSymbol)constructor.getSymbol());
            void var17_17 = $this$build_u24lambda_u2410_u24lambda_u249;
            boolean bl3 = false;
            if ($this$build_u24lambda_u2410_u24lambda_u249_u24lambda_u248.getValueArgumentsCount() > 0) {
                Pair<IrValueParameter, IrExpression> pair = this.boundReceiver;
                Intrinsics.checkNotNull(pair);
                $this$build_u24lambda_u2410_u24lambda_u249_u24lambda_u248.putValueArgument(0, (IrExpression)pair.getSecond());
            }
            var17_17.unaryPlus((IrStatement)irConstructorCall);
            return (IrExpression)this_$iv$iv.doBuild();
        }

        private final void generateSamEqualsHashCodeMethods(JvmIrBuilder $this$generateSamEqualsHashCodeMethods, IrVariable boundReceiverVar) {
            if (this.samSuperType == null) {
                boolean $i$a$-checkNotNull-FunctionReferenceLowering$FunctionReferenceBuilder$generateSamEqualsHashCodeMethods$22 = false;
                String $i$a$-checkNotNull-FunctionReferenceLowering$FunctionReferenceBuilder$generateSamEqualsHashCodeMethods$22 = "equals/hashCode can only be generated for fun interface wrappers: " + RenderIrElementKt.render((IrElement)((IrElement)this.callee));
                throw new IllegalStateException($i$a$-checkNotNull-FunctionReferenceLowering$FunctionReferenceBuilder$generateSamEqualsHashCodeMethods$22.toString());
            }
            if (!this.useOptimizedSuperClass) {
                IrSimpleFunctionSymbol it;
                Sequence $this$single$iv;
                IrSimpleFunction irSimpleFunction;
                IrSimpleFunction $this$generateSamEqualsHashCodeMethods_u24lambda_u2413 = irSimpleFunction = DeclarationBuildersKt.addFunction$default((IrClass)this.functionReferenceClass, (String)"equals", (IrType)$this$generateSamEqualsHashCodeMethods.getBackendContext().getIrBuiltIns().getBooleanType(), (Modality)Modality.ABSTRACT, null, (boolean)false, (boolean)false, (boolean)false, null, (int)0, (int)0, (int)1016, null);
                boolean bl = false;
                DeclarationBuildersKt.addValueParameter$default((IrFunction)((IrFunction)$this$generateSamEqualsHashCodeMethods_u24lambda_u2413), (String)"other", (IrType)$this$generateSamEqualsHashCodeMethods.getBackendContext().getIrBuiltIns().getAnyNType(), null, (int)4, null);
                Sequence sequence2 = IrUtilsKt.getFunctions((IrClassSymbol)this.functionSuperClass);
                IrSimpleFunction irSimpleFunction2 = $this$generateSamEqualsHashCodeMethods_u24lambda_u2413;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    it = (IrSimpleFunctionSymbol)element$iv;
                    boolean bl2 = false;
                    if (!this.isEqualsFromAny((IrSimpleFunction)it.getOwner())) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Sequence contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                irSimpleFunction2.setOverriddenSymbols(CollectionsKt.listOf(single$iv));
                IrSimpleFunction $this$generateSamEqualsHashCodeMethods_u24lambda_u2415 = irSimpleFunction = DeclarationBuildersKt.addFunction$default((IrClass)this.functionReferenceClass, (String)"hashCode", (IrType)$this$generateSamEqualsHashCodeMethods.getBackendContext().getIrBuiltIns().getIntType(), (Modality)Modality.ABSTRACT, null, (boolean)false, (boolean)false, (boolean)false, null, (int)0, (int)0, (int)1016, null);
                boolean bl3 = false;
                $this$single$iv = IrUtilsKt.getFunctions((IrClassSymbol)this.functionSuperClass);
                irSimpleFunction2 = $this$generateSamEqualsHashCodeMethods_u24lambda_u2415;
                $i$f$single = false;
                single$iv = null;
                found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    it = (IrSimpleFunctionSymbol)element$iv;
                    boolean bl4 = false;
                    if (!this.isHashCodeFromAny((IrSimpleFunction)it.getOwner())) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Sequence contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                irSimpleFunction2.setOverriddenSymbols(CollectionsKt.listOf(single$iv));
                return;
            }
            new SamEqualsHashCodeMethodsGenerator((CommonBackendContext)$this$generateSamEqualsHashCodeMethods.getBackendContext(), this.functionReferenceClass, this.samSuperType, (Function2)new Function2<IrBuilderWithScope, IrExpression, IrExpression>(this, $this$generateSamEqualsHashCodeMethods, boundReceiverVar){
                final /* synthetic */ FunctionReferenceBuilder this$0;
                final /* synthetic */ JvmIrBuilder $this_generateSamEqualsHashCodeMethods;
                final /* synthetic */ IrVariable $boundReceiverVar;
                {
                    this.this$0 = $receiver;
                    this.$this_generateSamEqualsHashCodeMethods = $receiver2;
                    this.$boundReceiverVar = $boundReceiverVar;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final IrExpression invoke(@NotNull IrBuilderWithScope $this$$receiver, @NotNull IrExpression it) {
                    void $this$single$iv;
                    Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    IrClassSymbol internalClass = FunctionReferenceBuilder.access$isAdaptedReference$p(this.this$0) ? this.$this_generateSamEqualsHashCodeMethods.getBackendContext().getIr().getSymbols().getAdaptedFunctionReference() : this.$this_generateSamEqualsHashCodeMethods.getBackendContext().getIr().getSymbols().getFunctionReferenceImpl();
                    Sequence sequence2 = IrUtilsKt.getConstructors((IrClass)((IrClass)internalClass.getOwner()));
                    FunctionReferenceBuilder functionReferenceBuilder = this.this$0;
                    boolean $i$f$single = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (E element$iv : $this$single$iv) {
                        IrConstructor it2 = (IrConstructor)element$iv;
                        boolean bl = false;
                        if (!(it2.getValueParameters().size() == 1 + (FunctionReferenceBuilder.access$getBoundReceiver$p(functionReferenceBuilder) != null ? 1 : 0) + 4)) continue;
                        if (found$iv) {
                            throw new IllegalArgumentException("Sequence contains more than one matching element.");
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    if (!found$iv) {
                        throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                    }
                    IrConstructor constructor = single$iv;
                    sequence2 = ExpressionHelpersKt.irCallConstructor((IrBuilderWithScope)$this$$receiver, (IrConstructorSymbol)constructor.getSymbol(), (List)CollectionsKt.emptyList());
                    functionReferenceBuilder = this.this$0;
                    JvmIrBuilder jvmIrBuilder = this.$this_generateSamEqualsHashCodeMethods;
                    IrVariable irVariable = this.$boundReceiverVar;
                    Sequence $this$invoke_u24lambda_u241 = sequence2;
                    boolean bl = false;
                    FunctionReferenceBuilder.access$generateConstructorCallArguments(functionReferenceBuilder, jvmIrBuilder, (IrFunctionAccessExpression)$this$invoke_u24lambda_u241, (Function1)new Function1<IrBuilder, IrExpression>($this$$receiver, irVariable){
                        final /* synthetic */ IrBuilderWithScope $this_$receiver;
                        final /* synthetic */ IrVariable $boundReceiverVar;
                        {
                            this.$this_$receiver = $this_$receiver;
                            this.$boundReceiverVar = $boundReceiverVar;
                            super(1);
                        }

                        @NotNull
                        public final IrExpression invoke(@NotNull IrBuilder $this$generateConstructorCallArguments) {
                            Intrinsics.checkNotNullParameter((Object)$this$generateConstructorCallArguments, (String)"$this$generateConstructorCallArguments");
                            IrVariable irVariable = this.$boundReceiverVar;
                            Intrinsics.checkNotNull((Object)irVariable);
                            return (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)this.$this_$receiver, (IrValueDeclaration)((IrValueDeclaration)irVariable));
                        }
                    });
                    return (IrExpression)sequence2;
                }
            }).generate();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isEqualsFromAny(IrSimpleFunction f) {
            if (!Intrinsics.areEqual((Object)f.getName().asString(), (Object)"equals")) return false;
            if (f.getExtensionReceiverParameter() != null) return false;
            IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull((List)f.getValueParameters());
            IrValueParameter irValueParameter2 = irValueParameter;
            if (irValueParameter == null) return false;
            IrType irType = irValueParameter2.getType();
            irValueParameter2 = irType;
            if (irType == null) return false;
            if (!IrTypePredicatesKt.isNullableAny((IrType)irValueParameter2)) return false;
            return true;
        }

        private final boolean isHashCodeFromAny(IrSimpleFunction f) {
            return Intrinsics.areEqual((Object)f.getName().asString(), (Object)"hashCode") && f.getExtensionReceiverParameter() == null && f.getValueParameters().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        private final IrConstructor createConstructor() {
            IrDelegatingConstructorCall irDelegatingConstructorCall;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlockBody$iv;
            void $this$createConstructor_u24lambda_u2421_u24lambda_u2420;
            IrConstructor it;
            IrConstructor irConstructor;
            IrClass $this$addConstructor$iv = this.functionReferenceClass;
            boolean $i$f$addConstructor = false;
            IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2422$iv$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$addConstructor_u24lambda_u2423$iv = $this$buildConstructor_u24lambda_u2422$iv$iv;
            boolean bl2 = false;
            IrFunctionBuilder $this$createConstructor_u24lambda_u2416 = $this$addConstructor_u24lambda_u2423$iv;
            boolean bl3 = false;
            $this$createConstructor_u24lambda_u2416.setOrigin((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
            $this$createConstructor_u24lambda_u2416.setReturnType((IrType)IrUtilsKt.getDefaultType((IrClass)this.functionReferenceClass));
            $this$createConstructor_u24lambda_u2416.setPrimary(true);
            $this$addConstructor_u24lambda_u2423$iv.setReturnType((IrType)IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
            IrFactory constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2422$iv$iv);
            boolean bl4 = false;
            $this$addConstructor$iv.getDeclarations().add(constructor$iv);
            constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
            IrFactory irFactory = $this$buildConstructor$iv$iv;
            FunctionReferenceLowering functionReferenceLowering = this.this$0;
            IrFactory $this$createConstructor_u24lambda_u2421 = irFactory;
            boolean bl5 = false;
            if (this.samSuperType == null && this.boundReceiver != null) {
                DeclarationBuildersKt.addValueParameter$default((IrFunction)((IrFunction)$this$createConstructor_u24lambda_u2421), (String)"receiver", (IrType)functionReferenceLowering.context.getIrBuiltIns().getAnyNType(), null, (int)4, null);
            }
            if (this.isFunInterfaceConstructorReference) {
                irConstructor = (IrConstructor)SequencesKt.single((Sequence)IrUtilsKt.getConstructors((IrClass)((IrClass)functionReferenceLowering.context.getIr().getSymbols().getFunInterfaceConstructorReferenceClass().getOwner())));
            } else if (this.samSuperType != null) {
                irConstructor = (IrConstructor)SequencesKt.single((Sequence)IrUtilsKt.getConstructors((IrClass)((IrClass)functionReferenceLowering.context.getIrBuiltIns().getAnyClass().getOwner())));
            } else {
                int expectedArity = this.isLambda && !this.isAdaptedReference ? 1 : 1 + (this.boundReceiver != null ? 1 : 0) + (this.useOptimizedSuperClass ? 4 : 0);
                IrClass irClass = IrTypesKt.getClass((IrType)this.superType);
                Intrinsics.checkNotNull((Object)irClass);
                Sequence $this$single$iv = IrUtilsKt.getConstructors((IrClass)irClass);
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    it = (IrConstructor)element$iv;
                    boolean bl6 = false;
                    if (!(it.getValueParameters().size() == expectedArity)) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Sequence contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                irConstructor = single$iv;
            }
            IrConstructor constructor = irConstructor;
            JvmIrBuilder $this$single$iv = JvmIrBuilderKt.createJvmIrBuilder$default(functionReferenceLowering.context, (IrSymbol)$this$createConstructor_u24lambda_u2421.getSymbol(), 0, 0, 6, null);
            IrFactory irFactory2 = $this$createConstructor_u24lambda_u2421;
            boolean bl7 = false;
            IrBuilderWithScope single$iv = (IrBuilderWithScope)$this$createConstructor_u24lambda_u2421_u24lambda_u2420;
            int found$iv = $this$createConstructor_u24lambda_u2421_u24lambda_u2420.getStartOffset();
            int endOffset$iv = $this$createConstructor_u24lambda_u2421_u24lambda_u2420.getEndOffset();
            boolean $i$f$irBlockBody = false;
            it = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void $this$createConstructor_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419 = this_$iv$iv;
            boolean bl8 = false;
            IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)((IrBuilderWithScope)$this$createConstructor_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419), (IrConstructor)constructor);
            void var20_34 = $this$createConstructor_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419;
            boolean bl9 = false;
            if (this.samSuperType == null) {
                void call2;
                this.generateConstructorCallArguments((JvmIrBuilder)$this$createConstructor_u24lambda_u2421_u24lambda_u2420, (IrFunctionAccessExpression)call2, (Function1<? super IrBuilder, ? extends IrExpression>)((Function1)new Function1<IrBuilder, IrExpression>((IrBlockBodyBuilder)$this$createConstructor_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419, (IrConstructor)$this$createConstructor_u24lambda_u2421){
                    final /* synthetic */ IrBlockBodyBuilder $this_irBlockBody;
                    final /* synthetic */ IrConstructor $this_apply;
                    {
                        this.$this_irBlockBody = $receiver;
                        this.$this_apply = $receiver2;
                        super(1);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull IrBuilder $this$generateConstructorCallArguments) {
                        Intrinsics.checkNotNullParameter((Object)$this$generateConstructorCallArguments, (String)"$this$generateConstructorCallArguments");
                        return (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)this.$this_irBlockBody), (IrValueDeclaration)((IrValueDeclaration)CollectionsKt.first((List)this.$this_apply.getValueParameters())));
                    }
                }));
            }
            var20_34.unaryPlus((IrStatement)irDelegatingConstructorCall);
            $this$createConstructor_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.unaryPlus((IrStatement)new IrInstanceInitializerCallImpl($this$createConstructor_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.getStartOffset(), $this$createConstructor_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.getEndOffset(), this.functionReferenceClass.getSymbol(), $this$createConstructor_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.getContext().getIrBuiltIns().getUnitType()));
            irFactory2.setBody((IrBody)this_$iv$iv.doBuild());
            return irFactory;
        }

        private final void generateConstructorCallArguments(JvmIrBuilder $this$generateConstructorCallArguments, IrFunctionAccessExpression call2, Function1<? super IrBuilder, ? extends IrExpression> generateBoundReceiver) {
            if (this.isFunInterfaceConstructorReference) {
                IrBuilderWithScope irBuilderWithScope = $this$generateConstructorCallArguments;
                IrClassSymbol irClassSymbol = this.constructedFunInterfaceSymbol;
                Intrinsics.checkNotNull((Object)irClassSymbol);
                IrClassReference funInterfaceKClassRef = JvmIrUtilsKt.kClassReference(irBuilderWithScope, (IrType)IrUtilsKt.getDefaultType((IrClass)((IrClass)irClassSymbol.getOwner())));
                IrCall funInterfaceJavaClassRef = JvmIrUtilsKt.kClassToJavaClass($this$generateConstructorCallArguments, (IrExpression)funInterfaceKClassRef);
                call2.putValueArgument(0, (IrExpression)funInterfaceJavaClassRef);
            } else {
                int index2 = 0;
                call2.putValueArgument(index2++, (IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$generateConstructorCallArguments, (int)(this.argumentTypes.size() + (IrUtilsKt.isSuspend((IrFunctionReference)this.irFunctionReference) ? 1 : 0)), null, (int)2, null));
                if (this.boundReceiver != null) {
                    call2.putValueArgument(index2++, (IrExpression)generateBoundReceiver.invoke((Object)$this$generateConstructorCallArguments));
                }
                if (!this.isLambda && this.useOptimizedSuperClass) {
                    IrFunction irFunction = this.adaptedReferenceOriginalTarget;
                    if (irFunction == null) {
                        irFunction = this.callee;
                    }
                    IrFunction callableReferenceTarget = irFunction;
                    IrExpression owner = Companion.calculateOwnerKClass$backend_jvm_lower($this$generateConstructorCallArguments, callableReferenceTarget.getParent());
                    call2.putValueArgument(index2++, (IrExpression)JvmIrUtilsKt.kClassToJavaClass($this$generateConstructorCallArguments, owner));
                    int n = index2++;
                    IrBuilderWithScope irBuilderWithScope = $this$generateConstructorCallArguments;
                    String string2 = this.getOriginalName(callableReferenceTarget).asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"callableReferenceTarget.originalName.asString()");
                    call2.putValueArgument(n, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)irBuilderWithScope, (String)string2));
                    call2.putValueArgument(index2++, this.generateSignature($this$generateConstructorCallArguments, callableReferenceTarget.getSymbol()));
                    call2.putValueArgument(index2, (IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$generateConstructorCallArguments, (int)this.getFunctionReferenceFlags(callableReferenceTarget), null, (int)2, null));
                }
            }
        }

        private final int getFunctionReferenceFlags(IrFunction callableReferenceTarget) {
            int isTopLevelBit = JvmIrUtilsKt.getCallableReferenceTopLevelFlag((IrDeclaration)callableReferenceTarget);
            int adaptedCallableReferenceFlags = this.getAdaptedCallableReferenceFlags();
            return isTopLevelBit + (adaptedCallableReferenceFlags << 1);
        }

        private final int getAdaptedCallableReferenceFlags() {
            if (this.adaptedReferenceOriginalTarget == null) {
                return 0;
            }
            int isVarargMappedToElementBit = this.hasVarargMappedToElement() ? 1 : 0;
            int isSuspendConvertedBit = !AdditionalIrUtilsKt.isSuspend((IrFunction)this.adaptedReferenceOriginalTarget) && AdditionalIrUtilsKt.isSuspend((IrFunction)this.callee) ? 1 : 0;
            int isCoercedToUnitBit = !IrTypePredicatesKt.isUnit((IrType)this.adaptedReferenceOriginalTarget.getReturnType()) && IrTypePredicatesKt.isUnit((IrType)this.callee.getReturnType()) ? 1 : 0;
            return isVarargMappedToElementBit + (isSuspendConvertedBit << 1) + (isCoercedToUnitBit << 2);
        }

        private final boolean hasVarargMappedToElement() {
            if (this.adapteeCall == null) {
                return false;
            }
            int n = this.adapteeCall.getValueArgumentsCount();
            for (int i = 0; i < n; ++i) {
                IrExpression arg;
                if (this.adapteeCall.getValueArgument(i) == null || !(arg instanceof IrVararg)) continue;
                for (IrVarargElement varargElement : ((IrVararg)arg).getElements()) {
                    if (!(varargElement instanceof IrGetValue)) continue;
                    return true;
                }
            }
            return false;
        }

        private final IrSimpleFunction createInvokeMethod(IrValueDeclaration receiverVar) {
            IrSimpleFunction irSimpleFunction;
            IrSimpleFunction irSimpleFunction2;
            IrClass $this$addFunction$iv = this.functionReferenceClass;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            IrFactory $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2418$iv$iv$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$createInvokeMethod_u24lambda_u2422 = $this$buildFun_u24lambda_u2418$iv$iv$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)((IrElementBuilder)$this$createInvokeMethod_u24lambda_u2422), (IrElement)(this.isLambda ? (IrElement)this.callee : (IrElement)this.irFunctionReference));
            $this$createInvokeMethod_u24lambda_u2422.setName(this.superMethod.getName());
            $this$createInvokeMethod_u24lambda_u2422.setReturnType(this.referenceReturnType);
            $this$createInvokeMethod_u24lambda_u2422.setSuspend(AdditionalIrUtilsKt.isSuspend((IrFunction)this.callee));
            IrSimpleFunction function$iv$iv = irSimpleFunction2 = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2418$iv$iv$iv);
            boolean bl3 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add(function$iv$iv);
            function$iv$iv.setParent((IrDeclarationParent)((IrDeclarationContainer)$this$addFunction$iv));
            IrSimpleFunction $this$createInvokeMethod_u24lambda_u2423 = irSimpleFunction = irSimpleFunction2;
            boolean bl4 = false;
            $this$createInvokeMethod_u24lambda_u2423.setMetadata(this.functionReferenceClass.getMetadata());
            $this$createInvokeMethod_u24lambda_u2423.setOverriddenSymbols(CollectionsKt.plus((Collection)$this$createInvokeMethod_u24lambda_u2423.getOverriddenSymbols(), (Object)this.superMethod.getSymbol()));
            $this$createInvokeMethod_u24lambda_u2423.setDispatchReceiverParameter(DeclarationBuildersKt.buildReceiverParameter$default((IrDeclaration)((IrDeclaration)$this$createInvokeMethod_u24lambda_u2423), (IrDeclarationOrigin)((IrDeclarationOrigin)IrDeclarationOrigin.INSTANCE_RECEIVER.INSTANCE), (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)this.functionReferenceClass.getSymbol())), (int)0, (int)0, (int)24, null));
            if (this.isLambda) {
                this.createLambdaInvokeMethod($this$createInvokeMethod_u24lambda_u2423);
            } else if (this.isFunInterfaceConstructorReference) {
                this.createFunInterfaceConstructorInvokeMethod($this$createInvokeMethod_u24lambda_u2423);
            } else {
                this.createFunctionReferenceInvokeMethod($this$createInvokeMethod_u24lambda_u2423, receiverVar);
            }
            return irSimpleFunction;
        }

        /*
         * WARNING - void declaration
         */
        private final void createLambdaInvokeMethod(IrSimpleFunction $this$createLambdaInvokeMethod) {
            void $this$associateTo$iv$iv;
            $this$createLambdaInvokeMethod.setAnnotations(CollectionsKt.plus((Collection)$this$createLambdaInvokeMethod.getAnnotations(), (Iterable)this.callee.getAnnotations()));
            Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)IrUtilsKt.getExplicitParameters((IrFunction)this.callee));
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                IndexedValue indexedValue = (IndexedValue)element$iv$iv;
                boolean bl = false;
                int index2 = indexedValue.component1();
                IrValueParameter param = (IrValueParameter)indexedValue.component2();
                indexedValue = TuplesKt.to((Object)param, (Object)IrUtilsKt.copyTo$default((IrValueParameter)param, (IrFunction)((IrFunction)$this$createLambdaInvokeMethod), null, (int)index2, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (int)8186, null));
                map.put(indexedValue.getFirst(), indexedValue.getSecond());
            }
            Map valueParameterMap = destination$iv$iv;
            $this$createLambdaInvokeMethod.setValueParameters(CollectionsKt.plus((Collection)$this$createLambdaInvokeMethod.getValueParameters(), (Iterable)valueParameterMap.values()));
            $this$createLambdaInvokeMethod.setBody(IrInlineUtilsKt.moveBodyTo((IrFunction)this.callee, (IrFunction)((IrFunction)$this$createLambdaInvokeMethod), (Map)valueParameterMap));
        }

        private final void createFunInterfaceConstructorInvokeMethod(IrSimpleFunction $this$createFunInterfaceConstructorInvokeMethod) {
            IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull((List)this.callee.getValueParameters());
            if (irValueParameter == null) {
                throw new AssertionError((Object)("Single value parameter expected: " + RenderIrElementKt.render((IrElement)((IrElement)this.callee))));
            }
            IrValueParameter adapterValueParameter = irValueParameter;
            IrValueParameter invokeValueParameter = IrUtilsKt.copyTo$default((IrValueParameter)adapterValueParameter, (IrFunction)((IrFunction)$this$createFunInterfaceConstructorInvokeMethod), null, (int)0, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (int)8186, null);
            Map valueParameterMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)adapterValueParameter, (Object)invokeValueParameter));
            $this$createFunInterfaceConstructorInvokeMethod.setValueParameters(CollectionsKt.listOf((Object)invokeValueParameter));
            $this$createFunInterfaceConstructorInvokeMethod.setBody(IrInlineUtilsKt.moveBodyTo((IrFunction)this.callee, (IrFunction)((IrFunction)$this$createFunInterfaceConstructorInvokeMethod), (Map)valueParameterMap));
            this.callee.setBody(null);
        }

        /*
         * WARNING - void declaration
         */
        private final void createFunctionReferenceInvokeMethod(IrSimpleFunction $this$createFunctionReferenceInvokeMethod, IrValueDeclaration receiver) {
            void $this$createFunctionReferenceInvokeMethod_u24lambda_u2428;
            IrFunctionAccessExpression irFunctionAccessExpression;
            IrValueParameter irValueParameter;
            Iterator<IrType> iterator2 = this.argumentTypes.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int index2 = n++;
                IrType argumentType = iterator2.next();
                IrFunction $this$addValueParameter$iv = (IrFunction)$this$createFunctionReferenceInvokeMethod;
                boolean $i$f$addValueParameter = false;
                IrValueParameterBuilder $this$addValueParameter_u24lambda_u2430$iv = new IrValueParameterBuilder();
                boolean bl = false;
                IrValueParameterBuilder $this$createFunctionReferenceInvokeMethod_u24lambda_u2425 = $this$addValueParameter_u24lambda_u2430$iv;
                boolean bl2 = false;
                Name name = Name.identifier((String)("" + 'p' + index2));
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"p$index\")");
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2425.setName(name);
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2425.setType(argumentType);
                if ($this$addValueParameter_u24lambda_u2430$iv.getIndex() == -1) {
                    $this$addValueParameter_u24lambda_u2430$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
                }
                IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter((IrFactory)$this$addValueParameter$iv.getFactory(), (IrValueParameterBuilder)$this$addValueParameter_u24lambda_u2430$iv, (IrDeclarationParent)((IrDeclarationParent)$this$addValueParameter$iv));
                boolean bl3 = false;
                $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
            }
            JvmIrBuilder jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder(this.this$0.context, (IrSymbol)$this$createFunctionReferenceInvokeMethod.getSymbol(), $this$createFunctionReferenceInvokeMethod.getStartOffset(), $this$createFunctionReferenceInvokeMethod.getEndOffset());
            IrSimpleFunction irSimpleFunction = $this$createFunctionReferenceInvokeMethod;
            boolean bl = false;
            int unboundIndex = 0;
            IrFunctionAccessExpression $this$createFunctionReferenceInvokeMethod_u24lambda_u2428_u24lambda_u2427 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2428), (IrFunctionSymbol)this.callee.getSymbol(), (IrType)this.referenceReturnType);
            boolean bl4 = false;
            for (IrTypeParameter typeParameter : IrUtilsKt.getAllTypeParameters((IrFunction)((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner())) {
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2428_u24lambda_u2427.putTypeArgument(typeParameter.getIndex(), this.typeArgumentsMap.get(typeParameter.getSymbol()));
            }
            for (IrValueParameter parameter : IrUtilsKt.getExplicitParameters((IrFunction)this.callee)) {
                IrExpression irExpression;
                Pair<IrValueParameter, IrExpression> pair = this.boundReceiver;
                if (Intrinsics.areEqual((Object)(pair != null ? (IrValueParameter)pair.getFirst() : null), (Object)parameter)) {
                    if (this.samSuperType == null) {
                        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2428;
                        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2428;
                        IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2428;
                        IrValueParameter irValueParameter2 = $this$createFunctionReferenceInvokeMethod.getDispatchReceiverParameter();
                        Intrinsics.checkNotNull((Object)irValueParameter2);
                        irExpression = (IrExpression)ExpressionHelpersKt.irImplicitCast((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)ExpressionHelpersKt.irGetField((IrBuilderWithScope)irBuilderWithScope2, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)irBuilderWithScope3, (IrValueDeclaration)((IrValueDeclaration)irValueParameter2))), (IrField)this.receiverField)), (IrType)((IrExpression)this.boundReceiver.getSecond()).getType());
                    } else {
                        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2428;
                        IrValueDeclaration irValueDeclaration = receiver;
                        Intrinsics.checkNotNull((Object)irValueDeclaration);
                        irExpression = (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)irBuilderWithScope, (IrValueDeclaration)irValueDeclaration);
                    }
                } else if (unboundIndex >= this.argumentTypes.size()) {
                    irExpression = null;
                } else {
                    int n2 = unboundIndex;
                    unboundIndex = n2 + 1;
                    irExpression = (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2428), (IrValueDeclaration)((IrValueDeclaration)$this$createFunctionReferenceInvokeMethod.getValueParameters().get(n2)));
                }
                if ((irValueParameter = irExpression) == null) continue;
                IrValueParameter it = irValueParameter;
                boolean bl5 = false;
                IrMemberAccessExpressionKt.putArgument((IrMemberAccessExpression)((IrMemberAccessExpression)$this$createFunctionReferenceInvokeMethod_u24lambda_u2428_u24lambda_u2427), (IrFunction)this.callee, (IrValueParameter)parameter, (IrExpression)it);
            }
            IrFunctionAccessExpression call2 = irFunctionAccessExpression;
            irSimpleFunction.setBody((IrBody)ExpressionHelpersKt.irExprBody((IrBuilderWithScope)((IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2428), (IrExpression)this.inlineAdapterCallIfPossible(call2, $this$createFunctionReferenceInvokeMethod)));
        }

        private final IrExpression inlineAdapterCallIfPossible(IrFunctionAccessExpression expression2, IrSimpleFunction invokeMethod) {
            IrValueDeclaration irValueDeclaration;
            Map map;
            IrValueParameter it;
            IrExpression irExpression;
            IrBlockBody adapterBody;
            IrCall irCall = expression2 instanceof IrCall ? (IrCall)expression2 : null;
            if (irCall == null) {
                return (IrExpression)expression2;
            }
            IrCall irCall2 = irCall;
            IrSimpleFunction callee = (IrSimpleFunction)irCall2.getSymbol().getOwner();
            if (!Intrinsics.areEqual((Object)callee.getOrigin(), (Object)IrDeclarationOrigin.ADAPTER_FOR_CALLABLE_REFERENCE.INSTANCE)) {
                return (IrExpression)expression2;
            }
            if (callee.isSuspend()) {
                return (IrExpression)expression2;
            }
            IrBody irBody = callee.getBody();
            IrBlockBody irBlockBody = adapterBody = irBody instanceof IrBlockBody ? (IrBlockBody)irBody : null;
            if (adapterBody == null || adapterBody.getStatements().size() != 1) {
                throw new AssertionError((Object)("Unexpected adapter body: " + DumpIrTreeKt.dump$default((IrElement)((IrElement)callee), (boolean)false, (boolean)false, (int)3, null)));
            }
            IrStatement resultStatement = (IrStatement)adapterBody.getStatements().get(0);
            if (resultStatement instanceof IrReturn) {
                irExpression = ((IrReturn)resultStatement).getValue();
            } else if (resultStatement instanceof IrTypeOperatorCall && ((IrTypeOperatorCall)resultStatement).getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT) {
                irExpression = (IrExpression)resultStatement;
            } else if (resultStatement instanceof IrCall) {
                irExpression = (IrExpression)resultStatement;
            } else if (resultStatement instanceof IrConstructorCall) {
                irExpression = (IrExpression)resultStatement;
            } else {
                throw new AssertionError((Object)("Unexpected adapter body: " + DumpIrTreeKt.dump$default((IrElement)((IrElement)callee), (boolean)false, (boolean)false, (int)3, null)));
            }
            IrExpression resultExpression = irExpression;
            int startOffset = irCall2.getStartOffset();
            int endOffset = irCall2.getEndOffset();
            LinkedHashMap callArguments = new LinkedHashMap();
            IrBlockImpl inlinedAdapterBlock = new IrBlockImpl(startOffset, endOffset, irCall2.getType(), null);
            Ref.IntRef tmpVarIndex = new Ref.IntRef();
            IrValueParameter irValueParameter = callee.getDispatchReceiverParameter();
            if (irValueParameter != null) {
                it = irValueParameter;
                boolean bl = false;
                map = callArguments;
                IrExpression irExpression2 = irCall2.getDispatchReceiver();
                if (irExpression2 == null) {
                    throw new AssertionError((Object)("No dispatch receiver in adapter call: " + DumpIrTreeKt.dump$default((IrElement)((IrElement)irCall2), (boolean)false, (boolean)false, (int)3, null)));
                }
                irValueDeclaration = FunctionReferenceBuilder.inlineAdapterCallIfPossible$wrapIntoTemporaryVariableIfNecessary(startOffset, endOffset, tmpVarIndex, invokeMethod, inlinedAdapterBlock, irExpression2);
                map.put(it, irValueDeclaration);
            }
            IrValueParameter irValueParameter2 = callee.getExtensionReceiverParameter();
            if (irValueParameter2 != null) {
                it = irValueParameter2;
                boolean bl = false;
                map = callArguments;
                IrExpression irExpression3 = irCall2.getExtensionReceiver();
                if (irExpression3 == null) {
                    throw new AssertionError((Object)("No extension receiver in adapter call: " + DumpIrTreeKt.dump$default((IrElement)((IrElement)irCall2), (boolean)false, (boolean)false, (int)3, null)));
                }
                irValueDeclaration = FunctionReferenceBuilder.inlineAdapterCallIfPossible$wrapIntoTemporaryVariableIfNecessary(startOffset, endOffset, tmpVarIndex, invokeMethod, inlinedAdapterBlock, irExpression3);
                map.put(it, irValueDeclaration);
            }
            for (IrValueParameter valueParameter2 : callee.getValueParameters()) {
                Map map2 = callArguments;
                IrExpression irExpression4 = irCall2.getValueArgument(valueParameter2.getIndex());
                if (irExpression4 == null) {
                    throw new AssertionError((Object)("No value argument #" + valueParameter2.getIndex() + " in adapter call: " + DumpIrTreeKt.dump$default((IrElement)((IrElement)irCall2), (boolean)false, (boolean)false, (int)3, null)));
                }
                IrValueDeclaration irValueDeclaration2 = FunctionReferenceBuilder.inlineAdapterCallIfPossible$wrapIntoTemporaryVariableIfNecessary(startOffset, endOffset, tmpVarIndex, invokeMethod, inlinedAdapterBlock, irExpression4);
                map2.put(valueParameter2, irValueDeclaration2);
            }
            IrExpression inlinedAdapterResult = resultExpression.transform((IrElementTransformer)new VariableRemapper((Map)callArguments), null);
            inlinedAdapterBlock.getStatements().add(inlinedAdapterResult);
            callee.setBody(null);
            return (IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrElement)inlinedAdapterBlock), (IrDeclarationParent)((IrDeclarationParent)invokeMethod));
        }

        private final IrSimpleFunction buildOverride(IrSimpleFunction superFunction, IrType newReturnType) {
            IrSimpleFunction irSimpleFunction;
            IrSimpleFunction irSimpleFunction2;
            IrClass $this$addFunction$iv = this.functionReferenceClass;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            IrFactory $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2418$iv$iv$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$buildOverride_u24lambda_u2431 = $this$buildFun_u24lambda_u2418$iv$iv$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)((IrElementBuilder)$this$buildOverride_u24lambda_u2431), (IrElement)((IrElement)this.irFunctionReference));
            $this$buildOverride_u24lambda_u2431.setOrigin((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
            $this$buildOverride_u24lambda_u2431.setName(superFunction.getName());
            $this$buildOverride_u24lambda_u2431.setReturnType(newReturnType);
            $this$buildOverride_u24lambda_u2431.setVisibility(superFunction.getVisibility());
            $this$buildOverride_u24lambda_u2431.setSuspend(superFunction.isSuspend());
            IrSimpleFunction function$iv$iv = irSimpleFunction2 = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2418$iv$iv$iv);
            boolean bl3 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add(function$iv$iv);
            function$iv$iv.setParent((IrDeclarationParent)((IrDeclarationContainer)$this$addFunction$iv));
            IrSimpleFunction $this$buildOverride_u24lambda_u2432 = irSimpleFunction = irSimpleFunction2;
            boolean bl4 = false;
            $this$buildOverride_u24lambda_u2432.setOverriddenSymbols(CollectionsKt.plus((Collection)$this$buildOverride_u24lambda_u2432.getOverriddenSymbols(), (Object)superFunction.getSymbol()));
            IrValueParameter irValueParameter = this.functionReferenceClass.getThisReceiver();
            $this$buildOverride_u24lambda_u2432.setDispatchReceiverParameter(irValueParameter != null ? IrUtilsKt.copyTo$default((IrValueParameter)irValueParameter, (IrFunction)((IrFunction)$this$buildOverride_u24lambda_u2432), null, (int)0, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (int)8190, null) : null);
            return irSimpleFunction;
        }

        static /* synthetic */ IrSimpleFunction buildOverride$default(FunctionReferenceBuilder functionReferenceBuilder, IrSimpleFunction irSimpleFunction, IrType irType, int n, Object object) {
            if ((n & 2) != 0) {
                irType = irSimpleFunction.getReturnType();
            }
            return functionReferenceBuilder.buildOverride(irSimpleFunction, irType);
        }

        private final Name getOriginalName(IrFunction $this$originalName) {
            MetadataSource metadataSource = $this$originalName.getMetadata();
            if (metadataSource == null || (metadataSource = metadataSource.getName()) == null) {
                metadataSource = $this$originalName.getName();
            }
            return metadataSource;
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression generateSignature(JvmIrBuilder $this$generateSignature, IrFunctionSymbol target) {
            void $this$generateSignature_u24lambda_u2434_u24lambda_u2433;
            IrFunctionReferenceImpl irFunctionReferenceImpl;
            IrCall irCall;
            IrCall $this$generateSignature_u24lambda_u2434 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateSignature, (IrSimpleFunctionSymbol)$this$generateSignature.getBackendContext().getIr().getSymbols().getSignatureStringIntrinsic());
            boolean bl = false;
            IrFunctionReferenceImpl irFunctionReferenceImpl2 = irFunctionReferenceImpl = new IrFunctionReferenceImpl(-1, -1, this.irFunctionReference.getType(), target, this.irFunctionReference.getTypeArgumentsCount(), target.getOwner().getValueParameters().size(), this.irFunctionReference.getReflectionTarget(), null);
            int n = 0;
            IrCall irCall2 = $this$generateSignature_u24lambda_u2434;
            boolean bl2 = false;
            IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)((IrMemberAccessExpression)$this$generateSignature_u24lambda_u2434_u24lambda_u2433), (IrMemberAccessExpression)((IrMemberAccessExpression)this.irFunctionReference), (int)0, (int)2, null);
            Unit unit = Unit.INSTANCE;
            irCall2.putValueArgument(n, (IrExpression)irFunctionReferenceImpl);
            return (IrExpression)irCall;
        }

        private final Pair<IrValueParameter, IrGetObjectValueImpl> createFakeBoundReceiverForJvmStaticInObject() {
            IrClass objectClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)this.callee));
            IrDeclaration declaration$iv = (IrDeclaration)this.callee;
            boolean $i$f$buildValueParameter = false;
            IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2428$iv = new IrValueParameterBuilder();
            boolean bl = false;
            IrValueParameterBuilder $this$createFakeBoundReceiverForJvmStaticInObject_u24lambda_u2435 = $this$buildValueParameter_u24lambda_u2428$iv;
            boolean bl2 = false;
            Name name = Name.identifier((String)"$this");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"\\$this\")");
            $this$createFakeBoundReceiverForJvmStaticInObject_u24lambda_u2435.setName(name);
            $this$createFakeBoundReceiverForJvmStaticInObject_u24lambda_u2435.setType((IrType)IrTypesKt.typeWith((IrClass)objectClass, (IrType[])new IrType[0]));
            return TuplesKt.to((Object)DeclarationBuildersKt.buildValueParameter((IrFactory)declaration$iv.getFactory(), (IrValueParameterBuilder)$this$buildValueParameter_u24lambda_u2428$iv, (IrDeclarationParent)((IrDeclarationParent)declaration$iv)), (Object)new IrGetObjectValueImpl(-1, -1, (IrType)IrTypesKt.typeWith((IrClass)objectClass, (IrType[])new IrType[0]), objectClass.getSymbol()));
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction createLegacyMethodOverride(IrSimpleFunction superFunction, Function1<? super JvmIrBuilder, ? extends IrExpression> generator) {
            void $this$createLegacyMethodOverride_u24lambda_u2437_u24lambda_u2436;
            IrSimpleFunction irSimpleFunction = FunctionReferenceBuilder.buildOverride$default(this, superFunction, null, 2, null);
            FunctionReferenceLowering functionReferenceLowering = this.this$0;
            IrSimpleFunction $this$createLegacyMethodOverride_u24lambda_u2437 = irSimpleFunction;
            boolean bl = false;
            JvmIrBuilder jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder(functionReferenceLowering.context, (IrSymbol)$this$createLegacyMethodOverride_u24lambda_u2437.getSymbol(), $this$createLegacyMethodOverride_u24lambda_u2437.getStartOffset(), $this$createLegacyMethodOverride_u24lambda_u2437.getEndOffset());
            IrSimpleFunction irSimpleFunction2 = $this$createLegacyMethodOverride_u24lambda_u2437;
            boolean bl2 = false;
            irSimpleFunction2.setBody((IrBody)ExpressionHelpersKt.irExprBody((IrBuilderWithScope)((IrBuilderWithScope)$this$createLegacyMethodOverride_u24lambda_u2437_u24lambda_u2436), (IrExpression)((IrExpression)generator.invoke((Object)$this$createLegacyMethodOverride_u24lambda_u2437_u24lambda_u2436))));
            return irSimpleFunction;
        }

        private static final IrValueDeclaration inlineAdapterCallIfPossible$wrapIntoTemporaryVariableIfNecessary(int startOffset, int endOffset, Ref.IntRef tmpVarIndex, IrSimpleFunction $invokeMethod, IrBlockImpl inlinedAdapterBlock, IrExpression expression2) {
            if (expression2 instanceof IrGetValue) {
                return ((IrGetValue)expression2).getSymbol().getOwner();
            }
            if (!(expression2 instanceof IrTypeOperatorCall) || !(((IrTypeOperatorCall)expression2).getArgument() instanceof IrGetField)) {
                throw new AssertionError((Object)("Unexpected adapter argument:\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)expression2), (boolean)false, (boolean)false, (int)3, null)));
            }
            IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE;
            IrVariableSymbol irVariableSymbol = (IrVariableSymbol)new IrVariableSymbolImpl(null, 1, null);
            int n = tmpVarIndex.element;
            tmpVarIndex.element = n + 1;
            Name name = Name.identifier((String)("tmp_" + n));
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"tmp_${tmpVarIndex++}\")");
            IrVariableImpl temporaryVar = new IrVariableImpl(startOffset, endOffset, irDeclarationOrigin, irVariableSymbol, name, expression2.getType(), false, false, false);
            temporaryVar.setParent((IrDeclarationParent)$invokeMethod);
            temporaryVar.setInitializer(expression2);
            inlinedAdapterBlock.getStatements().add(temporaryVar);
            return (IrValueDeclaration)temporaryVar;
        }

        public static final /* synthetic */ boolean access$isAdaptedReference$p(FunctionReferenceBuilder $this) {
            return $this.isAdaptedReference;
        }

        public static final /* synthetic */ Pair access$getBoundReceiver$p(FunctionReferenceBuilder $this) {
            return $this.boundReceiver;
        }

        public static final /* synthetic */ void access$generateConstructorCallArguments(FunctionReferenceBuilder $this, JvmIrBuilder $receiver, IrFunctionAccessExpression call2, Function1 generateBoundReceiver) {
            $this.generateConstructorCallArguments($receiver, call2, (Function1<? super IrBuilder, ? extends IrExpression>)generateBoundReceiver);
        }

        public static final /* synthetic */ IrExpression access$generateSignature(FunctionReferenceBuilder $this, JvmIrBuilder $receiver, IrFunctionSymbol target) {
            return $this.generateSignature($receiver, target);
        }

        public static final /* synthetic */ IrFunction access$getCallee$p(FunctionReferenceBuilder $this) {
            return $this.callee;
        }

        public static final /* synthetic */ Name access$getOriginalName(FunctionReferenceBuilder $this, IrFunction $receiver) {
            return $this.getOriginalName($receiver);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u0019\u0010\t\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$Companion;", "", "()V", "calculateOwner", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "irContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "calculateOwner$backend_jvm_lower", "calculateOwnerKClass", "calculateOwnerKClass$backend_jvm_lower", "backend.jvm.lower"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrExpression calculateOwner$backend_jvm_lower(@NotNull JvmIrBuilder $this$calculateOwner, @NotNull IrDeclarationParent irContainer) {
            IrCall irCall;
            Intrinsics.checkNotNullParameter((Object)((Object)$this$calculateOwner), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)irContainer, (String)"irContainer");
            IrExpression kClass2 = this.calculateOwnerKClass$backend_jvm_lower($this$calculateOwner, irContainer);
            IrClass irClass = irContainer instanceof IrClass ? (IrClass)irContainer : null;
            if (!(irClass != null ? IrUtilsKt.isFileClass((IrDeclaration)((IrDeclaration)irClass)) : false) && !(irContainer instanceof IrPackageFragment)) {
                return kClass2;
            }
            IrCall $this$calculateOwner_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$calculateOwner, (IrSimpleFunctionSymbol)$this$calculateOwner.getIrSymbols().getGetOrCreateKotlinPackage());
            boolean bl = false;
            $this$calculateOwner_u24lambda_u240.putValueArgument(0, (IrExpression)JvmIrUtilsKt.kClassToJavaClass($this$calculateOwner, kClass2));
            $this$calculateOwner_u24lambda_u240.putValueArgument(1, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)$this$calculateOwner, (String)$this$calculateOwner.getBackendContext().getState().getModuleName()));
            return (IrExpression)irCall;
        }

        @NotNull
        public final IrExpression calculateOwnerKClass$backend_jvm_lower(@NotNull JvmIrBuilder $this$calculateOwnerKClass, @NotNull IrDeclarationParent irContainer) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$calculateOwnerKClass), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)irContainer, (String)"irContainer");
            return (IrExpression)JvmIrUtilsKt.kClassReference($this$calculateOwnerKClass, JvmIrUtilsKt.getCallableReferenceOwnerKClassType(irContainer, $this$calculateOwnerKClass.getBackendContext()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

