/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayDeque;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.IrInlinable;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrThrowImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002:\u0001%B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020 2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u001e\u0010!\u001a\u00020\"*\u00020\u00112\u0006\u0010#\u001a\u00020\u000f2\b\u0010$\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\r\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/AssertionLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/backend/jvm/lower/AssertionLowering$ClassInfo;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "scopeOwnerStack", "Ljava/util/ArrayDeque;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isAssert", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "getAssertionDisabled", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "irBuilder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "data", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "Lorg/jetbrains/kotlin/ir/IrElement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "checkAssertion", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "assertCondition", "lambdaArgument", "ClassInfo", "backend.jvm.lower"})
final class AssertionLowering
implements FileLoweringPass,
IrElementTransformer<ClassInfo> {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final ArrayDeque<IrDeclaration> scopeOwnerStack;

    public AssertionLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.scopeOwnerStack = new ArrayDeque();
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.context.getState().getAssertionsMode() != JVMAssertionsMode.LEGACY) {
            irFile.transformChildren((IrElementTransformer)this, null);
        }
    }

    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable ClassInfo data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.scopeOwnerStack.push((IrDeclaration)declaration);
        IrStatement result2 = IrElementTransformer.DefaultImpls.visitDeclaration((IrElementTransformer)this, (IrDeclarationBase)declaration, (Object)data);
        this.scopeOwnerStack.pop();
        return result2;
    }

    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration, @Nullable ClassInfo data) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            ClassInfo classInfo = data;
            if (classInfo == null || (classInfo = classInfo.getTopLevelClass()) == null) {
                classInfo = declaration;
            }
            ClassInfo info = new ClassInfo(declaration, (IrClass)classInfo, null, 4, null);
            this.visitDeclaration((IrDeclarationBase)declaration, info);
            IrField irField = info.getAssertionsDisabledField();
            if (irField == null) break block1;
            IrField it = irField;
            boolean bl = false;
            declaration.getDeclarations().add(0, it);
        }
        return (IrStatement)declaration;
    }

    @NotNull
    public IrElement visitCall(@NotNull IrCall expression2, @Nullable ClassInfo data) {
        IrElement irElement;
        IrExpression lambdaArgument;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunction function2 = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (!this.isAssert((IrFunction)function2)) {
            return IrElementTransformer.DefaultImpls.visitCall((IrElementTransformer)this, (IrCall)expression2, (Object)data);
        }
        JVMAssertionsMode mode = this.context.getState().getAssertionsMode();
        if (mode == JVMAssertionsMode.ALWAYS_DISABLE) {
            return (IrElement)new IrCompositeImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.context.getIrBuiltIns().getUnitType(), null, 8, null);
        }
        DeclarationIrBuilder $this$visitCall_u24lambda_u241 = LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)this.scopeOwnerStack.peek().getSymbol(), (int)0, (int)0, (int)6, null);
        boolean bl = false;
        LowerUtilsKt.at((IrBuilder)((IrBuilder)$this$visitCall_u24lambda_u241), (IrElement)((IrElement)expression2));
        IrExpression irExpression = expression2.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression);
        IrExpression assertCondition = irExpression;
        IrExpression irExpression2 = lambdaArgument = function2.getValueParameters().size() == 2 ? expression2.getValueArgument(1) : null;
        if (mode == JVMAssertionsMode.ALWAYS_ENABLE) {
            irElement = (IrElement)this.checkAssertion((IrBuilderWithScope)$this$visitCall_u24lambda_u241, assertCondition, lambdaArgument);
        } else {
            if (!(mode == JVMAssertionsMode.JVM && data != null)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            irElement = (IrElement)LowerUtilsKt.irIfThen((IrBuilderWithScope)((IrBuilderWithScope)$this$visitCall_u24lambda_u241), (IrExpression)LowerUtilsKt.irNot((IrBuilderWithScope)((IrBuilderWithScope)$this$visitCall_u24lambda_u241), (IrExpression)this.getAssertionDisabled((IrBuilderWithScope)$this$visitCall_u24lambda_u241, data)), (IrExpression)((IrExpression)this.checkAssertion((IrBuilderWithScope)$this$visitCall_u24lambda_u241, assertCondition, lambdaArgument)));
        }
        return irElement;
    }

    /*
     * WARNING - void declaration
     */
    private final IrContainerExpression checkAssertion(IrBuilderWithScope $this$checkAssertion, IrExpression assertCondition, IrExpression lambdaArgument) {
        void $this$checkAssertion_u24lambda_u243_u24lambda_u242;
        IrConstructorCall irConstructorCall;
        void this_$iv$iv;
        IrBuilderWithScope $this$irBlock_u24default$iv = $this$checkAssertion;
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$checkAssertion_u24lambda_u243 = this_$iv$iv;
        boolean bl = false;
        IrExpression irExpression = lambdaArgument;
        IrInlinable generator = irExpression != null ? IrInlineUtilsKt.asInlinable((IrExpression)irExpression, (IrStatementsBuilder)((IrStatementsBuilder)$this$checkAssertion_u24lambda_u243)) : null;
        IrConstructorSymbol constructor = this.context.getIr().getSymbols().getAssertionErrorConstructor();
        IrConstructorCall irConstructorCall2 = irConstructorCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$checkAssertion_u24lambda_u243), (IrConstructorSymbol)constructor);
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$checkAssertion_u24lambda_u243;
        boolean bl2 = false;
        IrInlinable irInlinable = generator;
        if (irInlinable == null || (irInlinable = IrInlineUtilsKt.inline$default((IrInlinable)irInlinable, (IrDeclarationParent)ExpressionHelpersKt.getParent((IrBuilderWithScope)((IrBuilderWithScope)$this$checkAssertion_u24lambda_u243)), null, (int)2, null)) == null || (irInlinable = (IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrElement)irInlinable), (IrDeclarationParent)$this$checkAssertion_u24lambda_u243.getScope().getLocalDeclarationParent())) == null) {
            irInlinable = (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)((IrBuilderWithScope)$this$checkAssertion_u24lambda_u243), (String)"Assertion failed");
        }
        IrInlinable message = irInlinable;
        $this$checkAssertion_u24lambda_u243_u24lambda_u242.putValueArgument(0, (IrExpression)message);
        IrThrowImpl throwError = LowerUtilsKt.irThrow((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)irConstructorCall));
        $this$checkAssertion_u24lambda_u243.unaryPlus((IrStatement)LowerUtilsKt.irIfThen((IrBuilderWithScope)((IrBuilderWithScope)$this$checkAssertion_u24lambda_u243), (IrExpression)LowerUtilsKt.irNot((IrBuilderWithScope)((IrBuilderWithScope)$this$checkAssertion_u24lambda_u243), (IrExpression)assertCondition), (IrExpression)((IrExpression)throwError)));
        return this_$iv$iv.doBuild();
    }

    private final IrExpression getAssertionDisabled(IrBuilderWithScope irBuilder, ClassInfo data) {
        if (data.getAssertionsDisabledField() == null) {
            data.setAssertionsDisabledField(JvmIrUtilsKt.buildAssertionsDisabledField(data.getIrClass(), this.context, data.getTopLevelClass()));
        }
        IrField irField = data.getAssertionsDisabledField();
        Intrinsics.checkNotNull((Object)irField);
        return (IrExpression)ExpressionHelpersKt.irGetField((IrBuilderWithScope)irBuilder, null, (IrField)irField);
    }

    private final boolean isAssert(IrFunction $this$isAssert) {
        return Intrinsics.areEqual((Object)$this$isAssert.getName().asString(), (Object)"assert") && Intrinsics.areEqual((Object)IrUtilsKt.getPackageFragment((IrDeclaration)((IrDeclaration)$this$isAssert)).getFqName(), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME);
    }

    @NotNull
    public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitAnonymousInitializer((IrElementTransformer)this, (IrAnonymousInitializer)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitBlock((IrElementTransformer)this, (IrBlock)expression2, (Object)data);
    }

    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitBlockBody((IrElementTransformer)this, (IrBlockBody)body2, (Object)data);
    }

    @NotNull
    public IrBody visitBody(@NotNull IrBody body2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitBody((IrElementTransformer)this, (IrBody)body2, (Object)data);
    }

    @NotNull
    public IrBranch visitBranch(@NotNull IrBranch branch, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitBranch((IrElementTransformer)this, (IrBranch)branch, (Object)data);
    }

    @NotNull
    public IrExpression visitBreak(@NotNull IrBreak jump, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitBreak((IrElementTransformer)this, (IrBreak)jump, (Object)data);
    }

    @NotNull
    public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitBreakContinue((IrElementTransformer)this, (IrBreakContinue)jump, (Object)data);
    }

    @NotNull
    public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitCallableReference((IrElementTransformer)this, expression2, (Object)data);
    }

    @NotNull
    public IrCatch visitCatch(@NotNull IrCatch aCatch, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitCatch((IrElementTransformer)this, (IrCatch)aCatch, (Object)data);
    }

    @NotNull
    public IrExpression visitClassReference(@NotNull IrClassReference expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitClassReference((IrElementTransformer)this, (IrClassReference)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitComposite(@NotNull IrComposite expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitComposite((IrElementTransformer)this, (IrComposite)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitConst(@NotNull IrConst<?> expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitConst((IrElementTransformer)this, expression2, (Object)data);
    }

    @NotNull
    public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitConstantArray((IrElementTransformer)this, (IrConstantArray)expression2, (Object)data);
    }

    @NotNull
    public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitConstantObject((IrElementTransformer)this, (IrConstantObject)expression2, (Object)data);
    }

    @NotNull
    public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitConstantPrimitive((IrElementTransformer)this, (IrConstantPrimitive)expression2, (Object)data);
    }

    @NotNull
    public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitConstantValue((IrElementTransformer)this, (IrConstantValue)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitConstructor(@NotNull IrConstructor declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitConstructor((IrElementTransformer)this, (IrConstructor)declaration, (Object)data);
    }

    @NotNull
    public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitConstructorCall((IrElementTransformer)this, (IrConstructorCall)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitContainerExpression((IrElementTransformer)this, (IrContainerExpression)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitContinue(@NotNull IrContinue jump, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitContinue((IrElementTransformer)this, (IrContinue)jump, (Object)data);
    }

    @NotNull
    public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitDeclarationReference((IrElementTransformer)this, (IrDeclarationReference)expression2, (Object)data);
    }

    @NotNull
    public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall((IrElementTransformer)this, (IrDelegatingConstructorCall)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitDoWhileLoop((IrElementTransformer)this, (IrDoWhileLoop)loop, (Object)data);
    }

    @NotNull
    public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitDynamicExpression((IrElementTransformer)this, (IrDynamicExpression)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression((IrElementTransformer)this, (IrDynamicMemberExpression)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression((IrElementTransformer)this, (IrDynamicOperatorExpression)expression2, (Object)data);
    }

    @NotNull
    public IrElement visitElement(@NotNull IrElement element, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitElement((IrElementTransformer)this, (IrElement)element, (Object)data);
    }

    @NotNull
    public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitElseBranch((IrElementTransformer)this, (IrElseBranch)branch, (Object)data);
    }

    @NotNull
    public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitEnumConstructorCall((IrElementTransformer)this, (IrEnumConstructorCall)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitEnumEntry((IrElementTransformer)this, (IrEnumEntry)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitErrorCallExpression((IrElementTransformer)this, (IrErrorCallExpression)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitErrorDeclaration((IrElementTransformer)this, (IrErrorDeclaration)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitErrorExpression((IrElementTransformer)this, (IrErrorExpression)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitExpression((IrElementTransformer)this, (IrExpression)expression2, (Object)data);
    }

    @NotNull
    public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitExpressionBody((IrElementTransformer)this, (IrExpressionBody)body2, (Object)data);
    }

    @NotNull
    public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitExternalPackageFragment((IrElementTransformer)this, (IrExternalPackageFragment)declaration, (Object)data);
    }

    @NotNull
    public IrStatement visitField(@NotNull IrField declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitField((IrElementTransformer)this, (IrField)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitFieldAccess((IrElementTransformer)this, (IrFieldAccessExpression)expression2, (Object)data);
    }

    @NotNull
    public IrFile visitFile(@NotNull IrFile declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitFile((IrElementTransformer)this, (IrFile)declaration, (Object)data);
    }

    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitFunction((IrElementTransformer)this, (IrFunction)declaration, (Object)data);
    }

    @NotNull
    public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitFunctionAccess((IrElementTransformer)this, (IrFunctionAccessExpression)expression2, (Object)data);
    }

    @NotNull
    public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitFunctionExpression((IrElementTransformer)this, (IrFunctionExpression)expression2, (Object)data);
    }

    @NotNull
    public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitFunctionReference((IrElementTransformer)this, (IrFunctionReference)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitGetClass(@NotNull IrGetClass expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitGetClass((IrElementTransformer)this, (IrGetClass)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitGetEnumValue((IrElementTransformer)this, (IrGetEnumValue)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitGetField((IrElementTransformer)this, (IrGetField)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitGetObjectValue((IrElementTransformer)this, (IrGetObjectValue)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitGetValue((IrElementTransformer)this, (IrGetValue)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall((IrElementTransformer)this, (IrInstanceInitializerCall)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty((IrElementTransformer)this, (IrLocalDelegatedProperty)declaration, (Object)data);
    }

    @NotNull
    public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementTransformer)this, (IrLocalDelegatedPropertyReference)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitLoop(@NotNull IrLoop loop, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitLoop((IrElementTransformer)this, (IrLoop)loop, (Object)data);
    }

    @NotNull
    public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitMemberAccess((IrElementTransformer)this, expression2, (Object)data);
    }

    @NotNull
    public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitModuleFragment((IrElementTransformer)this, (IrModuleFragment)declaration, (Object)data);
    }

    @NotNull
    public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitPackageFragment((IrElementTransformer)this, (IrPackageFragment)declaration, (Object)data);
    }

    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitProperty((IrElementTransformer)this, (IrProperty)declaration, (Object)data);
    }

    @NotNull
    public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitPropertyReference((IrElementTransformer)this, (IrPropertyReference)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitRawFunctionReference((IrElementTransformer)this, (IrRawFunctionReference)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitReturn((IrElementTransformer)this, (IrReturn)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitScript(@NotNull IrScript declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitScript((IrElementTransformer)this, (IrScript)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitSetField((IrElementTransformer)this, (IrSetField)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitSetValue((IrElementTransformer)this, (IrSetValue)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitSimpleFunction((IrElementTransformer)this, (IrSimpleFunction)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitSingletonReference((IrElementTransformer)this, (IrGetSingletonValue)expression2, (Object)data);
    }

    @NotNull
    public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitSpreadElement((IrElementTransformer)this, (IrSpreadElement)spread, (Object)data);
    }

    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitStringConcatenation((IrElementTransformer)this, (IrStringConcatenation)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitSuspendableExpression((IrElementTransformer)this, (IrSuspendableExpression)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitSuspensionPoint((IrElementTransformer)this, (IrSuspensionPoint)expression2, (Object)data);
    }

    @NotNull
    public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitSyntheticBody((IrElementTransformer)this, (IrSyntheticBody)body2, (Object)data);
    }

    @NotNull
    public IrExpression visitThrow(@NotNull IrThrow expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitThrow((IrElementTransformer)this, (IrThrow)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitTry(@NotNull IrTry aTry, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitTry((IrElementTransformer)this, (IrTry)aTry, (Object)data);
    }

    @NotNull
    public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitTypeAlias((IrElementTransformer)this, (IrTypeAlias)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitTypeOperator((IrElementTransformer)this, (IrTypeOperatorCall)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitTypeParameter((IrElementTransformer)this, (IrTypeParameter)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitValueAccess((IrElementTransformer)this, (IrValueAccessExpression)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitValueParameter((IrElementTransformer)this, (IrValueParameter)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitVararg((IrElementTransformer)this, (IrVararg)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitVariable((IrElementTransformer)this, (IrVariable)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression2, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitWhen((IrElementTransformer)this, (IrWhen)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable ClassInfo data) {
        return IrElementTransformer.DefaultImpls.visitWhileLoop((IrElementTransformer)this, (IrWhileLoop)loop, (Object)data);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/AssertionLowering$ClassInfo;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "topLevelClass", "assertionsDisabledField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrField;)V", "getAssertionsDisabledField", "()Lorg/jetbrains/kotlin/ir/declarations/IrField;", "setAssertionsDisabledField", "(Lorg/jetbrains/kotlin/ir/declarations/IrField;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getTopLevelClass", "backend.jvm.lower"})
    public static final class ClassInfo {
        @NotNull
        private final IrClass irClass;
        @NotNull
        private final IrClass topLevelClass;
        @Nullable
        private IrField assertionsDisabledField;

        public ClassInfo(@NotNull IrClass irClass, @NotNull IrClass topLevelClass2, @Nullable IrField assertionsDisabledField) {
            Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
            Intrinsics.checkNotNullParameter((Object)topLevelClass2, (String)"topLevelClass");
            this.irClass = irClass;
            this.topLevelClass = topLevelClass2;
            this.assertionsDisabledField = assertionsDisabledField;
        }

        public /* synthetic */ ClassInfo(IrClass irClass, IrClass irClass2, IrField irField, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                irField = null;
            }
            this(irClass, irClass2, irField);
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        @NotNull
        public final IrClass getTopLevelClass() {
            return this.topLevelClass;
        }

        @Nullable
        public final IrField getAssertionsDisabledField() {
            return this.assertionsDisabledField;
        }

        public final void setAssertionsDisabledField(@Nullable IrField irField) {
            this.assertionsDisabledField = irField;
        }
    }
}

