/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetEnumValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010*\u00020\u000bH\u0002J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/AdditionalClassAnnotationLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "symbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols$JavaAnnotations;", "Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "generateDocumentedAnnotation", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateRepeatableAnnotation", "generateRetentionAnnotation", "generateTargetAnnotation", "loadAnnotationTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "targetEntry", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "lower", "applicableTargetSet", "getValueArgument", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "name", "Lorg/jetbrains/kotlin/name/Name;", "backend.jvm.lower"})
final class AdditionalClassAnnotationLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final JvmSymbols.JavaAnnotations symbols;

    public AdditionalClassAnnotationLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.symbols = this.context.getIr().getSymbols().getJavaAnnotations();
    }

    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        if (!IrUtilsKt.isAnnotationClass((IrClass)irClass)) {
            return;
        }
        this.generateDocumentedAnnotation(irClass);
        this.generateRetentionAnnotation(irClass);
        this.generateTargetAnnotation(irClass);
        this.generateRepeatableAnnotation(irClass);
    }

    private final void generateDocumentedAnnotation(IrClass irClass) {
        block3: {
            block2: {
                if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)irClass), (FqName)StandardNames.FqNames.mustBeDocumented)) break block2;
                IrAnnotationContainer irAnnotationContainer = (IrAnnotationContainer)irClass;
                FqName fqName2 = JvmAnnotationNames.DOCUMENTED_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"DOCUMENTED_ANNOTATION");
                if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)irAnnotationContainer, (FqName)fqName2)) break block3;
            }
            return;
        }
        irClass.setAnnotations(CollectionsKt.plus((Collection)irClass.getAnnotations(), (Object)IrConstructorCallImpl.Companion.fromSymbolOwner$default((IrConstructorCallImpl.Companion)IrConstructorCallImpl.Companion, (int)-1, (int)-1, (IrType)this.symbols.getDocumentedConstructor().getReturnType(), (IrConstructorSymbol)this.symbols.getDocumentedConstructor().getSymbol(), (int)0, null, (int)32, null)));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateRetentionAnnotation(IrClass irClass) {
        void $this$generateRetentionAnnotation_u24lambda_u241;
        IrConstructorCallImpl irConstructorCallImpl;
        KotlinRetention kotlinRetention;
        block5: {
            block4: {
                IrAnnotationContainer irAnnotationContainer = (IrAnnotationContainer)irClass;
                FqName fqName2 = JvmAnnotationNames.RETENTION_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"RETENTION_ANNOTATION");
                if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)irAnnotationContainer, (FqName)fqName2)) {
                    return;
                }
                KotlinRetention kotlinRetentionPolicy = JvmIrUtilsKt.getAnnotationRetention(irClass);
                kotlinRetention = kotlinRetentionPolicy;
                if (kotlinRetention == null) break block4;
                KotlinRetention it = kotlinRetention;
                boolean bl = false;
                IrEnumEntry irEnumEntry = this.symbols.getAnnotationRetentionMap().get((Object)it);
                kotlinRetention = irEnumEntry;
                if (irEnumEntry != null) break block5;
            }
            kotlinRetention = this.symbols.getRpRuntime();
        }
        KotlinRetention javaRetentionPolicy = kotlinRetention;
        IrConstructorCallImpl irConstructorCallImpl2 = irConstructorCallImpl = IrConstructorCallImpl.Companion.fromSymbolOwner$default((IrConstructorCallImpl.Companion)IrConstructorCallImpl.Companion, (int)-1, (int)-1, (IrType)this.symbols.getRetentionConstructor().getReturnType(), (IrConstructorSymbol)this.symbols.getRetentionConstructor().getSymbol(), (int)0, null, (int)32, null);
        Collection collection = irClass.getAnnotations();
        IrClass irClass2 = irClass;
        boolean bl = false;
        $this$generateRetentionAnnotation_u24lambda_u241.putValueArgument(0, (IrExpression)new IrGetEnumValueImpl(-1, -1, (IrType)IrUtilsKt.getDefaultType((IrClass)this.symbols.getRetentionPolicyEnum()), javaRetentionPolicy.getSymbol()));
        Unit unit = Unit.INSTANCE;
        irClass2.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)irConstructorCallImpl));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTargetAnnotation(IrClass irClass) {
        void $this$generateTargetAnnotation_u24lambda_u244;
        void $this$sortedBy$iv;
        Iterable $this$mapNotNullTo$iv;
        IrAnnotationContainer irAnnotationContainer = (IrAnnotationContainer)irClass;
        FqName fqName2 = JvmAnnotationNames.TARGET_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"TARGET_ANNOTATION");
        if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)irAnnotationContainer, (FqName)fqName2)) {
            return;
        }
        Map<KotlinTarget, IrEnumEntry> annotationTargetMap = this.symbols.getAnnotationTargetMap(this.context.getState().getTarget());
        Set<KotlinTarget> set = this.applicableTargetSet(irClass);
        if (set == null) {
            return;
        }
        Set<KotlinTarget> targets = set;
        Iterable iterable = targets;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrEnumEntry it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinTarget it = (KotlinTarget)element$iv;
            boolean bl2 = false;
            if (annotationTargetMap.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        $this$mapNotNullTo$iv = destination$iv;
        boolean $i$f$sortedBy = false;
        List javaTargets = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IrEnumEntry it = (IrEnumEntry)a;
                boolean bl = false;
                String string2 = ((IrEnumEntry)it.getSymbol().getOwner()).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.symbol.owner.name.asString()");
                it = (IrEnumEntry)b;
                Comparable comparable = (Comparable)((Object)ElementType.valueOf(string2));
                bl = false;
                String string3 = ((IrEnumEntry)it.getSymbol().getOwner()).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.symbol.owner.name.asString()");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)ElementType.valueOf(string3))));
            }
        });
        Object object = new IrType[]{(IrType)IrUtilsKt.getDefaultType((IrClass)this.symbols.getElementTypeEnum())};
        IrVarargImpl vararg = new IrVarargImpl(-1, -1, (IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass()), (IrType[])object), (IrType)IrUtilsKt.getDefaultType((IrClass)this.symbols.getElementTypeEnum()));
        object = javaTargets.iterator();
        while (object.hasNext()) {
            IrEnumEntry target = (IrEnumEntry)object.next();
            vararg.getElements().add(new IrGetEnumValueImpl(-1, -1, (IrType)IrUtilsKt.getDefaultType((IrClass)this.symbols.getElementTypeEnum()), target.getSymbol()));
        }
        Object target = object = IrConstructorCallImpl.Companion.fromSymbolOwner$default((IrConstructorCallImpl.Companion)IrConstructorCallImpl.Companion, (int)-1, (int)-1, (IrType)this.symbols.getTargetConstructor().getReturnType(), (IrConstructorSymbol)this.symbols.getTargetConstructor().getSymbol(), (int)0, null, (int)32, null);
        Collection collection = irClass.getAnnotations();
        IrClass irClass2 = irClass;
        boolean bl = false;
        $this$generateTargetAnnotation_u24lambda_u244.putValueArgument(0, (IrExpression)vararg);
        Unit unit = Unit.INSTANCE;
        irClass2.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)object));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateRepeatableAnnotation(IrClass irClass) {
        void $this$generateRepeatableAnnotation_u24lambda_u246;
        Object v2;
        block7: {
            block9: {
                block8: {
                    if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)irClass), (FqName)StandardNames.FqNames.repeatable)) break block8;
                    IrAnnotationContainer irAnnotationContainer = (IrAnnotationContainer)irClass;
                    FqName fqName2 = JvmAnnotationNames.REPEATABLE_ANNOTATION;
                    Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"REPEATABLE_ANNOTATION");
                    if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)irAnnotationContainer, (FqName)fqName2)) break block9;
                }
                return;
            }
            Iterable $this$singleOrNull$iv = irClass.getDeclarations();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof IrClass && Intrinsics.areEqual((Object)((IrClass)it).getName().asString(), (Object)"Container"))) continue;
                if (found$iv) {
                    v2 = null;
                    break block7;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        IrClass irClass2 = v2;
        if (irClass2 == null) {
            throw new IllegalStateException(("Repeatable annotation class should have a container generated: " + RenderIrElementKt.render((IrElement)((IrElement)irClass))).toString());
        }
        IrClass containerClass = irClass2;
        IrConstructorCallImpl irConstructorCallImpl = new IrConstructorCallImpl[]{(IrType)IrUtilsKt.getDefaultType((IrClass)containerClass)};
        IrClassReferenceImpl containerReference = new IrClassReferenceImpl(-1, -1, (IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)this.context.getIrBuiltIns().getKClassClass()), (IrType[])irConstructorCallImpl), (IrClassifierSymbol)containerClass.getSymbol(), (IrType)IrUtilsKt.getDefaultType((IrClass)containerClass));
        IrConstructorCallImpl $i$f$singleOrNull = irConstructorCallImpl = IrConstructorCallImpl.Companion.fromSymbolOwner$default((IrConstructorCallImpl.Companion)IrConstructorCallImpl.Companion, (int)-1, (int)-1, (IrType)this.symbols.getRepeatableConstructor().getReturnType(), (IrConstructorSymbol)this.symbols.getRepeatableConstructor().getSymbol(), (int)0, null, (int)32, null);
        Collection collection = irClass.getAnnotations();
        IrClass irClass3 = irClass;
        boolean bl = false;
        $this$generateRepeatableAnnotation_u24lambda_u246.putValueArgument(0, (IrExpression)containerReference);
        Unit unit = Unit.INSTANCE;
        irClass3.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)irConstructorCallImpl));
    }

    private final IrExpression getValueArgument(IrConstructorCall $this$getValueArgument, Name name) {
        Object v0;
        block2: {
            Iterable iterable = ((IrConstructor)$this$getValueArgument.getSymbol().getOwner()).getValueParameters();
            for (Object t : iterable) {
                IrValueParameter it = (IrValueParameter)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        IrValueParameter irValueParameter = v0;
        if (irValueParameter == null) {
            return null;
        }
        int index2 = irValueParameter.getIndex();
        return $this$getValueArgument.getValueArgument(index2);
    }

    private final Set<KotlinTarget> applicableTargetSet(IrClass $this$applicableTargetSet) {
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation((IrAnnotationContainer)((IrAnnotationContainer)$this$applicableTargetSet), (FqName)StandardNames.FqNames.target);
        if (irConstructorCall == null) {
            return null;
        }
        IrConstructorCall targetEntry = irConstructorCall;
        return this.loadAnnotationTargets(targetEntry);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<KotlinTarget> loadAnnotationTargets(IrConstructorCall targetEntry) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Name name = Name.identifier((String)"allowedTargets");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(Target::allowedTargets.name)");
        IrExpression irExpression = this.getValueArgument(targetEntry, name);
        IrVararg irVararg = irExpression instanceof IrVararg ? (IrVararg)irExpression : null;
        if (irVararg == null) {
            return null;
        }
        IrVararg valueArgument = irVararg;
        Iterable $this$filterIsInstance$iv = valueArgument.getElements();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrGetEnumValue)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinTarget it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrGetEnumValue it = (IrGetEnumValue)element$iv$iv;
            boolean bl2 = false;
            String string2 = ((IrEnumEntry)it.getSymbol().getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.symbol.owner.name.asString()");
            if (KotlinTarget.Companion.valueOrNull(string2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public void lower(@NotNull IrFile irFile) {
        ClassLoweringPass.DefaultImpls.lower((ClassLoweringPass)this, (IrFile)irFile);
    }
}

