/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIntrinsicFunction;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Range;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "kind", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Range$RangeKind;", "(Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Range$RangeKind;)V", "mapRangeTypeToPrimitiveType", "Lorg/jetbrains/org/objectweb/asm/Type;", "rangeType", "toCallable", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "RangeKind", "backend.jvm.codegen"})
public abstract class Range
extends IntrinsicMethod {
    @NotNull
    private final RangeKind kind;

    public Range(@NotNull RangeKind kind) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        this.kind = kind;
    }

    private final Type mapRangeTypeToPrimitiveType(Type rangeType, RangeKind kind) {
        Type type2;
        String fqName2 = rangeType.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"fqName");
        switch (StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)fqName2, (String)"kotlin/ranges/", null, (int)2, null), (String)"Range", null, (int)2, null)) {
            case "Double": {
                Type type3 = Type.DOUBLE_TYPE;
                type2 = type3;
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"DOUBLE_TYPE");
                break;
            }
            case "Float": {
                Type type4 = Type.FLOAT_TYPE;
                type2 = type4;
                Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"FLOAT_TYPE");
                break;
            }
            case "Long": {
                Type type5 = Type.LONG_TYPE;
                type2 = type5;
                Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"LONG_TYPE");
                break;
            }
            case "Int": {
                Type type6 = Type.INT_TYPE;
                type2 = type6;
                Intrinsics.checkNotNullExpressionValue((Object)type6, (String)"INT_TYPE");
                break;
            }
            case "Short": {
                Type type7 = Type.SHORT_TYPE;
                type2 = type7;
                Intrinsics.checkNotNullExpressionValue((Object)type7, (String)"SHORT_TYPE");
                break;
            }
            case "Char": {
                Type type8 = Type.CHAR_TYPE;
                type2 = type8;
                Intrinsics.checkNotNullExpressionValue((Object)type8, (String)"CHAR_TYPE");
                break;
            }
            case "Byte": {
                Type type9 = Type.BYTE_TYPE;
                type2 = type9;
                Intrinsics.checkNotNullExpressionValue((Object)type9, (String)"BYTE_TYPE");
                break;
            }
            default: {
                throw new IllegalStateException(kind.getDesc() + " intrinsic can only work for primitive types: " + fqName2);
            }
        }
        return type2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrIntrinsicFunction toCallable(@NotNull IrFunctionAccessExpression expression2, @NotNull JvmMethodSignature signature, @NotNull JvmBackendContext context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Type type2 = signature.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"signature.returnType");
        Type argType = this.mapRangeTypeToPrimitiveType(type2, this.kind);
        Collection collection = CollectionsKt.listOf((Object)argType);
        List list2 = signature.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"signature.valueParameters");
        Iterable iterable = list2;
        Collection collection2 = collection;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JvmMethodParameterSignature jvmMethodParameterSignature = (JvmMethodParameterSignature)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(argType);
        }
        List list3 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
        return new IrIntrinsicFunction(expression2, signature, context, argType, list3){
            final /* synthetic */ JvmMethodSignature $signature;
            final /* synthetic */ Type $argType;
            {
                this.$signature = $signature;
                this.$argType = $argType;
                super($expression, $signature, $context, $super_call_param$1);
            }

            public void genInvokeInstruction(@NotNull InstructionAdapter v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                Type[] typeArray = new Type[]{this.$argType, this.$argType};
                v.invokespecial(this.$signature.getReturnType().getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])typeArray), false);
            }

            @NotNull
            public StackValue invoke(@NotNull InstructionAdapter v, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data, @NotNull IrFunctionAccessExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                codegen2.markLineNumber((IrElement)expression2);
                v.anew(this.getReturnType());
                v.dup();
                return super.invoke(v, codegen2, data, expression2);
            }
        };
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Range$RangeKind;", "", "desc", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDesc", "()Ljava/lang/String;", "TO", "UNTIL", "backend.jvm.codegen"})
    public static final class RangeKind
    extends Enum<RangeKind> {
        @NotNull
        private final String desc;
        public static final /* enum */ RangeKind TO = new RangeKind("RangeTo");
        public static final /* enum */ RangeKind UNTIL = new RangeKind("RangeUntil");
        private static final /* synthetic */ RangeKind[] $VALUES;

        private RangeKind(String desc) {
            this.desc = desc;
        }

        @NotNull
        public final String getDesc() {
            return this.desc;
        }

        public static RangeKind[] values() {
            return (RangeKind[])$VALUES.clone();
        }

        public static RangeKind valueOf(String value2) {
            return Enum.valueOf(RangeKind.class, value2);
        }

        static {
            $VALUES = rangeKindArray = new RangeKind[]{RangeKind.TO, RangeKind.UNTIL};
        }
    }
}

