/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a4\u0010\u000b\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u001a(\u0010\u000f\u001a\u00020\b*\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\n\u001a\n\u0010\u0018\u001a\u00020\u0017*\u00020\n\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u0015*\u00020\b2\u0006\u0010\u001a\u001a\u00020\n\u00a8\u0006\u001b"}, d2={"translateAccessors", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "result", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "declaration", "Lorg/jetbrains/kotlin/psi/KtProperty;", "addGetterAndSetter", "generateGetter", "Lkotlin/Function0;", "generateSetter", "contextWithPropertyMetadataCreationIntrinsified", "delegatedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "property", "host", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "hasCustomGetter", "", "hasCustomSetter", "translateDelegateOrInitializerExpression", "expression", "js.translator"})
public final class PropertyTranslatorKt {
    public static final void translateAccessors(@NotNull VariableDescriptorWithAccessors descriptor2, @Nullable KtProperty declaration, @NotNull List<JsPropertyInitializer> result2, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (descriptor2 instanceof PropertyDescriptor && (((PropertyDescriptor)descriptor2).getModality() == Modality.ABSTRACT || JsDescriptorUtils.isSimpleFinalProperty((PropertyDescriptor)descriptor2))) {
            return;
        }
        new PropertyTranslator(descriptor2, declaration, context).translate(result2);
    }

    public static final void translateAccessors(@NotNull VariableDescriptorWithAccessors descriptor2, @NotNull List<JsPropertyInitializer> result2, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PropertyTranslatorKt.translateAccessors(descriptor2, null, result2, context);
    }

    public static final void addGetterAndSetter(@NotNull List<JsPropertyInitializer> $this$addGetterAndSetter, @NotNull VariableDescriptorWithAccessors descriptor2, @NotNull Function0<? extends JsPropertyInitializer> generateGetter, @NotNull Function0<? extends JsPropertyInitializer> generateSetter) {
        Intrinsics.checkNotNullParameter($this$addGetterAndSetter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(generateGetter, (String)"generateGetter");
        Intrinsics.checkNotNullParameter(generateSetter, (String)"generateSetter");
        $this$addGetterAndSetter.add((JsPropertyInitializer)generateGetter.invoke());
        if (descriptor2.isVar()) {
            $this$addGetterAndSetter.add((JsPropertyInitializer)generateSetter.invoke());
        }
    }

    @Nullable
    public static final JsExpression translateDelegateOrInitializerExpression(@NotNull TranslationContext $this$translateDelegateOrInitializerExpression, @NotNull KtProperty expression2) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)$this$translateDelegateOrInitializerExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement($this$translateDelegateOrInitializerExpression.bindingContext(), (PsiElement)expression2);
        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors");
        VariableDescriptorWithAccessors propertyDescriptor = (VariableDescriptorWithAccessors)declarationDescriptor;
        KtExpression ktExpression = expression2.getDelegateExpressionOrInitializer();
        if (ktExpression == null) {
            return null;
        }
        KtExpression expressionPsi = ktExpression;
        JsExpression jsExpression2 = Translation.translateAsExpression(expressionPsi, $this$translateDelegateOrInitializerExpression);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"translateAsExpression(expressionPsi, this)");
        JsExpression initializer = jsExpression2;
        ResolvedCall provideDelegateCall = (ResolvedCall)$this$translateDelegateOrInitializerExpression.bindingContext().get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor);
        if (provideDelegateCall != null) {
            TranslationContext innerContext = PropertyTranslatorKt.contextWithPropertyMetadataCreationIntrinsified($this$translateDelegateOrInitializerExpression, provideDelegateCall, propertyDescriptor, new JsThisRef());
            jsExpression = CallTranslator.translate(innerContext, provideDelegateCall, initializer);
        } else {
            jsExpression = TranslationUtils.coerce($this$translateDelegateOrInitializerExpression, initializer, propertyDescriptor.getType());
        }
        return jsExpression;
    }

    @NotNull
    public static final TranslationContext contextWithPropertyMetadataCreationIntrinsified(@NotNull TranslationContext $this$contextWithPropertyMetadataCreationIntrinsified, @NotNull ResolvedCall<FunctionDescriptor> delegatedCall, @NotNull VariableDescriptorWithAccessors property, @NotNull JsExpression host) {
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter((Object)$this$contextWithPropertyMetadataCreationIntrinsified, (String)"<this>");
        Intrinsics.checkNotNullParameter(delegatedCall, (String)"delegatedCall");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        List<ResolvedValueArgument> list2 = delegatedCall.getValueArgumentsByIndex();
        Intrinsics.checkNotNull(list2);
        ResolvedValueArgument resolvedValueArgument = list2.get(0);
        Intrinsics.checkNotNull((Object)resolvedValueArgument, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument");
        ValueArgument valueArgument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument();
        Intrinsics.checkNotNull((Object)valueArgument);
        KtExpression hostExpression = valueArgument.getArgumentExpression();
        List<ResolvedValueArgument> list3 = delegatedCall.getValueArgumentsByIndex();
        Intrinsics.checkNotNull(list3);
        ResolvedValueArgument resolvedValueArgument2 = list3.get(1);
        Intrinsics.checkNotNull((Object)resolvedValueArgument2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument");
        ValueArgument valueArgument2 = ((ExpressionValueArgument)resolvedValueArgument2).getValueArgument();
        Intrinsics.checkNotNull((Object)valueArgument2);
        KtExpression fakeArgumentExpression = valueArgument2.getArgumentExpression();
        Pair[] $this$contextWithPropertyMetadataCreationIntrinsified_u24lambda_u2d0 = pairArray = JsAstUtils.pureFqn($this$contextWithPropertyMetadataCreationIntrinsified.getVariableForPropertyMetadata(property), null);
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$contextWithPropertyMetadataCreationIntrinsified_u24lambda_u2d0, (String)"");
        MetadataProperties.setSynthetic((HasMetadata)$this$contextWithPropertyMetadataCreationIntrinsified_u24lambda_u2d0, true);
        Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"pureFqn(getVariableForPr\u2026pply { synthetic = true }");
        Pair[] metadataRef = pairArray;
        pairArray = new Pair[]{TuplesKt.to((Object)hostExpression, (Object)host), TuplesKt.to((Object)fakeArgumentExpression, (Object)metadataRef)};
        TranslationContext translationContext = $this$contextWithPropertyMetadataCreationIntrinsified.innerContextWithAliasesForExpressions(MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"innerContextWithAliasesF\u2026ion to metadataRef\n    ))");
        return translationContext;
    }

    public static final boolean hasCustomGetter(@NotNull KtProperty $this$hasCustomGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCustomGetter, (String)"<this>");
        KtPropertyAccessor ktPropertyAccessor = $this$hasCustomGetter.getGetter();
        return ktPropertyAccessor != null ? ktPropertyAccessor.hasBody() : false;
    }

    public static final boolean hasCustomSetter(@NotNull KtProperty $this$hasCustomSetter) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCustomSetter, (String)"<this>");
        KtPropertyAccessor ktPropertyAccessor = $this$hasCustomSetter.getSetter();
        return ktPropertyAccessor != null ? ktPropertyAccessor.hasBody() : false;
    }
}

