/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeReconstructionResult;

public class TypeReconstructionUtil {
    @NotNull
    public static KotlinType reconstructBareType(@NotNull KtTypeReference right, @NotNull PossiblyBareType possiblyBareTarget, @Nullable KotlinType subjectType, @NotNull BindingTrace trace, @NotNull KotlinBuiltIns builtIns) {
        KotlinType targetType;
        TypeReconstructionResult reconstructionResult;
        if (right == null) {
            TypeReconstructionUtil.$$$reportNull$$$0(0);
        }
        if (possiblyBareTarget == null) {
            TypeReconstructionUtil.$$$reportNull$$$0(1);
        }
        if (trace == null) {
            TypeReconstructionUtil.$$$reportNull$$$0(2);
        }
        if (builtIns == null) {
            TypeReconstructionUtil.$$$reportNull$$$0(3);
        }
        if (subjectType == null) {
            subjectType = builtIns.getAnyType();
        }
        if (!(reconstructionResult = possiblyBareTarget.reconstruct(subjectType)).isAllArgumentsInferred()) {
            TypeConstructor typeConstructor2 = possiblyBareTarget.getBareTypeConstructor();
            trace.report(Errors.NO_TYPE_ARGUMENTS_ON_RHS.on(right, typeConstructor2.getParameters().size(), TypeReconstructionUtil.allStarProjectionsString(typeConstructor2)));
        }
        if ((targetType = reconstructionResult.getResultingType()) != null) {
            if (possiblyBareTarget.isBare()) {
                trace.record(BindingContext.TYPE, right, targetType);
            }
            KotlinType kotlinType = targetType;
            if (kotlinType == null) {
                TypeReconstructionUtil.$$$reportNull$$$0(4);
            }
            return kotlinType;
        }
        SimpleType simpleType2 = ErrorUtils.createErrorType("Failed to reconstruct type: " + right.getText());
        if (simpleType2 == null) {
            TypeReconstructionUtil.$$$reportNull$$$0(5);
        }
        return simpleType2;
    }

    @NotNull
    private static String allStarProjectionsString(@NotNull TypeConstructor constructor) {
        if (constructor == null) {
            TypeReconstructionUtil.$$$reportNull$$$0(6);
        }
        int size = constructor.getParameters().size();
        assert (size != 0) : "No projections possible for a nilary type constructor" + constructor;
        ClassifierDescriptor declarationDescriptor = constructor.getDeclarationDescriptor();
        assert (declarationDescriptor != null) : "No declaration descriptor for type constructor " + constructor;
        String name = declarationDescriptor.getName().asString();
        return TypeReconstructionUtil.getTypeNameAndStarProjectionsString(name, size);
    }

    @NotNull
    public static String getTypeNameAndStarProjectionsString(@NotNull String name, int size) {
        if (name == null) {
            TypeReconstructionUtil.$$$reportNull$$$0(7);
        }
        StringBuilder builder2 = new StringBuilder(name);
        builder2.append("<");
        for (int i = 0; i < size; ++i) {
            builder2.append("*");
            if (i == size - 1) break;
            builder2.append(", ");
        }
        builder2.append(">");
        String string2 = builder2.toString();
        if (string2 == null) {
            TypeReconstructionUtil.$$$reportNull$$$0(8);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possiblyBareTarget";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/expressions/TypeReconstructionUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/TypeReconstructionUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "reconstructBareType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNameAndStarProjectionsString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reconstructBareType";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "allStarProjectionsString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTypeNameAndStarProjectionsString";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

