/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\t*\u00020\f\u001a\n\u0010\r\u001a\u00020\t*\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\t*\u00020\u000e\u001a\n\u0010\u0010\u001a\u00020\t*\u00020\u000e\u001a$\u0010\u0011\u001a\u00020\t*\u00020\u000e2\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015H\u0002\u001a\n\u0010\u0016\u001a\u00020\t*\u00020\u0017\u001a\f\u0010\u0018\u001a\u0004\u0018\u00010\u000e*\u00020\u000e\u001a\f\u0010\u0019\u001a\u0004\u0018\u00010\u000e*\u00020\u000e\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"JVM_INLINE_ANNOTATION_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "getJVM_INLINE_ANNOTATION_CLASS_ID", "()Lorg/jetbrains/kotlin/name/ClassId;", "JVM_INLINE_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getJVM_INLINE_ANNOTATION_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "isGetterOfUnderlyingPropertyOfInlineClass", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isInlineClass", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isInlineClassType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isNullableUnderlyingType", "isRecursiveInlineClassType", "isRecursiveInlineClassTypeInner", "visited", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "Lkotlin/collections/HashSet;", "isUnderlyingPropertyOfInlineClass", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "substitutedUnderlyingType", "unsubstitutedUnderlyingType", "descriptors"})
public final class InlineClassesUtilsKt {
    @NotNull
    private static final FqName JVM_INLINE_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmInline");
    @NotNull
    private static final ClassId JVM_INLINE_ANNOTATION_CLASS_ID;

    @NotNull
    public static final FqName getJVM_INLINE_ANNOTATION_FQ_NAME() {
        return JVM_INLINE_ANNOTATION_FQ_NAME;
    }

    @NotNull
    public static final ClassId getJVM_INLINE_ANNOTATION_CLASS_ID() {
        return JVM_INLINE_ANNOTATION_CLASS_ID;
    }

    public static final boolean isInlineClass(@NotNull DeclarationDescriptor $this$isInlineClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineClass, (String)"<this>");
        return $this$isInlineClass instanceof ClassDescriptor && (((ClassDescriptor)$this$isInlineClass).isInline() || ((ClassDescriptor)$this$isInlineClass).isValue());
    }

    @Nullable
    public static final KotlinType unsubstitutedUnderlyingType(@NotNull KotlinType $this$unsubstitutedUnderlyingType) {
        InlineClassRepresentation<SimpleType> inlineClassRepresentation2;
        Intrinsics.checkNotNullParameter((Object)$this$unsubstitutedUnderlyingType, (String)"<this>");
        ClassifierDescriptor $this$safeAs$iv = $this$unsubstitutedUnderlyingType.getConstructor().getDeclarationDescriptor();
        boolean $i$f$safeAs = false;
        ClassifierDescriptor classifierDescriptor = $this$safeAs$iv;
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return (inlineClassRepresentation2 = (InlineClassRepresentation<SimpleType>)classifierDescriptor) != null && (inlineClassRepresentation2 = inlineClassRepresentation2.getInlineClassRepresentation()) != null ? (SimpleType)inlineClassRepresentation2.getUnderlyingType() : null;
    }

    public static final boolean isInlineClassType(@NotNull KotlinType $this$isInlineClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineClassType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isInlineClassType.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? InlineClassesUtilsKt.isInlineClass(classifierDescriptor) : false;
    }

    @Nullable
    public static final KotlinType substitutedUnderlyingType(@NotNull KotlinType $this$substitutedUnderlyingType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$substitutedUnderlyingType, (String)"<this>");
        KotlinType kotlinType2 = InlineClassesUtilsKt.unsubstitutedUnderlyingType($this$substitutedUnderlyingType);
        if (kotlinType2 != null) {
            KotlinType it = kotlinType2;
            boolean bl = false;
            kotlinType = TypeSubstitutor.create($this$substitutedUnderlyingType).substitute(it, Variance.INVARIANT);
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    public static final boolean isRecursiveInlineClassType(@NotNull KotlinType $this$isRecursiveInlineClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$isRecursiveInlineClassType, (String)"<this>");
        return InlineClassesUtilsKt.isRecursiveInlineClassTypeInner($this$isRecursiveInlineClassType, new HashSet<ClassifierDescriptor>());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isRecursiveInlineClassTypeInner(KotlinType $this$isRecursiveInlineClassTypeInner, HashSet<ClassifierDescriptor> visited2) {
        KotlinType it;
        ClassifierDescriptor classifierDescriptor = $this$isRecursiveInlineClassTypeInner.getConstructor().getDeclarationDescriptor();
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        if (classifierDescriptor == null) return false;
        if ((classifierDescriptor2 = classifierDescriptor2.getOriginal()) == null) {
            return false;
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor2;
        if (!visited2.add(descriptor2)) {
            return true;
        }
        ClassifierDescriptor classifierDescriptor3 = descriptor2;
        if (classifierDescriptor3 instanceof ClassDescriptor) {
            if (!InlineClassesUtilsKt.isInlineClass(descriptor2)) return false;
            KotlinType kotlinType = InlineClassesUtilsKt.unsubstitutedUnderlyingType($this$isRecursiveInlineClassTypeInner);
            if (kotlinType == null) return false;
            if (!InlineClassesUtilsKt.isRecursiveInlineClassTypeInner(kotlinType, visited2)) return false;
            return true;
        }
        if (!(classifierDescriptor3 instanceof TypeParameterDescriptor)) return false;
        List<KotlinType> list2 = ((TypeParameterDescriptor)descriptor2).getUpperBounds();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.upperBounds");
        Iterable $this$any$iv = list2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (KotlinType)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        } while (!InlineClassesUtilsKt.isRecursiveInlineClassTypeInner(it, visited2));
        return true;
    }

    public static final boolean isNullableUnderlyingType(@NotNull KotlinType $this$isNullableUnderlyingType) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableUnderlyingType, (String)"<this>");
        if (!InlineClassesUtilsKt.isInlineClassType($this$isNullableUnderlyingType)) {
            return false;
        }
        KotlinType kotlinType = InlineClassesUtilsKt.unsubstitutedUnderlyingType($this$isNullableUnderlyingType);
        if (kotlinType == null) {
            return false;
        }
        KotlinType underlyingType = kotlinType;
        return TypeUtils.isNullableType(underlyingType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGetterOfUnderlyingPropertyOfInlineClass(@NotNull CallableDescriptor $this$isGetterOfUnderlyingPropertyOfInlineClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isGetterOfUnderlyingPropertyOfInlineClass, (String)"<this>");
        if (!($this$isGetterOfUnderlyingPropertyOfInlineClass instanceof PropertyGetterDescriptor)) return false;
        PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)$this$isGetterOfUnderlyingPropertyOfInlineClass).getCorrespondingProperty();
        Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"correspondingProperty");
        if (!InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass(propertyDescriptor)) return false;
        return true;
    }

    public static final boolean isUnderlyingPropertyOfInlineClass(@NotNull VariableDescriptor $this$isUnderlyingPropertyOfInlineClass) {
        DeclarationDescriptor declarationDescriptor;
        InlineClassRepresentation<SimpleType> inlineClassRepresentation2;
        Intrinsics.checkNotNullParameter((Object)$this$isUnderlyingPropertyOfInlineClass, (String)"<this>");
        return $this$isUnderlyingPropertyOfInlineClass.getExtensionReceiverParameter() == null && Intrinsics.areEqual((Object)((inlineClassRepresentation2 = (declarationDescriptor = $this$isUnderlyingPropertyOfInlineClass.getContainingDeclaration()) instanceof ClassDescriptor ? (InlineClassRepresentation<SimpleType>)declarationDescriptor : null) != null && (inlineClassRepresentation2 = inlineClassRepresentation2.getInlineClassRepresentation()) != null ? inlineClassRepresentation2.getUnderlyingPropertyName() : null), (Object)$this$isUnderlyingPropertyOfInlineClass.getName());
    }

    static {
        ClassId classId = ClassId.topLevel((FqName)JVM_INLINE_ANNOTATION_FQ_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(JVM_INLINE_ANNOTATION_FQ_NAME)");
        JVM_INLINE_ANNOTATION_CLASS_ID = classId;
    }
}

