/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendException;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrThrowImpl;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.BodyGenerator;
import org.jetbrains.kotlin.psi2ir.generators.BranchingExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.DelegatedPropertyGenerator;
import org.jetbrains.kotlin.psi2ir.generators.ErrorExpressionException;
import org.jetbrains.kotlin.psi2ir.generators.ErrorExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.Generator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorWithScope;
import org.jetbrains.kotlin.psi2ir.generators.LocalClassGenerator;
import org.jetbrains.kotlin.psi2ir.generators.LocalFunctionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.LoopExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.OperatorExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.ReflectionReferencesGenerator;
import org.jetbrains.kotlin.psi2ir.generators.TryCatchExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilder;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilderKt;
import org.jetbrains.kotlin.psi2ir.intermediate.IntermediateValue;
import org.jetbrains.kotlin.psi2ir.intermediate.RematerializableValueKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00012\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%J\u000e\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(J&\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\f\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u00010,H\u0002J(\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u000e\u00106\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(J\"\u00107\u001a\b\u0012\u0004\u0012\u00020\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020#0:2\u0006\u0010;\u001a\u00020\u001dJ&\u0010<\u001a\u00020!2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CJ\u0010\u0010D\u001a\u00020E2\u0006\u0010\"\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020H2\u0006\u0010B\u001a\u00020CH\u0002J\b\u0010I\u001a\u00020EH\u0002J\u001a\u0010J\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010M\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020N2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010O\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020P2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010Q\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020R2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010S\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020T2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010U\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020V2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010W\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020X2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010Y\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020Z2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010[\u001a\u00020\u00022\u0006\u0010\\\u001a\u00020]2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010^\u001a\u00020!2\u0006\u0010\"\u001a\u00020_2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010`\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020a2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010b\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010c\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020d2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010e\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020f2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010g\u001a\u00020\u00022\u0006\u0010h\u001a\u00020i2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010j\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010k\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020l2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010m\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020n2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010o\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020p2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010q\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020r2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010s\u001a\u00020\u00022\u0006\u0010h\u001a\u00020t2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010u\u001a\u00020\u00022\u0006\u0010v\u001a\u00020w2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010x\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020y2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010z\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020{2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010|\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020}2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010~\u001a\u00020\u00022\u0006\u0010\u007f\u001a\u00020/2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001b\u0010\u0080\u0001\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020F2\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0081\u0001\u001a\u00020\u00022\u0007\u0010\"\u001a\u00030\u0082\u00012\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0083\u0001\u001a\u00020!2\u0007\u0010\"\u001a\u00030\u0084\u00012\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0085\u0001\u001a\u00020\u00022\u0007\u0010h\u001a\u00030\u0086\u00012\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0087\u0001\u001a\u00020\u00022\u0007\u0010\"\u001a\u00030\u0088\u00012\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0089\u0001\u001a\u00020!2\u0007\u0010\"\u001a\u00030\u008a\u00012\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u008b\u0001\u001a\u00020\u00022\u0007\u0010\"\u001a\u00030\u008c\u00012\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u008d\u0001\u001a\u00020\u00022\u0007\u0010\"\u001a\u00030\u008e\u00012\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001d\u0010\u008f\u0001\u001a\u00020\u00022\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0092\u0001\u001a\u00020\u00022\u0007\u0010\"\u001a\u00030\u0093\u00012\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0094\u0001\u001a\u00020\u00022\u0007\u0010\"\u001a\u00030\u0095\u00012\b\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u0019\u0010\u0096\u0001\u001a\b\u0012\u0004\u0012\u00020!0:*\b\u0012\u0004\u0012\u00020!0:H\u0002J\f\u0010\u0097\u0001\u001a\u00030\u0098\u0001*\u00020AR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0099\u0001"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/ir/IrStatement;", "", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorWithScope;", "bodyGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/BodyGenerator;", "scope", "Lorg/jetbrains/kotlin/ir/builders/Scope;", "(Lorg/jetbrains/kotlin/psi2ir/generators/BodyGenerator;Lorg/jetbrains/kotlin/ir/builders/Scope;)V", "getBodyGenerator", "()Lorg/jetbrains/kotlin/psi2ir/generators/BodyGenerator;", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "getContext", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "getScope", "()Lorg/jetbrains/kotlin/ir/builders/Scope;", "scopeOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getScopeOwner", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "declareComponentVariablesInBlock", "", "multiDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "irBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementContainer;", "containerValue", "Lorg/jetbrains/kotlin/psi2ir/intermediate/IntermediateValue;", "generateConstantExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "generateExpression", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "generateExpressionForReferencedDescriptor", "descriptor", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "generateLocalDelegatedProperty", "ktProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "ktDelegate", "Lorg/jetbrains/kotlin/psi/KtPropertyDelegate;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "scopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "generateStatement", "generateStatements", "", "ktStatements", "", "to", "generateThisReceiver", "startOffset", "", "endOffset", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getReturnExpressionTarget", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "isThisForClassPhysicallyAvailable", "", "scopeOwnerAsCallable", "visitArrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "data", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitBlockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "visitBreakExpression", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitCallableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "visitClassLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "visitClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "visitContinueExpression", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "visitDestructuringDeclaration", "visitDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "visitDotQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "visitEscapeStringTemplateEntry", "entry", "Lorg/jetbrains/kotlin/psi/KtEscapeStringTemplateEntry;", "visitExpression", "visitForExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitLiteralStringTemplateEntry", "Lorg/jetbrains/kotlin/psi/KtLiteralStringTemplateEntry;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitObjectLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "visitPostfixExpression", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "visitPrefixExpression", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "visitProperty", "property", "visitReturnExpression", "visitSafeQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitStringTemplateEntryWithExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntryWithExpression;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitThisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "visitThrowExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "visitTryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "postprocessStringTemplateEntries", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ir.psi2ir"})
public final class StatementGenerator
extends KtVisitor
implements GeneratorWithScope {
    @NotNull
    private final BodyGenerator bodyGenerator;
    @NotNull
    private final Scope scope;
    @NotNull
    private final TypeTranslator typeTranslator;

    public StatementGenerator(@NotNull BodyGenerator bodyGenerator, @NotNull Scope scope) {
        Intrinsics.checkNotNullParameter((Object)bodyGenerator, (String)"bodyGenerator");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.bodyGenerator = bodyGenerator;
        this.scope = scope;
        this.typeTranslator = this.getContext().getTypeTranslator();
    }

    @NotNull
    public final BodyGenerator getBodyGenerator() {
        return this.bodyGenerator;
    }

    @NotNull
    public Scope getScope() {
        return this.scope;
    }

    @Override
    @NotNull
    public GeneratorContext getContext() {
        return this.bodyGenerator.getContext();
    }

    @NotNull
    public final DeclarationDescriptor getScopeOwner() {
        return this.bodyGenerator.getScopeOwner();
    }

    @NotNull
    public final IrType toIrType(@NotNull KotlinType $this$toIrType) {
        Intrinsics.checkNotNullParameter((Object)$this$toIrType, (String)"<this>");
        return this.typeTranslator.translateType($this$toIrType);
    }

    @NotNull
    public final IrStatement generateStatement(@NotNull KtElement ktElement) {
        IrStatement irStatement;
        Intrinsics.checkNotNullParameter((Object)ktElement, (String)"ktElement");
        try {
            irStatement = (IrStatement)KotlinUtilsKt.deparenthesize(ktElement).accept((KtVisitor)this, null);
        }
        catch (BackendException e) {
            throw e;
        }
        catch (ErrorExpressionException e) {
            throw e;
        }
        catch (Throwable e) {
            irStatement = (IrStatement)new ErrorExpressionGenerator(this).generateErrorExpression(ktElement, e);
        }
        return irStatement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IrStatement> generateStatements(@NotNull List<? extends KtExpression> ktStatements, @NotNull IrStatementContainer to) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(ktStatements, (String)"ktStatements");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Iterable iterable = ktStatements;
        Collection destination$iv = to.getStatements();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            KtExpression ktExpression = (KtExpression)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(this.generateStatement((KtElement)it));
        }
        return (List)destination$iv;
    }

    @NotNull
    public final IrExpression generateExpression(@NotNull KtElement ktElement) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)ktElement, (String)"ktElement");
        IrStatement irStatement = this.generateStatement(ktElement);
        if (irStatement instanceof IrExpression) {
            irExpression = (IrExpression)irStatement;
        } else if (irStatement instanceof IrDeclaration) {
            irExpression = (IrExpression)new IrBlockImpl(irStatement.getStartOffset(), irStatement.getEndOffset(), this.getContext().getIrBuiltIns().getUnitType(), null, CollectionsKt.listOf((Object)irStatement));
        } else {
            throw new AssertionError((Object)("Unexpected statement: " + RenderIrElementKt.render((IrElement)((IrElement)irStatement))));
        }
        return irExpression;
    }

    @NotNull
    public IrStatement visitExpression(@NotNull KtExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        int n = PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)expression2));
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)expression2));
        IrType irType = this.getContext().getIrBuiltIns().getNothingType();
        String string2 = expression2.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"expression::class.java.simpleName");
        return (IrStatement)new IrErrorExpressionImpl(n, n2, irType, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrStatement visitProperty(@NotNull KtProperty property, @Nullable Void data) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Generator generator = this;
        WritableSlice<PsiElement, VariableDescriptor> writableSlice = BindingContext.VARIABLE;
        Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"VARIABLE");
        VariableDescriptor variableDescriptor = (VariableDescriptor)GeneratorKt.getOrFail(generator, writableSlice, property);
        KtPropertyDelegate ktPropertyDelegate = property.getDelegate();
        if (ktPropertyDelegate != null) {
            KtPropertyDelegate ktDelegate = ktPropertyDelegate;
            boolean bl = false;
            VariableDescriptor variableDescriptor2 = variableDescriptor;
            if (variableDescriptor2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors");
            }
            return this.generateLocalDelegatedProperty(property, ktDelegate, (VariableDescriptorWithAccessors)variableDescriptor2, this.bodyGenerator.getScopeOwnerSymbol());
        }
        SymbolTable symbolTable = this.getContext().getSymbolTable();
        int n = PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)property));
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)property));
        IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)IrDeclarationOrigin.DEFINED.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)variableDescriptor, (String)"variableDescriptor");
        VariableDescriptor variableDescriptor3 = variableDescriptor;
        KotlinType kotlinType = variableDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"variableDescriptor.type");
        IrType irType = this.toIrType(kotlinType);
        KtExpression ktExpression = property.getInitializer();
        if (ktExpression != null) {
            void it;
            KtExpression ktDelegate = ktExpression;
            IrType irType2 = irType;
            VariableDescriptor variableDescriptor4 = variableDescriptor3;
            IrDeclarationOrigin irDeclarationOrigin2 = irDeclarationOrigin;
            int n3 = n2;
            int n4 = n;
            SymbolTable symbolTable2 = symbolTable;
            boolean bl = false;
            IrExpression irExpression2 = this.generateExpression((KtElement)it);
            symbolTable = symbolTable2;
            n = n4;
            n2 = n3;
            irDeclarationOrigin = irDeclarationOrigin2;
            variableDescriptor3 = variableDescriptor4;
            irType = irType2;
            irExpression = irExpression2;
        } else {
            irExpression = null;
        }
        return (IrStatement)symbolTable.declareVariable(n, n2, irDeclarationOrigin, variableDescriptor3, irType, irExpression);
    }

    private final IrStatement generateLocalDelegatedProperty(KtProperty ktProperty, KtPropertyDelegate ktDelegate, VariableDescriptorWithAccessors variableDescriptor, IrSymbol scopeOwnerSymbol) {
        return (IrStatement)new DelegatedPropertyGenerator(this.getContext()).generateLocalDelegatedProperty(ktProperty, ktDelegate, variableDescriptor, scopeOwnerSymbol);
    }

    @NotNull
    public IrStatement visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)multiDeclaration, (String)"multiDeclaration");
        IrCompositeImpl irBlock = new IrCompositeImpl(PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)multiDeclaration)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)multiDeclaration)), this.getContext().getIrBuiltIns().getUnitType(), (IrStatementOrigin)IrStatementOrigin.DESTRUCTURING_DECLARATION.INSTANCE);
        KtExpression ktExpression = multiDeclaration.getInitializer();
        Intrinsics.checkNotNull((Object)ktExpression);
        KtExpression ktInitializer = ktExpression;
        IntermediateValue containerValue = RematerializableValueKt.createTemporaryVariableInBlock(this.getScope(), this.getContext(), this.generateExpression((KtElement)ktInitializer), (IrStatementContainer)irBlock, "container");
        this.declareComponentVariablesInBlock(multiDeclaration, (IrStatementContainer)irBlock, containerValue);
        return (IrStatement)irBlock;
    }

    public final void declareComponentVariablesInBlock(@NotNull KtDestructuringDeclaration multiDeclaration, @NotNull IrStatementContainer irBlock, @NotNull IntermediateValue containerValue) {
        Intrinsics.checkNotNullParameter((Object)multiDeclaration, (String)"multiDeclaration");
        Intrinsics.checkNotNullParameter((Object)irBlock, (String)"irBlock");
        Intrinsics.checkNotNullParameter((Object)containerValue, (String)"containerValue");
        CallGenerator callGenerator = new CallGenerator(this);
        Iterator iterator2 = multiDeclaration.getEntries().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            KtDestructuringDeclarationEntry ktEntry = (KtDestructuringDeclarationEntry)iterator2.next();
            Generator generator = this;
            WritableSlice<KtDestructuringDeclarationEntry, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.COMPONENT_RESOLVED_CALL;
            Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"COMPONENT_RESOLVED_CALL");
            ResolvedCall componentResolvedCall = (ResolvedCall)GeneratorKt.getOrFail(generator, writableSlice, ktEntry);
            Intrinsics.checkNotNullExpressionValue((Object)componentResolvedCall, (String)"componentResolvedCall");
            CallBuilder componentSubstitutedCall = ArgumentsGenerationUtilsKt.pregenerateCall(this, componentResolvedCall);
            CallBuilderKt.setExplicitReceiverValue(componentSubstitutedCall, containerValue);
            Generator generator2 = this;
            WritableSlice<PsiElement, VariableDescriptor> writableSlice2 = BindingContext.VARIABLE;
            Intrinsics.checkNotNullExpressionValue(writableSlice2, (String)"VARIABLE");
            VariableDescriptor componentVariable = (VariableDescriptor)GeneratorKt.getOrFail(generator2, writableSlice2, ktEntry);
            if (componentVariable.getName().isSpecial()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)ktEntry, (String)"ktEntry");
            IrExpression irComponentCall = callGenerator.generateCall(PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)ktEntry)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktEntry)), componentSubstitutedCall, (IrStatementOrigin)IrStatementOrigin.COMPONENT_N.Companion.withIndex(index2 + 1));
            SymbolTable symbolTable = this.getContext().getSymbolTable();
            int n2 = PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)ktEntry));
            int n3 = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktEntry));
            IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)IrDeclarationOrigin.DEFINED.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)componentVariable, (String)"componentVariable");
            KotlinType kotlinType = componentVariable.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"componentVariable.type");
            IrVariable irComponentVar = symbolTable.declareVariable(n2, n3, irDeclarationOrigin, componentVariable, this.toIrType(kotlinType), irComponentCall);
            irBlock.getStatements().add(irComponentVar);
        }
    }

    @NotNull
    public IrStatement visitBlockExpression(@NotNull KtBlockExpression expression2, @Nullable Void data) {
        boolean isBlockBody;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        boolean bl = isBlockBody = expression2.getParent() instanceof KtDeclarationWithBody && !(expression2.getParent() instanceof KtFunctionLiteral);
        if (isBlockBody) {
            throw new AssertionError((Object)"Use IrBlockBody and corresponding body generator to generate blocks as function bodies");
        }
        KotlinType returnType = GeneratorKt.getExpressionTypeWithCoercionToUnitOrFail(this, (KtExpression)expression2);
        IrBlockImpl irBlock = new IrBlockImpl(PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)expression2)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)expression2)), this.toIrType(returnType), null, 8, null);
        List list2 = expression2.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expression.statements");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression it = (KtExpression)element$iv;
            boolean bl2 = false;
            List list3 = irBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            list3.add(this.generateStatement((KtElement)it));
        }
        return (IrStatement)irBlock;
    }

    @NotNull
    public IrStatement visitReturnExpression(@NotNull KtReturnExpression expression2, @Nullable Void data) {
        KtExpression ktExpression;
        CallableDescriptor returnTarget;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                returnTarget = this.getReturnExpressionTarget(expression2);
                ktExpression = expression2.getReturnedExpression();
                if (ktExpression == null) break block2;
                KtExpression it = ktExpression;
                boolean bl = false;
                IrExpression irExpression = this.generateExpression((KtElement)it);
                ktExpression = irExpression;
                if (irExpression != null) break block3;
            }
            ktExpression = (IrExpression)new IrGetObjectValueImpl(PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)expression2)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)expression2)), this.getContext().getIrBuiltIns().getUnitType(), this.getContext().getIrBuiltIns().getUnitClass());
        }
        KtExpression irReturnedExpression = ktExpression;
        return (IrStatement)new IrReturnImpl(PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)expression2)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)expression2)), this.getContext().getIrBuiltIns().getNothingType(), (IrReturnTargetSymbol)IrUtilsKt.referenceFunction((ReferenceSymbolTable)((ReferenceSymbolTable)this.getContext().getSymbolTable()), (CallableDescriptor)returnTarget), (IrExpression)irReturnedExpression);
    }

    private final CallableDescriptor scopeOwnerAsCallable() {
        DeclarationDescriptor declarationDescriptor = this.getScopeOwner();
        CallableDescriptor callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
        if (callableDescriptor == null) {
            throw new AssertionError((Object)("'return' in a non-callable: " + this.getScopeOwner()));
        }
        return callableDescriptor;
    }

    private final CallableDescriptor getReturnExpressionTarget(KtReturnExpression expression2) {
        CallableDescriptor callableDescriptor;
        if (!ExpressionTypingUtils.isFunctionLiteral(this.getScopeOwner()) && !ExpressionTypingUtils.isFunctionExpression(this.getScopeOwner())) {
            callableDescriptor = this.scopeOwnerAsCallable();
        } else {
            CallableDescriptor callableDescriptor2;
            KtSimpleNameExpression label = expression2.getTargetLabel();
            if (label != null) {
                DeclarationDescriptor labelTargetDescriptor;
                Generator generator = this;
                WritableSlice<KtReferenceExpression, PsiElement> writableSlice = BindingContext.LABEL_TARGET;
                Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"LABEL_TARGET");
                PsiElement labelTarget = (PsiElement)GeneratorKt.getOrFail(generator, writableSlice, label);
                Generator generator2 = this;
                ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
                Intrinsics.checkNotNullExpressionValue(readOnlySlice, (String)"DECLARATION_TO_DESCRIPTOR");
                DeclarationDescriptor declarationDescriptor = labelTargetDescriptor = GeneratorKt.getOrFail(generator2, readOnlySlice, labelTarget);
                if (declarationDescriptor == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
                }
                callableDescriptor2 = (CallableDescriptor)declarationDescriptor;
            } else {
                callableDescriptor2 = ExpressionTypingUtils.isFunctionLiteral(this.getScopeOwner()) ? (CallableDescriptor)BindingContextUtils.getContainingFunctionSkipFunctionLiterals((DeclarationDescriptor)this.getScopeOwner(), (boolean)true).first : this.scopeOwnerAsCallable();
            }
            CallableDescriptor callableDescriptor3 = callableDescriptor2;
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor3, (String)"{\n            val label \u2026}\n            }\n        }");
            callableDescriptor = callableDescriptor3;
        }
        return callableDescriptor;
    }

    @NotNull
    public IrStatement visitThrowExpression(@NotNull KtThrowExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        int n = PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)expression2));
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)expression2));
        IrType irType = this.getContext().getIrBuiltIns().getNothingType();
        KtExpression ktExpression = expression2.getThrownExpression();
        Intrinsics.checkNotNull((Object)ktExpression);
        return (IrStatement)new IrThrowImpl(n, n2, irType, this.generateExpression((KtElement)ktExpression));
    }

    @NotNull
    public IrExpression visitConstantExpression(@NotNull KtConstantExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant((KtExpression)expression2, this.getContext().getBindingContext());
        if (compileTimeConstant == null) {
            throw new IllegalStateException(("KtConstantExpression was not evaluated: " + expression2.getText()).toString());
        }
        return this.generateConstantExpression((KtExpression)expression2, compileTimeConstant);
    }

    @NotNull
    public final IrExpression generateConstantExpression(@NotNull KtExpression expression2, @NotNull CompileTimeConstant<?> constant) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(constant, (String)"constant");
        return this.getContext().getConstantValueGenerator().generateConstantValueAsExpression(PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)expression2)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)expression2)), constant.toConstantValue(GeneratorKt.getTypeInferredByFrontendOrFail(this, expression2)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrStatement visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, @Nullable Void data) {
        IrStatement irStatement;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)expression2));
        int endOffset = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)expression2));
        IrType resultType = this.toIrType(GeneratorKt.getTypeInferredByFrontendOrFail(this, (KtExpression)expression2));
        KtStringTemplateEntry[] ktStringTemplateEntryArray = expression2.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"expression.entries");
        Object[] objectArray = ktStringTemplateEntryArray;
        StatementGenerator statementGenerator = this;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtStringTemplateEntry ktStringTemplateEntry = (KtStringTemplateEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(this.generateExpression((KtElement)it));
        }
        List<IrExpression> entries = statementGenerator.postprocessStringTemplateEntries((List)destination$iv$iv);
        switch (entries.size()) {
            case 0: {
                irStatement = (IrStatement)IrConstImpl.Companion.string(startOffset, endOffset, resultType, "");
                break;
            }
            case 1: {
                IrExpression first = (IrExpression)CollectionsKt.first(entries);
                irStatement = (IrStatement)(first instanceof IrConst && Intrinsics.areEqual((Object)((IrConst)first).getKind(), (Object)IrConstKind.String.INSTANCE) ? first : (IrExpression)new IrStringConcatenationImpl(startOffset, endOffset, resultType, (Collection)CollectionsKt.listOf((Object)first)));
                break;
            }
            default: {
                irStatement = (IrStatement)new IrStringConcatenationImpl(startOffset, endOffset, resultType, (Collection)entries);
            }
        }
        return irStatement;
    }

    private final List<IrExpression> postprocessStringTemplateEntries(List<? extends IrExpression> $this$postprocessStringTemplateEntries) {
        ArrayList<Object> arrayList;
        ArrayList<Object> result2 = arrayList = new ArrayList<Object>($this$postprocessStringTemplateEntries.size());
        boolean bl = false;
        IrType stringType = this.getContext().getIrBuiltIns().getStringType();
        StringBuilder constString = new StringBuilder();
        int constStringStartOffset = 0;
        int constStringEndOffset = 0;
        for (IrExpression irExpression : $this$postprocessStringTemplateEntries) {
            if (irExpression instanceof IrConst && Intrinsics.areEqual((Object)((IrConst)irExpression).getKind(), (Object)IrConstKind.String.INSTANCE)) {
                if (((CharSequence)constString).length() == 0) {
                    constStringStartOffset = irExpression.getStartOffset();
                }
                constString.append((String)IrConstKind.String.INSTANCE.valueOf((IrConst)irExpression));
                constStringEndOffset = irExpression.getEndOffset();
                continue;
            }
            if (((CharSequence)constString).length() > 0) {
                String string2 = constString.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"constString.toString()");
                result2.add(IrConstImpl.Companion.string(constStringStartOffset, constStringEndOffset, stringType, string2));
                StringsKt.clear((StringBuilder)constString);
            }
            result2.add(irExpression);
        }
        if (((CharSequence)constString).length() > 0) {
            String string3 = constString.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"constString.toString()");
            result2.add(IrConstImpl.Companion.string(constStringStartOffset, constStringEndOffset, stringType, string3));
        }
        return arrayList;
    }

    @NotNull
    public IrStatement visitLiteralStringTemplateEntry(@NotNull KtLiteralStringTemplateEntry entry, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        int n = PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)entry));
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)entry));
        IrType irType = this.getContext().getIrBuiltIns().getStringType();
        String string2 = entry.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.text");
        return (IrStatement)IrConstImpl.Companion.string(n, n2, irType, string2);
    }

    @NotNull
    public IrStatement visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        int n = PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)entry));
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)entry));
        IrType irType = this.getContext().getIrBuiltIns().getStringType();
        String string2 = entry.getUnescapedValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.unescapedValue");
        return (IrStatement)IrConstImpl.Companion.string(n, n2, irType, string2);
    }

    @NotNull
    public IrStatement visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        KtExpression ktExpression = entry.getExpression();
        Intrinsics.checkNotNull((Object)ktExpression);
        return (IrStatement)this.generateExpression((KtElement)ktExpression);
    }

    @NotNull
    public IrExpression visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, (KtElement)expression2);
        if (resolvedCall2 != null) {
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                CallBuilder variableCall = ArgumentsGenerationUtilsKt.pregenerateCall(this, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall());
                return CallGeneratorKt.generateCall(new CallGenerator(this), (KtElement)expression2, variableCall, (IrStatementOrigin)IrStatementOrigin.VARIABLE_AS_FUNCTION.INSTANCE);
            }
            CallableDescriptor descriptor2 = resolvedCall2.getResultingDescriptor();
            return this.generateExpressionForReferencedDescriptor(descriptor2, (KtExpression)expression2, resolvedCall2);
        }
        Generator generator = this;
        WritableSlice<KtReferenceExpression, DeclarationDescriptor> writableSlice = BindingContext.REFERENCE_TARGET;
        Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"REFERENCE_TARGET");
        DeclarationDescriptor referenceTarget = (DeclarationDescriptor)GeneratorKt.get(generator, writableSlice, expression2);
        if (referenceTarget != null) {
            return this.generateExpressionForReferencedDescriptor(referenceTarget, (KtExpression)expression2, null);
        }
        return new ErrorExpressionGenerator(this).generateErrorSimpleName(expression2);
    }

    private final IrExpression generateExpressionForReferencedDescriptor(DeclarationDescriptor descriptor2, KtExpression expression2, ResolvedCall<?> resolvedCall2) {
        Object object;
        return new CallGenerator(this).generateValueReference(PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)expression2)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)expression2)), descriptor2, resolvedCall2, null, (object = (ExplicitSmartCasts)this.getContext().getBindingContext().get(BindingContext.SMARTCAST, expression2)) != null && (object = object.getDefaultType()) != null ? this.toIrType((KotlinType)object) : null);
    }

    @NotNull
    public IrStatement visitCallExpression(@NotNull KtCallExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, (KtElement)expression2);
        if (resolvedCall2 == null) {
            return (IrStatement)new ErrorExpressionGenerator(this).generateErrorCall(expression2);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (resolvedCall3 instanceof VariableAsFunctionResolvedCall) {
            CallBuilder functionCall = ArgumentsGenerationUtilsKt.pregenerateCall(this, ((VariableAsFunctionResolvedCall)((Object)resolvedCall3)).getFunctionCall());
            return (IrStatement)CallGeneratorKt.generateCall(new CallGenerator(this), (KtElement)expression2, functionCall, (IrStatementOrigin)IrStatementOrigin.INVOKE.INSTANCE);
        }
        KtExpression calleeExpression = expression2.getCalleeExpression();
        IrStatementOrigin.INVOKE origin = Intrinsics.areEqual((Object)resolvedCall3.getResultingDescriptor().getName(), (Object)OperatorNameConventions.INVOKE) && !(calleeExpression instanceof KtSimpleNameExpression) && !(calleeExpression instanceof KtQualifiedExpression) ? IrStatementOrigin.INVOKE.INSTANCE : null;
        return (IrStatement)new CallGenerator(this).generateCall(PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)expression2)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)expression2)), ArgumentsGenerationUtilsKt.pregenerateCall(this, resolvedCall3), (IrStatementOrigin)origin);
    }

    @NotNull
    public IrStatement visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2, @Nullable Void data) {
        IrStatement irStatement;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Generator generator = this;
        WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.INDEXED_LVALUE_GET;
        Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"INDEXED_LVALUE_GET");
        ResolvedCall indexedGetCall = (ResolvedCall)GeneratorKt.getOrFail(generator, writableSlice, expression2);
        Object d = indexedGetCall.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(d, (String)"indexedGetCall.resultingDescriptor");
        if (DynamicCallsKt.isDynamic((DeclarationDescriptor)d)) {
            irStatement = (IrStatement)new OperatorExpressionGenerator(this).generateDynamicArrayAccess(expression2);
        } else {
            CallGenerator callGenerator = new CallGenerator(this);
            int n = PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)expression2));
            int n2 = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)expression2));
            Intrinsics.checkNotNullExpressionValue((Object)indexedGetCall, (String)"indexedGetCall");
            irStatement = (IrStatement)callGenerator.generateCall(n, n2, ArgumentsGenerationUtilsKt.pregenerateCall(this, indexedGetCall), (IrStatementOrigin)IrStatementOrigin.GET_ARRAY_ELEMENT.INSTANCE);
        }
        return irStatement;
    }

    @NotNull
    public IrStatement visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtExpression ktExpression = expression2.getSelectorExpression();
        Intrinsics.checkNotNull((Object)ktExpression);
        Object object = ktExpression.accept((KtVisitor)this, (Object)data);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"expression.selectorExpression!!.accept(this, data)");
        return (IrStatement)object;
    }

    @NotNull
    public IrStatement visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtExpression ktExpression = expression2.getSelectorExpression();
        Intrinsics.checkNotNull((Object)ktExpression);
        Object object = ktExpression.accept((KtVisitor)this, (Object)data);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"expression.selectorExpression!!.accept(this, data)");
        return (IrStatement)object;
    }

    private final boolean isThisForClassPhysicallyAvailable(ClassDescriptor classDescriptor) {
        for (DeclarationDescriptor scopeDescriptor = this.getScopeOwner(); scopeDescriptor != null; scopeDescriptor = scopeDescriptor.getContainingDeclaration()) {
            if (Intrinsics.areEqual((Object)scopeDescriptor, (Object)classDescriptor)) {
                return true;
            }
            if (!(scopeDescriptor instanceof ClassDescriptor) || ((ClassDescriptor)scopeDescriptor).isInner()) continue;
            return false;
        }
        return false;
    }

    @NotNull
    public final IrExpression generateThisReceiver(int startOffset, int endOffset, @NotNull KotlinType kotlinType, @NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        ReceiverParameterDescriptor receiverParameterDescriptor = classDescriptor.getThisAsReceiverParameter();
        Intrinsics.checkNotNullExpressionValue((Object)receiverParameterDescriptor, (String)"classDescriptor.thisAsReceiverParameter");
        ReceiverParameterDescriptor thisAsReceiverParameter = receiverParameterDescriptor;
        IrType thisType = this.toIrType(kotlinType);
        return DescriptorUtils.isObject(classDescriptor) && !this.isThisForClassPhysicallyAvailable(classDescriptor) ? (IrExpression)new IrGetObjectValueImpl(startOffset, endOffset, thisType, this.getContext().getSymbolTable().referenceClass(classDescriptor)) : (IrExpression)new IrGetValueImpl(startOffset, endOffset, thisType, (IrValueSymbol)this.getContext().getSymbolTable().referenceValueParameter((ParameterDescriptor)thisAsReceiverParameter), null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrExpression visitThisExpression(@NotNull KtThisExpression expression2, @Nullable Void data) {
        IrExpression irExpression;
        void slice$iv;
        void $this$getOrFail$iv;
        Object v;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Generator generator = this;
        WritableSlice<KtReferenceExpression, DeclarationDescriptor> writableSlice = BindingContext.REFERENCE_TARGET;
        Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"REFERENCE_TARGET");
        ReadOnlySlice readOnlySlice = writableSlice;
        KtReferenceExpression key$iv = expression2.getInstanceReference();
        boolean $i$f$getOrFail = false;
        Object v2 = v = $this$getOrFail$iv.getContext().getBindingContext().get(slice$iv, key$iv);
        if (v2 == null) {
            KtReferenceExpression it = key$iv;
            boolean bl = false;
            String string2 = "No reference target for this";
            throw new RuntimeException(string2);
        }
        Intrinsics.checkNotNullExpressionValue(v2, (String)"context.bindingContext[s\u2026meException(message(key))");
        DeclarationDescriptor referenceTarget = (DeclarationDescriptor)v;
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)expression2));
        int endOffset = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)expression2));
        DeclarationDescriptor declarationDescriptor = referenceTarget;
        if (declarationDescriptor instanceof ClassDescriptor) {
            KotlinType kotlinType = ((ClassDescriptor)referenceTarget).getThisAsReceiverParameter().getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"referenceTarget.thisAsReceiverParameter.type");
            irExpression = this.generateThisReceiver(startOffset, endOffset, kotlinType, (ClassDescriptor)referenceTarget);
        } else if (declarationDescriptor instanceof CallableDescriptor) {
            ReceiverParameterDescriptor receiverParameterDescriptor;
            Object v7;
            block7: {
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, (KtElement)expression2);
                Collection collection = CollectionsKt.listOfNotNull((Object)((CallableDescriptor)referenceTarget).getExtensionReceiverParameter());
                List<ReceiverParameterDescriptor> list2 = ((CallableDescriptor)referenceTarget).getContextReceiverParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"referenceTarget.contextReceiverParameters");
                List receivers = CollectionsKt.plus((Collection)collection, (Iterable)list2);
                Iterable iterable = receivers;
                for (Object t : iterable) {
                    ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)t;
                    boolean bl = false;
                    ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
                    if (!Intrinsics.areEqual((Object)it, (Object)(resolvedCall3 != null ? resolvedCall3.getCandidateDescriptor() : null))) continue;
                    v7 = t;
                    break block7;
                }
                v7 = null;
            }
            if ((receiverParameterDescriptor = (ReceiverParameterDescriptor)v7) == null && (receiverParameterDescriptor = ((CallableDescriptor)referenceTarget).getExtensionReceiverParameter()) == null) {
                throw new IllegalStateException(("No receiver: " + referenceTarget).toString());
            }
            ReceiverParameterDescriptor receiver = receiverParameterDescriptor;
            KotlinType kotlinType = receiver.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"receiver.type");
            IrType receiverType = this.toIrType(kotlinType);
            irExpression = (IrExpression)new IrGetValueImpl(startOffset, endOffset, receiverType, (IrValueSymbol)this.getContext().getSymbolTable().referenceValueParameter((ParameterDescriptor)receiver), null, 16, null);
        } else {
            throw new IllegalStateException(("Expected this or receiver: " + referenceTarget).toString());
        }
        return irExpression;
    }

    @NotNull
    public IrStatement visitBinaryExpression(@NotNull KtBinaryExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrStatement)new OperatorExpressionGenerator(this).generateBinaryExpression(expression2);
    }

    @NotNull
    public IrStatement visitPrefixExpression(@NotNull KtPrefixExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrStatement)new OperatorExpressionGenerator(this).generatePrefixExpression(expression2);
    }

    @NotNull
    public IrStatement visitPostfixExpression(@NotNull KtPostfixExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrStatement)new OperatorExpressionGenerator(this).generatePostfixExpression(expression2);
    }

    @NotNull
    public IrStatement visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrStatement)new OperatorExpressionGenerator(this).generateCastExpression(expression2);
    }

    @NotNull
    public IrStatement visitIsExpression(@NotNull KtIsExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return new OperatorExpressionGenerator(this).generateInstanceOfExpression(expression2);
    }

    @NotNull
    public IrStatement visitIfExpression(@NotNull KtIfExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrStatement)new BranchingExpressionGenerator(this).generateIfExpression(expression2);
    }

    @NotNull
    public IrStatement visitWhenExpression(@NotNull KtWhenExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrStatement)new BranchingExpressionGenerator(this).generateWhenExpression(expression2);
    }

    @NotNull
    public IrStatement visitWhileExpression(@NotNull KtWhileExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrStatement)new LoopExpressionGenerator(this).generateWhileLoop(expression2);
    }

    @NotNull
    public IrStatement visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrStatement)new LoopExpressionGenerator(this).generateDoWhileLoop(expression2);
    }

    @NotNull
    public IrStatement visitForExpression(@NotNull KtForExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrStatement)new LoopExpressionGenerator(this).generateForLoop(expression2);
    }

    @NotNull
    public IrStatement visitBreakExpression(@NotNull KtBreakExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrStatement)new LoopExpressionGenerator(this).generateBreak(expression2);
    }

    @NotNull
    public IrStatement visitContinueExpression(@NotNull KtContinueExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrStatement)new LoopExpressionGenerator(this).generateContinue(expression2);
    }

    @NotNull
    public IrStatement visitTryExpression(@NotNull KtTryExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrStatement)new TryCatchExpressionGenerator(this).generateTryCatch(expression2);
    }

    @NotNull
    public IrStatement visitLambdaExpression(@NotNull KtLambdaExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return new LocalFunctionGenerator(this).generateLambda(expression2);
    }

    @NotNull
    public IrStatement visitNamedFunction(@NotNull KtNamedFunction function2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return new LocalFunctionGenerator(this).generateFunction(function2);
    }

    @NotNull
    public IrStatement visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return new LocalClassGenerator(this).generateObjectLiteral(expression2);
    }

    @NotNull
    public IrStatement visitClassOrObject(@NotNull KtClassOrObject classOrObject, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        return new LocalClassGenerator(this).generateLocalClass(classOrObject);
    }

    @NotNull
    public IrStatement visitTypeAlias(@NotNull KtTypeAlias typeAlias, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        return (IrStatement)new IrBlockImpl(PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)typeAlias)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)typeAlias)), this.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
    }

    @NotNull
    public IrStatement visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrStatement)new ReflectionReferencesGenerator(this).generateClassLiteral(expression2);
    }

    @NotNull
    public IrStatement visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrStatement)new ReflectionReferencesGenerator(this).generateCallableReference(expression2);
    }
}

