/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformer;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\bH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsAnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "jsContext", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "arraysContentEquals", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getJsContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getArrayContentEqualsSymbol", "type", "implementAnnotationPropertiesAndConstructor", "", "implClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "annotationClass", "generatedConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "backend.js"})
public final class JsAnnotationImplementationTransformer
extends AnnotationImplementationTransformer
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext jsContext;
    @NotNull
    private final Map<IrType, IrSimpleFunctionSymbol> arraysContentEquals;

    public JsAnnotationImplementationTransformer(@NotNull JsIrBackendContext jsContext) {
        Intrinsics.checkNotNullParameter((Object)jsContext, (String)"jsContext");
        super((BackendContext)jsContext, null);
        this.jsContext = jsContext;
        Map map = this.jsContext.getIr().getSymbols().getArraysContentEquals();
        if (map == null) {
            JsAnnotationImplementationTransformer jsAnnotationImplementationTransformer = this;
            boolean bl = false;
            JsAnnotationImplementationTransformer jsAnnotationImplementationTransformer2 = jsAnnotationImplementationTransformer;
            String string2 = "contentEquals symbols should be defined in JS IR context";
            throw new IllegalArgumentException(string2.toString());
        }
        this.arraysContentEquals = map;
    }

    @NotNull
    public final JsIrBackendContext getJsContext() {
        return this.jsContext;
    }

    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return declaration2 instanceof IrClass && IrUtilsKt.isAnnotationClass((IrClass)((IrClass)declaration2)) ? CollectionsKt.listOf((Object)((IrClass)this.visitClassNew((IrClass)declaration2))) : null;
    }

    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrExpression)expression2;
    }

    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (IrUtilsKt.isAnnotationClass((IrClass)declaration2)) {
            this.getContext().getIrFactory().getStageController().unrestrictDeclarationListsAccess((Function0)new Function0<Unit>(this, declaration2){
                final /* synthetic */ JsAnnotationImplementationTransformer this$0;
                final /* synthetic */ IrClass $declaration;
                {
                    this.this$0 = $receiver;
                    this.$declaration = $declaration;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.implementGeneratedFunctions(this.$declaration, this.$declaration);
                }
            });
        }
        return super.visitClassNew(declaration2);
    }

    @NotNull
    public IrSimpleFunctionSymbol getArrayContentEqualsSymbol(@NotNull IrType type2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (IrTypeUtilsKt.isPrimitiveArray((IrType)type2)) {
            object = this.arraysContentEquals.get(type2);
        } else {
            Object v1;
            block5: {
                Iterable $this$singleOrNull$iv = this.arraysContentEquals.entrySet();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    IrType k = (IrType)entry.getKey();
                    if (!IrTypePredicatesKt.isArray((IrType)k)) continue;
                    if (found$iv) {
                        v1 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            Map.Entry entry = v1;
            object = entry != null ? (IrSimpleFunctionSymbol)entry.getValue() : null;
        }
        if (object == null) {
            CompilationExceptionKt.compilationException((String)"Can't find an Arrays.contentEquals method for array type", (IrType)type2);
            throw null;
        }
        return object;
    }

    public void implementAnnotationPropertiesAndConstructor(@NotNull IrClass implClass, @NotNull IrClass annotationClass, @NotNull IrConstructor generatedConstructor) {
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)generatedConstructor, (String)"generatedConstructor");
        CompilationExceptionKt.compilationException((String)"Should not be called", (IrDeclaration)((IrDeclaration)implClass));
        throw null;
    }

    public boolean getWithLocalDeclarations() {
        return DeclarationTransformer.DefaultImpls.getWithLocalDeclarations((DeclarationTransformer)this);
    }

    public void lower(@NotNull IrFile irFile) {
        DeclarationTransformer.DefaultImpls.lower((DeclarationTransformer)this, (IrFile)irFile);
    }
}

