/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.TailRecursionKind;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0012\u0010\u0014\u001a\u00020\f2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u00020\u001c2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/codegen/TailRecursionCodegen;", "", "context", "Lorg/jetbrains/kotlin/codegen/context/MethodContext;", "codegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/kotlin/codegen/context/MethodContext;Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "assignParameterValues", "", "fd", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "callableMethod", "Lorg/jetbrains/kotlin/codegen/CallableMethod;", "valueArguments", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "generateTailRecursion", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getParameterVariableIndex", "", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "isTailRecursion", "", "store", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "backend"})
public final class TailRecursionCodegen {
    @NotNull
    private final MethodContext context;
    @NotNull
    private final ExpressionCodegen codegen;
    @NotNull
    private final InstructionAdapter v;
    @NotNull
    private final GenerationState state;

    public TailRecursionCodegen(@NotNull MethodContext context2, @NotNull ExpressionCodegen codegen2, @NotNull InstructionAdapter v, @NotNull GenerationState state) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.context = context2;
        this.codegen = codegen2;
        this.v = v;
        this.state = state;
    }

    public final boolean isTailRecursion(@NotNull ResolvedCall<?> resolvedCall2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        TailRecursionKind status2 = (TailRecursionKind)((Object)this.state.getBindingContext().get(BindingContext.TAIL_RECURSION_CALL, resolvedCall2.getCall()));
        return status2 != null && status2.isDoGenerateTailRecursion();
    }

    public final void generateTailRecursion(@NotNull ResolvedCall<?> resolvedCall2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Object it = CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(resolvedCall2.getResultingDescriptor());
        boolean bl = false;
        FunctionDescriptor functionDescriptor = it instanceof FunctionDescriptor ? (FunctionDescriptor)it : null;
        if (functionDescriptor == null) {
            throw new IllegalStateException(("Resolved call doesn't refer to the function descriptor: " + it).toString());
        }
        FunctionDescriptor fd = functionDescriptor;
        CallableMethod callable = (CallableMethod)this.codegen.resolveToCallable(fd, false, resolvedCall2);
        List<ResolvedValueArgument> list2 = resolvedCall2.getValueArgumentsByIndex();
        if (list2 == null) {
            throw new IllegalStateException("Failed to arrange value arguments by index: " + fd);
        }
        List<ResolvedValueArgument> arguments2 = list2;
        if (fd.isSuspend()) {
            AsmUtil.pop((MethodVisitor)this.v, ((JvmMethodParameterSignature)CollectionsKt.last(callable.getValueParameters())).getAsmType());
        }
        this.assignParameterValues(fd, callable, arguments2);
        if (callable.getExtensionReceiverType() != null) {
            ReceiverValue receiverValue = resolvedCall2.getExtensionReceiver();
            ReceiverParameterDescriptor receiverParameterDescriptor = fd.getExtensionReceiverParameter();
            Intrinsics.checkNotNull((Object)receiverParameterDescriptor);
            if (!Intrinsics.areEqual((Object)receiverValue, (Object)receiverParameterDescriptor.getValue())) {
                StackValue expression2 = this.context.getReceiverExpression(this.codegen.typeMapper);
                expression2.store(StackValue.onStack(callable.getExtensionReceiverType()), this.v, true);
            } else {
                AsmUtil.pop((MethodVisitor)this.v, callable.getExtensionReceiverType());
            }
        }
        if (callable.getDispatchReceiverType() != null) {
            AsmUtil.pop((MethodVisitor)this.v, callable.getDispatchReceiverType());
        }
        this.v.goTo(this.context.getMethodStartLabel());
    }

    private final void assignParameterValues(CallableDescriptor fd, CallableMethod callableMethod, List<? extends ResolvedValueArgument> valueArguments) {
        Type type2;
        ResolvedValueArgument arg;
        boolean properDefaultInitialization = this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperComputationOrderOfTailrecDefaultParameters);
        List<Type> types2 = callableMethod.getValueParameterTypes();
        List<ValueParameterDescriptor> list2 = fd.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"fd.valueParameters");
        for (ValueParameterDescriptor parameterDescriptor : CollectionsKt.asReversedMutable(list2)) {
            arg = valueArguments.get(parameterDescriptor.getIndex());
            type2 = types2.get(parameterDescriptor.getIndex());
            ResolvedValueArgument resolvedValueArgument = arg;
            if (resolvedValueArgument instanceof ExpressionValueArgument) {
                KtExpression argumentExpression;
                ValueArgument valueArgument = ((ExpressionValueArgument)arg).getValueArgument();
                Object object = argumentExpression = valueArgument != null ? valueArgument.getArgumentExpression() : null;
                if (argumentExpression instanceof KtSimpleNameExpression) {
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                    ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)argumentExpression, this.state.getBindingContext());
                    if (Intrinsics.areEqual((Object)(resolvedCall3 != null ? resolvedCall3.getResultingDescriptor() : null), (Object)parameterDescriptor.getOriginal())) {
                        AsmUtil.pop((MethodVisitor)this.v, type2);
                        continue;
                    }
                }
            } else if (resolvedValueArgument instanceof DefaultValueArgument) {
                AsmUtil.pop((MethodVisitor)this.v, type2);
                if (properDefaultInitialization) continue;
                DefaultParameterValueLoader.DEFAULT.genValue(parameterDescriptor, this.codegen).put(type2, this.v);
            } else if (!(resolvedValueArgument instanceof VarargValueArgument)) {
                throw new UnsupportedOperationException("Unknown argument type: " + arg + " in " + fd);
            }
            Intrinsics.checkNotNullExpressionValue((Object)parameterDescriptor, (String)"parameterDescriptor");
            this.store(parameterDescriptor, type2);
        }
        if (properDefaultInitialization) {
            for (ValueParameterDescriptor parameterDescriptor : fd.getValueParameters()) {
                arg = valueArguments.get(parameterDescriptor.getIndex());
                type2 = types2.get(parameterDescriptor.getIndex());
                if (!(arg instanceof DefaultValueArgument)) continue;
                DefaultParameterValueLoader.DEFAULT.genValue(parameterDescriptor, this.codegen).put(type2, this.v);
                Intrinsics.checkNotNullExpressionValue((Object)parameterDescriptor, (String)"parameterDescriptor");
                this.store(parameterDescriptor, type2);
            }
        }
    }

    private final void store(ValueParameterDescriptor parameterDescriptor, Type type2) {
        int index2 = this.getParameterVariableIndex(parameterDescriptor);
        this.v.store(index2, type2);
    }

    private final int getParameterVariableIndex(ValueParameterDescriptor parameterDescriptor) {
        int index2 = this.codegen.lookupLocalIndex(parameterDescriptor);
        if (index2 == -1) {
            index2 = this.codegen.lookupLocalIndex(parameterDescriptor.getOriginal());
        }
        if (index2 == -1) {
            throw new IllegalStateException("Failed to obtain parameter index: " + parameterDescriptor);
        }
        return index2;
    }
}

