/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataKt;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataIntField;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataElement;", "name", "", "value", "", "(Ljava/lang/String;I)V", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;)V", "getName", "()Ljava/lang/String;", "sizeInBytes", "getSizeInBytes", "()I", "getValue", "()Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "dump", "indent", "startAddress", "toBytes", "", "backend.wasm"})
public final class ConstantDataIntField
extends ConstantDataElement {
    @NotNull
    private final String name;
    @NotNull
    private final WasmSymbol<Integer> value;
    private final int sizeInBytes;

    public ConstantDataIntField(@NotNull String name, @NotNull WasmSymbol<Integer> value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        super(null);
        this.name = name;
        this.value = value2;
        this.sizeInBytes = 4;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final WasmSymbol<Integer> getValue() {
        return this.value;
    }

    public ConstantDataIntField(@NotNull String name, int value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, (WasmSymbol<Integer>)new WasmSymbol((Object)value2));
    }

    @Override
    @NotNull
    public byte[] toBytes() {
        return ConstantDataKt.toLittleEndianBytes(((Number)this.value.getOwner()).intValue());
    }

    @Override
    @NotNull
    public String dump(@NotNull String indent, int startAddress) {
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        return ConstantDataKt.access$addressToString(startAddress) + ": " + indent + " i32   : " + ((Number)this.value.getOwner()).intValue() + "    ;; " + this.name + '\n';
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }
}

