/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LoopLabelType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VirtualMethodMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFunctionCodegenContext;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.UtilsKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrReturnTarget;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImmediateKind;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolIntWrapper;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u000202H\u0016J\u001c\u00103\u001a\u00020\u0018\"\u0004\b\u0000\u001042\f\u00101\u001a\b\u0012\u0004\u0012\u0002H405H\u0016J\u0010\u00106\u001a\u00020\u00182\u0006\u00101\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00182\u0006\u00101\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u00182\u0006\u0010.\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u00182\u0006\u00101\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u00182\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\u00182\u0006\u0010B\u001a\u00020\u001dH\u0016J\u0010\u0010C\u001a\u00020\u00182\u0006\u00101\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\u00182\u0006\u00101\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\u00182\u0006\u00101\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\u00182\u0006\u00101\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\u00182\u0006\u00101\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020\u00182\u0006\u00101\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020\u00182\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\u00182\u0006\u00101\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u00020\u00182\u0006\u0010U\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020\u00182\u0006\u00101\u001a\u00020XH\u0016J\u0010\u0010Y\u001a\u00020\u00182\u0006\u0010?\u001a\u00020ZH\u0016J\n\u0010[\u001a\u00020\u0018*\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/BodyGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;)V", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "body", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getBody", "()Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "unitGetInstance", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getUnitGetInstance", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unitGetInstance$delegate", "Lkotlin/Lazy;", "wasmSymbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "generateCall", "", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "generateExpression", "elem", "Lorg/jetbrains/kotlin/ir/IrElement;", "generateInstanceFieldAccess", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "generateStatement", "statement", "generateTypeRTT", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "tryToGenerateIntrinsicCall", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "tryToGenerateWasmOpIntrinsicCall", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitConst", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "visitElement", "element", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitVariable", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "buildGetUnit", "backend.wasm"})
public final class BodyGenerator
implements IrElementVisitorVoid {
    @NotNull
    private final WasmFunctionCodegenContext context;
    @NotNull
    private final WasmExpressionBuilder body;
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmSymbols wasmSymbols;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Lazy unitGetInstance$delegate;

    public BodyGenerator(@NotNull WasmFunctionCodegenContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.body = this.context.getBodyGen();
        this.backendContext = this.context.getBackendContext();
        this.wasmSymbols = this.backendContext.getWasmSymbols();
        this.irBuiltIns = this.backendContext.getIrBuiltIns();
        this.unitGetInstance$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IrSimpleFunction>(this){
            final /* synthetic */ BodyGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrSimpleFunction invoke() {
                return MiscKt.findUnitGetInstanceFunction(BodyGenerator.access$getBackendContext$p(this.this$0));
            }
        }));
    }

    @NotNull
    public final WasmFunctionCodegenContext getContext() {
        return this.context;
    }

    @NotNull
    public final WasmExpressionBuilder getBody() {
        return this.body;
    }

    private final IrSimpleFunction getUnitGetInstance() {
        Lazy lazy = this.unitGetInstance$delegate;
        return (IrSimpleFunction)lazy.getValue();
    }

    public final void buildGetUnit(@NotNull WasmExpressionBuilder $this$buildGetUnit) {
        Intrinsics.checkNotNullParameter((Object)$this$buildGetUnit, (String)"<this>");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{(WasmImmediate)new WasmImmediate.FuncIdx(this.context.referenceFunction((IrFunctionSymbol)this.getUnitGetInstance().getSymbol()))};
        $this$buildGetUnit.buildInstr(WasmOp.GET_UNIT, wasmImmediateArray);
    }

    private final void generateExpression(IrElement elem) {
        boolean bl;
        boolean bl2 = bl = elem instanceof IrExpression || elem instanceof IrVariable;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Unsupported statement kind";
            throw new AssertionError((Object)string2);
        }
        IrElementVisitorVoidKt.acceptVoid((IrElement)elem, (IrElementVisitorVoid)this);
        if (elem instanceof IrExpression && Intrinsics.areEqual((Object)((IrExpression)elem).getType(), (Object)this.irBuiltIns.getNothingType())) {
            this.body.buildUnreachable();
        }
    }

    private final void generateStatement(IrElement statement2) {
        boolean bl;
        boolean bl2 = bl = statement2 instanceof IrExpression || statement2 instanceof IrVariable;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Unsupported statement kind";
            throw new AssertionError((Object)string2);
        }
        this.generateExpression(statement2);
        if (statement2 instanceof IrExpression && !Intrinsics.areEqual((Object)((IrExpression)statement2).getType(), (Object)this.wasmSymbols.getVoidType())) {
            this.body.buildDrop();
        }
    }

    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new IllegalStateException(("Unexpected element of type " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
    }

    public void visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.generateExpression((IrElement)expression2.getValue());
        this.body.buildThrow(this.context.getTagIdx());
    }

    public void visitTry(@NotNull IrTry aTry) {
        Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
        boolean bl = UtilsKt.isCanonical(aTry, this.irBuiltIns);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "expected canonical try/catch";
            throw new AssertionError((Object)string2);
        }
        WasmType resultType = this.context.transformBlockResultType(aTry.getType());
        this.body.buildTry(null, resultType);
        this.generateExpression((IrElement)aTry.getTryResult());
        this.body.buildCatch(this.context.getTagIdx());
        IrVariableSymbol it = ((IrCatch)CollectionsKt.single((List)aTry.getCatches())).getCatchParameter().getSymbol();
        boolean bl3 = false;
        this.context.defineLocal((IrValueSymbol)it);
        this.body.buildSetLocal(this.context.referenceLocal((IrValueSymbol)it));
        this.generateExpression((IrElement)((IrCatch)CollectionsKt.single((List)aTry.getCatches())).getResult());
        this.body.buildEnd();
    }

    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
            case 1: {
                this.generateExpression((IrElement)expression2.getArgument());
                break;
            }
            case 2: {
                this.generateStatement((IrElement)expression2.getArgument());
                this.buildGetUnit(this.body);
                break;
            }
            default: {
                if (!_Assertions.ENABLED) break;
                boolean bl = false;
                String string2 = "Other types of casts must be lowered";
                throw new AssertionError((Object)string2);
            }
        }
    }

    public <T> void visitConst(@NotNull IrConst<T> expression2) {
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        IrConstKind kind = expression2.getKind();
        if (kind instanceof IrConstKind.Null) {
            DeclarationGeneratorKt.generateDefaultInitializerForType(this.context.transformType(expression2.getType()), this.body);
        } else if (kind instanceof IrConstKind.Boolean) {
            this.body.buildConstI32((Boolean)((IrConstKind.Boolean)kind).valueOf(expression2) != false ? 1 : 0);
        } else if (kind instanceof IrConstKind.Byte) {
            this.body.buildConstI32((int)((Number)((IrConstKind.Byte)kind).valueOf(expression2)).byteValue());
        } else if (kind instanceof IrConstKind.Short) {
            this.body.buildConstI32((int)((Number)((IrConstKind.Short)kind).valueOf(expression2)).shortValue());
        } else if (kind instanceof IrConstKind.Int) {
            this.body.buildConstI32(((Number)((IrConstKind.Int)kind).valueOf(expression2)).intValue());
        } else if (kind instanceof IrConstKind.Long) {
            this.body.buildConstI64(((Number)((IrConstKind.Long)kind).valueOf(expression2)).longValue());
        } else if (kind instanceof IrConstKind.Char) {
            this.body.buildConstI32((int)((Character)((IrConstKind.Char)kind).valueOf(expression2)).charValue());
        } else if (kind instanceof IrConstKind.Float) {
            this.body.buildConstF32(((Number)((IrConstKind.Float)kind).valueOf(expression2)).floatValue());
        } else if (kind instanceof IrConstKind.Double) {
            this.body.buildConstF64(((Number)((IrConstKind.Double)kind).valueOf(expression2)).doubleValue());
        } else if (kind instanceof IrConstKind.String) {
            this.body.buildConstI32Symbol(this.context.referenceStringLiteral((String)((IrConstKind.String)kind).valueOf(expression2)));
            this.body.buildConstI32(((String)((IrConstKind.String)kind).valueOf(expression2)).length());
            this.body.buildCall(this.context.referenceFunction((IrFunctionSymbol)this.wasmSymbols.getStringGetLiteral()));
        } else {
            throw new IllegalStateException("Unknown constant kind".toString());
        }
    }

    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        IrExpression receiver = expression2.getReceiver();
        if (receiver != null) {
            this.generateExpression((IrElement)receiver);
            if (!this.backendContext.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)field)))) {
                this.generateInstanceFieldAccess(field);
            }
        } else {
            this.body.buildGetGlobal(this.context.referenceGlobal(field.getSymbol()));
        }
    }

    private final void generateInstanceFieldAccess(IrField field) {
        WasmImmediate[] wasmImmediateArray = field.getType();
        WasmOp opcode = Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getCharType()) ? WasmOp.STRUCT_GET_U : (((Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getBooleanType()) ? true : Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getByteType())) ? true : Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getShortType())) ? WasmOp.STRUCT_GET_S : WasmOp.STRUCT_GET);
        wasmImmediateArray = new WasmImmediate[]{(WasmImmediate)new WasmImmediate.GcType(this.context.referenceGcType(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)field)).getSymbol())), (WasmImmediate)new WasmImmediate.StructFieldIdx(this.context.getStructFieldRef(field))};
        this.body.buildInstr(opcode, wasmImmediateArray);
    }

    public void visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        IrExpression receiver = expression2.getReceiver();
        if (receiver != null) {
            this.generateExpression((IrElement)receiver);
            this.generateExpression((IrElement)expression2.getValue());
            this.body.buildStructSet(this.context.referenceGcType(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)field)).getSymbol()), this.context.getStructFieldRef(field));
        } else {
            this.generateExpression((IrElement)expression2.getValue());
            this.body.buildSetGlobal(this.context.referenceGlobal(expression2.getSymbol()));
        }
        this.buildGetUnit(this.body);
    }

    public void visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrValueSymbol valueSymbol = expression2.getSymbol();
        IrValueDeclaration valueDeclaration = valueSymbol.getOwner();
        this.body.buildGetLocal(MiscKt.isDispatchReceiver(valueDeclaration) ? this.context.referenceLocal(0) : this.context.referenceLocal(valueSymbol));
    }

    public void visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.generateExpression((IrElement)expression2.getValue());
        this.body.buildSetLocal(this.context.referenceLocal(expression2.getSymbol()));
        this.buildGetUnit(this.body);
    }

    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.generateCall((IrFunctionAccessExpression)expression2);
    }

    /*
     * WARNING - void declaration
     */
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)expression2.getSymbol().getOwner()));
        if (!(!this.backendContext.getInlineClassesUtils().isClassInlineLike(klass))) {
            boolean $i$a$-require-BodyGenerator$visitConstructorCall$32 = false;
            String $i$a$-require-BodyGenerator$visitConstructorCall$32 = "All inline class constructor calls must be lowered to static function calls";
            throw new IllegalArgumentException($i$a$-require-BodyGenerator$visitConstructorCall$32.toString());
        }
        WasmSymbol<WasmTypeDeclaration> wasmGcType = this.context.referenceGcType(klass.getSymbol());
        if (AnnotationsKt.getWasmArrayAnnotation((IrAnnotationContainer)klass) != null) {
            if (!(expression2.getValueArgumentsCount() == 1)) {
                boolean $i$a$-require-BodyGenerator$visitConstructorCall$42 = false;
                String $i$a$-require-BodyGenerator$visitConstructorCall$42 = "@WasmArrayOf constructs must have exactly one argument";
                throw new IllegalArgumentException($i$a$-require-BodyGenerator$visitConstructorCall$42.toString());
            }
            IrExpression irExpression = expression2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            this.generateExpression((IrElement)irExpression);
            this.body.buildRttCanon(wasmGcType);
            WasmImmediate[] $i$a$-require-BodyGenerator$visitConstructorCall$32 = new WasmImmediate[]{(WasmImmediate)new WasmImmediate.GcType(wasmGcType)};
            this.body.buildInstr(WasmOp.ARRAY_NEW_DEFAULT_WITH_RTT, $i$a$-require-BodyGenerator$visitConstructorCall$32);
            return;
        }
        WasmSymbol<Integer> wasmClassId = this.context.referenceClassId(klass.getSymbol());
        List<IrField> irFields = ClassInfoKt.allFields(klass, this.backendContext.getIrBuiltIns());
        Iterable $this$forEachIndexed$iv = irFields;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void field;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrField irField = (IrField)item$iv;
            int index2 = n;
            boolean bl = false;
            if (index2 == 0) {
                this.body.buildConstI32Symbol(wasmClassId);
                continue;
            }
            DeclarationGeneratorKt.generateDefaultInitializerForType(this.context.transformType(field.getType()), this.body);
        }
        this.body.buildGetGlobal(this.context.referenceClassRTT(klass.getSymbol()));
        this.body.buildStructNew(wasmGcType);
        this.generateCall((IrFunctionAccessExpression)expression2);
    }

    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)this.context.getIrFunction()));
        if (IrTypePredicatesKt.isAny((IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)klass)))) {
            this.buildGetUnit(this.body);
            return;
        }
        this.body.buildGetLocal(this.context.referenceLocal(0));
        this.generateCall((IrFunctionAccessExpression)expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateCall(IrFunctionAccessExpression call2) {
        boolean isSuperCall;
        IrExpression it;
        if (Intrinsics.areEqual((Object)call2.getSymbol(), (Object)this.wasmSymbols.getBoxIntrinsic())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrType toType = irType;
            IrClass irClass = TypeTransformerKt.getGetRuntimeClass(toType);
            Intrinsics.checkNotNull((Object)irClass);
            IrClass klass = irClass;
            WasmSymbol<WasmTypeDeclaration> structTypeName = this.context.referenceGcType(klass.getSymbol());
            WasmSymbol<Integer> klassId = this.context.referenceClassId(klass.getSymbol());
            this.body.buildConstI32Symbol(klassId);
            this.body.buildConstI32(0);
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            this.generateExpression((IrElement)irExpression);
            this.body.buildGetGlobal(this.context.referenceClassRTT(klass.getSymbol()));
            this.body.buildStructNew(structTypeName);
            return;
        }
        if (Intrinsics.areEqual((Object)call2.getSymbol(), (Object)this.getUnitGetInstance().getSymbol())) {
            this.buildGetUnit(this.body);
            return;
        }
        IrFunction function2 = IrResolveUtilsKt.getRealOverrideTarget(((IrFunctionSymbol)call2.getSymbol()).getOwner());
        IrExpression irExpression = call2.getDispatchReceiver();
        if (irExpression != null) {
            it = irExpression;
            boolean bl = false;
            this.generateExpression((IrElement)it);
        }
        IrExpression irExpression2 = call2.getExtensionReceiver();
        if (irExpression2 != null) {
            it = irExpression2;
            boolean bl = false;
            this.generateExpression((IrElement)it);
        }
        int structTypeName = call2.getValueArgumentsCount();
        for (int i = 0; i < structTypeName; ++i) {
            IrExpression valueArgument = call2.getValueArgument(i);
            if (valueArgument == null) {
                DeclarationGeneratorKt.generateDefaultInitializerForType(this.context.transformType(((IrValueParameter)function2.getValueParameters().get(i)).getType()), this.body);
                continue;
            }
            this.generateExpression((IrElement)valueArgument);
        }
        if (this.tryToGenerateIntrinsicCall(call2, function2)) {
            if (Intrinsics.areEqual((Object)function2.getReturnType(), (Object)this.irBuiltIns.getUnitType())) {
                this.buildGetUnit(this.body);
            }
            return;
        }
        boolean bl = isSuperCall = call2 instanceof IrCall && ((IrCall)call2).getSuperQualifierSymbol() != null;
        if (function2 instanceof IrSimpleFunction && org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isOverridable((IrSimpleFunction)((IrSimpleFunction)function2)) && !isSuperCall) {
            IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)function2));
            if (!IrUtilsKt.isInterface((IrClass)klass)) {
                void $this$mapTo$iv$iv;
                ClassMetadata classMetadata = this.context.getClassMetadata(klass.getSymbol());
                Iterable $this$map$iv = classMetadata.getVirtualMethods();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    VirtualMethodMetadata virtualMethodMetadata = (VirtualMethodMetadata)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it2.getFunction());
                }
                int vfSlot = ((List)destination$iv$iv).indexOf(function2);
                IrExpression irExpression3 = call2.getDispatchReceiver();
                Intrinsics.checkNotNull((Object)irExpression3);
                this.generateExpression((IrElement)irExpression3);
                this.body.buildConstI32(vfSlot);
                this.body.buildCall(this.context.referenceFunction((IrFunctionSymbol)this.wasmSymbols.getGetVirtualMethodId()));
                WasmExpressionBuilder.buildCallIndirect$default((WasmExpressionBuilder)this.body, this.context.referenceFunctionType((IrFunctionSymbol)((IrSimpleFunction)function2).getSymbol()), null, (int)2, null);
            } else {
                IrExpression irExpression4 = call2.getDispatchReceiver();
                Intrinsics.checkNotNull((Object)irExpression4);
                this.generateExpression((IrElement)irExpression4);
                this.body.buildConstI32Symbol(this.context.referenceInterfaceId(klass.getSymbol()));
                this.body.buildCall(this.context.referenceFunction((IrFunctionSymbol)this.wasmSymbols.getGetInterfaceImplId()));
                WasmExpressionBuilder wasmExpressionBuilder = this.body;
                WasmSymbolIntWrapper wasmSymbolIntWrapper = new WasmSymbolIntWrapper(this.context.referenceInterfaceTable((IrFunctionSymbol)((IrSimpleFunction)function2).getSymbol()));
                WasmSymbol<WasmFunctionType> wasmSymbol = this.context.referenceFunctionType((IrFunctionSymbol)((IrSimpleFunction)function2).getSymbol());
                wasmExpressionBuilder.buildCallIndirect(wasmSymbol, (WasmSymbolReadOnly)wasmSymbolIntWrapper);
            }
        } else {
            this.body.buildCall(this.context.referenceFunction(function2.getSymbol()));
        }
        if (Intrinsics.areEqual((Object)function2.getReturnType(), (Object)this.irBuiltIns.getUnitType())) {
            this.buildGetUnit(this.body);
        }
    }

    private final void generateTypeRTT(IrType type2) {
        IrClass irClass = TypeTransformerKt.getGetRuntimeClass(type2);
        if (irClass == null || (irClass = irClass.getSymbol()) == null) {
            irClass = this.context.getBackendContext().getIrBuiltIns().getAnyClass();
        }
        IrClass rtClass = irClass;
        this.body.buildGetGlobal(this.context.referenceClassRTT((IrClassSymbol)rtClass));
    }

    private final boolean tryToGenerateIntrinsicCall(IrFunctionAccessExpression call2, IrFunction function2) {
        if (this.tryToGenerateWasmOpIntrinsicCall(call2, function2)) {
            return true;
        }
        IrFunctionSymbol irFunctionSymbol = function2.getSymbol();
        if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getWasmClassId())) {
            boolean bl;
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrClass irClass = IrTypesKt.getClass((IrType)irType);
            if (irClass == null) {
                throw new IllegalStateException("No class given for wasmClassId intrinsic".toString());
            }
            IrClass klass = irClass;
            boolean bl2 = bl = !IrUtilsKt.isInterface((IrClass)klass);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            this.body.buildConstI32Symbol(this.context.referenceClassId(klass.getSymbol()));
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getWasmInterfaceId())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrClass irClass = IrTypesKt.getClass((IrType)irType);
            if (irClass == null) {
                throw new IllegalStateException("No interface given for wasmInterfaceId intrinsic".toString());
            }
            IrClass irInterface = irClass;
            boolean bl = IrUtilsKt.isInterface((IrClass)irInterface);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            this.body.buildConstI32Symbol(this.context.referenceInterfaceId(irInterface.getSymbol()));
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getWasmRefCast())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrType toType = irType;
            this.generateTypeRTT(toType);
            this.body.buildRefCast();
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getUnboxIntrinsic())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrType fromType = irType;
            if (IrTypePredicatesKt.isNothing((IrType)fromType)) {
                this.body.buildUnreachable();
                return true;
            }
            if (IrTypePredicatesKt.isNothing((IrType)IrTypesKt.makeNotNull((IrType)fromType))) {
                this.body.buildUnreachable();
                return true;
            }
            IrType irType2 = call2.getTypeArgument(1);
            Intrinsics.checkNotNull((Object)irType2);
            IrType toType = irType2;
            IrClass irClass = this.backendContext.getInlineClassesUtils().getInlinedClass(toType);
            Intrinsics.checkNotNull((Object)irClass);
            IrClass klass = irClass;
            IrField field = InlineClassesKt.getInlineClassBackingField((IrClass)klass);
            this.generateTypeRTT(toType);
            this.body.buildRefCast();
            this.generateInstanceFieldAccess(field);
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getUnsafeGetScratchRawMemory())) {
            this.body.buildDrop();
            this.body.buildConstI32Symbol(this.context.getScratchMemAddr());
        } else {
            return false;
        }
        return true;
    }

    public void visitBlockBody(@NotNull IrBlockBody body2) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Iterable $this$forEach$iv = body2.getStatements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrElement p0 = (IrElement)element$iv;
            boolean bl = false;
            this.generateStatement(p0);
        }
    }

    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        List statements = expression2.getStatements();
        if (statements.isEmpty()) {
            if (Intrinsics.areEqual((Object)expression2.getType(), (Object)this.irBuiltIns.getUnitType())) {
                this.buildGetUnit(this.body);
            }
            return;
        }
        Iterable $this$forEach$iv = CollectionsKt.dropLast((List)statements, (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement it = (IrStatement)element$iv;
            boolean bl = false;
            this.generateStatement((IrElement)it);
        }
        this.generateExpression((IrElement)CollectionsKt.last((List)statements));
        if (!(CollectionsKt.last((List)statements) instanceof IrExpression) && !Intrinsics.areEqual((Object)expression2.getType(), (Object)this.wasmSymbols.getVoidType())) {
            this.buildGetUnit(this.body);
        }
    }

    public void visitBreak(@NotNull IrBreak jump) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        boolean bl = Intrinsics.areEqual((Object)jump.getType(), (Object)this.irBuiltIns.getNothingType());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.body.buildBr(this.context.referenceLoopLevel(jump.getLoop(), LoopLabelType.BREAK));
    }

    public void visitContinue(@NotNull IrContinue jump) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        boolean bl = Intrinsics.areEqual((Object)jump.getType(), (Object)this.irBuiltIns.getNothingType());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.body.buildBr(this.context.referenceLoopLevel(jump.getLoop(), LoopLabelType.CONTINUE));
    }

    public void visitReturn(@NotNull IrReturn expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (Intrinsics.areEqual((Object)org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.returnType((IrReturnTarget)expression2.getReturnTargetSymbol().getOwner(), (CommonBackendContext)this.backendContext), (Object)this.irBuiltIns.getUnitType()) && !Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol().getOwner(), (Object)this.getUnitGetInstance())) {
            this.generateStatement((IrElement)expression2.getValue());
        } else {
            this.generateExpression((IrElement)expression2.getValue());
        }
        if (this.context.getIrFunction() instanceof IrConstructor) {
            this.body.buildGetLocal(this.context.referenceLocal(0));
        }
        this.body.buildInstr(WasmOp.RETURN, new WasmImmediate[0]);
    }

    public void visitWhen(@NotNull IrWhen expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        WasmType resultType = this.context.transformBlockResultType(expression2.getType());
        int ifCount = 0;
        boolean seenElse = false;
        for (Object branch : expression2.getBranches()) {
            if (!org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isElseBranch((IrBranch)branch)) {
                this.generateExpression((IrElement)branch.getCondition());
                this.body.buildIf(null, resultType);
                this.generateExpression((IrElement)branch.getResult());
                if (Intrinsics.areEqual((Object)expression2.getType(), (Object)this.irBuiltIns.getNothingType())) {
                    this.body.buildUnreachable();
                }
                this.body.buildElse();
                ++ifCount;
                continue;
            }
            this.generateExpression((IrElement)branch.getResult());
            if (Intrinsics.areEqual((Object)expression2.getType(), (Object)this.irBuiltIns.getNothingType())) {
                this.body.buildUnreachable();
            }
            seenElse = true;
            break;
        }
        if (!seenElse && resultType != null) {
            boolean bl;
            boolean bl2 = bl = !Intrinsics.areEqual((Object)expression2.getType(), (Object)this.irBuiltIns.getNothingType());
            if (_Assertions.ENABLED && !bl) {
                Object branch;
                branch = "Assertion failed";
                throw new AssertionError(branch);
            }
            DeclarationGeneratorKt.generateDefaultInitializerForType(resultType, this.body);
        }
        int n = 0;
        while (n < ifCount) {
            int it = n++;
            boolean bl = false;
            this.body.buildEnd();
        }
    }

    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        String label = loop.getLabel();
        WasmExpressionBuilder.buildLoop$default((WasmExpressionBuilder)this.body, (String)label, null, (int)2, null);
        int wasmLoop = this.body.getNumberOfNestedBlocks();
        WasmExpressionBuilder.buildBlock$default((WasmExpressionBuilder)this.body, (String)("BREAK_" + label), null, (int)2, null);
        int wasmBreakBlock = this.body.getNumberOfNestedBlocks();
        WasmExpressionBuilder.buildBlock$default((WasmExpressionBuilder)this.body, (String)("CONTINUE_" + label), null, (int)2, null);
        int wasmContinueBlock = this.body.getNumberOfNestedBlocks();
        this.context.defineLoopLevel((IrLoop)loop, LoopLabelType.BREAK, wasmBreakBlock);
        this.context.defineLoopLevel((IrLoop)loop, LoopLabelType.CONTINUE, wasmContinueBlock);
        IrExpression irExpression = loop.getBody();
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl = false;
            this.generateStatement((IrElement)it);
        }
        this.body.buildEnd();
        this.generateExpression((IrElement)loop.getCondition());
        this.body.buildBrIf(wasmLoop);
        this.body.buildEnd();
        this.body.buildEnd();
        this.buildGetUnit(this.body);
    }

    public void visitWhileLoop(@NotNull IrWhileLoop loop) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        String label = loop.getLabel();
        WasmExpressionBuilder.buildLoop$default((WasmExpressionBuilder)this.body, (String)label, null, (int)2, null);
        int wasmLoop = this.body.getNumberOfNestedBlocks();
        WasmExpressionBuilder.buildBlock$default((WasmExpressionBuilder)this.body, (String)("BREAK_" + label), null, (int)2, null);
        int wasmBreakBlock = this.body.getNumberOfNestedBlocks();
        this.context.defineLoopLevel((IrLoop)loop, LoopLabelType.BREAK, wasmBreakBlock);
        this.context.defineLoopLevel((IrLoop)loop, LoopLabelType.CONTINUE, wasmLoop);
        this.generateExpression((IrElement)loop.getCondition());
        this.body.buildInstr(WasmOp.I32_EQZ, new WasmImmediate[0]);
        this.body.buildBrIf(wasmBreakBlock);
        IrExpression irExpression = loop.getBody();
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl = false;
            this.generateStatement((IrElement)it);
        }
        this.body.buildBr(wasmLoop);
        this.body.buildEnd();
        this.body.buildEnd();
        this.buildGetUnit(this.body);
    }

    public void visitVariable(@NotNull IrVariable declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        this.context.defineLocal((IrValueSymbol)declaration2.getSymbol());
        if (declaration2.getInitializer() == null) {
            return;
        }
        IrExpression irExpression = declaration2.getInitializer();
        Intrinsics.checkNotNull((Object)irExpression);
        IrExpression init = irExpression;
        this.generateExpression((IrElement)init);
        WasmLocal varName = this.context.referenceLocal((IrValueSymbol)declaration2.getSymbol());
        this.body.buildSetLocal(varName);
    }

    public final boolean tryToGenerateWasmOpIntrinsicCall(@NotNull IrFunctionAccessExpression call2, @NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (AnnotationsKt.hasWasmNoOpCastAnnotation((IrAnnotationContainer)function2)) {
            return true;
        }
        String opString = AnnotationsKt.getWasmOpAnnotation((IrAnnotationContainer)function2);
        if (opString != null) {
            WasmOp op = WasmOp.valueOf((String)opString);
            boolean $i$f$emptyArray = false;
            WasmImmediate[] immediates = (WasmImmediate[])((Object[])new WasmImmediate[0]);
            switch (op.getImmediates().size()) {
                case 0: {
                    if (WhenMappings.$EnumSwitchMapping$1[op.ordinal()] != 1) break;
                    IrType irType = call2.getTypeArgument(0);
                    Intrinsics.checkNotNull((Object)irType);
                    IrType toIrType = irType;
                    this.generateTypeRTT(toIrType);
                    break;
                }
                case 1: {
                    WasmImmediate wasmImmediate;
                    WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
                    WasmImmediateKind imm = (WasmImmediateKind)op.getImmediates().get(0);
                    switch (WhenMappings.$EnumSwitchMapping$2[imm.ordinal()]) {
                        case 1: {
                            wasmImmediate = (WasmImmediate)new WasmImmediate.MemArg(0, 0, null);
                            break;
                        }
                        case 2: {
                            IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
                            Intrinsics.checkNotNull((Object)irValueParameter);
                            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)irValueParameter.getType());
                            Intrinsics.checkNotNull((Object)irClassSymbol);
                            wasmImmediate = (WasmImmediate)new WasmImmediate.GcType(this.context.referenceGcType(irClassSymbol));
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("Immediate " + imm + " is unsupported").toString());
                        }
                    }
                    wasmImmediateArray[0] = wasmImmediate;
                    immediates = wasmImmediateArray;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Op " + opString + " is unsupported").toString());
                }
            }
            this.body.buildInstr(op, Arrays.copyOf(immediates, immediates.length));
            return true;
        }
        return false;
    }

    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElement((IrElementVisitorVoid)this, (IrElement)element, (Void)data);
    }

    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression2, (Void)data);
    }

    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry, (Void)data);
    }

    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression2, (Void)data);
    }

    public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, expression2, (Void)data);
    }

    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression2, (Void)data);
    }

    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression2, (Void)data);
    }

    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression2, (Void)data);
    }

    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression2, (Void)data);
    }

    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression2, (Void)data);
    }

    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression2, (Void)data);
    }

    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression2, (Void)data);
    }

    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body2, (Void)data);
    }

    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression2, (Void)data);
    }

    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump, (Void)data);
    }

    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump, (Void)data);
    }

    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression2, (Void)data);
    }

    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression2, (Void)data);
    }

    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop, (Void)data);
    }

    public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop, (Void)data);
    }

    public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration2, (Void)data);
    }

    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration2);
    }

    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration2, (Void)data);
    }

    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2);
    }

    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2, (Void)data);
    }

    public void visitBody(@NotNull IrBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body2);
    }

    public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body2, (Void)data);
    }

    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch);
    }

    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch, (Void)data);
    }

    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump);
    }

    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump, (Void)data);
    }

    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2);
    }

    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2, (Void)data);
    }

    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch);
    }

    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch, (Void)data);
    }

    public void visitClass(@NotNull IrClass declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration2);
    }

    public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration2, (Void)data);
    }

    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2);
    }

    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2, (Void)data);
    }

    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2);
    }

    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2, (Void)data);
    }

    public void visitConstantArray(@NotNull IrConstantArray expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2);
    }

    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2, (Void)data);
    }

    public void visitConstantObject(@NotNull IrConstantObject expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2);
    }

    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2, (Void)data);
    }

    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2);
    }

    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2, (Void)data);
    }

    public void visitConstantValue(@NotNull IrConstantValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2);
    }

    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2, (Void)data);
    }

    public void visitConstructor(@NotNull IrConstructor declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration2);
    }

    public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration2, (Void)data);
    }

    public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration2);
    }

    public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration2, (Void)data);
    }

    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2);
    }

    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2, (Void)data);
    }

    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2);
    }

    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2, (Void)data);
    }

    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2);
    }

    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2, (Void)data);
    }

    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2);
    }

    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2, (Void)data);
    }

    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch);
    }

    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch, (Void)data);
    }

    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2);
    }

    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2, (Void)data);
    }

    public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration2);
    }

    public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration2, (Void)data);
    }

    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2);
    }

    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2, (Void)data);
    }

    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration2);
    }

    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration2, (Void)data);
    }

    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2);
    }

    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2, (Void)data);
    }

    public void visitExpression(@NotNull IrExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2);
    }

    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2, (Void)data);
    }

    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body2);
    }

    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body2, (Void)data);
    }

    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration2);
    }

    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration2, (Void)data);
    }

    public void visitField(@NotNull IrField declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration2);
    }

    public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration2, (Void)data);
    }

    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2);
    }

    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2, (Void)data);
    }

    public void visitFile(@NotNull IrFile declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration2);
    }

    public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration2, (Void)data);
    }

    public void visitFunction(@NotNull IrFunction declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration2);
    }

    public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration2, (Void)data);
    }

    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2);
    }

    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2, (Void)data);
    }

    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2);
    }

    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2, (Void)data);
    }

    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2);
    }

    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2, (Void)data);
    }

    public void visitGetClass(@NotNull IrGetClass expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2);
    }

    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2, (Void)data);
    }

    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2);
    }

    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2, (Void)data);
    }

    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2);
    }

    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2, (Void)data);
    }

    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2);
    }

    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2, (Void)data);
    }

    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration2);
    }

    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration2, (Void)data);
    }

    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2);
    }

    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2, (Void)data);
    }

    public void visitLoop(@NotNull IrLoop loop) {
        IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop);
    }

    public void visitLoop(@NotNull IrLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop, (Void)data);
    }

    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2);
    }

    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2, (Void)data);
    }

    public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration2);
    }

    public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration2, (Void)data);
    }

    public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration2);
    }

    public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration2, (Void)data);
    }

    public void visitProperty(@NotNull IrProperty declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration2);
    }

    public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration2, (Void)data);
    }

    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2);
    }

    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2, (Void)data);
    }

    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2);
    }

    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2, (Void)data);
    }

    public void visitScript(@NotNull IrScript declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration2);
    }

    public void visitScript(@NotNull IrScript declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration2, (Void)data);
    }

    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration2);
    }

    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration2, (Void)data);
    }

    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2);
    }

    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2, (Void)data);
    }

    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread);
    }

    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread, (Void)data);
    }

    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2);
    }

    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2, (Void)data);
    }

    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2);
    }

    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2, (Void)data);
    }

    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2);
    }

    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2, (Void)data);
    }

    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body2);
    }

    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body2, (Void)data);
    }

    public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration2);
    }

    public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration2, (Void)data);
    }

    public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration2);
    }

    public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration2, (Void)data);
    }

    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2, (Void)data);
    }

    public void visitValueParameter(@NotNull IrValueParameter declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration2);
    }

    public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration2, (Void)data);
    }

    public void visitVararg(@NotNull IrVararg expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression2);
    }

    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression2, (Void)data);
    }

    public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVariableAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2);
    }

    public static final /* synthetic */ WasmBackendContext access$getBackendContext$p(BodyGenerator $this) {
        return $this.backendContext;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 1;
            nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WasmOp.values().length];
            nArray[WasmOp.REF_TEST.ordinal()] = 1;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[WasmImmediateKind.values().length];
            nArray[WasmImmediateKind.MEM_ARG.ordinal()] = 1;
            nArray[WasmImmediateKind.STRUCT_TYPE_IDX.ordinal()] = 2;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

