/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.lower.Closure;
import org.jetbrains.kotlin.backend.common.lower.ClosureAnnotator;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmInnerClassesSupport;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptFixLambdasTransformer;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptFixLambdasTransformerContext;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptToClassTransformer;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptToClassTransformerContext;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptsToClassesLowering;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptsToClassesSymbolRemapper;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReporterWithContext;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrAnonymousInitializerImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrClassImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrExternalPackageFragmentImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrAnonymousInitializerSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrAnonymousInitializerSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SimpleTypeRemapper;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmBackendErrors;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\"\u001a\u00020\u0017*\u00020\u0019H\u0002J \u0010#\u001a\u00020\u0017*\u00020\u00192\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesLowering;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "innerClassesSupport", "Lorg/jetbrains/kotlin/backend/jvm/JvmInnerClassesSupport;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Lorg/jetbrains/kotlin/backend/jvm/JvmInnerClassesSupport;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "getInnerClassesSupport", "()Lorg/jetbrains/kotlin/backend/jvm/JvmInnerClassesSupport;", "scriptingJvmPackage", "Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "getScriptingJvmPackage", "()Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "scriptingJvmPackage$delegate", "Lkotlin/Lazy;", "collectCapturingClasses", "", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrClassImpl;", "irScript", "Lorg/jetbrains/kotlin/ir/declarations/IrScript;", "finalizeScriptClass", "", "irScriptClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "symbolRemapper", "Lorg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesSymbolRemapper;", "lower", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "prepareScriptClass", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "addScriptMainFun", "addSimplePropertyFrom", "from", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "initializer", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "backend.jvm.lower"})
final class ScriptsToClassesLowering {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final JvmInnerClassesSupport innerClassesSupport;
    @NotNull
    private final Lazy scriptingJvmPackage$delegate;

    public ScriptsToClassesLowering(@NotNull JvmBackendContext context2, @NotNull JvmInnerClassesSupport innerClassesSupport) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)innerClassesSupport, (String)"innerClassesSupport");
        this.context = context2;
        this.innerClassesSupport = innerClassesSupport;
        this.scriptingJvmPackage$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<IrExternalPackageFragment>(this){
            final /* synthetic */ ScriptsToClassesLowering this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrExternalPackageFragment invoke() {
                return IrExternalPackageFragmentImpl.Companion.createEmptyExternalPackageFragment(this.this$0.getContext().getState().getModule(), new FqName("kotlin.script.experimental.jvm"));
            }
        }));
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final JvmInnerClassesSupport getInnerClassesSupport() {
        return this.innerClassesSupport;
    }

    public final void lower(@NotNull IrModuleFragment module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map scriptsToClasses = new LinkedHashMap();
        for (IrFile irFile : module.getFiles()) {
            ListIterator<IrClass> iterator2 = irFile.getDeclarations().listIterator();
            while (iterator2.hasNext()) {
                IrDeclaration declaration2 = (IrDeclaration)iterator2.next();
                if (!(declaration2 instanceof IrScript)) continue;
                IrClass scriptClass = this.prepareScriptClass(irFile, (IrScript)declaration2);
                scriptsToClasses.put(declaration2, scriptClass);
                iterator2.set(scriptClass);
            }
        }
        ScriptsToClassesSymbolRemapper symbolRemapper2 = new ScriptsToClassesSymbolRemapper(scriptsToClasses);
        for (Map.Entry entry : scriptsToClasses.entrySet()) {
            IrScript irScript = (IrScript)entry.getKey();
            IrClass irScriptClass = (IrClass)entry.getValue();
            this.finalizeScriptClass(irScriptClass, irScript, symbolRemapper2);
        }
    }

    private final IrClass prepareScriptClass(IrFile irFile, IrScript irScript) {
        IrClass irClass;
        IrFileEntry fileEntry = irFile.getFileEntry();
        IrFactory $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u2d1$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$prepareScriptClass_u24lambda_u2d0 = $this$buildClass_u24lambda_u2d1$iv;
        boolean bl2 = false;
        $this$prepareScriptClass_u24lambda_u2d0.setStartOffset(0);
        $this$prepareScriptClass_u24lambda_u2d0.setEndOffset(fileEntry.getMaxOffset());
        $this$prepareScriptClass_u24lambda_u2d0.setOrigin((IrDeclarationOrigin)IrDeclarationOrigin.SCRIPT_CLASS.INSTANCE);
        $this$prepareScriptClass_u24lambda_u2d0.setName(irScript.getName());
        $this$prepareScriptClass_u24lambda_u2d0.setKind(ClassKind.CLASS);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PUBLIC");
        $this$prepareScriptClass_u24lambda_u2d0.setVisibility(descriptorVisibility);
        $this$prepareScriptClass_u24lambda_u2d0.setModality(Modality.FINAL);
        IrClass irScriptClass = irClass = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, (IrClassBuilder)$this$buildClass_u24lambda_u2d1$iv);
        boolean bl3 = false;
        irScriptClass.setSuperTypes(CollectionsKt.plus((Collection)irScriptClass.getSuperTypes(), (Object)irScript.getBaseClass()));
        irScriptClass.setParent((IrDeclarationParent)irFile);
        irScriptClass.setMetadata(irScript.getMetadata());
        irScript.setTargetClass(irScriptClass.getSymbol());
        return irClass;
    }

    private final Set<IrClassImpl> collectCapturingClasses(IrScript irScript) {
        ClosureAnnotator annotator = new ClosureAnnotator((IrElement)irScript, (IrDeclaration)irScript);
        Set capturingClasses = new LinkedHashSet();
        IrElementVisitorVoid collector2 = new IrElementVisitorVoid(annotator, irScript, this, capturingClasses){
            final /* synthetic */ ClosureAnnotator $annotator;
            final /* synthetic */ IrScript $irScript;
            final /* synthetic */ ScriptsToClassesLowering this$0;
            final /* synthetic */ Set<IrClassImpl> $capturingClasses;
            {
                this.$annotator = $annotator;
                this.$irScript = $irScript;
                this.this$0 = $receiver;
                this.$capturingClasses = $capturingClasses;
            }

            public void visitElement(@NotNull IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrElementVisitorVoidKt.acceptChildrenVoid((IrElement)element, (IrElementVisitorVoid)this);
            }

            public void visitClass(@NotNull IrClass declaration2) {
                Closure closure;
                IrValueSymbol irValueSymbol;
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                if (declaration2 instanceof IrClassImpl && !((IrClassImpl)declaration2).isInner() && Intrinsics.areEqual((Object)((irValueSymbol = (IrValueSymbol)CollectionsKt.singleOrNull((List)(closure = this.$annotator.getClassClosure(declaration2)).getCapturedValues())) != null && (irValueSymbol = irValueSymbol.getOwner()) != null ? irValueSymbol.getType() : null), (Object)this.$irScript.getThisReceiver().getType())) {
                    if (IrUtilsKt.isInterface((IrClass)declaration2)) {
                        collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration2, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_INTERFACE(), null, 8, null);
                    } else if (IrUtilsKt.isEnumClass((IrClass)declaration2)) {
                        collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration2, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_ENUM(), null, 8, null);
                    } else if (IrUtilsKt.isEnumEntry((IrClass)declaration2)) {
                        collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration2, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_ENUM_ENTRY(), null, 8, null);
                    } else if (declaration2.isCompanion()) {
                        collectCapturingClasses.collector.1.visitClass$reportError(this.this$0, declaration2, (KtDiagnosticFactory1<String>)JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_OBJECT(), SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
                    } else if (declaration2.getKind().isSingleton()) {
                        collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration2, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_OBJECT(), null, 8, null);
                    } else if (IrUtilsKt.isClass((IrClass)declaration2)) {
                        if (!Intrinsics.areEqual((Object)declaration2.getParent(), (Object)this.$irScript)) {
                            KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = this.this$0.getContext().getKtDiagnosticReporter().at((IrDeclaration)declaration2);
                            KtDiagnosticFactory2 ktDiagnosticFactory2 = JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_NESTED_CLASS();
                            String string2 = declaration2.getName().asString();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"declaration.name.asString()");
                            IrDeclarationParent irDeclarationParent = declaration2.getParent();
                            IrDeclarationWithName irDeclarationWithName = irDeclarationParent instanceof IrDeclarationWithName ? (IrDeclarationWithName)irDeclarationParent : null;
                            if (irDeclarationWithName == null || (irDeclarationWithName = irDeclarationWithName.getName()) == null) {
                                irDeclarationWithName = SpecialNames.NO_NAME_PROVIDED;
                            }
                            String string3 = irDeclarationWithName.asString();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(declaration.parent as? \u2026NAME_PROVIDED).asString()");
                            KtDiagnosticReporterWithContext.DiagnosticContextImpl.report$default((KtDiagnosticReporterWithContext.DiagnosticContextImpl)diagnosticContextImpl, (KtDiagnosticFactory2)ktDiagnosticFactory2, (Object)string2, (Object)string3, null, (int)8, null);
                        } else {
                            this.$capturingClasses.add((IrClassImpl)declaration2);
                        }
                    }
                }
                IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration2);
            }

            public void visitElement(@NotNull IrElement element, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElement((IrElementVisitorVoid)this, (IrElement)element, (Void)data);
            }

            public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration2, (Void)data);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration2, (Void)data);
            }

            public void visitBlock(@NotNull IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2);
            }

            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2, (Void)data);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body2, (Void)data);
            }

            public void visitBody(@NotNull IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body2, (Void)data);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch, (Void)data);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump, (Void)data);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump, (Void)data);
            }

            public void visitCall(@NotNull IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression2);
            }

            public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression2, (Void)data);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2, (Void)data);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch, (Void)data);
            }

            public void visitClassReference(@NotNull IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2, (Void)data);
            }

            public void visitComposite(@NotNull IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2);
            }

            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2, (Void)data);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, expression2);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, expression2, (Void)data);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2, (Void)data);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2, (Void)data);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2, (Void)data);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2, (Void)data);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration2, (Void)data);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression2, (Void)data);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression2, (Void)data);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump, (Void)data);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration2, (Void)data);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2, (Void)data);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression2, (Void)data);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop, (Void)data);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2, (Void)data);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2, (Void)data);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2, (Void)data);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch, (Void)data);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2, (Void)data);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration2, (Void)data);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2, (Void)data);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration2, (Void)data);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2, (Void)data);
            }

            public void visitExpression(@NotNull IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2);
            }

            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2, (Void)data);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body2, (Void)data);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration2, (Void)data);
            }

            public void visitField(@NotNull IrField declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration2);
            }

            public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration2, (Void)data);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2, (Void)data);
            }

            public void visitFile(@NotNull IrFile declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration2);
            }

            public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration2, (Void)data);
            }

            public void visitFunction(@NotNull IrFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration2);
            }

            public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration2, (Void)data);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2, (Void)data);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2, (Void)data);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2, (Void)data);
            }

            public void visitGetClass(@NotNull IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2, (Void)data);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2, (Void)data);
            }

            public void visitGetField(@NotNull IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression2);
            }

            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression2, (Void)data);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2, (Void)data);
            }

            public void visitGetValue(@NotNull IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression2, (Void)data);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2, (Void)data);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration2, (Void)data);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2, (Void)data);
            }

            public void visitLoop(@NotNull IrLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop);
            }

            public void visitLoop(@NotNull IrLoop loop, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop, (Void)data);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2, (Void)data);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration2, (Void)data);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration2, (Void)data);
            }

            public void visitProperty(@NotNull IrProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration2);
            }

            public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration2, (Void)data);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2, (Void)data);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2, (Void)data);
            }

            public void visitReturn(@NotNull IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression2);
            }

            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression2, (Void)data);
            }

            public void visitScript(@NotNull IrScript declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration2);
            }

            public void visitScript(@NotNull IrScript declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration2, (Void)data);
            }

            public void visitSetField(@NotNull IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression2);
            }

            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression2, (Void)data);
            }

            public void visitSetValue(@NotNull IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression2, (Void)data);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration2, (Void)data);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2, (Void)data);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread, (Void)data);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2, (Void)data);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2, (Void)data);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2, (Void)data);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body2, (Void)data);
            }

            public void visitThrow(@NotNull IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression2);
            }

            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression2, (Void)data);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry, (Void)data);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration2, (Void)data);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression2, (Void)data);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration2, (Void)data);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2, (Void)data);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration2, (Void)data);
            }

            public void visitVararg(@NotNull IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression2);
            }

            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression2, (Void)data);
            }

            public void visitVariable(@NotNull IrVariable declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration2);
            }

            public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration2, (Void)data);
            }

            public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVariableAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression2, (Void)data);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop, (Void)data);
            }

            private static final void visitClass$reportError(ScriptsToClassesLowering this$0, IrClass $declaration, KtDiagnosticFactory1<String> factory, Name name) {
                KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = this$0.getContext().getKtDiagnosticReporter().at((IrDeclaration)$declaration);
                Name name2 = name;
                if (name2 == null) {
                    name2 = $declaration.getName();
                }
                String string2 = name2.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name ?: declaration.name).asString()");
                KtDiagnosticReporterWithContext.DiagnosticContextImpl.report$default((KtDiagnosticReporterWithContext.DiagnosticContextImpl)diagnosticContextImpl, factory, (Object)string2, null, (int)4, null);
            }

            static /* synthetic */ void visitClass$reportError$default(ScriptsToClassesLowering scriptsToClassesLowering, IrClass irClass, KtDiagnosticFactory1 ktDiagnosticFactory1, Name name, int n, Object object) {
                if ((n & 8) != 0) {
                    name = null;
                }
                collectCapturingClasses.collector.1.visitClass$reportError(scriptsToClassesLowering, irClass, (KtDiagnosticFactory1<String>)ktDiagnosticFactory1, name);
            }
        };
        for (IrStatement statement2 : irScript.getStatements()) {
            if (!(statement2 instanceof IrClassImpl)) continue;
            collector2.visitClass((IrClass)statement2);
        }
        return capturingClasses;
    }

    /*
     * WARNING - void declaration
     */
    private final void finalizeScriptClass(IrClass irScriptClass, IrScript irScript, ScriptsToClassesSymbolRemapper symbolRemapper2) {
        block14: {
            IrField irField;
            IrBlockBodyBuilder it;
            void $this$finalizeScriptClass_u24lambda_u2d5_u24lambda_u2d4;
            IrConstructor baseClassCtor;
            void this_$iv$iv;
            IrConstructor irConstructor;
            IrConstructor irConstructor2;
            SimpleTypeRemapper typeRemapper = new SimpleTypeRemapper((SymbolRemapper)symbolRemapper2);
            Set<IrClassImpl> capturingClasses = this.collectCapturingClasses(irScript);
            ScriptToClassTransformer scriptTransformer = new ScriptToClassTransformer(irScript, irScriptClass, (TypeRemapper)typeRemapper, this.context, capturingClasses, this.innerClassesSupport);
            ScriptFixLambdasTransformer lambdaPatcher = new ScriptFixLambdasTransformer(irScript, irScriptClass, this.context);
            irScriptClass.setThisReceiver(scriptTransformer.getScriptClassReceiver());
            IrValueParameter irValueParameter = irScriptClass.getThisReceiver();
            ScriptToClassTransformerContext defaultContext = new ScriptToClassTransformerContext((IrValueParameterSymbol)(irValueParameter != null ? irValueParameter.getSymbol() : null), null, null);
            IrConstructor irConstructor3 = irScript.getConstructor();
            if (irConstructor3 != null && (irConstructor3 = ScriptsToClassesLowering.finalizeScriptClass$patchForClass((IrElement)irConstructor3, scriptTransformer, defaultContext, lambdaPatcher)) != null) {
                IrConstructor $this$safeAs$iv = irConstructor3;
                boolean $i$f$safeAs = false;
                IrConstructor irConstructor4 = $this$safeAs$iv;
                if (!(irConstructor4 instanceof IrConstructor)) {
                    irConstructor4 = null;
                }
                irConstructor2 = irConstructor4;
            } else {
                irConstructor2 = null;
            }
            Intrinsics.checkNotNull(irConstructor2);
            IrConstructor constructor = irConstructor = irConstructor2;
            boolean bl = false;
            int explicitParamsStartIndex = irScript.getEarlierScriptsParameter() == null ? 0 : 1;
            List explicitParameters = constructor.getValueParameters().subList(explicitParamsStartIndex, irScript.getExplicitCallParameters().size() + explicitParamsStartIndex);
            IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)constructor.getSymbol()), (int)0, (int)0, (int)6, null);
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void var20_26 = this_$iv$iv;
            IrConstructor irConstructor5 = constructor;
            boolean bl2 = false;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)irScript.getBaseClass());
            IrConstructor irConstructor6 = irClassSymbol != null && (irClassSymbol = (IrClass)irClassSymbol.getOwner()) != null && (irClassSymbol = IrUtilsKt.getConstructors((IrClass)irClassSymbol)) != null ? (IrConstructor)SequencesKt.firstOrNull((Sequence)irClassSymbol) : (baseClassCtor = null);
            if (baseClassCtor == null) {
                $this$finalizeScriptClass_u24lambda_u2d5_u24lambda_u2d4.unaryPlus((IrStatement)ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)((IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2d5_u24lambda_u2d4), (IrConstructor)((IrConstructor)SequencesKt.single((Sequence)IrUtilsKt.getConstructors((IrClass)((IrClass)$this$finalizeScriptClass_u24lambda_u2d5_u24lambda_u2d4.getContext().getIrBuiltIns().getAnyClass().getOwner()))))));
            } else {
                IrDelegatingConstructorCall irDelegatingConstructorCall;
                IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)((IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2d5_u24lambda_u2d4), (IrConstructor)baseClassCtor);
                void var26_35 = $this$finalizeScriptClass_u24lambda_u2d5_u24lambda_u2d4;
                boolean bl3 = false;
                Iterable $this$forEachIndexed$iv = explicitParameters;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void valueParameter2;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    IrValueParameter irValueParameter2 = (IrValueParameter)item$iv;
                    int idx = n;
                    boolean bl4 = false;
                    it.putValueArgument(idx, (IrExpression)new IrGetValueImpl(valueParameter2.getStartOffset(), valueParameter2.getEndOffset(), valueParameter2.getType(), (IrValueSymbol)valueParameter2.getSymbol(), null, 16, null));
                }
                var26_35.unaryPlus((IrStatement)irDelegatingConstructorCall);
            }
            $this$finalizeScriptClass_u24lambda_u2d5_u24lambda_u2d4.unaryPlus((IrStatement)new IrInstanceInitializerCallImpl(irScript.getStartOffset(), irScript.getEndOffset(), irScriptClass.getSymbol(), $this$finalizeScriptClass_u24lambda_u2d5_u24lambda_u2d4.getContext().getIrBuiltIns().getUnitType()));
            irConstructor5.setBody((IrBody)this_$iv$iv.doBuild());
            irScriptClass.getDeclarations().add(constructor);
            constructor.setParent((IrDeclarationParent)irScriptClass);
            boolean hasMain = false;
            Iterable $this$forEach$iv = irScript.getStatements();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$finalizeScriptClass_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6;
                void this_$iv$iv2;
                IrVariable copy2;
                IrStatement scriptStatement = (IrStatement)element$iv;
                boolean bl5 = false;
                IrStatement irStatement = scriptStatement;
                if (irStatement instanceof IrVariable) {
                    copy2 = (IrVariable)ScriptsToClassesLowering.finalizeScriptClass$patchForClass((IrElement)scriptStatement, scriptTransformer, defaultContext, lambdaPatcher);
                    ScriptsToClassesLowering.addSimplePropertyFrom$default(this, irScriptClass, (IrValueDeclaration)copy2, null, 2, null);
                    continue;
                }
                if (irStatement instanceof IrDeclaration) {
                    copy2 = (IrDeclaration)ScriptsToClassesLowering.finalizeScriptClass$patchForClass((IrElement)scriptStatement, scriptTransformer, defaultContext, lambdaPatcher);
                    irScriptClass.getDeclarations().add(copy2);
                    if (!(copy2 instanceof IrSimpleFunction) || !Intrinsics.areEqual((Object)((IrSimpleFunction)copy2).getName().asString(), (Object)"main")) continue;
                    hasMain = true;
                    continue;
                }
                IrStatement transformedStatement = (IrStatement)ScriptsToClassesLowering.finalizeScriptClass$patchForClass((IrElement)scriptStatement, scriptTransformer, defaultContext, lambdaPatcher);
                IrClass $this$addAnonymousInitializer_u24default$iv = irScriptClass;
                boolean $i$f$addAnonymousInitializer = false;
                IrFunctionBuilder $this$addAnonymousInitializer_u24lambda_u2d0$iv = new IrFunctionBuilder();
                boolean bl6 = false;
                IrFunctionBuilder $this$null = $this$addAnonymousInitializer_u24lambda_u2d0$iv;
                $this$addAnonymousInitializer_u24lambda_u2d0$iv.setReturnType((IrType)IrUtilsKt.getDefaultType((IrClass)$this$addAnonymousInitializer_u24default$iv));
                IrConstructor anonymousInitializer$iv = baseClassCtor = new IrAnonymousInitializerImpl($this$addAnonymousInitializer_u24lambda_u2d0$iv.getStartOffset(), $this$addAnonymousInitializer_u24lambda_u2d0$iv.getEndOffset(), $this$addAnonymousInitializer_u24lambda_u2d0$iv.getOrigin(), (IrAnonymousInitializerSymbol)new IrAnonymousInitializerSymbolImpl(null, 1, null), false, null, 48, null);
                boolean bl7 = false;
                $this$addAnonymousInitializer_u24default$iv.getDeclarations().add(anonymousInitializer$iv);
                anonymousInitializer$iv.setParent((IrDeclarationParent)$this$addAnonymousInitializer_u24default$iv);
                IrBlockBodyBuilder irInitializer = irBlockBodyBuilder = (IrAnonymousInitializer)baseClassCtor;
                boolean bl8 = false;
                IrBuilderWithScope $this$irBlockBody_u24default$iv2 = (IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)irInitializer.getSymbol()), (int)0, (int)0, (int)6, null);
                int startOffset$iv2 = $this$irBlockBody_u24default$iv2.getStartOffset();
                int endOffset$iv2 = $this$irBlockBody_u24default$iv2.getEndOffset();
                boolean $i$f$irBlockBody2 = false;
                it = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv2.getContext(), $this$irBlockBody_u24default$iv2.getScope(), startOffset$iv2, endOffset$iv2);
                boolean $i$f$blockBody2 = false;
                void bl3 = this_$iv$iv2;
                IrBlockBodyBuilder irBlockBodyBuilder2 = irInitializer;
                boolean bl9 = false;
                if (transformedStatement instanceof IrComposite) {
                    for (IrStatement statement2 : ((IrComposite)transformedStatement).getStatements()) {
                        $this$finalizeScriptClass_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6.unaryPlus(statement2);
                    }
                } else {
                    $this$finalizeScriptClass_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6.unaryPlus(transformedStatement);
                }
                irBlockBodyBuilder2.setBody(this_$iv$iv2.doBuild());
            }
            if (!hasMain) {
                this.addScriptMainFun(irScriptClass);
            }
            irScriptClass.setAnnotations(CollectionsKt.plus((Collection)irScriptClass.getAnnotations(), (Iterable)((IrFile)irScriptClass.getParent()).getAnnotations()));
            IrPropertySymbol irPropertySymbol = irScript.getResultProperty();
            if (irPropertySymbol == null || (irPropertySymbol = (IrProperty)irPropertySymbol.getOwner()) == null) break block14;
            IrPropertySymbol irResultProperty = irPropertySymbol;
            boolean bl10 = false;
            this.context.getState().getScriptSpecific().setResultFieldName(irResultProperty.getName().getIdentifier());
            this.context.getState().getScriptSpecific().setResultTypeString((irField = irResultProperty.getBackingField()) != null && (irField = irField.getType()) != null ? RenderIrElementKt.render((IrType)irField) : null);
        }
    }

    private final IrExternalPackageFragment getScriptingJvmPackage() {
        Lazy lazy = this.scriptingJvmPackage$delegate;
        return (IrExternalPackageFragment)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void addScriptMainFun(IrClass $this$addScriptMainFun) {
        void $this$addScriptMainFun_u24lambda_u2d20_u24lambda_u2d19_u24lambda_u2d18_u24lambda_u2d17;
        void $this$addScriptMainFun_u24lambda_u2d20_u24lambda_u2d19_u24lambda_u2d18;
        void $this$addScriptMainFun_u24lambda_u2d20_u24lambda_u2d19;
        IrFactory irFactory;
        IrValueParameter irValueParameter;
        IrClassSymbol javaLangClass2 = this.context.getIr().getSymbols().getJavaLangClass();
        IrPropertySymbol kClassJava = this.context.getIr().getSymbols().getKClassJava();
        IrFactory $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u2d1$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$addScriptMainFun_u24lambda_u2d10 = $this$buildClass_u24lambda_u2d1$iv;
        boolean bl2 = false;
        Name name = Name.identifier((String)"RunnerKt");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"RunnerKt\")");
        $this$addScriptMainFun_u24lambda_u2d10.setName(name);
        $this$addScriptMainFun_u24lambda_u2d10.setKind(ClassKind.CLASS);
        $this$addScriptMainFun_u24lambda_u2d10.setModality(Modality.FINAL);
        $this$addScriptMainFun_u24lambda_u2d10.setInline(false);
        IrFactory $this$addScriptMainFun_u24lambda_u2d13 = $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, (IrClassBuilder)$this$buildClass_u24lambda_u2d1$iv);
        boolean bl3 = false;
        $this$addScriptMainFun_u24lambda_u2d13.setParent((IrDeclarationParent)this.getScriptingJvmPackage());
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$addScriptMainFun_u24lambda_u2d13);
        IrSimpleFunction $this$addScriptMainFun_u24lambda_u2d13_u24lambda_u2d12 = bl = DeclarationBuildersKt.addFunction$default((IrClass)$this$addScriptMainFun_u24lambda_u2d13, (String)"runCompiledScript", (IrType)this.context.getIrBuiltIns().getUnitType(), null, null, (boolean)true, (boolean)false, (boolean)false, null, (int)0, (int)0, (int)1004, null);
        boolean bl4 = false;
        DeclarationBuildersKt.addValueParameter$default((IrFunction)((IrFunction)$this$addScriptMainFun_u24lambda_u2d13_u24lambda_u2d12), (String)"scriptClass", (IrType)((IrType)IrTypesKt.getStarProjectedType((IrClassSymbol)javaLangClass2)), null, (int)4, null);
        IrFunction $this$addValueParameter$iv = (IrFunction)$this$addScriptMainFun_u24lambda_u2d13_u24lambda_u2d12;
        boolean $i$f$addValueParameter = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv = new IrValueParameterBuilder();
        boolean bl5 = false;
        IrValueParameterBuilder $this$addScriptMainFun_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11 = $this$addValueParameter_u24lambda_u2d28$iv;
        boolean bl6 = false;
        Name name2 = Name.identifier((String)"args");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"args\")");
        $this$addScriptMainFun_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11.setName(name2);
        IrValueParameter irValueParameter2 = new IrValueParameter[]{this.context.getIrBuiltIns().getStringType()};
        $this$addScriptMainFun_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11.setType((IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass()), (IrType[])irValueParameter2));
        $this$addScriptMainFun_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11.setOrigin((IrDeclarationOrigin)IrDeclarationOrigin.DEFINED.INSTANCE);
        $this$addScriptMainFun_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11.setVarargElementType(this.context.getIrBuiltIns().getAnyNType());
        if ($this$addValueParameter_u24lambda_u2d28$iv.getIndex() == -1) {
            $this$addValueParameter_u24lambda_u2d28$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
        }
        IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter((IrFactory)$this$addValueParameter$iv.getFactory(), (IrValueParameterBuilder)$this$addValueParameter_u24lambda_u2d28$iv, (IrDeclarationParent)((IrDeclarationParent)$this$addValueParameter$iv));
        boolean bl7 = false;
        $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
        IrClassSymbol scriptRunnerPackageClass = $this$buildClass$iv.getSymbol();
        Sequence $this$single$iv = IrUtilsKt.getFunctions((IrClassSymbol)scriptRunnerPackageClass);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
            boolean bl8 = false;
            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it.getOwner()).getName().asString(), (Object)"runCompiledScript")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunctionSymbol scriptRunHelper = single$iv;
        IrClassReferenceImpl scriptClassRef = new IrClassReferenceImpl($this$addScriptMainFun.getStartOffset(), $this$addScriptMainFun.getEndOffset(), (IrType)IrTypesKt.getStarProjectedType((IrClassSymbol)this.context.getIrBuiltIns().getKClassClass()), (IrClassifierSymbol)this.context.getIrBuiltIns().getKClassClass(), (IrType)IrUtilsKt.getDefaultType((IrClass)$this$addScriptMainFun));
        IrClass $this$addFunction$iv = $this$addScriptMainFun;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        IrFactory $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv$iv$iv = new IrFunctionBuilder();
        boolean bl9 = false;
        IrFunctionBuilder $this$addScriptMainFun_u24lambda_u2d15 = $this$buildFun_u24lambda_u2d16$iv$iv$iv;
        boolean $i$a$-addFunction-ScriptsToClassesLowering$addScriptMainFun$22 = false;
        Name name3 = Name.identifier((String)"main");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(\"main\")");
        $this$addScriptMainFun_u24lambda_u2d15.setName(name3);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PUBLIC");
        $this$addScriptMainFun_u24lambda_u2d15.setVisibility(descriptorVisibility);
        $this$addScriptMainFun_u24lambda_u2d15.setReturnType(this.context.getIrBuiltIns().getUnitType());
        $this$addScriptMainFun_u24lambda_u2d15.setModality(Modality.FINAL);
        IrFactory function$iv$iv = $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2d16$iv$iv$iv);
        boolean bl10 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add(function$iv$iv);
        function$iv$iv.setParent((IrDeclarationParent)((IrDeclarationContainer)$this$addFunction$iv));
        IrFactory mainFun = irFactory = $this$buildFun$iv$iv$iv;
        boolean bl11 = false;
        IrFunction $this$addValueParameter$iv2 = (IrFunction)mainFun;
        boolean $i$f$addValueParameter22 = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv2 = new IrValueParameterBuilder();
        $i$a$-run-DeclarationBuildersKt$addValueParameter$1$iv = false;
        IrValueParameterBuilder $this$addScriptMainFun_u24lambda_u2d20_u24lambda_u2d16 = $this$addValueParameter_u24lambda_u2d28$iv2;
        boolean bl12 = false;
        Name name4 = Name.identifier((String)"args");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(\"args\")");
        $this$addScriptMainFun_u24lambda_u2d20_u24lambda_u2d16.setName(name4);
        IrType[] $i$a$-addFunction-ScriptsToClassesLowering$addScriptMainFun$22 = new IrType[]{this.context.getIrBuiltIns().getStringType()};
        $this$addScriptMainFun_u24lambda_u2d20_u24lambda_u2d16.setType((IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass()), (IrType[])$i$a$-addFunction-ScriptsToClassesLowering$addScriptMainFun$22));
        if ($this$addValueParameter_u24lambda_u2d28$iv2.getIndex() == -1) {
            $this$addValueParameter_u24lambda_u2d28$iv2.setIndex($this$addValueParameter$iv2.getValueParameters().size());
        }
        IrValueParameter valueParameter$iv2 = irValueParameter2 = DeclarationBuildersKt.buildValueParameter((IrFactory)$this$addValueParameter$iv2.getFactory(), (IrValueParameterBuilder)$this$addValueParameter_u24lambda_u2d28$iv2, (IrDeclarationParent)((IrDeclarationParent)$this$addValueParameter$iv2));
        $i$a$-also-DeclarationBuildersKt$addValueParameter$1$1$iv = false;
        $this$addValueParameter$iv2.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv2.getValueParameters(), (Object)valueParameter$iv2));
        IrValueParameter args = irValueParameter2;
        DeclarationIrBuilder $i$f$addValueParameter22 = LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)mainFun.getSymbol()), (int)0, (int)0, (int)6, null);
        IrFactory irFactory2 = mainFun;
        boolean bl13 = false;
        IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$addScriptMainFun_u24lambda_u2d20_u24lambda_u2d19), (IrSimpleFunctionSymbol)scriptRunHelper);
        $this$addScriptMainFun_u24lambda_u2d20_u24lambda_u2d16 = irCall;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$addScriptMainFun_u24lambda_u2d20_u24lambda_u2d19;
        boolean bl14 = false;
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$addScriptMainFun_u24lambda_u2d20_u24lambda_u2d19;
        IrType irType = (IrType)IrTypesKt.getStarProjectedType((IrClassSymbol)javaLangClass2);
        IrSimpleFunction irSimpleFunction = ((IrProperty)kClassJava.getOwner()).getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        valueParameter$iv2 = irValueParameter2 = ExpressionHelpersKt.irGet((IrBuilderWithScope)irBuilderWithScope2, (IrType)irType, null, (IrFunctionSymbol)((IrFunctionSymbol)irSimpleFunction.getSymbol()));
        int n = 0;
        void var22_49 = $this$addScriptMainFun_u24lambda_u2d20_u24lambda_u2d19_u24lambda_u2d18;
        boolean bl15 = false;
        $this$addScriptMainFun_u24lambda_u2d20_u24lambda_u2d19_u24lambda_u2d18_u24lambda_u2d17.setExtensionReceiver((IrExpression)scriptClassRef);
        Unit unit = Unit.INSTANCE;
        var22_49.putValueArgument(n, (IrExpression)irValueParameter2);
        $this$addScriptMainFun_u24lambda_u2d20_u24lambda_u2d19_u24lambda_u2d18.putValueArgument(1, (IrExpression)new IrGetValueImpl(-1, -1, args.getType(), (IrValueSymbol)args.getSymbol(), null, 16, null));
        irFactory2.setBody((IrBody)ExpressionHelpersKt.irExprBody((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)irCall)));
    }

    /*
     * WARNING - void declaration
     */
    private final void addSimplePropertyFrom(IrClass $this$addSimplePropertyFrom, IrValueDeclaration from, IrExpressionBody initializer) {
        void field;
        IrField irField;
        void $this$addSimplePropertyFrom_u24lambda_u2d24_u24lambda_u2d22;
        IrFactory irFactory;
        IrClass $this$addProperty$iv = $this$addSimplePropertyFrom;
        boolean $i$f$addProperty = false;
        IrFactory $this$buildProperty$iv$iv = $this$addProperty$iv.getFactory();
        boolean $i$f$buildProperty = false;
        IrPropertyBuilder $this$buildProperty_u24lambda_u2d8$iv$iv = new IrPropertyBuilder();
        boolean bl = false;
        IrPropertyBuilder $this$addSimplePropertyFrom_u24lambda_u2d21 = $this$buildProperty_u24lambda_u2d8$iv$iv;
        boolean $i$a$-addProperty-ScriptsToClassesLowering$addSimplePropertyFrom$22 = false;
        $this$addSimplePropertyFrom_u24lambda_u2d21.updateFrom((IrDeclaration)from);
        $this$addSimplePropertyFrom_u24lambda_u2d21.setName(from.getName());
        IrFactory property$iv = $this$buildProperty$iv$iv = DeclarationBuildersKt.buildProperty((IrFactory)$this$buildProperty$iv$iv, (IrPropertyBuilder)$this$buildProperty_u24lambda_u2d8$iv$iv);
        boolean bl2 = false;
        $this$addProperty$iv.getDeclarations().add(property$iv);
        property$iv.setParent((IrDeclarationParent)$this$addProperty$iv);
        IrFactory property = irFactory = $this$buildProperty$iv$iv;
        boolean bl3 = false;
        IrFactory $this$buildField$iv = this.context.getIrFactory();
        boolean $i$f$buildField22 = false;
        IrFieldBuilder $this$buildField_u24lambda_u2d4$iv = new IrFieldBuilder();
        boolean bl4 = false;
        IrFieldBuilder $i$a$-addProperty-ScriptsToClassesLowering$addSimplePropertyFrom$22 = $this$buildField_u24lambda_u2d4$iv;
        IrFactory irFactory2 = property;
        boolean bl5 = false;
        $this$addSimplePropertyFrom_u24lambda_u2d24_u24lambda_u2d22.setName(from.getName());
        $this$addSimplePropertyFrom_u24lambda_u2d24_u24lambda_u2d22.setType(from.getType());
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PROTECTED;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PROTECTED");
        $this$addSimplePropertyFrom_u24lambda_u2d24_u24lambda_u2d22.setVisibility(descriptorVisibility);
        IrField $i$f$buildField22 = irField = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv, (IrFieldBuilder)$this$buildField_u24lambda_u2d4$iv);
        boolean bl6 = false;
        field.setParent((IrDeclarationParent)$this$addSimplePropertyFrom);
        if (initializer != null) {
            field.setInitializer(initializer);
        }
        DeclarationBuildersKt.addDefaultGetter((IrProperty)property, (IrClass)$this$addSimplePropertyFrom, (IrBuiltIns)this.context.getIrBuiltIns());
        irFactory2.setBackingField(irField);
    }

    static /* synthetic */ void addSimplePropertyFrom$default(ScriptsToClassesLowering scriptsToClassesLowering, IrClass irClass, IrValueDeclaration irValueDeclaration, IrExpressionBody irExpressionBody, int n, Object object) {
        if ((n & 2) != 0) {
            irExpressionBody = null;
        }
        scriptsToClassesLowering.addSimplePropertyFrom(irClass, irValueDeclaration, irExpressionBody);
    }

    private static final <E extends IrElement> IrElement finalizeScriptClass$patchForClass(E $this$finalizeScriptClass_u24patchForClass, ScriptToClassTransformer scriptTransformer, ScriptToClassTransformerContext defaultContext, ScriptFixLambdasTransformer lambdaPatcher) {
        return $this$finalizeScriptClass_u24patchForClass.transform((IrElementTransformer)scriptTransformer, (Object)defaultContext).transform((IrElementTransformer)lambdaPatcher, (Object)new ScriptFixLambdasTransformerContext(false, null, 3, null));
    }
}

