/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.phaser.NamedCompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseBuildersKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.FileClassLoweringKt;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmSimpleFileClassInfo;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.PsiIrFileEntry;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\" \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\f"}, d2={"fileClassPhase", "Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getFileClassPhase", "()Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "checkAllFileLevelDeclarationsAreClasses", "", "irModuleFragment", "getFileClassInfo", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.jvm.lower"})
public final class FileClassLoweringKt {
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrModuleFragment> fileClassPhase = PhaseBuildersKt.makeIrModulePhase$default((Function1)fileClassPhase.1.INSTANCE, (String)"FileClass", (String)"Put file level function and property declaration into a class", null, null, null, (Set)SetsKt.setOf((Object)((Object)fileClassPhase.2.INSTANCE)), null, (int)184, null);

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrModuleFragment> getFileClassPhase() {
        return fileClassPhase;
    }

    public static final void checkAllFileLevelDeclarationsAreClasses(@NotNull IrModuleFragment irModuleFragment) {
        boolean bl;
        block8: {
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)irModuleFragment, (String)"irModuleFragment");
            Iterable $this$all$iv = irModuleFragment.getFiles();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl3;
                    block7: {
                        IrFile irFile = (IrFile)element$iv;
                        boolean bl4 = false;
                        Iterable $this$all$iv2 = irFile.getDeclarations();
                        boolean $i$f$all2 = false;
                        if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                            bl3 = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv2) {
                                IrDeclaration it = (IrDeclaration)element$iv2;
                                boolean bl5 = false;
                                if (it instanceof IrClass) continue;
                                bl3 = false;
                                break block7;
                            }
                            bl3 = true;
                        }
                    }
                    if (bl3) continue;
                    bl2 = false;
                    break block8;
                }
                bl2 = bl = true;
            }
        }
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public static final JvmFileClassInfo getFileClassInfo(@NotNull IrFile $this$getFileClassInfo) {
        JvmFileClassInfo jvmFileClassInfo;
        Intrinsics.checkNotNullParameter((Object)$this$getFileClassInfo, (String)"<this>");
        IrFileEntry fileEntry = $this$getFileClassInfo.getFileEntry();
        if (fileEntry instanceof PsiIrFileEntry) {
            jvmFileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)((KtFile)((PsiIrFileEntry)fileEntry).getPsiFile()));
        } else if (fileEntry instanceof NaiveSourceBasedFileEntryImpl) {
            jvmFileClassInfo = (JvmFileClassInfo)new JvmSimpleFileClassInfo(PackagePartClassUtils.getPackagePartFqName((FqName)$this$getFileClassInfo.getFqName(), (String)fileEntry.getName()), false);
        } else {
            throw new IllegalStateException(("unknown kind of file entry: " + fileEntry).toString());
        }
        return jvmFileClassInfo;
    }
}

