/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.bridges;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.FunctionHandle;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u0001*\n\b\u0001\u0010\u0002 \u0001*\u00020\u00032\u00020\u0004B#\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0011\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\bH\u00c6\u0003J>\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0005\u001a\u00028\u00002\b\b\u0002\u0010\u0006\u001a\u00028\u00002\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/common/bridges/Bridge;", "Signature", "Function", "Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;", "", "from", "to", "originalFunctions", "", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/Set;)V", "getFrom", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getOriginalFunctions", "()Ljava/util/Set;", "getTo", "component1", "component2", "component3", "copy", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/Set;)Lorg/jetbrains/kotlin/backend/common/bridges/Bridge;", "equals", "", "other", "hashCode", "", "toString", "", "backend-common"})
public final class Bridge<Signature, Function extends FunctionHandle> {
    private final Signature from;
    private final Signature to;
    @NotNull
    private final Set<Function> originalFunctions;

    public Bridge(Signature from, Signature to, @NotNull Set<? extends Function> originalFunctions) {
        Intrinsics.checkNotNullParameter(originalFunctions, (String)"originalFunctions");
        this.from = from;
        this.to = to;
        this.originalFunctions = originalFunctions;
    }

    public final Signature getFrom() {
        return this.from;
    }

    public final Signature getTo() {
        return this.to;
    }

    @NotNull
    public final Set<Function> getOriginalFunctions() {
        return this.originalFunctions;
    }

    @NotNull
    public String toString() {
        return this.from + " -> " + this.to;
    }

    public final Signature component1() {
        return this.from;
    }

    public final Signature component2() {
        return this.to;
    }

    @NotNull
    public final Set<Function> component3() {
        return this.originalFunctions;
    }

    @NotNull
    public final Bridge<Signature, Function> copy(Signature from, Signature to, @NotNull Set<? extends Function> originalFunctions) {
        Intrinsics.checkNotNullParameter(originalFunctions, (String)"originalFunctions");
        return new Bridge<Signature, Function>(from, to, originalFunctions);
    }

    public static /* synthetic */ Bridge copy$default(Bridge bridge, Object object, Object object2, Set set, int n, Object object3) {
        if ((n & 1) != 0) {
            object = bridge.from;
        }
        if ((n & 2) != 0) {
            object2 = bridge.to;
        }
        if ((n & 4) != 0) {
            set = bridge.originalFunctions;
        }
        return bridge.copy(object, object2, set);
    }

    public int hashCode() {
        int result2 = this.from == null ? 0 : this.from.hashCode();
        result2 = result2 * 31 + (this.to == null ? 0 : this.to.hashCode());
        result2 = result2 * 31 + ((Object)this.originalFunctions).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Bridge)) {
            return false;
        }
        Bridge bridge = (Bridge)other;
        if (!Intrinsics.areEqual(this.from, bridge.from)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.to, bridge.to)) {
            return false;
        }
        return Intrinsics.areEqual(this.originalFunctions, bridge.originalFunctions);
    }
}

