/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl.classFiles;

import com.intellij.util.containers.Interner;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.ClassifierResolutionContext;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaArrayType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaWildcardType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.PlatformUtilsKt;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u0014\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u001b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser;", "", "()V", "canonicalNameInterner", "Lcom/intellij/util/containers/Interner;", "", "mapAsmType", "Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "context", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;", "parseClassOrTypeVariableElement", "signature", "Ljava/text/CharacterIterator;", "parseClassifierRefSignature", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifierType;", "parseDimensions", "", "parseParameterizedClassRefSignature", "parsePrimitiveType", "primitiveType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "parseTypeParameter", "Lorg/jetbrains/kotlin/load/java/structure/JavaTypeParameter;", "parseTypeParametersDeclaration", "", "parseTypeString", "parseTypeVariableRefSignature", "parseTypeWithoutVarianceAndArray", "parseVariance", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$JavaSignatureVariance;", "ClsFormatException", "JavaSignatureVariance", "resolution.common.jvm"})
@SourceDebugExtension(value={"SMAP\nBinaryClassSignatureParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinaryClassSignatureParser.kt\norg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n1789#2,3:230\n*S KotlinDebug\n*F\n+ 1 BinaryClassSignatureParser.kt\norg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser\n*L\n200#1:230,3\n*E\n"})
public final class BinaryClassSignatureParser {
    @NotNull
    private final Interner<String> canonicalNameInterner = PlatformUtilsKt.createStringInterner();

    @NotNull
    public final List<JavaTypeParameter> parseTypeParametersDeclaration(@NotNull CharacterIterator signature, @NotNull ClassifierResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (signature.current() != '<') {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        ArrayList<JavaTypeParameter> typeParameters = new ArrayList<JavaTypeParameter>();
        signature.next();
        while (signature.current() != '>') {
            typeParameters.add(this.parseTypeParameter(signature, context));
        }
        signature.next();
        return CollectionsKt.compact(typeParameters);
    }

    private final JavaTypeParameter parseTypeParameter(CharacterIterator signature, ClassifierResolutionContext context) {
        StringBuilder name = new StringBuilder();
        while (signature.current() != ':' && signature.current() != '\uffff') {
            name.append(signature.current());
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw new ClsFormatException(null, null, 3, null);
        }
        String string = name.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name.toString()");
        String parameterName = string;
        List bounds = new SmartList();
        boolean hasImplicitObjectBound = false;
        while (signature.current() == ':') {
            signature.next();
            if (signature.current() == ':') {
                hasImplicitObjectBound = true;
                continue;
            }
            JavaClassifierType javaClassifierType = this.parseClassifierRefSignature(signature, context);
            if (javaClassifierType == null) continue;
            bounds.add(javaClassifierType);
        }
        Name name2 = Name.identifier(parameterName);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(parameterName)");
        return new BinaryJavaTypeParameter(name2, bounds, hasImplicitObjectBound);
    }

    @Nullable
    public final JavaClassifierType parseClassifierRefSignature(@NotNull CharacterIterator signature, @NotNull ClassifierResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        char c = signature.current();
        return c == 'L' ? this.parseParameterizedClassRefSignature(signature, context) : (c == 'T' ? this.parseTypeVariableRefSignature(signature, context) : null);
    }

    private final JavaClassifierType parseTypeVariableRefSignature(CharacterIterator signature, ClassifierResolutionContext context) {
        StringBuilder id = new StringBuilder();
        signature.next();
        while (signature.current() != ';' && signature.current() != '>' && signature.current() != '\uffff') {
            id.append(signature.current());
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw new ClsFormatException(null, null, 3, null);
        }
        if (signature.current() == ';') {
            signature.next();
        }
        Object object = this.canonicalNameInterner.intern((Object)id.toString());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"canonicalNameInterner.intern(id.toString())");
        String parameterName = (String)object;
        return new PlainJavaClassifierType((Function0<ClassifierResolutionContext.Result>)((Function0)new Function0<ClassifierResolutionContext.Result>(context, parameterName){
            final /* synthetic */ ClassifierResolutionContext $context;
            final /* synthetic */ String $parameterName;
            {
                this.$context = $context;
                this.$parameterName = $parameterName;
                super(0);
            }

            @NotNull
            public final ClassifierResolutionContext.Result invoke() {
                return this.$context.resolveTypeParameter$resolution_common_jvm(this.$parameterName);
            }
        }), kotlin.collections.CollectionsKt.emptyList());
    }

    private final JavaClassifierType parseParameterizedClassRefSignature(CharacterIterator signature, ClassifierResolutionContext context) {
        StringBuilder canonicalName = new StringBuilder();
        SmartList<List> argumentGroups = new SmartList<List>();
        signature.next();
        while (signature.current() != ';' && signature.current() != '\uffff') {
            char c = signature.current();
            if (c == '<') {
                List group = new ArrayList();
                signature.next();
                do {
                    group.add(this.parseClassOrTypeVariableElement(signature, context));
                } while (signature.current() != '>');
                argumentGroups.add(group);
            } else if (c != ' ') {
                canonicalName.append(c);
            }
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw new ClsFormatException(null, null, 3, null);
        }
        signature.next();
        String string = canonicalName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"canonicalName.toString()");
        Object object = this.canonicalNameInterner.intern((Object)StringsKt.replace$default((String)string, (char)'.', (char)'$', (boolean)false, (int)4, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"canonicalNameInterner.in\u2026ring().replace('.', '$'))");
        String internalName = (String)object;
        return new PlainJavaClassifierType((Function0<ClassifierResolutionContext.Result>)((Function0)new Function0<ClassifierResolutionContext.Result>(context, internalName){
            final /* synthetic */ ClassifierResolutionContext $context;
            final /* synthetic */ String $internalName;
            {
                this.$context = $context;
                this.$internalName = $internalName;
                super(0);
            }

            @NotNull
            public final ClassifierResolutionContext.Result invoke() {
                return this.$context.resolveByInternalName$resolution_common_jvm(this.$internalName);
            }
        }), CollectionsKt.compact((ArrayList)AddToStdlibKt.flattenTo(kotlin.collections.CollectionsKt.reversed((Iterable)argumentGroups), (Collection)new ArrayList())));
    }

    private final JavaType parseClassOrTypeVariableElement(CharacterIterator signature, ClassifierResolutionContext context) {
        JavaSignatureVariance variance = this.parseVariance(signature);
        if (variance == JavaSignatureVariance.STAR) {
            return new PlainJavaWildcardType(null, true);
        }
        JavaType type = this.parseTypeString(signature, context);
        if (variance == JavaSignatureVariance.NO_VARIANCE) {
            return type;
        }
        return new PlainJavaWildcardType(type, variance == JavaSignatureVariance.PLUS);
    }

    private final JavaSignatureVariance parseVariance(CharacterIterator signature) {
        JavaSignatureVariance variance;
        JavaSignatureVariance javaSignatureVariance;
        boolean advance = true;
        char c = signature.current();
        if (c == '+') {
            javaSignatureVariance = JavaSignatureVariance.PLUS;
        } else if (c == '-') {
            javaSignatureVariance = JavaSignatureVariance.MINUS;
        } else if (c == '*') {
            javaSignatureVariance = JavaSignatureVariance.STAR;
        } else if (c == '.' ? true : c == '=') {
            javaSignatureVariance = JavaSignatureVariance.NO_VARIANCE;
        } else {
            advance = false;
            javaSignatureVariance = variance = JavaSignatureVariance.NO_VARIANCE;
        }
        if (advance) {
            signature.next();
        }
        return variance;
    }

    private final int parseDimensions(CharacterIterator signature) {
        int dimensions = 0;
        while (signature.current() == '[') {
            ++dimensions;
            signature.next();
        }
        return dimensions;
    }

    @NotNull
    public final JavaType parseTypeString(@NotNull CharacterIterator signature, @NotNull ClassifierResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int dimensions = this.parseDimensions(signature);
        JavaType javaType = this.parseTypeWithoutVarianceAndArray(signature, context);
        if (javaType == null) {
            throw new ClsFormatException(null, null, 3, null);
        }
        JavaType type = javaType;
        Iterable $this$fold$iv = (Iterable)new IntRange(1, dimensions);
        boolean $i$f$fold = false;
        JavaType accumulator$iv = type;
        Iterator iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv = ((IntIterator)iterator2).nextInt();
            JavaType result2 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new PlainJavaArrayType(result2);
        }
        return accumulator$iv;
    }

    @NotNull
    public final JavaType mapAsmType(@NotNull Type type, @NotNull ClassifierResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.parseTypeString(new StringCharacterIterator(type.getDescriptor()), context);
    }

    private final JavaType parseTypeWithoutVarianceAndArray(CharacterIterator signature, ClassifierResolutionContext context) {
        char c = signature.current();
        return c == 'L' ? (JavaType)this.parseParameterizedClassRefSignature(signature, context) : (c == 'T' ? (JavaType)this.parseTypeVariableRefSignature(signature, context) : (c == 'B' ? this.parsePrimitiveType(signature, PrimitiveType.BYTE) : (c == 'C' ? this.parsePrimitiveType(signature, PrimitiveType.CHAR) : (c == 'D' ? this.parsePrimitiveType(signature, PrimitiveType.DOUBLE) : (c == 'F' ? this.parsePrimitiveType(signature, PrimitiveType.FLOAT) : (c == 'I' ? this.parsePrimitiveType(signature, PrimitiveType.INT) : (c == 'J' ? this.parsePrimitiveType(signature, PrimitiveType.LONG) : (c == 'Z' ? this.parsePrimitiveType(signature, PrimitiveType.BOOLEAN) : (c == 'S' ? this.parsePrimitiveType(signature, PrimitiveType.SHORT) : (c == 'V' ? this.parsePrimitiveType(signature, null) : null))))))))));
    }

    private final JavaType parsePrimitiveType(CharacterIterator signature, PrimitiveType primitiveType) {
        signature.next();
        return new PlainJavaPrimitiveType(primitiveType);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$ClsFormatException;", "", "message", "", "cause", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "resolution.common.jvm"})
    public static final class ClsFormatException
    extends Throwable {
        public ClsFormatException(@Nullable String message, @Nullable Throwable cause) {
            super(message, cause);
        }

        public /* synthetic */ ClsFormatException(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable);
        }

        public ClsFormatException() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$JavaSignatureVariance;", "", "(Ljava/lang/String;I)V", "PLUS", "MINUS", "STAR", "NO_VARIANCE", "resolution.common.jvm"})
    private static final class JavaSignatureVariance
    extends Enum<JavaSignatureVariance> {
        public static final /* enum */ JavaSignatureVariance PLUS = new JavaSignatureVariance();
        public static final /* enum */ JavaSignatureVariance MINUS = new JavaSignatureVariance();
        public static final /* enum */ JavaSignatureVariance STAR = new JavaSignatureVariance();
        public static final /* enum */ JavaSignatureVariance NO_VARIANCE = new JavaSignatureVariance();
        private static final /* synthetic */ JavaSignatureVariance[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static JavaSignatureVariance[] values() {
            return (JavaSignatureVariance[])$VALUES.clone();
        }

        public static JavaSignatureVariance valueOf(String value2) {
            return Enum.valueOf(JavaSignatureVariance.class, value2);
        }

        @NotNull
        public static EnumEntries<JavaSignatureVariance> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = javaSignatureVarianceArray = new JavaSignatureVariance[]{JavaSignatureVariance.PLUS, JavaSignatureVariance.MINUS, JavaSignatureVariance.STAR, JavaSignatureVariance.NO_VARIANCE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

