/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiElementFinderImpl;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightClassMarker;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.resolve.jvm.KotlinCliJavaFileManager;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;
import org.jetbrains.kotlin.resolve.jvm.KotlinSafeClassFinder;
import org.jetbrains.kotlin.resolve.jvm.NotFoundPackagesCachingStrategy;
import org.jetbrains.kotlin.resolve.jvm.TopPackageNamesProvider;

public class KotlinJavaPsiFacade
implements Disposable {
    private volatile KotlinPsiElementFinderWrapper[] elementFinders;
    private static final PsiPackage NULL_PACKAGE = new PsiPackageImpl(null, "NULL_PACKAGE");
    private volatile PackageCache packageCache;
    private volatile NotFoundPackagesCachingStrategy notFoundPackagesCachingStrategy;
    private final Project project;
    private final LightModifierList emptyModifierList;

    @Nullable
    private static PsiPackage unwrap(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(0);
        }
        return psiPackage == NULL_PACKAGE ? null : psiPackage;
    }

    public static KotlinJavaPsiFacade getInstance(Project project) {
        return (KotlinJavaPsiFacade)ServiceManager.getService((Project)project, KotlinJavaPsiFacade.class);
    }

    public KotlinJavaPsiFacade(@NotNull Project project) {
        if (project == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(1);
        }
        this.notFoundPackagesCachingStrategy = NotFoundPackagesCachingStrategy.Default.INSTANCE;
        this.project = project;
        this.emptyModifierList = new LightModifierList(PsiManager.getInstance((Project)project), (Language)KotlinLanguage.INSTANCE, new String[0]);
        LowMemoryWatcher.register(this::clearPackageCaches, (Disposable)this);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean relevant = false;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file = vFileEvent.getFile();
                    relevant = vFileEvent instanceof VFileCreateEvent && ((VFileCreateEvent)vFileEvent).isDirectory() || file != null && file.isDirectory() && (vFileEvent instanceof VFileDeleteEvent || vFileEvent instanceof VFileMoveEvent || vFileEvent instanceof VFileCopyEvent);
                    if (!relevant) continue;
                    break;
                }
                if (relevant) {
                    KotlinJavaPsiFacade.this.clearPackageCaches(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$1", "after"));
            }
        });
        final PsiModificationTracker modificationTracker = PsiManager.getInstance((Project)project).getModificationTracker();
        connection.subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){
            private long lastTimeSeen = -1L;

            public void modificationCountChanged() {
                long now = modificationTracker.getModificationCount();
                if (this.lastTimeSeen != now) {
                    this.lastTimeSeen = now;
                    KotlinJavaPsiFacade.this.clearPackageCaches(false);
                }
            }
        });
    }

    public void dispose() {
        this.clearPackageCaches();
    }

    public void clearPackageCaches() {
        this.clearPackageCaches(true);
    }

    private void clearPackageCaches(boolean force) {
        this.elementFinders = null;
        if (force) {
            this.packageCache = null;
        } else {
            this.obtainPackageCache().clear();
        }
    }

    public void setNotFoundPackagesCachingStrategy(NotFoundPackagesCachingStrategy notFoundPackagesCachingStrategy) {
        this.notFoundPackagesCachingStrategy = notFoundPackagesCachingStrategy;
    }

    public LightModifierList getEmptyModifierList() {
        return this.emptyModifierList;
    }

    public JavaClass findClass(@NotNull JavaClassFinder.Request request, @NotNull GlobalSearchScope scope2) {
        if (request == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(2);
        }
        if (scope2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(3);
        }
        if (scope2 == GlobalSearchScope.EMPTY_SCOPE) {
            return null;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        ClassId classId = request.getClassId();
        String qualifiedName = classId.asSingleFqName().asString();
        if (this.shouldUseSlowResolve()) {
            PsiClass[] classes2 = this.findClassesInDumbMode(qualifiedName, scope2);
            if (classes2.length != 0) {
                return KotlinJavaPsiFacade.createJavaClass(classId, classes2[0]);
            }
            return null;
        }
        for (KotlinPsiElementFinderWrapper finder : this.finders()) {
            Object aClass;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            if (finder instanceof CliFinder) {
                aClass = ((CliFinder)finder).findClass(request, scope2);
                if (aClass == null) continue;
                return aClass;
            }
            aClass = finder.findClass(qualifiedName, scope2);
            if (aClass == null) continue;
            return KotlinJavaPsiFacade.createJavaClass(classId, aClass);
        }
        return null;
    }

    @NotNull
    private static JavaClass createJavaClass(@NotNull ClassId classId, @NotNull PsiClass psiClass) {
        if (classId == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(4);
        }
        if (psiClass == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(5);
        }
        JavaClassImpl javaClass = new JavaClassImpl(psiClass);
        FqName fqName = classId.asSingleFqName();
        if (!fqName.equals(javaClass.getFqName())) {
            throw new IllegalStateException("Requested " + fqName + ", got " + javaClass.getFqName());
        }
        if (psiClass instanceof KtLightClassMarker) {
            throw new IllegalStateException("Kotlin light classes should not be found by JavaPsiFacade, resolving: " + fqName);
        }
        JavaClassImpl javaClassImpl = javaClass;
        if (javaClassImpl == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(6);
        }
        return javaClassImpl;
    }

    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope scope2) {
        if (packageFqName == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(7);
        }
        if (scope2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(8);
        }
        if (scope2 == GlobalSearchScope.EMPTY_SCOPE) {
            return Collections.emptySet();
        }
        KotlinPsiElementFinderWrapper[] finders = this.finders();
        if (finders.length == 1 && finders[0] instanceof CliFinder) {
            return ((CliFinder)finders[0]).knownClassNamesInPackage(packageFqName);
        }
        return null;
    }

    @NotNull
    private PsiClass[] findClassesInDumbMode(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(9);
        }
        if (scope2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(10);
        }
        String packageName = StringUtil.getPackageName((String)qualifiedName);
        PsiPackage pkg = this.findPackage(packageName, scope2);
        String className = StringUtil.getShortName((String)qualifiedName);
        if (pkg == null && packageName.length() < qualifiedName.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope2);
            if (containingClasses.length == 1) {
                PsiClass[] psiClassArray = PsiElementFinder.filterByName((String)className, (PsiClass[])containingClasses[0].getInnerClasses());
                if (psiClassArray == null) {
                    KotlinJavaPsiFacade.$$$reportNull$$$0(11);
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                KotlinJavaPsiFacade.$$$reportNull$$$0(12);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null || !pkg.containsClassNamed(className)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                KotlinJavaPsiFacade.$$$reportNull$$$0(13);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = pkg.findClassByShortName(className, scope2);
        if (psiClassArray == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(14);
        }
        return psiClassArray;
    }

    private boolean shouldUseSlowResolve() {
        DumbService dumbService = DumbService.getInstance((Project)this.getProject());
        return dumbService.isDumb() && dumbService.isAlternativeResolveEnabled();
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] finders() {
        KotlinPsiElementFinderWrapper[] answer = this.elementFinders;
        if (answer == null) {
            answer = this.calcFinders();
            this.elementFinders = answer;
        }
        if (answer == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(15);
        }
        return answer;
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] calcFinders() {
        ArrayList<CliFinder> elementFinders = new ArrayList<CliFinder>();
        JavaFileManager javaFileManager = KotlinJavaPsiFacade.findJavaFileManager(this.project);
        elementFinders.add((CliFinder)(javaFileManager instanceof KotlinCliJavaFileManager ? new CliFinder((KotlinCliJavaFileManager)javaFileManager) : new NonCliFinder(this.project, javaFileManager)));
        ArrayList<PsiElementFinder> nonKotlinFinders = new ArrayList<PsiElementFinder>();
        for (PsiElementFinder finder : PsiElementFinder.EP.getExtensions((AreaInstance)this.getProject())) {
            if (!(finder instanceof KotlinSafeClassFinder) && (finder instanceof NonClasspathClassFinder || finder instanceof KotlinFinderMarker || finder instanceof PsiElementFinderImpl)) continue;
            nonKotlinFinders.add(finder);
        }
        elementFinders.addAll(CollectionsKt.map(nonKotlinFinders, KotlinJavaPsiFacade::wrap));
        KotlinPsiElementFinderWrapper[] kotlinPsiElementFinderWrapperArray = elementFinders.toArray(new KotlinPsiElementFinderWrapper[0]);
        if (kotlinPsiElementFinderWrapperArray == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(16);
        }
        return kotlinPsiElementFinderWrapperArray;
    }

    @NotNull
    private static JavaFileManager findJavaFileManager(@NotNull Project project) {
        JavaFileManager javaFileManager;
        if (project == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(17);
        }
        if ((javaFileManager = (JavaFileManager)ServiceManager.getService((Project)project, JavaFileManager.class)) == null) {
            throw new IllegalStateException("JavaFileManager component is not found in project");
        }
        JavaFileManager javaFileManager2 = javaFileManager;
        if (javaFileManager2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(18);
        }
        return javaFileManager2;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName, GlobalSearchScope searchScope) {
        ConcurrentMap<Pair<String, GlobalSearchScope>, PsiPackage> notFoundPackageInScopeCache;
        if (qualifiedName == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(19);
        }
        if (searchScope == GlobalSearchScope.EMPTY_SCOPE) {
            return null;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (KotlinJavaPsiFacade.certainlyDoesNotExist(qualifiedName, searchScope)) {
            return null;
        }
        PackageCache cache2 = this.obtainPackageCache();
        Boolean packageFoundInAllScope = (Boolean)cache2.hasPackageInAllScopeCache.get(qualifiedName);
        if (packageFoundInAllScope != null && !packageFoundInAllScope.booleanValue()) {
            return null;
        }
        Pair key = new Pair((Object)qualifiedName, (Object)searchScope);
        PsiPackage pkg = (PsiPackage)cache2.packageInLibScopeCache.get(key);
        if (pkg != null) {
            return KotlinJavaPsiFacade.unwrap(pkg);
        }
        pkg = (PsiPackage)cache2.packageInScopeCache.get(key);
        if (pkg != null) {
            return KotlinJavaPsiFacade.unwrap(pkg);
        }
        boolean isALibrarySearchScope = KotlinJavaPsiFacade.isALibrarySearchScope(searchScope);
        NotFoundPackagesCachingStrategy.CacheType notFoundCacheType = this.notFoundPackagesCachingStrategy.chooseStrategy(isALibrarySearchScope, qualifiedName);
        ConcurrentMap<Pair<String, GlobalSearchScope>, PsiPackage> existedPackageInScopeCache = isALibrarySearchScope ? cache2.packageInLibScopeCache : cache2.packageInScopeCache;
        KotlinPsiElementFinderWrapper[] finders = this.filteredFinders();
        if (packageFoundInAllScope != null) {
            for (KotlinPsiElementFinderWrapper finder : finders) {
                PsiPackage aPackage;
                if (finder.isSameResultForAnyScope() || (aPackage = finder.findPackage(qualifiedName, searchScope)) == null) continue;
                return KotlinJavaPsiFacade.unwrap((PsiPackage)ConcurrencyUtil.cacheOrGet(existedPackageInScopeCache, (Object)key, (Object)aPackage));
            }
        } else {
            for (KotlinPsiElementFinderWrapper finder : finders) {
                PsiPackage aPackage = finder.findPackage(qualifiedName, searchScope);
                if (aPackage == null) continue;
                return KotlinJavaPsiFacade.unwrap((PsiPackage)ConcurrencyUtil.cacheOrGet(existedPackageInScopeCache, (Object)key, (Object)aPackage));
            }
            boolean found = false;
            for (KotlinPsiElementFinderWrapper finder : finders) {
                PsiPackage aPackage;
                if (finder.isSameResultForAnyScope() || (aPackage = finder.findPackage(qualifiedName, GlobalSearchScope.allScope((Project)this.project))) == null) continue;
                found = true;
                break;
            }
            if (found || notFoundCacheType != NotFoundPackagesCachingStrategy.CacheType.NO_CACHING) {
                cache2.hasPackageInAllScopeCache.put(qualifiedName, found);
            }
        }
        switch (notFoundCacheType) {
            case LIB_SCOPE: {
                notFoundPackageInScopeCache = cache2.packageInLibScopeCache;
                break;
            }
            case SCOPE: {
                notFoundPackageInScopeCache = cache2.packageInScopeCache;
                break;
            }
            case NO_CACHING: {
                return null;
            }
            default: {
                throw new IllegalStateException("Impossible enum value: " + notFoundCacheType.toString());
            }
        }
        return KotlinJavaPsiFacade.unwrap((PsiPackage)ConcurrencyUtil.cacheOrGet(notFoundPackageInScopeCache, (Object)key, (Object)NULL_PACKAGE));
    }

    private PackageCache obtainPackageCache() {
        PackageCache cache2 = this.packageCache;
        if (cache2 == null) {
            this.packageCache = cache2 = new PackageCache();
        }
        return cache2;
    }

    private static boolean isALibrarySearchScope(GlobalSearchScope searchScope) {
        return searchScope.isSearchInLibraries();
    }

    private static boolean certainlyDoesNotExist(@NotNull String qualifiedName, GlobalSearchScope searchScope) {
        TopPackageNamesProvider topPackageAwareSearchScope;
        Set<String> topPackageNames;
        if (qualifiedName == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(20);
        }
        if (searchScope instanceof TopPackageNamesProvider && (topPackageNames = (topPackageAwareSearchScope = (TopPackageNamesProvider)searchScope).getTopPackageNames()) != null) {
            String topPackageName = qualifiedName;
            int index = topPackageName.indexOf(46);
            if (index > 0) {
                topPackageName = topPackageName.substring(0, index);
            }
            if (!topPackageNames.contains(topPackageName)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] filteredFinders() {
        DumbService dumbService = DumbService.getInstance((Project)this.getProject());
        KotlinPsiElementFinderWrapper[] finders = this.finders();
        if (dumbService.isDumb()) {
            List list = dumbService.filterByDumbAwareness(Arrays.asList(finders));
            finders = list.toArray(new KotlinPsiElementFinderWrapper[0]);
        }
        if (finders == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(21);
        }
        return finders;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(22);
        }
        return project;
    }

    public static KotlinPsiElementFinderWrapper wrap(PsiElementFinder finder) {
        return finder instanceof DumbAware ? new KotlinPsiElementFinderWrapperImplDumbAware(finder) : new KotlinPsiElementFinderWrapperImpl(finder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqName";
                break;
            }
            case 9: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaClass";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesInDumbMode";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "finders";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFinders";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaFileManager";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "filteredFinders";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createJavaClass";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "knownClassNamesInPackage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findClassesInDumbMode";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findJavaFileManager";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "certainlyDoesNotExist";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NonCliFinder
    implements KotlinPsiElementFinderWrapper,
    DumbAware {
        private final JavaFileManager javaFileManager;
        private final PsiManager psiManager;
        private final PackageIndex packageIndex;

        public NonCliFinder(@NotNull Project project, @NotNull JavaFileManager javaFileManager) {
            if (project == null) {
                NonCliFinder.$$$reportNull$$$0(0);
            }
            if (javaFileManager == null) {
                NonCliFinder.$$$reportNull$$$0(1);
            }
            this.javaFileManager = javaFileManager;
            this.packageIndex = PackageIndex.getInstance((Project)project);
            this.psiManager = PsiManager.getInstance((Project)project);
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName == null) {
                NonCliFinder.$$$reportNull$$$0(2);
            }
            if (scope2 == null) {
                NonCliFinder.$$$reportNull$$$0(3);
            }
            return this.javaFileManager.findClass(qualifiedName, scope2);
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
            Query dirs;
            if (qualifiedName == null) {
                NonCliFinder.$$$reportNull$$$0(4);
            }
            if (scope2 == null) {
                NonCliFinder.$$$reportNull$$$0(5);
            }
            return NonCliFinder.hasDirectoriesInScope((Query<VirtualFile>)(dirs = this.packageIndex.getDirsByPackageName(qualifiedName, true)), scope2) ? new PsiPackageImpl(this.psiManager, qualifiedName) : null;
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return false;
        }

        private static boolean hasDirectoriesInScope(Query<VirtualFile> dirs, final GlobalSearchScope scope2) {
            CommonProcessors.FindProcessor<VirtualFile> findProcessor = new CommonProcessors.FindProcessor<VirtualFile>(){

                protected boolean accept(VirtualFile file) {
                    return scope2.accept(file);
                }
            };
            dirs.forEach((Processor)findProcessor);
            return findProcessor.isFound();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "javaFileManager";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$NonCliFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findClass";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPackage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CliFinder
    implements KotlinPsiElementFinderWrapper,
    DumbAware {
        private final KotlinCliJavaFileManager javaFileManager;

        public CliFinder(@NotNull KotlinCliJavaFileManager javaFileManager) {
            if (javaFileManager == null) {
                CliFinder.$$$reportNull$$$0(0);
            }
            this.javaFileManager = javaFileManager;
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName == null) {
                CliFinder.$$$reportNull$$$0(1);
            }
            if (scope2 == null) {
                CliFinder.$$$reportNull$$$0(2);
            }
            return this.javaFileManager.findClass(qualifiedName, scope2);
        }

        public JavaClass findClass(@NotNull JavaClassFinder.Request request, @NotNull GlobalSearchScope scope2) {
            if (request == null) {
                CliFinder.$$$reportNull$$$0(3);
            }
            if (scope2 == null) {
                CliFinder.$$$reportNull$$$0(4);
            }
            return this.javaFileManager.findClass(request, scope2);
        }

        @Nullable
        public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
            if (packageFqName == null) {
                CliFinder.$$$reportNull$$$0(5);
            }
            return this.javaFileManager.knownClassNamesInPackage(packageFqName);
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName == null) {
                CliFinder.$$$reportNull$$$0(6);
            }
            if (scope2 == null) {
                CliFinder.$$$reportNull$$$0(7);
            }
            return this.javaFileManager.findPackage(qualifiedName);
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "javaFileManager";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageFqName";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$CliFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findClass";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "knownClassNamesInPackage";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPackage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class KotlinPsiElementFinderWrapperImplDumbAware
    extends KotlinPsiElementFinderWrapperImpl
    implements DumbAware {
        private KotlinPsiElementFinderWrapperImplDumbAware(PsiElementFinder finder) {
            super(finder);
        }
    }

    private static class KotlinPsiElementFinderWrapperImpl
    implements KotlinPsiElementFinderWrapper {
        private final PsiElementFinder finder;

        private KotlinPsiElementFinderWrapperImpl(@NotNull PsiElementFinder finder) {
            if (finder == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(0);
            }
            this.finder = finder;
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(1);
            }
            if (scope2 == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(2);
            }
            return this.finder.findClass(qualifiedName, scope2);
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(3);
            }
            if (scope2 == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(4);
            }
            return this.finder.findPackage(qualifiedName);
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return true;
        }

        public String toString() {
            return this.finder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "finder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderWrapperImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findClass";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPackage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface KotlinPsiElementFinderWrapper {
        public PsiClass findClass(@NotNull String var1, @NotNull GlobalSearchScope var2);

        public PsiPackage findPackage(@NotNull String var1, @NotNull GlobalSearchScope var2);

        public boolean isSameResultForAnyScope();
    }

    private static class PackageCache {
        final ConcurrentMap<Pair<String, GlobalSearchScope>, PsiPackage> packageInLibScopeCache = new ConcurrentHashMap<Pair<String, GlobalSearchScope>, PsiPackage>();
        final ConcurrentMap<Pair<String, GlobalSearchScope>, PsiPackage> packageInScopeCache = new ConcurrentHashMap<Pair<String, GlobalSearchScope>, PsiPackage>();
        final ConcurrentMap<String, Boolean> hasPackageInAllScopeCache = new ConcurrentHashMap<String, Boolean>();

        private PackageCache() {
        }

        void clear() {
            this.packageInScopeCache.clear();
            this.hasPackageInAllScopeCache.clear();
        }
    }
}

