/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi.text;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtDecompiledFile;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.BuildDecompiledTextKt;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.ByDescriptorIndexer;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledTextIndexer;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.jvm.JvmBuiltInsSignatures;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\u0012\u001a\u00020\u0002*\u00020\u000bH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/ByDescriptorIndexer;", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledTextIndexer;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "descriptorRendererForKeys", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "getBuiltinsDescriptorKey", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getDeclarationForDescriptor", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "file", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/file/KtDecompiledFile;", "indexDescriptor", "", "toStringKey", "decompiler-to-psi"})
@SourceDebugExtension(value={"SMAP\nByDescriptorIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByDescriptorIndexer.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/ByDescriptorIndexer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n661#2,11:118\n1#3:129\n*S KotlinDebug\n*F\n+ 1 ByDescriptorIndexer.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/ByDescriptorIndexer\n*L\n80#1:118,11\n*E\n"})
public final class ByDescriptorIndexer
implements DecompiledTextIndexer<String> {
    @NotNull
    public static final ByDescriptorIndexer INSTANCE = new ByDescriptorIndexer();
    @NotNull
    private static final DescriptorRenderer descriptorRendererForKeys = DescriptorRenderer.Companion.withOptions((Function1)descriptorRendererForKeys.1.INSTANCE);
    @NotNull
    private static final Logger LOG;

    private ByDescriptorIndexer() {
    }

    @Override
    @NotNull
    public Collection<String> indexDescriptor(@NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return CollectionsKt.listOf((Object)this.toStringKey(descriptor));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final KtDeclaration getDeclarationForDescriptor(@NotNull DeclarationDescriptor descriptor, @NotNull KtDecompiledFile file) {
        block23: {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            v0 = descriptor.getOriginal();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"descriptor.original");
            original = v0;
            if (original instanceof TypeAliasConstructorDescriptor) {
                return this.getDeclarationForDescriptor((DeclarationDescriptor)((TypeAliasConstructorDescriptor)original).getTypeAliasDescriptor(), file);
            }
            if (original instanceof ValueParameterDescriptor) {
                callable = ((ValueParameterDescriptor)original).getContainingDeclaration();
                var7_7 = this.getDeclarationForDescriptor((DeclarationDescriptor)callable, file);
                v1 = var7_7 instanceof KtCallableDeclaration != false ? (KtCallableDeclaration)var7_7 : null;
                if (v1 == null) {
                    return null;
                }
                callableDeclaration = v1;
                if (((ValueParameterDescriptor)original).getIndex() >= callableDeclaration.getValueParameters().size()) {
                    v2 = callableDeclaration.getValueParameterList();
                    ByDescriptorIndexer.LOG.error("Parameter count mismatch for " + DescriptorRenderer.DEBUG_TEXT.render((DeclarationDescriptor)callable) + '[' + ((ValueParameterDescriptor)original).getIndex() + "] vs " + (v2 != null ? v2.getText() : null));
                    return null;
                }
                return callableDeclaration.getValueParameters().get(((ValueParameterDescriptor)original).getIndex());
            }
            if (original instanceof ConstructorDescriptor && ((ConstructorDescriptor)original).isPrimary()) {
                v3 = ((ConstructorDescriptor)original).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"original.containingDeclaration");
                callableDeclaration = this.getDeclarationForDescriptor((DeclarationDescriptor)v3, file);
                classOrObject = callableDeclaration instanceof KtClassOrObject != false ? (KtClassOrObject)callableDeclaration : null;
                v4 /* !! */  = classOrObject;
                return v4 /* !! */  != null && (v4 /* !! */  = v4 /* !! */ .getPrimaryConstructor()) != null ? (KtDeclaration)v4 /* !! */  : (KtDeclaration)classOrObject;
            }
            v5 = original instanceof CallableMemberDescriptor != false ? (CallableMemberDescriptor)original : null;
            v6 = v5 != null ? BuildDecompiledTextKt.mustNotBeWrittenToDecompiledText(v5) : false;
            if (v6 && ((CallableMemberDescriptor)original).getContainingDeclaration() instanceof ClassDescriptor) {
                v7 = ((CallableMemberDescriptor)original).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"original.containingDeclaration");
                return this.getDeclarationForDescriptor(v7, file);
            }
            descriptorKey = this.toStringKey(original);
            if (file.isContentsLoaded() || !(original instanceof MemberDescriptor)) break block23;
            if (file.hasDeclarationWithKey(this, descriptorKey)) ** GOTO lbl-1000
            v8 = this.getBuiltinsDescriptorKey(descriptor);
            if (v8 != null) {
                it = v8;
                $i$a$-let-ByDescriptorIndexer$getDeclarationForDescriptor$hasDeclarationByKey$1 = false;
                v9 = file.hasDeclarationWithKey(this, it);
            } else {
                v9 = false;
            }
            if (v9) lbl-1000:
            // 2 sources

            {
                v10 = true;
            } else {
                v10 = hasDeclarationByKey = false;
            }
            if (hasDeclarationByKey) {
                if (DescriptorUtils.isTopLevelDeclaration((DeclarationDescriptor)original)) {
                    v11 = file;
                } else if (((MemberDescriptor)original).getContainingDeclaration() instanceof ClassDescriptor) {
                    v12 = ((MemberDescriptor)original).getContainingDeclaration();
                    Intrinsics.checkNotNull((Object)v12, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    var7_8 = this.getDeclarationForDescriptor((DeclarationDescriptor)((ClassDescriptor)v12), file);
                    v11 = var7_8 instanceof KtClassOrObject != false ? (KtClassOrObject)var7_8 : null;
                } else {
                    v11 = declarationContainer = null;
                }
                if (declarationContainer != null) {
                    block22: {
                        v13 = ((MemberDescriptor)original).getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"original.name.asString()");
                        descriptorName = v13;
                        v14 = declarationContainer.getDeclarations();
                        Intrinsics.checkNotNullExpressionValue(v14, (String)"declarationContainer.declarations");
                        $this$singleOrNull$iv = v14;
                        $i$f$singleOrNull = false;
                        single$iv = null;
                        found$iv = false;
                        for (T element$iv : $this$singleOrNull$iv) {
                            it = (KtDeclaration)element$iv;
                            $i$a$-singleOrNull-ByDescriptorIndexer$getDeclarationForDescriptor$singleOrNull$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)descriptorName)) continue;
                            if (found$iv) {
                                v15 = null;
                                break block22;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v15 = found$iv == false ? null : single$iv;
                    }
                    singleOrNull = v15;
                    if (singleOrNull != null) {
                        return singleOrNull;
                    }
                }
            }
        }
        v16 = file.getDeclaration(this, descriptorKey);
        if (v16 == null) {
            $this$getDeclarationForDescriptor_u24lambda_u243 = this;
            $i$a$-run-ByDescriptorIndexer$getDeclarationForDescriptor$1 = false;
            v17 = $this$getDeclarationForDescriptor_u24lambda_u243.getBuiltinsDescriptorKey(descriptor);
            if (v17 != null) {
                it = v17;
                $i$a$-let-ByDescriptorIndexer$getDeclarationForDescriptor$1$1 = false;
                v18 = file.getDeclaration($this$getDeclarationForDescriptor_u24lambda_u243, it);
            } else {
                v18 = null;
            }
            return v18;
        }
        return v16;
    }

    @Nullable
    public final String getBuiltinsDescriptorKey(@NotNull DeclarationDescriptor descriptor) {
        ClassDescriptor builtInDescriptor;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!(descriptor instanceof ClassDescriptor)) {
            return null;
        }
        FqNameUnsafe classFqName = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)descriptor);
        if (!JvmBuiltInsSignatures.INSTANCE.isSerializableInJava(classFqName)) {
            return null;
        }
        ModuleDescriptorImpl moduleDescriptorImpl = DefaultBuiltIns.Companion.getInstance().getBuiltInsModule();
        Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptorImpl, (String)"DefaultBuiltIns.Instance.builtInsModule");
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)moduleDescriptorImpl;
        FqName fqName = classFqName.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"classFqName.toSafe()");
        ClassDescriptor classDescriptor = builtInDescriptor = DescriptorUtilsKt.resolveTopLevelClass((ModuleDescriptor)moduleDescriptor, (FqName)fqName, (LookupLocation)NoLookupLocation.FROM_IDE);
        return classDescriptor != null ? this.toStringKey((DeclarationDescriptor)classDescriptor) : null;
    }

    private final String toStringKey(DeclarationDescriptor $this$toStringKey) {
        return descriptorRendererForKeys.render($this$toStringKey);
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(this::class.java)");
        LOG = logger;
    }
}

