/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmStaticChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/JvmTarget;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "isLessJVM18", "", "supportJvmStaticInInterface", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDeclaration", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkForInterface", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\ndeclarationCheckers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 declarationCheckers.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmStaticChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,267:1\n1#2:268\n*E\n"})
public final class JvmStaticChecker
implements DeclarationChecker {
    private final boolean isLessJVM18;
    private final boolean supportJvmStaticInInterface;

    public JvmStaticChecker(@NotNull JvmTarget jvmTarget, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.isLessJVM18 = jvmTarget.getMajorVersion() < JvmTarget.JVM_1_8.getMajorVersion();
        this.supportJvmStaticInInterface = languageVersionSettings.supportsFeature(LanguageFeature.JvmStaticInInterface);
    }

    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (AnnotationUtilKt.hasJvmStaticAnnotation((DeclarationDescriptor)descriptor) && (declaration instanceof KtNamedFunction || declaration instanceof KtProperty || declaration instanceof KtPropertyAccessor || declaration instanceof KtParameter)) {
            this.checkDeclaration(declaration, descriptor, (DiagnosticSink)context.getTrace());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDeclaration(KtDeclaration declaration, DeclarationDescriptor descriptor, DiagnosticSink diagnosticHolder) {
        container = descriptor.getContainingDeclaration();
        insideObject = DescriptorUtils.isObject((DeclarationDescriptor)container);
        if (!DescriptorUtils.isCompanionObject((DeclarationDescriptor)container)) ** GOTO lbl-1000
        v0 = container;
        Intrinsics.checkNotNull((Object)v0);
        if (DescriptorUtils.isInterface((DeclarationDescriptor)v0.getContainingDeclaration())) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = insideCompanionObjectInInterface = false;
        }
        if (!insideObject || insideCompanionObjectInInterface) {
            if (insideCompanionObjectInInterface && this.supportJvmStaticInInterface && descriptor instanceof DeclarationDescriptorWithVisibility) {
                this.checkForInterface((DeclarationDescriptorWithVisibility)descriptor, diagnosticHolder, declaration);
                if (this.isLessJVM18) {
                    diagnosticHolder.report((Diagnostic)ErrorsJvm.JVM_STATIC_IN_INTERFACE_1_6.on((PsiElement)declaration));
                }
            } else {
                diagnosticHolder.report((Diagnostic)(this.supportJvmStaticInInterface != false ? ErrorsJvm.JVM_STATIC_NOT_IN_OBJECT_OR_COMPANION : ErrorsJvm.JVM_STATIC_NOT_IN_OBJECT_OR_CLASS_COMPANION).on((PsiElement)declaration));
            }
        }
        if (declaration instanceof KtPropertyAccessor) {
            v2 = declaration.getParent();
            Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
            v3 = (KtProperty)v2;
        } else {
            v3 = checkDeclaration = declaration;
        }
        if (DescriptorUtils.isNonCompanionObject((DeclarationDescriptor)container)) {
            v4 = checkDeclaration.getModifierList();
            v5 = v4 != null ? v4.hasModifier(KtTokens.OVERRIDE_KEYWORD) : false;
            if (v5) {
                diagnosticHolder.report((Diagnostic)ErrorsJvm.OVERRIDE_CANNOT_BE_STATIC.on((PsiElement)declaration));
            }
        }
        if (descriptor instanceof PropertyDescriptor && (((PropertyDescriptor)descriptor).isConst() || JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor))) {
            diagnosticHolder.report((Diagnostic)ErrorsJvm.JVM_STATIC_ON_CONST_OR_JVM_FIELD.on((PsiElement)declaration));
        }
    }

    private final void checkForInterface(DeclarationDescriptorWithVisibility descriptor, DiagnosticSink diagnosticHolder, KtDeclaration declaration) {
        block3: {
            PropertyGetterDescriptor it;
            block4: {
                block2: {
                    if (Intrinsics.areEqual((Object)descriptor.getVisibility(), (Object)DescriptorVisibilities.PUBLIC)) break block2;
                    diagnosticHolder.report((Diagnostic)ErrorsJvm.JVM_STATIC_ON_NON_PUBLIC_MEMBER.on((PsiElement)declaration));
                    break block3;
                }
                if (!(descriptor instanceof MemberDescriptor) || !((MemberDescriptor)descriptor).isExternal()) break block4;
                diagnosticHolder.report((Diagnostic)ErrorsJvm.JVM_STATIC_ON_EXTERNAL_IN_INTERFACE.on((PsiElement)declaration));
                break block3;
            }
            if (!(descriptor instanceof PropertyDescriptor)) break block3;
            PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)descriptor).getGetter();
            if (propertyGetterDescriptor != null) {
                it = propertyGetterDescriptor;
                boolean bl = false;
                this.checkForInterface((DeclarationDescriptorWithVisibility)it, diagnosticHolder, declaration);
            }
            PropertySetterDescriptor propertySetterDescriptor = ((PropertyDescriptor)descriptor).getSetter();
            if (propertySetterDescriptor != null) {
                it = propertySetterDescriptor;
                boolean bl = false;
                this.checkForInterface((DeclarationDescriptorWithVisibility)it, diagnosticHolder, declaration);
            }
        }
    }
}

