/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.platform.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JdkPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00070\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/platform/jvm/JvmPlatforms;", "", "()V", "UNSPECIFIED_SIMPLE_JVM_PLATFORM", "Lorg/jetbrains/kotlin/platform/jvm/JdkPlatform;", "allJvmPlatforms", "", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getAllJvmPlatforms", "()Ljava/util/List;", "defaultJvmPlatform", "getDefaultJvmPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "jvm11", "getJvm11", "jvm17", "getJvm17", "jvm6", "getJvm6", "jvm8", "getJvm8", "jvmTargetToJdkPlatform", "", "Lorg/jetbrains/kotlin/config/JvmTarget;", "unspecifiedJvmPlatform", "getUnspecifiedJvmPlatform", "jvmPlatformByTargetVersion", "targetVersion", "CompatJvmPlatform", "config.jvm"})
public final class JvmPlatforms {
    @NotNull
    public static final JvmPlatforms INSTANCE;
    @NotNull
    private static final JdkPlatform UNSPECIFIED_SIMPLE_JVM_PLATFORM;
    @NotNull
    private static final Map<JvmTarget, TargetPlatform> jvmTargetToJdkPlatform;
    @NotNull
    private static final TargetPlatform defaultJvmPlatform;
    @NotNull
    private static final TargetPlatform jvm6;
    @NotNull
    private static final TargetPlatform jvm8;
    @NotNull
    private static final TargetPlatform jvm11;
    @NotNull
    private static final TargetPlatform jvm17;
    @NotNull
    private static final List<TargetPlatform> allJvmPlatforms;

    private JvmPlatforms() {
    }

    @NotNull
    public final TargetPlatform getUnspecifiedJvmPlatform() {
        return CompatJvmPlatform.INSTANCE;
    }

    @NotNull
    public final TargetPlatform getDefaultJvmPlatform() {
        return defaultJvmPlatform;
    }

    @NotNull
    public final TargetPlatform getJvm6() {
        return jvm6;
    }

    @NotNull
    public final TargetPlatform getJvm8() {
        return jvm8;
    }

    @NotNull
    public final TargetPlatform getJvm11() {
        return jvm11;
    }

    @NotNull
    public final TargetPlatform getJvm17() {
        return jvm17;
    }

    @NotNull
    public final TargetPlatform jvmPlatformByTargetVersion(@NotNull JvmTarget targetVersion) {
        Intrinsics.checkNotNullParameter((Object)targetVersion, (String)"targetVersion");
        TargetPlatform targetPlatform = jvmTargetToJdkPlatform.get(targetVersion);
        Intrinsics.checkNotNull((Object)targetPlatform);
        return targetPlatform;
    }

    @NotNull
    public final List<TargetPlatform> getAllJvmPlatforms() {
        return allJvmPlatforms;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        INSTANCE = new JvmPlatforms();
        UNSPECIFIED_SIMPLE_JVM_PLATFORM = new JdkPlatform(JvmTarget.DEFAULT);
        JvmTarget[] $this$map$iv = JvmTarget.values();
        boolean $i$f$map = false;
        JvmTarget[] jvmTargetArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var8_8 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)TargetPlatformKt.toTargetPlatform(new JdkPlatform((JvmTarget)it))));
        }
        jvmTargetToJdkPlatform = MapsKt.toMap((Iterable)((List)var3_3));
        TargetPlatform targetPlatform = jvmTargetToJdkPlatform.get(JvmTarget.DEFAULT);
        Intrinsics.checkNotNull((Object)targetPlatform);
        defaultJvmPlatform = targetPlatform;
        TargetPlatform targetPlatform2 = jvmTargetToJdkPlatform.get(JvmTarget.JVM_1_6);
        Intrinsics.checkNotNull((Object)targetPlatform2);
        jvm6 = targetPlatform2;
        TargetPlatform targetPlatform3 = jvmTargetToJdkPlatform.get(JvmTarget.JVM_1_8);
        Intrinsics.checkNotNull((Object)targetPlatform3);
        jvm8 = targetPlatform3;
        TargetPlatform targetPlatform4 = jvmTargetToJdkPlatform.get(JvmTarget.JVM_11);
        Intrinsics.checkNotNull((Object)targetPlatform4);
        jvm11 = targetPlatform4;
        TargetPlatform targetPlatform5 = jvmTargetToJdkPlatform.get(JvmTarget.JVM_17);
        Intrinsics.checkNotNull((Object)targetPlatform5);
        jvm17 = targetPlatform5;
        allJvmPlatforms = CollectionsKt.toList((Iterable)jvmTargetToJdkPlatform.values());
    }

    @Deprecated(message="Should be accessed only by compatibility layer, other clients should use 'unspecifiedJvmPlatform'", level=DeprecationLevel.ERROR)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/platform/jvm/JvmPlatforms$CompatJvmPlatform;", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "Lorg/jetbrains/kotlin/resolve/jvm/platform/JvmPlatform;", "()V", "platformName", "", "getPlatformName", "()Ljava/lang/String;", "config.jvm"})
    public static final class CompatJvmPlatform
    extends TargetPlatform
    implements JvmPlatform {
        @NotNull
        public static final CompatJvmPlatform INSTANCE = new CompatJvmPlatform();

        private CompatJvmPlatform() {
            super(SetsKt.setOf((Object)UNSPECIFIED_SIMPLE_JVM_PLATFORM));
        }

        @NotNull
        public String getPlatformName() {
            return "JVM";
        }
    }
}

