/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmNameAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDeclaration", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "isRenamableFunction", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "frontend.java"})
public final class JvmNameAnnotationChecker
implements DeclarationChecker {
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AnnotationDescriptor jvmNameAnnotation = DescriptorUtils.findJvmNameAnnotation((Annotated)((Annotated)descriptor));
        if (jvmNameAnnotation != null) {
            this.checkDeclaration(descriptor, jvmNameAnnotation, (DiagnosticSink)context.getTrace());
        }
    }

    private final void checkDeclaration(DeclarationDescriptor descriptor, AnnotationDescriptor annotation, DiagnosticSink diagnosticHolder) {
        String value2;
        KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation((AnnotationDescriptor)annotation);
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        if (descriptor instanceof FunctionDescriptor && !this.isRenamableFunction((FunctionDescriptor)descriptor)) {
            diagnosticHolder.report((Diagnostic)ErrorsJvm.INAPPLICABLE_JVM_NAME.on((PsiElement)annotationEntry));
        }
        if ((value2 = DescriptorUtils.getJvmName((Annotated)((Annotated)descriptor))) == null || !Name.isValidIdentifier(value2)) {
            diagnosticHolder.report((Diagnostic)ErrorsJvm.ILLEGAL_JVM_NAME.on((PsiElement)annotationEntry));
        }
        if (descriptor instanceof CallableMemberDescriptor) {
            if (DescriptorUtils.isOverride((CallableMemberDescriptor)((CallableMemberDescriptor)descriptor)) || ModalityUtilsKt.isOverridable((CallableMemberDescriptor)((CallableMemberDescriptor)descriptor))) {
                diagnosticHolder.report((Diagnostic)ErrorsJvm.INAPPLICABLE_JVM_NAME.on((PsiElement)annotationEntry));
            } else {
                DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
                if (InlineClassManglingRulesKt.isInlineClassThatRequiresMangling((DeclarationDescriptor)declarationDescriptor)) {
                    diagnosticHolder.report((Diagnostic)ErrorsJvm.INAPPLICABLE_JVM_NAME.on((PsiElement)annotationEntry));
                }
            }
        }
    }

    private final boolean isRenamableFunction(FunctionDescriptor descriptor) {
        DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
        DeclarationDescriptor containingDescriptor = declarationDescriptor;
        return containingDescriptor instanceof PackageFragmentDescriptor || containingDescriptor instanceof ClassDescriptor;
    }
}

