/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.java.sources.JavaSourceElement;
import org.jetbrains.kotlin.load.java.structure.impl.VirtualFileBoundJavaClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryPackageSourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleResolver;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DescriptorWithContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J.\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmModuleAccessibilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleResolver", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleResolver;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "diagnosticFor", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "targetClassOrPackage", "Lorg/jetbrains/kotlin/descriptors/ClassOrPackageFragmentDescriptor;", "originalDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithSource;", "fileFromOurModule", "Lcom/intellij/openapi/vfs/VirtualFile;", "findVirtualFile", "descriptor", "ClassifierUsage", "frontend.java"})
public final class JvmModuleAccessibilityChecker
implements CallChecker {
    @NotNull
    private final JavaModuleResolver moduleResolver;

    public JvmModuleAccessibilityChecker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.moduleResolver = JavaModuleResolver.SERVICE.getInstance(project);
    }

    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        block2: {
            Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
            Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            CallableDescriptor descriptor = resolvedCall.getResultingDescriptor();
            if (descriptor instanceof ClassConstructorDescriptor) {
                return;
            }
            ClassOrPackageFragmentDescriptor classOrPackageFragmentDescriptor = (ClassOrPackageFragmentDescriptor)DescriptorUtils.getParentOfType((DeclarationDescriptor)((DeclarationDescriptor)descriptor), ClassOrPackageFragmentDescriptor.class);
            if (classOrPackageFragmentDescriptor == null) {
                return;
            }
            ClassOrPackageFragmentDescriptor targetDescriptor = classOrPackageFragmentDescriptor;
            KtFile ktFile = DescriptorToSourceUtils.getContainingFile((DeclarationDescriptor)context.getScope().getOwnerDescriptor());
            VirtualFile fileFromOurModule = ktFile != null ? ktFile.getVirtualFile() : null;
            Diagnostic diagnostic = this.diagnosticFor(targetDescriptor, (DeclarationDescriptorWithSource)descriptor, fileFromOurModule, reportOn);
            if (diagnostic == null) break block2;
            Diagnostic diagnostic2 = diagnostic;
            BindingTrace bindingTrace = context.getTrace();
            Diagnostic p0 = diagnostic2;
            boolean bl = false;
            bindingTrace.report(p0);
        }
    }

    private final Diagnostic diagnosticFor(ClassOrPackageFragmentDescriptor targetClassOrPackage, DeclarationDescriptorWithSource originalDescriptor, VirtualFile fileFromOurModule, PsiElement reportOn) {
        Diagnostic diagnostic;
        Object referencedPackageFqName;
        JavaModuleResolver.AccessError diagnostic2;
        JavaModuleResolver.AccessError accessError;
        VirtualFile virtualFile = this.findVirtualFile(targetClassOrPackage, originalDescriptor);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile referencedFile = virtualFile;
        Object object = originalDescriptor instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)originalDescriptor : null;
        if (object == null || (object = UtilKt.getImplClassNameForDeserialized((DescriptorWithContainerSource)((DescriptorWithContainerSource)object))) == null || (object = ((JvmClassName)object).getPackageFqName()) == null) {
            PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)DescriptorUtils.getParentOfType((DeclarationDescriptor)((DeclarationDescriptor)targetClassOrPackage), PackageFragmentDescriptor.class, (boolean)false);
            object = packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null;
        }
        if ((accessError = (diagnostic2 = this.moduleResolver.checkAccessibility(fileFromOurModule, referencedFile, (FqName)(referencedPackageFqName = object)))) instanceof JavaModuleResolver.AccessError.ModuleDoesNotReadUnnamedModule) {
            diagnostic = (Diagnostic)ErrorsJvm.JAVA_MODULE_DOES_NOT_READ_UNNAMED_MODULE.on(reportOn);
        } else if (accessError instanceof JavaModuleResolver.AccessError.ModuleDoesNotReadModule) {
            diagnostic = (Diagnostic)ErrorsJvm.JAVA_MODULE_DOES_NOT_DEPEND_ON_MODULE.on(reportOn, (Object)((JavaModuleResolver.AccessError.ModuleDoesNotReadModule)diagnostic2).getDependencyModuleName());
        } else if (accessError instanceof JavaModuleResolver.AccessError.ModuleDoesNotExportPackage) {
            String string = ((JavaModuleResolver.AccessError.ModuleDoesNotExportPackage)diagnostic2).getDependencyModuleName();
            Object object2 = referencedPackageFqName;
            Intrinsics.checkNotNull((Object)object2);
            diagnostic = (Diagnostic)ErrorsJvm.JAVA_MODULE_DOES_NOT_EXPORT_PACKAGE.on(reportOn, (Object)string, (Object)((FqName)object2).asString());
        } else {
            diagnostic = null;
        }
        return diagnostic;
    }

    private final VirtualFile findVirtualFile(ClassOrPackageFragmentDescriptor descriptor, DeclarationDescriptorWithSource originalDescriptor) {
        Object object;
        SourceElement source;
        SourceElement sourceElement = descriptor.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"descriptor.source");
        SourceElement sourceElement2 = source = sourceElement;
        if (sourceElement2 instanceof KotlinJvmBinarySourceElement) {
            VirtualFileKotlinClass virtualFileKotlinClass;
            object = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
            VirtualFileKotlinClass virtualFileKotlinClass2 = virtualFileKotlinClass = object instanceof VirtualFileKotlinClass ? (VirtualFileKotlinClass)object : null;
            if (virtualFileKotlinClass != null && (object = virtualFileKotlinClass.getFile()) != null) {
                Object it = object;
                boolean bl = false;
                return it;
            }
        } else if (sourceElement2 instanceof JavaSourceElement) {
            VirtualFileBoundJavaClass virtualFileBoundJavaClass;
            object = ((JavaSourceElement)source).getJavaElement();
            VirtualFileBoundJavaClass virtualFileBoundJavaClass2 = virtualFileBoundJavaClass = object instanceof VirtualFileBoundJavaClass ? (VirtualFileBoundJavaClass)object : null;
            if (virtualFileBoundJavaClass != null && (object = virtualFileBoundJavaClass.getVirtualFile()) != null) {
                Object it = object;
                boolean bl = false;
                return it;
            }
        } else if (sourceElement2 instanceof KotlinJvmBinaryPackageSourceElement && originalDescriptor instanceof DeserializedMemberDescriptor) {
            VirtualFileKotlinClass virtualFileKotlinClass;
            object = ((KotlinJvmBinaryPackageSourceElement)source).getContainingBinaryClass((DeserializedMemberDescriptor)originalDescriptor);
            VirtualFileKotlinClass virtualFileKotlinClass3 = virtualFileKotlinClass = object instanceof VirtualFileKotlinClass ? (VirtualFileKotlinClass)object : null;
            if (virtualFileKotlinClass != null && (object = virtualFileKotlinClass.getFile()) != null) {
                Object it = object;
                boolean bl = false;
                return it;
            }
        }
        if ((sourceElement2 = JvmModuleAccessibilityChecker.findVirtualFile$getContainingVirtualFile(source)) != null) {
            SourceElement it = sourceElement2;
            boolean bl = false;
            return it;
        }
        Object object2 = originalDescriptor;
        if (object2 == null || (object2 = object2.getSource()) == null) {
            return null;
        }
        Object originalSource = object2;
        return JvmModuleAccessibilityChecker.findVirtualFile$getContainingVirtualFile((SourceElement)originalSource);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final VirtualFile findVirtualFile$getContainingVirtualFile(SourceElement source) {
        VirtualFile virtualFile;
        PsiElement psiElement;
        PsiElement psiElement2 = PsiSourceElementKt.getPsi(source);
        if (psiElement2 == null) return null;
        PsiElement it = psiElement = psiElement2;
        boolean bl = false;
        if (!it.isValid()) return null;
        PsiElement psiElement3 = psiElement;
        PsiElement psiElement4 = psiElement3;
        if (psiElement4 == null) return null;
        psiElement = psiElement4.getContainingFile();
        if (psiElement == null) return null;
        VirtualFile virtualFile2 = psiElement.getVirtualFile();
        if (virtualFile2 == null) return null;
        VirtualFile it2 = virtualFile = virtualFile2;
        boolean bl2 = false;
        if (!it2.isValid()) return null;
        VirtualFile virtualFile3 = virtualFile;
        return virtualFile3;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmModuleAccessibilityChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "(Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmModuleAccessibilityChecker;)V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend.java"})
    public final class ClassifierUsage
    implements ClassifierUsageChecker {
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context) {
            block5: {
                ClassDescriptor expandedClass;
                BindingTrace bindingTrace;
                ClassifierDescriptor classifierDescriptor;
                ClassifierDescriptor classifierDescriptor2;
                VirtualFile virtualFile;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)targetDescriptor, (String)"targetDescriptor");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    virtualFile = element.getContainingFile().getVirtualFile();
                    classifierDescriptor2 = targetDescriptor;
                    if (!(classifierDescriptor2 instanceof ClassDescriptor)) break block4;
                    Diagnostic diagnostic = JvmModuleAccessibilityChecker.this.diagnosticFor((ClassOrPackageFragmentDescriptor)targetDescriptor, (DeclarationDescriptorWithSource)targetDescriptor, virtualFile, element);
                    if (diagnostic == null) break block5;
                    Diagnostic diagnostic2 = diagnostic;
                    BindingTrace bindingTrace2 = context.getTrace();
                    Diagnostic p0 = diagnostic2;
                    boolean bl = false;
                    bindingTrace2.report(p0);
                    break block5;
                }
                if (!(classifierDescriptor2 instanceof TypeAliasDescriptor)) break block5;
                ClassOrPackageFragmentDescriptor containingClassOrPackage = (ClassOrPackageFragmentDescriptor)DescriptorUtils.getParentOfType((DeclarationDescriptor)((DeclarationDescriptor)targetDescriptor), ClassOrPackageFragmentDescriptor.class);
                if (containingClassOrPackage != null) {
                    Diagnostic diagnostic = JvmModuleAccessibilityChecker.this.diagnosticFor(containingClassOrPackage, (DeclarationDescriptorWithSource)targetDescriptor, virtualFile, element);
                    if (diagnostic != null) {
                        classifierDescriptor = diagnostic;
                        bindingTrace = context.getTrace();
                        ClassifierDescriptor p0 = classifierDescriptor;
                        boolean bl = false;
                        bindingTrace.report((Diagnostic)p0);
                    }
                }
                ClassDescriptor classDescriptor = expandedClass = (classifierDescriptor = ((TypeAliasDescriptor)targetDescriptor).getExpandedType().getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                if (expandedClass != null) {
                    Diagnostic diagnostic = JvmModuleAccessibilityChecker.this.diagnosticFor((ClassOrPackageFragmentDescriptor)expandedClass, (DeclarationDescriptorWithSource)expandedClass, virtualFile, element);
                    if (diagnostic != null) {
                        bindingTrace = diagnostic;
                        BindingTrace bindingTrace3 = context.getTrace();
                        BindingTrace p0 = bindingTrace;
                        boolean bl = false;
                        bindingTrace3.report((Diagnostic)p0);
                    }
                }
            }
        }
    }
}

