/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaClassOnCompanionChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
public final class JavaClassOnCompanionChecker
implements CallChecker {
    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CallableDescriptor descriptor = resolvedCall.getResultingDescriptor();
        if (!(descriptor instanceof PropertyDescriptor) || !Intrinsics.areEqual((Object)((PropertyDescriptor)descriptor).getName().asString(), (Object)"javaClass")) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)descriptor).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
        DeclarationDescriptor container = declarationDescriptor;
        if (!(container instanceof PackageFragmentDescriptor) || !Intrinsics.areEqual((Object)((PackageFragmentDescriptor)container).getFqName().asString(), (Object)"kotlin.jvm")) {
            return;
        }
        KotlinType kotlinType = ((PropertyDescriptor)descriptor).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
        KotlinType actualType = kotlinType;
        TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull((List)actualType.getArguments());
        ClassifierDescriptor classifierDescriptor = typeProjection != null && (typeProjection = typeProjection.getType()) != null && (typeProjection = typeProjection.getConstructor()) != null ? typeProjection.getDeclarationDescriptor() : null;
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor companionObject = classDescriptor;
        if (companionObject.isCompanionObject()) {
            DeclarationDescriptor declarationDescriptor2 = companionObject.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            ClassDescriptor containingClass = (ClassDescriptor)declarationDescriptor2;
            ClassifierDescriptor classifierDescriptor2 = actualType.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor2 = classifierDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor2 : null;
            if (classDescriptor2 == null) {
                return;
            }
            ClassDescriptor javaLangClass = classDescriptor2;
            List arguments = CollectionsKt.listOf((Object)new TypeProjectionImpl((KotlinType)containingClass.getDefaultType()));
            TypeAttributes typeAttributes = TypeAttributes.Companion.getEmpty();
            TypeConstructor typeConstructor = javaLangClass.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor, (String)"javaLangClass.typeConstructor");
            SimpleType expectedType = KotlinTypeFactory.simpleType$default((TypeAttributes)typeAttributes, (TypeConstructor)typeConstructor, (List)arguments, (boolean)actualType.isMarkedNullable(), null, (int)16, null);
            context.getTrace().report((Diagnostic)ErrorsJvm.JAVA_CLASS_ON_COMPANION.on(reportOn, (Object)actualType, (Object)expectedType));
        }
    }
}

