/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u0001\u0011B\u0019\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ$\u0010\r\u001a\u00020\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer;", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "type", "Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;", "useHtml", "", "(Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;Z)V", "additionalFeatureMessages", "", "", "render", "obj", "renderingContext", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "Type", "frontend.common-psi"})
public final class LanguageFeatureMessageRenderer
implements DiagnosticParameterRenderer<Pair<? extends LanguageFeature, ? extends LanguageVersionSettings>> {
    @NotNull
    private final Type type;
    private final boolean useHtml;
    @NotNull
    private final Map<LanguageFeature, String> additionalFeatureMessages;

    @JvmOverloads
    public LanguageFeatureMessageRenderer(@NotNull Type type, boolean useHtml) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.useHtml = useHtml;
        this.additionalFeatureMessages = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)LanguageFeature.UnitConversionsOnArbitraryExpressions), (Object)"You can also change the original type of this expression to (...) -> Unit"));
    }

    public /* synthetic */ LanguageFeatureMessageRenderer(Type type, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(type, bl);
    }

    @Override
    @NotNull
    public String render(@NotNull Pair<? extends LanguageFeature, ? extends LanguageVersionSettings> obj, @NotNull RenderingContext renderingContext) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)renderingContext, (String)"renderingContext");
        LanguageFeature feature = (LanguageFeature)((Object)obj.component1());
        LanguageVersionSettings settings = (LanguageVersionSettings)obj.component2();
        LanguageVersion since = feature.getSinceVersion();
        StringBuilder sb = new StringBuilder();
        sb.append("The feature \"").append(feature.getPresentableName()).append("\" is ");
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                if (since == null) {
                    sb.append("experimental and should be enabled explicitly");
                    break;
                }
                if (since.compareTo((Enum)settings.getLanguageVersion()) > 0) {
                    sb.append("only available since language version ").append(since.getVersionString());
                    break;
                }
                if (feature.getSinceApiVersion().compareTo(settings.getApiVersion()) > 0) {
                    sb.append("only available since API version ").append(feature.getSinceApiVersion().getVersionString());
                    break;
                }
                sb.append("disabled");
                break;
            }
            case 2: {
                sb.append("experimental");
                break;
            }
            case 3: {
                sb.append("experimental and disabled");
            }
        }
        String hintUrl = feature.getHintUrl();
        if (hintUrl != null) {
            if (this.useHtml) {
                sb.append(" (").append("see more <a href=\"").append(hintUrl).append("\">here</a>)");
            } else {
                sb.append(" (see: ").append(hintUrl).append(")");
            }
        }
        if (this.additionalFeatureMessages.containsKey((Object)feature)) {
            sb.append(". " + this.additionalFeatureMessages.get((Object)feature));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @JvmOverloads
    public LanguageFeatureMessageRenderer(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(type, false, 2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;", "", "(Ljava/lang/String;I)V", "UNSUPPORTED", "WARNING", "ERROR", "frontend.common-psi"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type UNSUPPORTED = new Type();
        public static final /* enum */ Type WARNING = new Type();
        public static final /* enum */ Type ERROR = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value2) {
            return Enum.valueOf(Type.class, value2);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.UNSUPPORTED, Type.WARNING, Type.ERROR};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.UNSUPPORTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

