/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiPackage;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.AbstractJavaClassFinder;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaPackage;
import org.jetbrains.kotlin.load.java.structure.impl.JavaPackageImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/load/java/JavaClassFinderImpl;", "Lorg/jetbrains/kotlin/load/java/AbstractJavaClassFinder;", "()V", "javaFacade", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade;", "findClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "request", "Lorg/jetbrains/kotlin/load/java/JavaClassFinder$Request;", "findPackage", "Lorg/jetbrains/kotlin/load/java/structure/JavaPackage;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "mayHaveAnnotations", "", "knownClassNamesInPackage", "", "", "packageFqName", "setProjectInstance", "", "project", "Lcom/intellij/openapi/project/Project;", "frontend.java"})
public final class JavaClassFinderImpl
extends AbstractJavaClassFinder {
    private KotlinJavaPsiFacade javaFacade;

    @Override
    @Inject
    public void setProjectInstance(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super.setProjectInstance(project);
        KotlinJavaPsiFacade kotlinJavaPsiFacade = KotlinJavaPsiFacade.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinJavaPsiFacade, (String)"getInstance(project)");
        this.javaFacade = kotlinJavaPsiFacade;
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull JavaClassFinder.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        KotlinJavaPsiFacade kotlinJavaPsiFacade = this.javaFacade;
        if (kotlinJavaPsiFacade == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaFacade");
            kotlinJavaPsiFacade = null;
        }
        return kotlinJavaPsiFacade.findClass(request, this.getJavaSearchScope());
    }

    @Override
    @Nullable
    public JavaPackage findPackage(@NotNull FqName fqName, boolean mayHaveAnnotations) {
        JavaPackageImpl javaPackageImpl;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        KotlinJavaPsiFacade kotlinJavaPsiFacade = this.javaFacade;
        if (kotlinJavaPsiFacade == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaFacade");
            kotlinJavaPsiFacade = null;
        }
        PsiPackage psiPackage = kotlinJavaPsiFacade.findPackage(fqName.asString(), this.getJavaSearchScope());
        if (psiPackage != null) {
            PsiPackage it = psiPackage;
            boolean bl = false;
            javaPackageImpl = new JavaPackageImpl(it, this.getJavaSearchScope(), mayHaveAnnotations);
        } else {
            javaPackageImpl = null;
        }
        return javaPackageImpl;
    }

    @Override
    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        KotlinJavaPsiFacade kotlinJavaPsiFacade = this.javaFacade;
        if (kotlinJavaPsiFacade == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaFacade");
            kotlinJavaPsiFacade = null;
        }
        return kotlinJavaPsiFacade.knownClassNamesInPackage(packageFqName, this.getJavaSearchScope());
    }
}

