/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.lang.constant.Constable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.ArgsConverter;
import org.jetbrains.kotlin.utils.NamedArgument;
import org.jetbrains.kotlin.utils.ParametersMapKt;
import org.jetbrains.kotlin.utils.StringArgsConverter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J2\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\rH\u0016J2\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/utils/StringArgsConverter;", "Lorg/jetbrains/kotlin/utils/ArgsConverter;", "", "()V", "tryConvertSingle", "Lorg/jetbrains/kotlin/utils/ArgsConverter$Result;", "parameter", "Lkotlin/reflect/KParameter;", "arg", "Lorg/jetbrains/kotlin/utils/NamedArgument;", "tryConvertTail", "firstArg", "restArgs", "Lkotlin/sequences/Sequence;", "tryConvertVararg", "cli-common"})
final class StringArgsConverter
implements ArgsConverter<String> {
    @Override
    @NotNull
    public ArgsConverter.Result tryConvertSingle(@NotNull KParameter parameter, @NotNull NamedArgument<String> arg) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter(arg, (String)"arg");
        String string = arg.getValue();
        if (string == null) {
            return new ArgsConverter.Result.Success((Object)null);
        }
        String value2 = string;
        KClassifier kClassifier = parameter.getType().getClassifier();
        String primitive = Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(String.class)) ? value2 : (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) ? StringsKt.toIntOrNull((String)value2) : (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE)) ? StringsKt.toLongOrNull((String)value2) : (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE)) ? StringsKt.toShortOrNull((String)value2) : (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE)) ? StringsKt.toByteOrNull((String)value2) : (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE)) ? StringsKt.singleOrNull((CharSequence)value2) : (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE)) ? StringsKt.toFloatOrNull((String)value2) : (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE)) ? (Constable)StringsKt.toDoubleOrNull((String)value2) : (Constable)(Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE)) ? Boolean.valueOf(Boolean.parseBoolean(value2)) : null))))))));
        return primitive != null ? (ArgsConverter.Result)new ArgsConverter.Result.Success(primitive) : (ArgsConverter.Result)ArgsConverter.Result.Failure.INSTANCE;
    }

    @Override
    @NotNull
    public ArgsConverter.Result tryConvertVararg(@NotNull KParameter parameter, @NotNull NamedArgument<String> firstArg, @NotNull Sequence<NamedArgument<String>> restArgs) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter(firstArg, (String)"firstArg");
        Intrinsics.checkNotNullParameter(restArgs, (String)"restArgs");
        KType parameterType = parameter.getType();
        if (JvmClassMappingKt.getJavaClass((KClass)KTypesJvm.getJvmErasure((KType)parameterType)).isArray()) {
            String[] arrayArgCandidate;
            String[] stringArray;
            KType arrayElementType;
            Object[] objectArray = new String[]{firstArg.getValue()};
            Sequence argsSequence2 = SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Sequence)SequencesKt.map(restArgs, (Function1)tryConvertVararg.argsSequence.1.INSTANCE));
            Object primArrayArgCandidate = StringArgsConverter.tryConvertVararg$convertPrimitivesArray(parameterType, (Sequence<String>)argsSequence2);
            if (primArrayArgCandidate != null) {
                return new ArgsConverter.Result.Success(primArrayArgCandidate);
            }
            KTypeProjection kTypeProjection = (KTypeProjection)CollectionsKt.firstOrNull((List)parameterType.getArguments());
            KType kType = arrayElementType = kTypeProjection != null ? kTypeProjection.getType() : null;
            KClassifier classifier$iv = kType != null ? kType.getClassifier() : null;
            boolean $i$f$convertAnyArray = false;
            if (Intrinsics.areEqual((Object)classifier$iv, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                Collection $this$toTypedArray$iv$iv = SequencesKt.toList((Sequence)argsSequence2);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                stringArray = thisCollection$iv$iv.toArray(new String[0]);
            } else {
                stringArray = arrayArgCandidate = ParametersMapKt.access$convertAnyArrayImpl(classifier$iv, argsSequence2);
            }
            if (arrayArgCandidate != null) {
                return new ArgsConverter.Result.Success(arrayArgCandidate);
            }
        }
        return ArgsConverter.Result.Failure.INSTANCE;
    }

    @Override
    @NotNull
    public ArgsConverter.Result tryConvertTail(@NotNull KParameter parameter, @NotNull NamedArgument<String> firstArg, @NotNull Sequence<NamedArgument<String>> restArgs) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter(firstArg, (String)"firstArg");
        Intrinsics.checkNotNullParameter(restArgs, (String)"restArgs");
        return this.tryConvertVararg(parameter, firstArg, restArgs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Object tryConvertVararg$convertPrimitivesArray(KType type, Sequence<String> args) {
        Object object;
        Sequence sequence2;
        Object object2 = type.getClassifier();
        if (Intrinsics.areEqual((Object)object2, (Object)Reflection.getOrCreateKotlinClass(int[].class))) {
            sequence2 = SequencesKt.map(args, (Function1)tryConvertVararg.convertPrimitivesArray.1.INSTANCE);
        } else if (Intrinsics.areEqual((Object)object2, (Object)Reflection.getOrCreateKotlinClass(long[].class))) {
            sequence2 = SequencesKt.map(args, (Function1)tryConvertVararg.convertPrimitivesArray.2.INSTANCE);
        } else if (Intrinsics.areEqual((Object)object2, (Object)Reflection.getOrCreateKotlinClass(short[].class))) {
            sequence2 = SequencesKt.map(args, (Function1)tryConvertVararg.convertPrimitivesArray.3.INSTANCE);
        } else if (Intrinsics.areEqual((Object)object2, (Object)Reflection.getOrCreateKotlinClass(byte[].class))) {
            sequence2 = SequencesKt.map(args, (Function1)tryConvertVararg.convertPrimitivesArray.4.INSTANCE);
        } else if (Intrinsics.areEqual((Object)object2, (Object)Reflection.getOrCreateKotlinClass(char[].class))) {
            sequence2 = SequencesKt.map(args, (Function1)tryConvertVararg.convertPrimitivesArray.5.INSTANCE);
        } else if (Intrinsics.areEqual((Object)object2, (Object)Reflection.getOrCreateKotlinClass(float[].class))) {
            sequence2 = SequencesKt.map(args, (Function1)tryConvertVararg.convertPrimitivesArray.6.INSTANCE);
        } else if (Intrinsics.areEqual((Object)object2, (Object)Reflection.getOrCreateKotlinClass(double[].class))) {
            sequence2 = SequencesKt.map(args, (Function1)tryConvertVararg.convertPrimitivesArray.7.INSTANCE);
        } else {
            if (!Intrinsics.areEqual((Object)object2, (Object)Reflection.getOrCreateKotlinClass(boolean[].class))) return null;
            sequence2 = SequencesKt.map(args, (Function1)tryConvertVararg.convertPrimitivesArray.8.INSTANCE);
        }
        Sequence sequence3 = sequence2;
        if (sequence3 == null) return null;
        object2 = SequencesKt.toList((Sequence)sequence3);
        if (object2 == null) return null;
        Object it = object = object2;
        boolean bl = false;
        if (it.contains(null)) return null;
        Object object3 = object;
        Object object4 = object3;
        if (object4 == null) return null;
        Collection $this$toTypedArray$iv = (Collection)object4;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        return objectArray;
    }
}

