/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.annotations;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.deserialization.PlatformDependentDeclarationFilterKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.util.DeclarationUtilKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a\f\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u001b\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u001a*\u00020\u001b\u001a\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001a*\u00020\u001eH\u0002\u001a\f\u0010\u001f\u001a\u0004\u0018\u00010\u001a*\u00020\u001b\u001a\f\u0010 \u001a\u0004\u0018\u00010\u001a*\u00020\u001b\u001a\n\u0010!\u001a\u00020\u0015*\u00020\u0016\u001a\n\u0010\"\u001a\u00020\u0015*\u00020\u001b\u001a\n\u0010#\u001a\u00020\u0015*\u00020\u001b\u001a\n\u0010$\u001a\u00020\u0015*\u00020\u001b\u001a\n\u0010%\u001a\u00020\u0015*\u00020\u001b\u001a\n\u0010&\u001a\u00020\u0015*\u00020\u0016\u001a\u0012\u0010'\u001a\u00020\u0015*\u00020\u001b2\u0006\u0010(\u001a\u00020\u0018\u001a\u0012\u0010)\u001a\u00020\u0015*\u00020\u00162\u0006\u0010(\u001a\u00020\u0018\u001a\n\u0010*\u001a\u00020\u0015*\u00020+\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0003\"\u0010\u0010\f\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\r\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u000e\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u000f\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0012\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0013\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"JVM_DEFAULT_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getJVM_DEFAULT_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME", "getJVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME", "JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME", "getJVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME", "JVM_OVERLOADS_FQ_NAME", "getJVM_OVERLOADS_FQ_NAME", "JVM_RECORD_ANNOTATION_FQ_NAME", "getJVM_RECORD_ANNOTATION_FQ_NAME", "JVM_SERIALIZABLE_LAMBDA_ANNOTATION_FQ_NAME", "JVM_SYNTHETIC_ANNOTATION_FQ_NAME", "STRICTFP_ANNOTATION_FQ_NAME", "SYNCHRONIZED_ANNOTATION_FQ_NAME", "TRANSIENT_ANNOTATION_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "TRANSIENT_ANNOTATION_FQ_NAME", "VOLATILE_ANNOTATION_FQ_NAME", "checkIsImplementationCompiledToJvmDefault", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "jvmDefaultMode", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "findJvmFieldAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findJvmOverloadsAnnotation", "findJvmSyntheticAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "findStrictfpAnnotation", "findSynchronizedAnnotation", "hasJvmDefaultAnnotation", "hasJvmDefaultNoCompatibilityAnnotation", "hasJvmDefaultWithCompatibilityAnnotation", "hasJvmFieldAnnotation", "hasJvmSyntheticAnnotation", "hasPlatformDependentAnnotation", "isCallableMemberCompiledToJvmDefault", "jvmDefault", "isCompiledToJvmDefault", "isJvmRecord", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "frontend.java"})
public final class JvmAnnotationUtilKt {
    @NotNull
    private static final FqName JVM_DEFAULT_FQ_NAME = new FqName("kotlin.jvm.JvmDefault");
    @NotNull
    private static final FqName JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME = new FqName("kotlin.jvm.JvmDefaultWithoutCompatibility");
    @NotNull
    private static final FqName JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME = new FqName("kotlin.jvm.JvmDefaultWithCompatibility");
    @NotNull
    private static final FqName JVM_OVERLOADS_FQ_NAME = new FqName("kotlin.jvm.JvmOverloads");
    @JvmField
    @NotNull
    public static final FqName JVM_SYNTHETIC_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmSynthetic");
    @NotNull
    private static final FqName JVM_RECORD_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmRecord");
    @JvmField
    @NotNull
    public static final FqName SYNCHRONIZED_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Synchronized");
    @JvmField
    @NotNull
    public static final FqName STRICTFP_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Strictfp");
    @JvmField
    @NotNull
    public static final FqName VOLATILE_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Volatile");
    @JvmField
    @NotNull
    public static final FqName TRANSIENT_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Transient");
    @JvmField
    @NotNull
    public static final ClassId TRANSIENT_ANNOTATION_CLASS_ID;
    @JvmField
    @NotNull
    public static final FqName JVM_SERIALIZABLE_LAMBDA_ANNOTATION_FQ_NAME;

    @NotNull
    public static final FqName getJVM_DEFAULT_FQ_NAME() {
        return JVM_DEFAULT_FQ_NAME;
    }

    @NotNull
    public static final FqName getJVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME() {
        return JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME;
    }

    @NotNull
    public static final FqName getJVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME() {
        return JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME;
    }

    @NotNull
    public static final FqName getJVM_OVERLOADS_FQ_NAME() {
        return JVM_OVERLOADS_FQ_NAME;
    }

    @NotNull
    public static final FqName getJVM_RECORD_ANNOTATION_FQ_NAME() {
        return JVM_RECORD_ANNOTATION_FQ_NAME;
    }

    @Nullable
    public static final AnnotationDescriptor findJvmOverloadsAnnotation(@NotNull DeclarationDescriptor $this$findJvmOverloadsAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$findJvmOverloadsAnnotation, (String)"<this>");
        return $this$findJvmOverloadsAnnotation.getAnnotations().findAnnotation(JVM_OVERLOADS_FQ_NAME);
    }

    @Nullable
    public static final AnnotationDescriptor findJvmFieldAnnotation(@NotNull DeclarationDescriptor $this$findJvmFieldAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$findJvmFieldAnnotation, (String)"<this>");
        PropertyDescriptor propertyDescriptor = $this$findJvmFieldAnnotation instanceof PropertyDescriptor ? (PropertyDescriptor)$this$findJvmFieldAnnotation : null;
        return propertyDescriptor != null && (propertyDescriptor = propertyDescriptor.getBackingField()) != null && (propertyDescriptor = propertyDescriptor.getAnnotations()) != null ? propertyDescriptor.findAnnotation(JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME) : null;
    }

    public static final boolean hasJvmFieldAnnotation(@NotNull DeclarationDescriptor $this$hasJvmFieldAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasJvmFieldAnnotation, (String)"<this>");
        return JvmAnnotationUtilKt.findJvmFieldAnnotation($this$hasJvmFieldAnnotation) != null;
    }

    public static final boolean isCallableMemberCompiledToJvmDefault(@NotNull DeclarationDescriptor $this$isCallableMemberCompiledToJvmDefault, @NotNull JvmDefaultMode jvmDefault) {
        Intrinsics.checkNotNullParameter((Object)$this$isCallableMemberCompiledToJvmDefault, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)jvmDefault), (String)"jvmDefault");
        return $this$isCallableMemberCompiledToJvmDefault instanceof CallableMemberDescriptor && JvmAnnotationUtilKt.isCompiledToJvmDefault((CallableMemberDescriptor)$this$isCallableMemberCompiledToJvmDefault, jvmDefault);
    }

    public static final boolean isCompiledToJvmDefault(@NotNull CallableMemberDescriptor $this$isCompiledToJvmDefault, @NotNull JvmDefaultMode jvmDefault) {
        Intrinsics.checkNotNullParameter((Object)$this$isCompiledToJvmDefault, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)jvmDefault), (String)"jvmDefault");
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember((CallableMemberDescriptor)$this$isCompiledToJvmDefault);
        Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"getDirectMember(this)");
        CallableMemberDescriptor directMember = callableMemberDescriptor;
        DeclarationDescriptor declarationDescriptor = directMember.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"directMember.containingDeclaration");
        DeclarationDescriptor clazz = declarationDescriptor;
        if (directMember.getAnnotations().hasAnnotation(JVM_DEFAULT_FQ_NAME)) {
            return true;
        }
        if (!(clazz instanceof DeserializedClassDescriptor)) {
            return jvmDefault.getForAllMethodsWithBody();
        }
        return JvmProtoBufUtil.isNewPlaceForBodyGeneration(((DeserializedClassDescriptor)clazz).getClassProto());
    }

    public static final boolean checkIsImplementationCompiledToJvmDefault(@NotNull CallableMemberDescriptor $this$checkIsImplementationCompiledToJvmDefault, @NotNull JvmDefaultMode jvmDefaultMode2) {
        Intrinsics.checkNotNullParameter((Object)$this$checkIsImplementationCompiledToJvmDefault, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)jvmDefaultMode2), (String)"jvmDefaultMode");
        CallableMemberDescriptor callableMemberDescriptor = $this$checkIsImplementationCompiledToJvmDefault.getKind().isReal() ? $this$checkIsImplementationCompiledToJvmDefault : DeclarationUtilKt.findImplementationFromInterface((CallableMemberDescriptor)$this$checkIsImplementationCompiledToJvmDefault);
        if (callableMemberDescriptor == null) {
            throw new IllegalStateException(("Can't find actual implementation for " + $this$checkIsImplementationCompiledToJvmDefault).toString());
        }
        CallableMemberDescriptor actualImplementation = callableMemberDescriptor;
        return JvmAnnotationUtilKt.isCallableMemberCompiledToJvmDefault((DeclarationDescriptor)actualImplementation, jvmDefaultMode2);
    }

    public static final boolean hasJvmDefaultAnnotation(@NotNull CallableMemberDescriptor $this$hasJvmDefaultAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasJvmDefaultAnnotation, (String)"<this>");
        return DescriptorUtils.getDirectMember((CallableMemberDescriptor)$this$hasJvmDefaultAnnotation).getAnnotations().hasAnnotation(JVM_DEFAULT_FQ_NAME);
    }

    public static final boolean hasJvmDefaultNoCompatibilityAnnotation(@NotNull DeclarationDescriptor $this$hasJvmDefaultNoCompatibilityAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasJvmDefaultNoCompatibilityAnnotation, (String)"<this>");
        return $this$hasJvmDefaultNoCompatibilityAnnotation.getAnnotations().hasAnnotation(JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME);
    }

    public static final boolean hasJvmDefaultWithCompatibilityAnnotation(@NotNull DeclarationDescriptor $this$hasJvmDefaultWithCompatibilityAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasJvmDefaultWithCompatibilityAnnotation, (String)"<this>");
        return $this$hasJvmDefaultWithCompatibilityAnnotation.getAnnotations().hasAnnotation(JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME);
    }

    public static final boolean hasPlatformDependentAnnotation(@NotNull CallableMemberDescriptor $this$hasPlatformDependentAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasPlatformDependentAnnotation, (String)"<this>");
        return DescriptorUtils.getDirectMember((CallableMemberDescriptor)$this$hasPlatformDependentAnnotation).getAnnotations().hasAnnotation(PlatformDependentDeclarationFilterKt.getPLATFORM_DEPENDENT_ANNOTATION_FQ_NAME());
    }

    private static final AnnotationDescriptor findJvmSyntheticAnnotation(Annotated $this$findJvmSyntheticAnnotation) {
        Object object = $this$findJvmSyntheticAnnotation.getAnnotations().findAnnotation(JVM_SYNTHETIC_ANNOTATION_FQ_NAME);
        if (object == null) {
            PropertyDescriptor propertyDescriptor = $this$findJvmSyntheticAnnotation instanceof PropertyDescriptor ? (PropertyDescriptor)$this$findJvmSyntheticAnnotation : null;
            object = propertyDescriptor != null && (propertyDescriptor = propertyDescriptor.getBackingField()) != null && (propertyDescriptor = propertyDescriptor.getAnnotations()) != null ? propertyDescriptor.findAnnotation(JVM_SYNTHETIC_ANNOTATION_FQ_NAME) : null;
        }
        return object;
    }

    public static final boolean hasJvmSyntheticAnnotation(@NotNull DeclarationDescriptor $this$hasJvmSyntheticAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasJvmSyntheticAnnotation, (String)"<this>");
        return JvmAnnotationUtilKt.findJvmSyntheticAnnotation((Annotated)$this$hasJvmSyntheticAnnotation) != null;
    }

    @Nullable
    public static final AnnotationDescriptor findStrictfpAnnotation(@NotNull DeclarationDescriptor $this$findStrictfpAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$findStrictfpAnnotation, (String)"<this>");
        return $this$findStrictfpAnnotation.getAnnotations().findAnnotation(STRICTFP_ANNOTATION_FQ_NAME);
    }

    @Nullable
    public static final AnnotationDescriptor findSynchronizedAnnotation(@NotNull DeclarationDescriptor $this$findSynchronizedAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$findSynchronizedAnnotation, (String)"<this>");
        return $this$findSynchronizedAnnotation.getAnnotations().findAnnotation(SYNCHRONIZED_ANNOTATION_FQ_NAME);
    }

    public static final boolean isJvmRecord(@NotNull ClassDescriptor $this$isJvmRecord) {
        Intrinsics.checkNotNullParameter((Object)$this$isJvmRecord, (String)"<this>");
        return $this$isJvmRecord.getAnnotations().hasAnnotation(JVM_RECORD_ANNOTATION_FQ_NAME);
    }

    static {
        ClassId classId = ClassId.topLevel(TRANSIENT_ANNOTATION_FQ_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(TRANSIENT_ANNOTATION_FQ_NAME)");
        TRANSIENT_ANNOTATION_CLASS_ID = classId;
        JVM_SERIALIZABLE_LAMBDA_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmSerializableLambda");
    }
}

