/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinTypeAliasStub;
import org.jetbrains.kotlin.psi.stubs.StubUtils;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeAliasStubImpl;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u001e\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nH\u0016J\u001e\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0017H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtTypeAliasElementType;", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinTypeAliasStub;", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "debugName", "", "(Ljava/lang/String;)V", "createNestedClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "typeAlias", "createStub", "psi", "deserialize", "dataStream", "Lcom/intellij/psi/stubs/StubInputStream;", "indexStub", "", "stub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "serialize", "Lcom/intellij/psi/stubs/StubOutputStream;"})
public final class KtTypeAliasElementType
extends KtStubElementType<KotlinTypeAliasStub, KtTypeAlias> {
    public KtTypeAliasElementType(@NotNull String debugName) {
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        super(debugName, KtTypeAlias.class, KotlinTypeAliasStub.class);
    }

    @NotNull
    public KotlinTypeAliasStub createStub(@NotNull KtTypeAlias psi, @Nullable StubElement<?> parentStub) {
        ClassId classId;
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        StringRef name = StringRef.fromString((String)psi.getName());
        FqName fqName = KtPsiUtilKt.safeFqNameForLazyResolve(psi);
        StringRef fqName2 = StringRef.fromString((String)(fqName != null ? fqName.asString() : null));
        StubElement<?> stubElement = parentStub;
        if (stubElement != null) {
            StubElement<?> it = stubElement;
            boolean bl = false;
            classId = this.createNestedClassId(it, psi);
        } else {
            classId = null;
        }
        ClassId classId2 = classId;
        boolean isTopLevel = psi.isTopLevel();
        return new KotlinTypeAliasStubImpl(parentStub, name, fqName2, classId2, isTopLevel);
    }

    private final ClassId createNestedClassId(StubElement<?> parentStub, KtTypeAlias typeAlias) {
        StubElement stubElement;
        KotlinClassStub parentClass;
        Object object;
        Name name = typeAlias.getNameAsName();
        if (name == null) {
            return null;
        }
        Name typeAliasName = name;
        return Intrinsics.areEqual((Object)parentStub.getStubType(), KtStubElementTypes.CLASS_BODY) ? ((object = (parentClass = (stubElement = parentStub.getParentStub()) instanceof KotlinClassStub ? (KotlinClassStub)stubElement : null)) != null && (object = object.getClassId()) != null ? ((ClassId)object).createNestedClassId(typeAliasName) : null) : (parentStub instanceof KotlinFileStub ? new ClassId(((KotlinFileStub)parentStub).getPackageFqName(), typeAliasName) : null);
    }

    public void serialize(@NotNull KotlinTypeAliasStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeName(stub.getName());
        FqName fqName = stub.getFqName();
        dataStream.writeName(fqName != null ? fqName.asString() : null);
        StubUtils.serializeClassId(dataStream, stub.getClassId());
        dataStream.writeBoolean(stub.isTopLevel());
    }

    @NotNull
    public KotlinTypeAliasStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        StringRef name = dataStream.readName();
        StringRef fqName = dataStream.readName();
        ClassId classId = StubUtils.deserializeClassId(dataStream);
        boolean isTopLevel = dataStream.readBoolean();
        return new KotlinTypeAliasStubImpl(parentStub, name, fqName, classId, isTopLevel);
    }

    @Override
    public void indexStub(@NotNull KotlinTypeAliasStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        StubIndexService.Companion.getInstance().indexTypeAlias(stub, sink);
    }
}

