/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi.text;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.ByDescriptorIndexer;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledTextIndex;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledTextIndexer;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererModifier;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.DataClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0012\b\u0002\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DECOMPILED_CODE_COMMENT", "", "DECOMPILED_COMMENT_FOR_PARAMETER", "DECOMPILED_CONTRACT_STUB", "FLEXIBLE_TYPE_COMMENT", "buildDecompiledText", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "descriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptorRenderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "indexers", "", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledTextIndexer;", "defaultDecompilerRendererOptions", "", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptions;", "decompiler-to-psi"})
public final class BuildDecompiledTextKt {
    @NotNull
    private static final String DECOMPILED_CODE_COMMENT = "/* compiled code */";
    @NotNull
    private static final String DECOMPILED_COMMENT_FOR_PARAMETER = "/* = compiled code */";
    @NotNull
    private static final String FLEXIBLE_TYPE_COMMENT = "/* platform type */";
    @NotNull
    private static final String DECOMPILED_CONTRACT_STUB = "contract { /* compiled contract */ }";

    public static final void defaultDecompilerRendererOptions(@NotNull DescriptorRendererOptions $this$defaultDecompilerRendererOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultDecompilerRendererOptions, (String)"<this>");
        $this$defaultDecompilerRendererOptions.setWithDefinedIn(false);
        $this$defaultDecompilerRendererOptions.setClassWithPrimaryConstructor(true);
        $this$defaultDecompilerRendererOptions.setSecondaryConstructorsAsPrimary(false);
        $this$defaultDecompilerRendererOptions.setModifiers(DescriptorRendererModifier.ALL);
        $this$defaultDecompilerRendererOptions.setExcludedTypeAnnotationClasses(SetsKt.emptySet());
        $this$defaultDecompilerRendererOptions.setAlwaysRenderModifiers(true);
        $this$defaultDecompilerRendererOptions.setParameterNamesInFunctionalTypes(false);
    }

    @NotNull
    public static final DecompiledText buildDecompiledText(@NotNull FqName packageFqName, @NotNull List<? extends DeclarationDescriptor> descriptors, @NotNull DescriptorRenderer descriptorRenderer, @NotNull Collection<? extends DecompiledTextIndexer<?>> indexers) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)descriptorRenderer, (String)"descriptorRenderer");
        Intrinsics.checkNotNullParameter(indexers, (String)"indexers");
        StringBuilder builder = new StringBuilder();
        DecompiledTextIndex textIndex = new DecompiledTextIndex(indexers);
        BuildDecompiledTextKt.buildDecompiledText$appendDecompiledTextAndPackageName(builder, packageFqName);
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$default(builder, descriptorRenderer, textIndex, declarationDescriptor, "", null, 32, null);
            builder.append("\n");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return new DecompiledText(string, textIndex);
    }

    public static /* synthetic */ DecompiledText buildDecompiledText$default(FqName fqName, List list, DescriptorRenderer descriptorRenderer, Collection collection, int n, Object object) {
        if ((n & 8) != 0) {
            collection = CollectionsKt.listOf((Object)ByDescriptorIndexer.INSTANCE);
        }
        return BuildDecompiledTextKt.buildDecompiledText(fqName, list, descriptorRenderer, collection);
    }

    private static final void buildDecompiledText$appendDecompiledTextAndPackageName(StringBuilder builder, FqName $packageFqName) {
        builder.append("// IntelliJ API Decompiler stub source generated from a class file\n// Implementation of methods is not available");
        builder.append("\n\n");
        if (!$packageFqName.isRoot()) {
            builder.append("package ").append(RenderingUtilsKt.render($packageFqName)).append("\n\n");
        }
    }

    private static final void buildDecompiledText$indexDescriptor(DecompiledTextIndex textIndex, DeclarationDescriptor descriptor, int startOffset, int endOffset) {
        textIndex.addToIndex(descriptor, new TextRange(startOffset, endOffset));
    }

    private static final boolean buildDecompiledText$isConsideredSynthetic(CallableMemberDescriptor $this$buildDecompiledText_u24isConsideredSynthetic) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$buildDecompiledText_u24isConsideredSynthetic.getKind().ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            case 4: {
                Name name = $this$buildDecompiledText_u24isConsideredSynthetic.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                if (!DataClassDescriptorResolver.INSTANCE.isComponentLike(name)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final void buildDecompiledText$appendDescriptor$newlineExceptFirst(Ref.BooleanRef firstPassed, StringBuilder builder) {
        if (firstPassed.element) {
            builder.append("\n");
        } else {
            firstPassed.element = true;
        }
    }

    private static final void buildDecompiledText$appendDescriptor(StringBuilder builder, DescriptorRenderer $descriptorRenderer, DecompiledTextIndex textIndex, DeclarationDescriptor descriptor, String indent, Boolean lastEnumEntry) {
        ClassConstructorDescriptor primaryConstructor;
        int startOffset = builder.length();
        if (DescriptorUtils.isEnumEntry((DeclarationDescriptor)descriptor)) {
            for (AnnotationDescriptor annotation : descriptor.getAnnotations()) {
                builder.append(DescriptorRenderer.renderAnnotation$default((DescriptorRenderer)$descriptorRenderer, (AnnotationDescriptor)annotation, null, (int)2, null));
                builder.append(" ");
            }
            String string = descriptor.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.name.asString()");
            builder.append(KtPsiUtilKt.quoteIfNeeded(string));
            Boolean bl = lastEnumEntry;
            Intrinsics.checkNotNull((Object)bl);
            builder.append(bl != false ? ";" : ",");
        } else {
            builder.append(StringsKt.replace$default((String)$descriptorRenderer.render(descriptor), (String)"= ...", (String)DECOMPILED_COMMENT_FOR_PARAMETER, (boolean)false, (int)4, null));
        }
        int endOffset = builder.length();
        if (descriptor instanceof CallableDescriptor) {
            KotlinType kotlinType = ((CallableDescriptor)descriptor).getReturnType();
            Intrinsics.checkNotNull((Object)kotlinType);
            if (FlexibleTypesKt.isFlexible((KotlinType)kotlinType)) {
                builder.append(" ").append(FLEXIBLE_TYPE_COMMENT);
            }
        }
        if (descriptor instanceof FunctionDescriptor || descriptor instanceof PropertyDescriptor) {
            if (((MemberDescriptor)descriptor).getModality() != Modality.ABSTRACT) {
                if (descriptor instanceof FunctionDescriptor) {
                    StringBuilder $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240 = builder;
                    boolean bl = false;
                    $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240.append(" { ");
                    AbstractContractProvider abstractContractProvider = (AbstractContractProvider)((FunctionDescriptor)descriptor).getUserData((CallableDescriptor.UserDataKey)ContractProviderKey.INSTANCE);
                    if ((abstractContractProvider != null ? abstractContractProvider.getContractDescription() : null) != null) {
                        $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240.append(DECOMPILED_CONTRACT_STUB).append("; ");
                    }
                    $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240.append(DECOMPILED_CODE_COMMENT).append(" }");
                } else {
                    builder.append(" ").append(DECOMPILED_CODE_COMMENT);
                }
                endOffset = builder.length();
            }
        } else if (descriptor instanceof ClassDescriptor && !DescriptorUtils.isEnumEntry((DeclarationDescriptor)descriptor)) {
            builder.append(" {\n");
            String subindent = indent + "    ";
            Ref.BooleanRef firstPassed = new Ref.BooleanRef();
            List allDescriptors = CollectionsKt.plus((Collection)DescriptorUtilsKt.getSecondaryConstructors((ClassDescriptor)((ClassDescriptor)descriptor)), (Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default((ResolutionScope)((ResolutionScope)((ClassDescriptor)descriptor).getDefaultType().getMemberScope()), null, null, (int)3, null));
            Iterable $this$partition$iv = allDescriptors;
            boolean $i$f$partition = false;
            Object first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                DeclarationDescriptor p0 = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                if (DescriptorUtils.isEnumEntry((DeclarationDescriptor)p0)) {
                    ((ArrayList)first$iv).add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List enumEntries = (List)pair.component1();
            List members = (List)pair.component2();
            first$iv = enumEntries.iterator();
            int n = 0;
            while (first$iv.hasNext()) {
                int index = n++;
                DeclarationDescriptor enumEntry = (DeclarationDescriptor)first$iv.next();
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$newlineExceptFirst(firstPassed, builder);
                builder.append(subindent);
                Intrinsics.checkNotNullExpressionValue((Object)enumEntry, (String)"enumEntry");
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor(builder, $descriptorRenderer, textIndex, enumEntry, subindent, index == CollectionsKt.getLastIndex((List)enumEntries));
            }
            ClassDescriptor companionObject = ((ClassDescriptor)descriptor).getCompanionObjectDescriptor();
            if (companionObject != null) {
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$newlineExceptFirst(firstPassed, builder);
                builder.append(subindent);
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$default(builder, $descriptorRenderer, textIndex, (DeclarationDescriptor)companionObject, subindent, null, 32, null);
            }
            for (DeclarationDescriptor member : members) {
                if (!Intrinsics.areEqual((Object)member.getContainingDeclaration(), (Object)descriptor) || Intrinsics.areEqual((Object)member, (Object)companionObject) || member instanceof CallableMemberDescriptor && BuildDecompiledTextKt.buildDecompiledText$isConsideredSynthetic((CallableMemberDescriptor)member)) continue;
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$newlineExceptFirst(firstPassed, builder);
                builder.append(subindent);
                Intrinsics.checkNotNullExpressionValue((Object)member, (String)"member");
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$default(builder, $descriptorRenderer, textIndex, member, subindent, null, 32, null);
            }
            builder.append(indent).append("}");
            endOffset = builder.length();
        }
        builder.append("\n");
        BuildDecompiledTextKt.buildDecompiledText$indexDescriptor(textIndex, descriptor, startOffset, endOffset);
        if (descriptor instanceof ClassDescriptor && (primaryConstructor = ((ClassDescriptor)descriptor).getUnsubstitutedPrimaryConstructor()) != null) {
            BuildDecompiledTextKt.buildDecompiledText$indexDescriptor(textIndex, (DeclarationDescriptor)primaryConstructor, startOffset, endOffset);
        }
    }

    static /* synthetic */ void buildDecompiledText$appendDescriptor$default(StringBuilder stringBuilder, DescriptorRenderer descriptorRenderer, DecompiledTextIndex decompiledTextIndex, DeclarationDescriptor declarationDescriptor, String string, Boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = null;
        }
        BuildDecompiledTextKt.buildDecompiledText$appendDescriptor(stringBuilder, descriptorRenderer, decompiledTextIndex, declarationDescriptor, string, bl);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CallableMemberDescriptor.Kind.values().length];
            try {
                nArray[CallableMemberDescriptor.Kind.DECLARATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.FAKE_OVERRIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.DELEGATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.SYNTHESIZED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

