/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemCompletionMode;
import org.jetbrains.kotlin.resolve.calls.inference.components.TrivialConstraintTypeInferenceOracle;
import org.jetbrains.kotlin.resolve.calls.inference.components.TypeVariableDependencyInformationProvider;
import org.jetbrains.kotlin.resolve.calls.inference.components.VariableFixationFinderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.DeclaredUpperBoundConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtomMarker;
import org.jetbrains.kotlin.resolve.checkers.EmptyIntersectionTypeInfo;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.ObsoleteTypeKind;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentListMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;
import org.jetbrains.kotlin.types.model.TypeVariableTypeConstructorMarker;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0003012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J<\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0012J\u0014\u0010\u001c\u001a\u00020\b*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J:\u0010\u001e\u001a\u0004\u0018\u00010\r*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010 \u001a\u00020!*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010$\u001a\u00020\b*\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0014\u0010%\u001a\u00020\b*\u00020\u000f2\u0006\u0010\u000e\u001a\u00020&H\u0002J\u0014\u0010'\u001a\u00020\b*\u00020\u000f2\u0006\u0010(\u001a\u00020\u0018H\u0002J\u0014\u0010)\u001a\u00020\b*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\u0014\u0010*\u001a\u00020\b*\u00020\u000f2\u0006\u0010+\u001a\u00020&H\u0002J\u0014\u0010,\u001a\u00020\b*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\u0014\u0010-\u001a\u00020\b*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\u0014\u0010.\u001a\u00020\b*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\u0014\u0010/\u001a\u00020\b*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder;", "", "trivialConstraintTypeInferenceOracle", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "inferenceCompatibilityModeEnabled", "", "getInferenceCompatibilityModeEnabled", "()Z", "isTypeInferenceForSelfTypesSupported", "findFirstVariableForFixation", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$VariableForFixation;", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;", "allTypeVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "postponedKtPrimitives", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedResolvedAtomMarker;", "completionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;", "topLevelType", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "isTypeVariableHasProperConstraint", "context", "typeVariable", "areAllProperConstraintsSelfTypeBased", "variable", "findTypeVariableForFixation", "postponedArguments", "getTypeVariableReadiness", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$TypeVariableFixationReadiness;", "dependencyProvider", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDependencyInformationProvider;", "hasDependencyToOtherTypeVariables", "isProperArgumentConstraint", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "isProperType", "type", "isReified", "isSelfTypeConstraint", "constraint", "variableHasLowerNonNothingProperConstraint", "variableHasOnlyIncorporatedConstraintsFromDeclaredUpperBound", "variableHasProperArgumentConstraints", "variableHasTrivialOrNonProperConstraints", "Context", "TypeVariableFixationReadiness", "VariableForFixation", "resolution.common"})
public final class VariableFixationFinder {
    @NotNull
    private final TrivialConstraintTypeInferenceOracle trivialConstraintTypeInferenceOracle;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public VariableFixationFinder(@NotNull TrivialConstraintTypeInferenceOracle trivialConstraintTypeInferenceOracle, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)trivialConstraintTypeInferenceOracle, (String)"trivialConstraintTypeInferenceOracle");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.trivialConstraintTypeInferenceOracle = trivialConstraintTypeInferenceOracle;
        this.languageVersionSettings = languageVersionSettings;
    }

    @Nullable
    public final VariableForFixation findFirstVariableForFixation(@NotNull Context c, @NotNull List<? extends TypeConstructorMarker> allTypeVariables, @NotNull List<? extends PostponedResolvedAtomMarker> postponedKtPrimitives, @NotNull ConstraintSystemCompletionMode completionMode, @NotNull KotlinTypeMarker topLevelType) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter(allTypeVariables, (String)"allTypeVariables");
        Intrinsics.checkNotNullParameter(postponedKtPrimitives, (String)"postponedKtPrimitives");
        Intrinsics.checkNotNullParameter((Object)((Object)completionMode), (String)"completionMode");
        Intrinsics.checkNotNullParameter((Object)topLevelType, (String)"topLevelType");
        return this.findTypeVariableForFixation(c, allTypeVariables, postponedKtPrimitives, completionMode, topLevelType);
    }

    private final boolean getInferenceCompatibilityModeEnabled() {
        return this.languageVersionSettings.supportsFeature(LanguageFeature.InferenceCompatibility);
    }

    private final boolean isTypeInferenceForSelfTypesSupported() {
        return this.languageVersionSettings.supportsFeature(LanguageFeature.TypeInferenceOnCallsWithSelfTypes);
    }

    private final TypeVariableFixationReadiness getTypeVariableReadiness(Context $this$getTypeVariableReadiness, TypeConstructorMarker variable, TypeVariableDependencyInformationProvider dependencyProvider) {
        return !$this$getTypeVariableReadiness.getNotFixedTypeVariables().containsKey(variable) || dependencyProvider.isVariableRelatedToTopLevelType(variable) ? TypeVariableFixationReadiness.FORBIDDEN : (this.isTypeInferenceForSelfTypesSupported() && this.areAllProperConstraintsSelfTypeBased($this$getTypeVariableReadiness, variable) ? TypeVariableFixationReadiness.READY_FOR_FIXATION_DECLARED_UPPER_BOUND_WITH_SELF_TYPES : (!this.variableHasProperArgumentConstraints($this$getTypeVariableReadiness, variable) ? TypeVariableFixationReadiness.WITHOUT_PROPER_ARGUMENT_CONSTRAINT : (this.hasDependencyToOtherTypeVariables($this$getTypeVariableReadiness, variable) ? TypeVariableFixationReadiness.WITH_COMPLEX_DEPENDENCY : (this.variableHasTrivialOrNonProperConstraints($this$getTypeVariableReadiness, variable) ? TypeVariableFixationReadiness.WITH_TRIVIAL_OR_NON_PROPER_CONSTRAINTS : (dependencyProvider.isVariableRelatedToAnyOutputType(variable) ? TypeVariableFixationReadiness.RELATED_TO_ANY_OUTPUT_TYPE : (this.variableHasOnlyIncorporatedConstraintsFromDeclaredUpperBound($this$getTypeVariableReadiness, variable) ? TypeVariableFixationReadiness.FROM_INCORPORATION_OF_DECLARED_UPPER_BOUND : (this.isReified($this$getTypeVariableReadiness, variable) ? TypeVariableFixationReadiness.READY_FOR_FIXATION_REIFIED : (this.getInferenceCompatibilityModeEnabled() ? (this.variableHasLowerNonNothingProperConstraint($this$getTypeVariableReadiness, variable) ? TypeVariableFixationReadiness.READY_FOR_FIXATION_LOWER : TypeVariableFixationReadiness.READY_FOR_FIXATION_UPPER) : TypeVariableFixationReadiness.READY_FOR_FIXATION))))))));
    }

    public final boolean isTypeVariableHasProperConstraint(@NotNull Context context, @NotNull TypeConstructorMarker typeVariable2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)typeVariable2, (String)"typeVariable");
        Context $this$isTypeVariableHasProperConstraint_u24lambda_u240 = context;
        boolean bl2 = false;
        TypeVariableDependencyInformationProvider dependencyProvider = new TypeVariableDependencyInformationProvider($this$isTypeVariableHasProperConstraint_u24lambda_u240.getNotFixedTypeVariables(), CollectionsKt.emptyList(), null, context);
        switch (WhenMappings.$EnumSwitchMapping$0[this.getTypeVariableReadiness($this$isTypeVariableHasProperConstraint_u24lambda_u240, typeVariable2, dependencyProvider).ordinal()]) {
            case 1: 
            case 2: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private final boolean variableHasTrivialOrNonProperConstraints(Context $this$variableHasTrivialOrNonProperConstraints, TypeConstructorMarker variable) {
        boolean bl;
        block5: {
            Object object = $this$variableHasTrivialOrNonProperConstraints.getNotFixedTypeVariables().get(variable);
            if (object != null && (object = object.getConstraints()) != null) {
                Iterable $this$all$iv = (Iterable)object;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Constraint constraint = (Constraint)element$iv;
                        boolean bl2 = false;
                        boolean isProperConstraint = this.isProperArgumentConstraint($this$variableHasTrivialOrNonProperConstraints, constraint);
                        if (isProperConstraint && this.trivialConstraintTypeInferenceOracle.isNotInterestingConstraint(constraint) || !isProperConstraint) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean variableHasOnlyIncorporatedConstraintsFromDeclaredUpperBound(Context $this$variableHasOnlyIncorporatedConstraintsFromDeclaredUpperBound, TypeConstructorMarker variable) {
        boolean bl;
        block5: {
            void $this$all$iv;
            void $this$filterTo$iv$iv;
            Object object = $this$variableHasOnlyIncorporatedConstraintsFromDeclaredUpperBound.getNotFixedTypeVariables().get(variable);
            if (object == null || (object = object.getConstraints()) == null) {
                return false;
            }
            Object constraints = object;
            Iterable $this$filter$iv = (Iterable)constraints;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Constraint it = (Constraint)element$iv$iv;
                boolean bl2 = false;
                if (!this.isProperArgumentConstraint($this$variableHasOnlyIncorporatedConstraintsFromDeclaredUpperBound, it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Constraint it = (Constraint)element$iv;
                    boolean bl3 = false;
                    if (it.getPosition().isFromDeclaredUpperBound()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final VariableForFixation findTypeVariableForFixation(Context $this$findTypeVariableForFixation, List<? extends TypeConstructorMarker> allTypeVariables, List<? extends PostponedResolvedAtomMarker> postponedArguments, ConstraintSystemCompletionMode completionMode, KotlinTypeMarker topLevelType) {
        VariableForFixation variableForFixation;
        Object v0;
        KotlinTypeMarker kotlinTypeMarker;
        if (allTypeVariables.isEmpty()) {
            return null;
        }
        KotlinTypeMarker kotlinTypeMarker2 = kotlinTypeMarker = topLevelType;
        List<? extends PostponedResolvedAtomMarker> list = postponedArguments;
        Map<TypeConstructorMarker, VariableWithConstraints> map = $this$findTypeVariableForFixation.getNotFixedTypeVariables();
        boolean bl = false;
        boolean bl2 = completionMode == ConstraintSystemCompletionMode.PARTIAL;
        TypeSystemInferenceExtensionContext typeSystemInferenceExtensionContext = $this$findTypeVariableForFixation;
        KotlinTypeMarker kotlinTypeMarker3 = bl2 ? kotlinTypeMarker : null;
        List<? extends PostponedResolvedAtomMarker> list2 = list;
        Map<TypeConstructorMarker, VariableWithConstraints> map2 = map;
        TypeVariableDependencyInformationProvider dependencyProvider = new TypeVariableDependencyInformationProvider(map2, list2, kotlinTypeMarker3, typeSystemInferenceExtensionContext);
        Iterable $this$maxByOrNull$iv = allTypeVariables;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                TypeConstructorMarker it = (TypeConstructorMarker)maxElem$iv;
                boolean bl3 = false;
                Comparable maxValue$iv = (Comparable)((Object)this.getTypeVariableReadiness($this$findTypeVariableForFixation, it, dependencyProvider));
                do {
                    Object e$iv = iterator$iv.next();
                    TypeConstructorMarker it2 = (TypeConstructorMarker)e$iv;
                    $i$a$-maxByOrNull-VariableFixationFinder$findTypeVariableForFixation$candidate$1 = false;
                    Comparable v$iv = (Comparable)((Object)this.getTypeVariableReadiness($this$findTypeVariableForFixation, it2, dependencyProvider));
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        TypeConstructorMarker typeConstructorMarker = v0;
        if (typeConstructorMarker == null) {
            return null;
        }
        TypeConstructorMarker candidate = typeConstructorMarker;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getTypeVariableReadiness($this$findTypeVariableForFixation, candidate, dependencyProvider).ordinal()]) {
            case 1: {
                variableForFixation = null;
                break;
            }
            case 2: {
                variableForFixation = new VariableForFixation(candidate, false, false, 4, null);
                break;
            }
            case 3: {
                variableForFixation = new VariableForFixation(candidate, true, true);
                break;
            }
            default: {
                variableForFixation = new VariableForFixation(candidate, true, false, 4, null);
            }
        }
        return variableForFixation;
    }

    private final boolean hasDependencyToOtherTypeVariables(Context $this$hasDependencyToOtherTypeVariables, TypeConstructorMarker typeVariable2) {
        Object object = $this$hasDependencyToOtherTypeVariables.getNotFixedTypeVariables().get(typeVariable2);
        if (object == null || (object = object.getConstraints()) == null) {
            return false;
        }
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Constraint constraint = (Constraint)iterator2.next();
            Function1 dependencyPresenceCondition2 = (Function1)new Function1<KotlinTypeMarker, Boolean>($this$hasDependencyToOtherTypeVariables, typeVariable2){
                final /* synthetic */ Context $this_hasDependencyToOtherTypeVariables;
                final /* synthetic */ TypeConstructorMarker $typeVariable;
                {
                    this.$this_hasDependencyToOtherTypeVariables = $receiver;
                    this.$typeVariable = $typeVariable;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KotlinTypeMarker type) {
                    Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                    return !Intrinsics.areEqual((Object)this.$this_hasDependencyToOtherTypeVariables.typeConstructor(type), (Object)this.$typeVariable) && this.$this_hasDependencyToOtherTypeVariables.getNotFixedTypeVariables().containsKey(this.$this_hasDependencyToOtherTypeVariables.typeConstructor(type));
                }
            };
            if ($this$hasDependencyToOtherTypeVariables.argumentsCount($this$hasDependencyToOtherTypeVariables.lowerBoundIfFlexible(constraint.getType())) == 0 || !$this$hasDependencyToOtherTypeVariables.contains(constraint.getType(), (Function1<? super KotlinTypeMarker, Boolean>)dependencyPresenceCondition2)) continue;
            return true;
        }
        return false;
    }

    private final boolean variableHasProperArgumentConstraints(Context $this$variableHasProperArgumentConstraints, TypeConstructorMarker variable) {
        boolean bl;
        boolean areThereConstraintsWithUninferredTypeParameter2;
        block8: {
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            Object constraints;
            block7: {
                Object object = $this$variableHasProperArgumentConstraints.getNotFixedTypeVariables().get(variable);
                if (object == null || (object = object.getConstraints()) == null) {
                    return false;
                }
                constraints = object;
                $this$any$iv = (Iterable)constraints;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Constraint c = (Constraint)element$iv;
                        boolean bl3 = false;
                        if (!$this$variableHasProperArgumentConstraints.contains(c.getType(), (Function1<? super KotlinTypeMarker, Boolean>)((Function1)new Function1<KotlinTypeMarker, Boolean>($this$variableHasProperArgumentConstraints){
                            final /* synthetic */ Context $this_variableHasProperArgumentConstraints;
                            {
                                this.$this_variableHasProperArgumentConstraints = $receiver;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull KotlinTypeMarker it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return this.$this_variableHasProperArgumentConstraints.isUninferredParameter(it);
                            }
                        }))) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            areThereConstraintsWithUninferredTypeParameter2 = bl2;
            $this$any$iv = (Iterable)constraints;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Constraint it = (Constraint)element$iv;
                    boolean bl4 = false;
                    if (!this.isProperArgumentConstraint($this$variableHasProperArgumentConstraints, it)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl && !areThereConstraintsWithUninferredTypeParameter2;
    }

    private final boolean isProperArgumentConstraint(Context $this$isProperArgumentConstraint, Constraint c) {
        return this.isProperType($this$isProperArgumentConstraint, c.getType()) && !(c.getPosition().getInitialConstraint().getPosition() instanceof DeclaredUpperBoundConstraintPosition) && !c.isNullabilityConstraint();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProperType(Context $this$isProperType, KotlinTypeMarker type) {
        boolean bl;
        TypeSystemInferenceExtensionContext $this$isProperTypeForFixation$iv = $this$isProperType;
        boolean $i$f$isProperTypeForFixation = false;
        KotlinTypeMarker t = type;
        boolean bl2 = false;
        if ($this$isProperType.contains(t, (Function1<? super KotlinTypeMarker, Boolean>)((Function1)new Function1<KotlinTypeMarker, Boolean>($this$isProperType){
            final /* synthetic */ Context $this_isProperType;
            {
                this.$this_isProperType = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KotlinTypeMarker it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$this_isProperType.getNotFixedTypeVariables().containsKey(this.$this_isProperType.typeConstructor(it));
            }
        }))) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        Iterable $this$all$iv$iv = VariableFixationFinderKt.extractProjectionsForAllCapturedTypes($this$isProperTypeForFixation$iv, type);
        boolean $i$f$all = false;
        if ($this$all$iv$iv instanceof Collection && ((Collection)$this$all$iv$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv$iv = iterator2.next();
            KotlinTypeMarker t2 = (KotlinTypeMarker)element$iv$iv;
            $i$a$-isProperTypeForFixation-VariableFixationFinder$isProperType$1 = false;
            if ($this$isProperType.contains(t2, (Function1<? super KotlinTypeMarker, Boolean>)((Function1)new /* invalid duplicate definition of identical inner class */))) return false;
            bl = true;
        } while (bl);
        return false;
    }

    private final boolean isReified(Context $this$isReified, TypeConstructorMarker variable) {
        boolean bl;
        Object object = $this$isReified.getNotFixedTypeVariables().get(variable);
        if (object != null && (object = object.getTypeVariable()) != null) {
            Object it = object;
            boolean bl2 = false;
            bl = $this$isReified.isReified((TypeVariableMarker)it);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean variableHasLowerNonNothingProperConstraint(Context $this$variableHasLowerNonNothingProperConstraint, TypeConstructorMarker variable) {
        boolean bl;
        block4: {
            Object object = $this$variableHasLowerNonNothingProperConstraint.getNotFixedTypeVariables().get(variable);
            if (object == null || (object = object.getConstraints()) == null) {
                return false;
            }
            Object constraints = object;
            Iterable $this$any$iv = (Iterable)constraints;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Constraint it = (Constraint)element$iv;
                    boolean bl2 = false;
                    if (!(it.getKind().isLower() && this.isProperArgumentConstraint($this$variableHasLowerNonNothingProperConstraint, it) && !$this$variableHasLowerNonNothingProperConstraint.isNothingConstructor($this$variableHasLowerNonNothingProperConstraint.typeConstructor(it.getType())))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isSelfTypeConstraint(Context $this$isSelfTypeConstraint, Constraint constraint) {
        TypeConstructorMarker typeConstructor = $this$isSelfTypeConstraint.typeConstructor(constraint.getType());
        return constraint.getPosition().getFrom() instanceof DeclaredUpperBoundConstraintPosition && (InferenceUtilsKt.hasRecursiveTypeParametersWithGivenSelfType($this$isSelfTypeConstraint, typeConstructor) || InferenceUtilsKt.isRecursiveTypeParameter($this$isSelfTypeConstraint, typeConstructor));
    }

    private final boolean areAllProperConstraintsSelfTypeBased(Context $this$areAllProperConstraintsSelfTypeBased, TypeConstructorMarker variable) {
        Object object;
        block7: {
            block6: {
                Object object2;
                object = $this$areAllProperConstraintsSelfTypeBased.getNotFixedTypeVariables().get(variable);
                if (object == null || (object = object.getConstraints()) == null) break block6;
                Object it = object2 = object;
                boolean bl = false;
                object = !((Collection)it).isEmpty() ? object2 : null;
                if (object != null) break block7;
            }
            return false;
        }
        Object constraints = object;
        boolean hasSelfTypeConstraint = false;
        boolean hasOtherProperConstraint = false;
        Iterator iterator2 = constraints.iterator();
        while (iterator2.hasNext()) {
            Constraint constraint = (Constraint)iterator2.next();
            if (this.isSelfTypeConstraint($this$areAllProperConstraintsSelfTypeBased, constraint)) {
                hasSelfTypeConstraint = true;
            }
            if (this.isProperArgumentConstraint($this$areAllProperConstraintsSelfTypeBased, constraint)) {
                hasOtherProperConstraint = true;
            }
            if (!hasSelfTypeConstraint || !hasOtherProperConstraint) continue;
        }
        return hasSelfTypeConstraint && !hasOtherProperConstraint;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH&R\u001e\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "fixedTypeVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "getFixedTypeVariables", "()Ljava/util/Map;", "notFixedTypeVariables", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "getNotFixedTypeVariables", "postponedTypeVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "getPostponedTypeVariables", "()Ljava/util/List;", "isReified", "", "variable", "resolution.common"})
    public static interface Context
    extends TypeSystemInferenceExtensionContext {
        @NotNull
        public Map<TypeConstructorMarker, VariableWithConstraints> getNotFixedTypeVariables();

        @NotNull
        public Map<TypeConstructorMarker, KotlinTypeMarker> getFixedTypeVariables();

        @NotNull
        public List<TypeVariableMarker> getPostponedTypeVariables();

        public boolean isReified(@NotNull TypeVariableMarker var1);

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            @Nullable
            public static EmptyIntersectionTypeInfo computeEmptyIntersectionTypeKind(@NotNull Context $this, @NotNull Collection<? extends KotlinTypeMarker> types) {
                Intrinsics.checkNotNullParameter(types, (String)"types");
                return TypeSystemInferenceExtensionContext.DefaultImpls.computeEmptyIntersectionTypeKind($this, types);
            }

            @Nullable
            public static SimpleTypeMarker createCapturedStarProjectionForSelfType(@NotNull Context $this, @NotNull TypeVariableTypeConstructorMarker typeVariable2, @NotNull List<? extends KotlinTypeMarker> typesForRecursiveTypeParameters) {
                Intrinsics.checkNotNullParameter((Object)typeVariable2, (String)"typeVariable");
                Intrinsics.checkNotNullParameter(typesForRecursiveTypeParameters, (String)"typesForRecursiveTypeParameters");
                return TypeSystemInferenceExtensionContext.DefaultImpls.createCapturedStarProjectionForSelfType($this, typeVariable2, typesForRecursiveTypeParameters);
            }

            public static boolean identicalArguments(@NotNull Context $this, @NotNull SimpleTypeMarker a, @NotNull SimpleTypeMarker b) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                return TypeSystemInferenceExtensionContext.DefaultImpls.identicalArguments($this, a, b);
            }

            public static boolean anySuperTypeConstructor(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver, @NotNull Function1<? super SimpleTypeMarker, Boolean> predicate) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                return TypeSystemInferenceExtensionContext.DefaultImpls.anySuperTypeConstructor($this, $receiver, predicate);
            }

            @NotNull
            public static Set<TypeParameterMarker> extractTypeParameters(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.extractTypeParameters($this, $receiver);
            }

            @NotNull
            public static Set<TypeVariableTypeConstructorMarker> extractTypeVariables(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.extractTypeVariables($this, $receiver);
            }

            @Nullable
            public static List<SimpleTypeMarker> fastCorrespondingSupertypes(@NotNull Context $this, @NotNull SimpleTypeMarker $receiver, @NotNull TypeConstructorMarker constructor) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
                return TypeSystemInferenceExtensionContext.DefaultImpls.fastCorrespondingSupertypes($this, $receiver, constructor);
            }

            @NotNull
            public static TypeArgumentMarker get(@NotNull Context $this, @NotNull TypeArgumentListMarker $receiver, int index) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.get($this, $receiver, index);
            }

            @Nullable
            public static TypeArgumentMarker getArgumentOrNull(@NotNull Context $this, @NotNull SimpleTypeMarker $receiver, int index) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.getArgumentOrNull($this, $receiver, index);
            }

            public static boolean hasFlexibleNullability(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.hasFlexibleNullability($this, $receiver);
            }

            public static boolean isCapturedDynamic(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isCapturedDynamic($this, $receiver);
            }

            public static boolean isCapturedType(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isCapturedType($this, $receiver);
            }

            public static boolean isClassType(@NotNull Context $this, @NotNull SimpleTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isClassType($this, $receiver);
            }

            public static boolean isDefinitelyClassTypeConstructor(@NotNull Context $this, @NotNull TypeConstructorMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isDefinitelyClassTypeConstructor($this, $receiver);
            }

            public static boolean isDefinitelyNotNullType(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isDefinitelyNotNullType($this, $receiver);
            }

            public static boolean isDynamic(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isDynamic($this, $receiver);
            }

            public static boolean isFlexible(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isFlexible($this, $receiver);
            }

            public static boolean isFlexibleNothing(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isFlexibleNothing($this, $receiver);
            }

            public static boolean isIntegerLiteralType(@NotNull Context $this, @NotNull SimpleTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isIntegerLiteralType($this, $receiver);
            }

            public static boolean isMarkedNullable(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isMarkedNullable($this, $receiver);
            }

            @ObsoleteTypeKind
            public static boolean isNotNullTypeParameter(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNotNullTypeParameter($this, $receiver);
            }

            public static boolean isNothing(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNothing($this, $receiver);
            }

            public static boolean isNullableAny(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNullableAny($this, $receiver);
            }

            public static boolean isNullableNothing(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNullableNothing($this, $receiver);
            }

            public static boolean isSimpleType(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isSimpleType($this, $receiver);
            }

            @NotNull
            public static Iterator<TypeArgumentMarker> iterator(@NotNull Context $this, @NotNull TypeArgumentListMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.iterator($this, $receiver);
            }

            @NotNull
            public static SimpleTypeMarker lowerBoundIfFlexible(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.lowerBoundIfFlexible($this, $receiver);
            }

            @NotNull
            public static SimpleTypeMarker originalIfDefinitelyNotNullable(@NotNull Context $this, @NotNull SimpleTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.originalIfDefinitelyNotNullable($this, $receiver);
            }

            @NotNull
            public static KotlinTypeMarker replaceArguments(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver, @NotNull Function1<? super TypeArgumentMarker, ? extends TypeArgumentMarker> replacement) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                Intrinsics.checkNotNullParameter(replacement, (String)"replacement");
                return TypeSystemInferenceExtensionContext.DefaultImpls.replaceArguments($this, $receiver, replacement);
            }

            @NotNull
            public static KotlinTypeMarker replaceArgumentsDeeply(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver, @NotNull Function1<? super TypeArgumentMarker, ? extends TypeArgumentMarker> replacement) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                Intrinsics.checkNotNullParameter(replacement, (String)"replacement");
                return TypeSystemInferenceExtensionContext.DefaultImpls.replaceArgumentsDeeply((TypeSystemInferenceExtensionContext)$this, $receiver, replacement);
            }

            @NotNull
            public static SimpleTypeMarker replaceArgumentsDeeply(@NotNull Context $this, @NotNull SimpleTypeMarker $receiver, @NotNull Function1<? super TypeArgumentMarker, ? extends TypeArgumentMarker> replacement) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                Intrinsics.checkNotNullParameter(replacement, (String)"replacement");
                return TypeSystemInferenceExtensionContext.DefaultImpls.replaceArgumentsDeeply((TypeSystemInferenceExtensionContext)$this, $receiver, replacement);
            }

            public static int size(@NotNull Context $this, @NotNull TypeArgumentListMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.size($this, $receiver);
            }

            @NotNull
            public static TypeConstructorMarker typeConstructor(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.typeConstructor($this, $receiver);
            }

            public static int typeDepth(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.typeDepth($this, $receiver);
            }

            @NotNull
            public static SimpleTypeMarker upperBoundIfFlexible(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.upperBoundIfFlexible($this, $receiver);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$VariableForFixation;", "", "variable", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "hasProperConstraint", "", "hasOnlyTrivialProperConstraint", "(Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;ZZ)V", "getHasOnlyTrivialProperConstraint", "()Z", "getHasProperConstraint", "getVariable", "()Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "resolution.common"})
    public static final class VariableForFixation {
        @NotNull
        private final TypeConstructorMarker variable;
        private final boolean hasProperConstraint;
        private final boolean hasOnlyTrivialProperConstraint;

        public VariableForFixation(@NotNull TypeConstructorMarker variable, boolean hasProperConstraint, boolean hasOnlyTrivialProperConstraint) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            this.variable = variable;
            this.hasProperConstraint = hasProperConstraint;
            this.hasOnlyTrivialProperConstraint = hasOnlyTrivialProperConstraint;
        }

        public /* synthetic */ VariableForFixation(TypeConstructorMarker typeConstructorMarker, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(typeConstructorMarker, bl, bl2);
        }

        @NotNull
        public final TypeConstructorMarker getVariable() {
            return this.variable;
        }

        public final boolean getHasProperConstraint() {
            return this.hasProperConstraint;
        }

        public final boolean getHasOnlyTrivialProperConstraint() {
            return this.hasOnlyTrivialProperConstraint;
        }

        @NotNull
        public final TypeConstructorMarker component1() {
            return this.variable;
        }

        public final boolean component2() {
            return this.hasProperConstraint;
        }

        public final boolean component3() {
            return this.hasOnlyTrivialProperConstraint;
        }

        @NotNull
        public final VariableForFixation copy(@NotNull TypeConstructorMarker variable, boolean hasProperConstraint, boolean hasOnlyTrivialProperConstraint) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            return new VariableForFixation(variable, hasProperConstraint, hasOnlyTrivialProperConstraint);
        }

        public static /* synthetic */ VariableForFixation copy$default(VariableForFixation variableForFixation, TypeConstructorMarker typeConstructorMarker, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                typeConstructorMarker = variableForFixation.variable;
            }
            if ((n & 2) != 0) {
                bl = variableForFixation.hasProperConstraint;
            }
            if ((n & 4) != 0) {
                bl2 = variableForFixation.hasOnlyTrivialProperConstraint;
            }
            return variableForFixation.copy(typeConstructorMarker, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "VariableForFixation(variable=" + this.variable + ", hasProperConstraint=" + this.hasProperConstraint + ", hasOnlyTrivialProperConstraint=" + this.hasOnlyTrivialProperConstraint + ')';
        }

        public int hashCode() {
            int result2 = this.variable.hashCode();
            int n = this.hasProperConstraint ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            int n2 = this.hasOnlyTrivialProperConstraint ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result2 = result2 * 31 + n2;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VariableForFixation)) {
                return false;
            }
            VariableForFixation variableForFixation = (VariableForFixation)other;
            if (!Intrinsics.areEqual((Object)this.variable, (Object)variableForFixation.variable)) {
                return false;
            }
            if (this.hasProperConstraint != variableForFixation.hasProperConstraint) {
                return false;
            }
            return this.hasOnlyTrivialProperConstraint == variableForFixation.hasOnlyTrivialProperConstraint;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\r\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$TypeVariableFixationReadiness;", "", "(Ljava/lang/String;I)V", "FORBIDDEN", "WITHOUT_PROPER_ARGUMENT_CONSTRAINT", "READY_FOR_FIXATION_DECLARED_UPPER_BOUND_WITH_SELF_TYPES", "WITH_COMPLEX_DEPENDENCY", "WITH_TRIVIAL_OR_NON_PROPER_CONSTRAINTS", "RELATED_TO_ANY_OUTPUT_TYPE", "FROM_INCORPORATION_OF_DECLARED_UPPER_BOUND", "READY_FOR_FIXATION_UPPER", "READY_FOR_FIXATION_LOWER", "READY_FOR_FIXATION", "READY_FOR_FIXATION_REIFIED", "resolution.common"})
    public static final class TypeVariableFixationReadiness
    extends Enum<TypeVariableFixationReadiness> {
        public static final /* enum */ TypeVariableFixationReadiness FORBIDDEN = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness WITHOUT_PROPER_ARGUMENT_CONSTRAINT = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness READY_FOR_FIXATION_DECLARED_UPPER_BOUND_WITH_SELF_TYPES = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness WITH_COMPLEX_DEPENDENCY = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness WITH_TRIVIAL_OR_NON_PROPER_CONSTRAINTS = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness RELATED_TO_ANY_OUTPUT_TYPE = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness FROM_INCORPORATION_OF_DECLARED_UPPER_BOUND = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness READY_FOR_FIXATION_UPPER = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness READY_FOR_FIXATION_LOWER = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness READY_FOR_FIXATION = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness READY_FOR_FIXATION_REIFIED = new TypeVariableFixationReadiness();
        private static final /* synthetic */ TypeVariableFixationReadiness[] $VALUES;

        public static TypeVariableFixationReadiness[] values() {
            return (TypeVariableFixationReadiness[])$VALUES.clone();
        }

        public static TypeVariableFixationReadiness valueOf(String value2) {
            return Enum.valueOf(TypeVariableFixationReadiness.class, value2);
        }

        static {
            $VALUES = typeVariableFixationReadinessArray = new TypeVariableFixationReadiness[]{TypeVariableFixationReadiness.FORBIDDEN, TypeVariableFixationReadiness.WITHOUT_PROPER_ARGUMENT_CONSTRAINT, TypeVariableFixationReadiness.READY_FOR_FIXATION_DECLARED_UPPER_BOUND_WITH_SELF_TYPES, TypeVariableFixationReadiness.WITH_COMPLEX_DEPENDENCY, TypeVariableFixationReadiness.WITH_TRIVIAL_OR_NON_PROPER_CONSTRAINTS, TypeVariableFixationReadiness.RELATED_TO_ANY_OUTPUT_TYPE, TypeVariableFixationReadiness.FROM_INCORPORATION_OF_DECLARED_UPPER_BOUND, TypeVariableFixationReadiness.READY_FOR_FIXATION_UPPER, TypeVariableFixationReadiness.READY_FOR_FIXATION_LOWER, TypeVariableFixationReadiness.READY_FOR_FIXATION, TypeVariableFixationReadiness.READY_FOR_FIXATION_REIFIED};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TypeVariableFixationReadiness.values().length];
            try {
                nArray[TypeVariableFixationReadiness.FORBIDDEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeVariableFixationReadiness.WITHOUT_PROPER_ARGUMENT_CONSTRAINT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeVariableFixationReadiness.WITH_TRIVIAL_OR_NON_PROPER_CONSTRAINTS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

